/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.editor.process.StorePropertiesDialogEx;

public class InfoStore
extends AbstractProcessObject
implements EditableFonts {
    public static final String RDBMS = "RDBMS";
    public static final String FILE = "File";
    public static final String OBJECT = "Object";
    public static final String TEMPORARY = "Temporary";
    public static final String[] INFOSTORE_TYPES_DISPLAY = new String[]{Messages.getString("InfoStore.RDBMS"), Messages.getString("InfoStore.File"), Messages.getString("InfoStore.Object"), Messages.getString("InfoStore.Temporary")};
    public static final String[] INFOSTORE_TYPES_INTERNAL = new String[]{"RDBMS", "File", "Object", "Temporary"};
    public static final String[] FILE_TYPES_DISPLAY = new String[]{Messages.getString("InfoStore.CSV"), Messages.getString("InfoStore.FixedLengthFields"), Messages.getString("InfoStore.Excel"), Messages.getString("InfoStore.PlainText")};
    public static final String[] FILE_TYPES_INTERNAL = new String[]{"CSV", "Fixed Length Fields", "Excel", "Plain Text"};
    public static final String[] TRANSFER_TYPES_DISPLAY = new String[]{Messages.getString("InfoStore.FullRefresh"), Messages.getString("InfoStore.ChangesCapture"), Messages.getString("InfoStore.TriggeredCapture"), Messages.getString("InfoStore.ApplicationAssistedCapture"), Messages.getString("InfoStore.TimeStampBasedCapture"), Messages.getString("InfoStore.FileComparisonCapture")};
    public static final String[] TRANSFER_TYPES_INTERNAL = new String[]{"Full Refresh", "Changes Capture", "Triggered Capture", "Application Assisted Capture", "Time-Stamp based Capture", "File Comparison Capture"};
    private String type = "RDBMS";
    private String owner = "";
    private String source = "";
    private String fileName = "";
    private String location = "";
    private String fileType = FILE_TYPES_INTERNAL[0];
    private String fieldSeparator = ",";
    private String transferType = TRANSFER_TYPES_INTERNAL[0];
    private String scope = "";
    private String objectType = "";
    private String implementationName = "";
    private boolean isSelfDescribing = false;
    private int skipRecords = 0;
    private String textDelimiter = "";
    private Map entityImplementations = new HashMap();
    private String rdbmsSite = "";
    private List editableFonts = new ArrayList();
    private String systemObjective = "";
    private List datas = new ArrayList();
    public static final String TYPE_NAME = "InfoStore";

    public InfoStore(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "IST";
    }

    public List getAttributes() {
        Iterator is;
        TreeMap<String, Attribute> attributes = new TreeMap<String, Attribute>();
        Iterator it = this.getIncomingFlows().iterator();
        while (it.hasNext()) {
            is = ((Flow)it.next()).getInfoStructures().iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    attributes.put(attribute.getLongName(), attribute);
                }
            }
        }
        it = this.getOutgoingFlows().iterator();
        while (it.hasNext()) {
            is = ((Flow)it.next()).getInfoStructures().iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    attributes.put(attribute.getLongName(), attribute);
                }
            }
        }
        return new ArrayList(attributes.values());
    }

    public List getEntities() {
        Entity ent;
        Iterator is;
        TreeMap<String, Entity> map = new TreeMap<String, Entity>();
        Iterator it = this.getIncomingFlows().iterator();
        while (it.hasNext()) {
            is = ((Flow)it.next()).getInfoStructures().iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    ent = attribute.getEntity();
                    map.put(ent.getName(), ent);
                }
            }
        }
        it = this.getOutgoingFlows().iterator();
        while (it.hasNext()) {
            is = ((Flow)it.next()).getInfoStructures().iterator();
            while (is.hasNext()) {
                for (Attribute attribute : ((InfoStructure)is.next()).getAttributes()) {
                    ent = attribute.getEntity();
                    map.put(ent.getName(), ent);
                }
            }
        }
        return new ArrayList(map.values());
    }

    public List getProcesses() {
        ArrayList<AbstractProcessObject> result = new ArrayList<AbstractProcessObject>();
        for (Flow flow : this.getIncomingFlows()) {
            AbstractProcessObject obj = flow.getSourceProcessObject();
            if (obj instanceof Process) {
                result.add(obj);
                continue;
            }
            obj = flow.getTargetProcessObject();
            if (!(obj instanceof Process)) continue;
            result.add(obj);
        }
        return result;
    }

    public String getSystemObjective() {
        return this.systemObjective;
    }

    public void setSystemObjective(String systemObjective) {
        this.systemObjective = systemObjective;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StorePropertiesDialogEx dialog = new StorePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    public void addData(ExternalData data) {
        this.datas.add(data);
        data.remove();
    }

    public void removeData(ExternalData data) {
        this.datas.remove(data);
    }

    public ExternalData createExternalData() {
        ExternalData ed = ((ProcessModel)this.getDesignPart()).createExternalData();
        this.addData(ed);
        return ed;
    }

    public ExternalData getExternalDataByID(String id) {
        for (ExternalData ed : this.datas) {
            if (!ed.getObjectID().equals(id)) continue;
            return ed;
        }
        return null;
    }

    public List getDatas() {
        return this.datas;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public void setImplementationName(String implementationName) {
        this.implementationName = implementationName;
    }

    public boolean isSelfDescribing() {
        return this.isSelfDescribing;
    }

    public void setSelfDescribing(boolean isSelfDescribing) {
        this.isSelfDescribing = isSelfDescribing;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getSkipRecords() {
        return this.skipRecords;
    }

    public void setSkipRecords(int skipRecords) {
        this.skipRecords = skipRecords;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }

    public void setTextDelimiter(String textDelimiter) {
        this.textDelimiter = textDelimiter;
    }

    public Map getEntityImplementations() {
        return this.entityImplementations;
    }

    public Object getEntityImpl(Entity entity) {
        return this.entityImplementations.get(entity);
    }

    public void addEntityImpl(Entity entity, Object impl) {
        this.entityImplementations.put(entity, impl);
    }

    public List getImplementationsForEntity(Entity entity) {
        ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
        if (entity.getGenerator() != null) {
            list.add(entity.getGenerator());
        } else {
            for (RelationalDesign design : this.getDesign().getRelationalDesigns()) {
                ModelIDObject impl = design.getTableSet().getObjectGeneratedBy(entity);
                if (impl == null) continue;
                list.add(impl);
            }
        }
        return list;
    }

    public String getRdbmsSite() {
        return this.rdbmsSite;
    }

    public void setRdbmsSite(String rdbmsSite) {
        this.rdbmsSite = rdbmsSite;
    }

    @Override
    public String getFCObjectType() {
        return "Information Store";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "store" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        InfoStore store = (InfoStore)desObject;
        super.copy(desObject);
        store.setSynonym(this.getSynonym());
        store.setType(this.getType());
        store.setRdbmsSite(this.getRdbmsSite());
        store.setObjectType(this.getObjectType());
        store.setImplementationName(this.getImplementationName());
        store.setScope(this.getScope());
        store.setOwner(this.getOwner());
        store.setSource(this.getSource());
        store.setFileName(this.getFileName());
        store.setLocation(this.getLocation());
        store.setFileType(this.getFileType());
        store.setFieldSeparator(this.getFieldSeparator());
        store.setTransferType(this.getTransferType());
        store.setSelfDescribing(this.isSelfDescribing);
        store.setSkipRecords(this.getSkipRecords());
        store.setTextDelimiter(this.getTextDelimiter());
        for (ExternalData exData : this.getDatas()) {
            ExternalData newExData = store.createExternalData();
            newExData.setName(exData.getName());
            newExData.setComment(exData.getComment());
            newExData.setType(exData.getType());
            newExData.setStartingPos(exData.getStartingPos());
            newExData.setDescription(exData.getDescription());
            newExData.setStructured(exData.isStructured());
            newExData.setRecordStructure(exData.getRecordStructure());
        }
    }
}

