/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import oracle.dbtools.crest.model.design.multidimensional.Context11g;
import oracle.dbtools.crest.model.design.multidimensional.CursorPrintWriter;
import oracle.dbtools.crest.model.design.multidimensional.Logger;
import oracle.jdbc.driver.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.transaction.TransactionProvider;

public abstract class BaseExample11g {
    public static final String KEY_LOGFILE = "logfile";
    public static final String VALUE_YES = "yes";
    public static final String KEY_VERBOSE = "verbose";
    public static final Properties props = new Properties();
    private Context11g context;
    protected boolean createContext = true;
    private CursorPrintWriter cpw;
    private Logger logger;

    protected abstract void run() throws Exception;

    public void execute(Properties properties) {
        this.shutdown();
    }

    public void execute(String[] args) {
        this.execute(BaseExample11g.convertToProperties(args));
    }

    protected void initialize(Properties properties, OracleConnection connection) throws Exception {
        this.setUpCursorPrintWriter(properties);
        this.setupLogger(this.getCursorPrintWriter(), properties);
        if (this.createContext) {
            this.createContext(properties, connection);
        }
    }

    protected void initialize(Properties properties) throws Exception {
        this.setUpCursorPrintWriter(properties);
        this.setupLogger(this.getCursorPrintWriter(), properties);
        if (this.createContext) {
            this.createContext(properties);
        }
    }

    protected void shutdown() {
        this.closeContext();
        this.logger.close();
        this.logger = null;
        this.closeCursorPrintWriter();
    }

    protected void createContext(Properties properties, OracleConnection connection) {
        this.context = new Context11g(properties, this.getLogger(), connection);
    }

    protected void createContext(Properties properties) {
        this.context = new Context11g(properties, this.getLogger());
    }

    protected void closeContext() {
        try {
            this.context.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.context = null;
        }
    }

    protected Context11g getContext() {
        return this.context;
    }

    final void setupLogger(PrintWriter writer, Properties properties) {
        this.logger = writer == null ? new Logger() : new Logger(writer);
        boolean verbose = VALUE_YES.equalsIgnoreCase(properties.getProperty(KEY_VERBOSE));
        this.logger.setVerbose(verbose);
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    final void setUpCursorPrintWriter(Properties properties) throws IOException {
        String logFile = properties.getProperty(KEY_LOGFILE);
        if (null == logFile) {
            this.cpw = CursorPrintWriter.getStandardOutput();
        } else {
            PrintWriter writer = new PrintWriter(new FileWriter(logFile));
            this.cpw = new CursorPrintWriter(writer);
        }
    }

    protected CursorPrintWriter getCursorPrintWriter() {
        return this.cpw;
    }

    final void closeCursorPrintWriter() {
        if (this.cpw != null) {
            this.cpw.close();
        }
        this.cpw = null;
    }

    void printStackTrace(Exception e) {
        if (null != this.cpw) {
            e.printStackTrace(this.cpw);
        }
    }

    protected void println(String line) {
        this.cpw.println(line);
    }

    protected void println() {
        this.cpw.println();
    }

    protected void print(String line) {
        this.cpw.print(line);
    }

    protected void print(Object obj) {
        this.cpw.print(obj);
    }

    public static Properties convertToProperties(String[] args) {
        for (int i = 0; i < args.length; i += 2) {
            if (i + 1 == args.length || !args[i].startsWith("-")) {
                throw new IllegalArgumentException("Command-line arguments must be specified in the form -<property_name> <value> with the property name and value separated by whitespace.");
            }
            props.put(args[i].substring(1), args[i + 1]);
        }
        return props;
    }

    public Properties getProperties() {
        return props;
    }

    public String getProperty(Properties properties, String key, boolean required) {
        String ret = properties.getProperty(key);
        if (required && ret == null) {
            throw new IllegalArgumentException("Command-line arguments must be specified in the form -<property_name> <value> with the property name and value separated by whitespace.");
        }
        return ret;
    }

    public String getOptionalProperty(String key) {
        return this.getProperty(this.getProperties(), key, false);
    }

    protected MdmPrimaryDimension getMdmPrimaryDimension(String name) {
        return this.context.getMdmPrimaryDimensionByName(name);
    }

    protected MdmMeasure getMdmMeasure(String name) {
        return this.context.getMdmMeasureByName(name);
    }

    protected DataProvider getDataProvider() {
        return this.context.getDataProvider();
    }

    protected MdmMetadataProvider getMdmMetadataProvider() {
        return this.context.getMetadataProvider();
    }

    protected FundamentalMetadataProvider getFundamentalMetadataProvider() {
        return this.context.getFundamentalMetadataProvider();
    }

    protected TransactionProvider getTransactionProvider() {
        return this.context.getTransactionProvider();
    }
}

