/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.logical;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.logical.AttributePropertiesDialogEx;
import oracle.dbtools.crest.util.GUID;

public class Attribute
extends ContainedObjectWithDomain
implements ObjectListener,
ConstrainedObject {
    public static final String DEFAULT_NAME = "Attribute";
    public static boolean propagateFKName = true;
    protected Attribute delegate;
    private String preferredAbbreviation = "";
    private String source = "";
    private Relation.Connection connection = null;

    public Attribute(DesignPart designPart) {
        super(designPart);
    }

    public Attribute(DesignPart designPart, Relation.Connection connection, Attribute referenced) {
        super(designPart);
        this.connection = connection;
        this.setDelegate(referenced);
    }

    @Override
    public String getObjectTypeName() {
        return DEFAULT_NAME;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("attribute id prefix");
    }

    public boolean isFKAttribute() {
        return this.connection != null;
    }

    @Override
    public boolean isFKElement() {
        return this.isFKAttribute();
    }

    @Override
    public boolean hasAliveGenerator() {
        DesignObject obj;
        ColumnSet set = this.getDesign().getRelationalDesign().getColumnSet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog(Dialog owner) {
        if (!this.isDialogVisible()) {
            AttributePropertiesDialogEx dialog = owner == null ? new AttributePropertiesDialogEx(this.getDesign().getAppView(), this, false) : new AttributePropertiesDialogEx(owner, this.getDesign().getAppView(), this, false);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void showPropertyDialog() {
        this.showPropertyDialog(null);
    }

    public Column getEngColumn(RelationalDesign pdes, Table table) {
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                Column col = (Column)mapping.getObjectMappedTo(this);
                if (col == null || col.getContainerWithKeyObject() != table) continue;
                return col;
            }
        }
        return null;
    }

    public XtdMapping getMappingFor(RelationalDesign pdes, Table table) {
        List list;
        if (table != null && (list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                Column col = (Column)mapping.getObjectMappedTo(this);
                if (col == null || col.getContainerWithKeyObject() != table) continue;
                return mapping;
            }
        }
        return null;
    }

    public List getMappingsFor(RelationalDesign pdes, Table table) {
        List list;
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        if (table != null && (list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID())).size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                XtdMapping mapping = (XtdMapping)list.get(i);
                Column col = (Column)mapping.getObjectMappedTo(this);
                if (col == null || col.getContainerWithKeyObject() != table) continue;
                temp.add(mapping);
            }
        }
        return temp;
    }

    public ContainedObject getEngColumn(RelationalDesign pdes) {
        Relation rel;
        DesignObject obj;
        XtdMapping mapping;
        Column col;
        Column column = null;
        List list = this.getDesign().getExtendedMap().getMappingsForDesignPart(this, pdes.getObjectID());
        if (list.size() > 0 && (col = (Column)(mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            return col;
        }
        if (this.getGenerator() instanceof Column) {
            column = (Column)this.getGenerator();
        }
        if (column != null && column.getDesignPart() == pdes) {
            return column;
        }
        column = (Column)pdes.getColumnSet().getObjectGeneratedBy(this.getObjectID());
        if (column == null && this.isFKAttribute() && !this.hasCircularRef() && (obj = this.getGenerator()) != null && obj instanceof Relation && (obj = (rel = (Relation)obj).getGenerator()) != null && obj instanceof FKIndexAssociation) {
            FKIndexAssociation fk = (FKIndexAssociation)obj;
            String delid = this.getReferedAttribute();
            Attribute attr = (Attribute)this.getDesign().getDesignObject(delid);
            if (attr != null) {
                ContainedObject col2 = attr.getEngColumn(pdes);
                Table tab = ((Entity)this.getContainer()).getEngTable(pdes);
                if (tab != null && col2 != null) {
                    FKElement fcol = tab.getFKColumn(fk, (FKElement)col2);
                    return fcol;
                }
            }
        }
        return column;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public void copy(DesignObject desObject) {
        Attribute attribute = (Attribute)desObject;
        super.copy(attribute);
        attribute.setDesignObjectSet(this.getDesignObjectSet());
        attribute.setUnique(this.isUnique());
        attribute.setNullsAllowed(this.getNullsAllowed());
        attribute.setReference(this.isReference());
        attribute.setUse(this.getUse());
        if (this.getUse() == 0) {
            Domain remoteDomain = this.getDomain();
            if (!remoteDomain.isDefault() && desObject.isRemoteObject()) {
                Domain newDomain;
                String domainID = remoteDomain.getObjectID();
                if (remoteDomain.isRemoteObject()) {
                    domainID = remoteDomain.getRemoteObjectID();
                }
                if ((newDomain = (Domain)attribute.getDesign().getDomainSet().getByRemoteObjectId(domainID)) == null) {
                    newDomain = attribute.getDesign().getDomainSet().createDomain();
                    newDomain.setObjectID(new GUID().toString());
                    remoteDomain.copyTo(newDomain);
                    newDomain.setOwnerDesignName(attribute.getDesign().getName());
                    newDomain.setFileName(attribute.getDesign().getName());
                    if (remoteDomain.isRemoteObject()) {
                        newDomain.setRemoteObjectID(remoteDomain.getRemoteObjectID());
                    } else {
                        newDomain.setRemoteObjectID(remoteDomain.getObjectID());
                    }
                    newDomain.setRemoteDesignID(this.getDesign().getObjectID());
                    newDomain.setRemoteObjectRelativeStorageName(remoteDomain.getRelativeStorageName());
                }
                attribute.setDomain(newDomain);
            } else {
                attribute.setDomain(remoteDomain);
            }
        } else if (this.getUse() == 1) {
            attribute.setLogicalDatatype(this.getLogicalDatatype());
            attribute.setDataTypeParameter("size", this.getSize());
            attribute.setDataTypeParameter("precision", this.getPrecision());
            attribute.setDataTypeParameter("scale", this.getScale());
        } else if (this.getUse() == 3) {
            attribute.setStructuredType(this.getStructuredType());
            List list = attribute.getPermittedSubTypes();
            list.clear();
            list.addAll(this.getPermittedSubTypes());
        } else if (this.getUse() == 4) {
            attribute.setCollectionType(this.getCollectionType());
        } else if (this.getUse() == 2) {
            attribute.setDistinctType(this.getDistinctType());
        }
        attribute.setUsesDefaultValue(this.getUsesDefaultValue());
        attribute.setUseDomainConstraints(this.getUseDomainConstraints());
        attribute.setDefaultValue(this.getDefaultValue());
        attribute.setSourceType(this.getSourceType());
        attribute.setSource(this.getSource());
        attribute.setFormulaDesc(this.getFormulaDesc());
        attribute.setScopeId(this.getScopeId());
        attribute.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        if (!this.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(this, attribute);
            EngCOPropertiesComparator.copyRangeConstraint(this, attribute);
            EngCOPropertiesComparator.copyLOVConstraint(this, attribute);
        }
        attribute.setSynonym(this.getSynonym());
        attribute.setPreferredAbbreviation(this.getPreferredAbbreviation());
        attribute.setSensitiveType(this.getSensitiveType());
        attribute.setSensitiveTypeDescription(this.getSensitiveTypeDescription());
        block0: for (Attribute sourceNestedAtt : this.getNestedObjects()) {
            String sourceStructAttID = sourceNestedAtt.getStructAttributeID();
            if (sourceStructAttID.equals("")) continue;
            for (Attribute targetNestedAtt : attribute.getNestedObjects()) {
                if (!sourceStructAttID.equals(targetNestedAtt.getStructAttributeID())) continue;
                sourceNestedAtt.copy(targetNestedAtt);
                continue block0;
            }
        }
    }

    public void importAttribute(DesignObject desObject) {
        Attribute attribute = (Attribute)desObject;
        super.copy(attribute);
        attribute.setDesignObjectSet(this.getDesignObjectSet());
        attribute.setUnique(this.isUnique());
        attribute.setNullsAllowed(this.getNullsAllowed());
        attribute.setUse(this.getUse());
        attribute.setReference(this.isReference());
        if (this.getDomain() != null) {
            Domain sourceDomain = this.getDomain();
            Domain targetDomain = (Domain)attribute.getDesign().getDomainSet().getByName(sourceDomain.getName());
            if (targetDomain != null) {
                attribute.setDomain(targetDomain);
            } else {
                targetDomain = sourceDomain;
                targetDomain.copy(sourceDomain);
                targetDomain.setDesign(attribute.getDesign());
                targetDomain.setOwnerDesign(attribute.getDesign());
                targetDomain.setDirty(true);
                attribute.getDesign().getDomainSet().add(targetDomain);
                attribute.setDomain(targetDomain);
            }
        }
        attribute.setLogicalDatatype(this.getLogicalDatatype());
        attribute.setDataTypeParameter("size", this.getSize());
        attribute.setDataTypeParameter("precision", this.getPrecision());
        attribute.setDataTypeParameter("scale", this.getScale());
        attribute.setUsesDefaultValue(this.getUsesDefaultValue());
        attribute.setUseDomainConstraints(this.getUseDomainConstraints());
        attribute.setDefaultValue(this.getDefaultValue());
        attribute.setSourceType(this.getSourceType());
        attribute.setFormulaDesc(this.getFormulaDesc());
        attribute.setScopeId(this.getScopeId());
        attribute.setAllowSubtypeSubstitution(this.isAllowSubtypeSubstitution());
        attribute.setRestrictedTypeSubstitution(this.isRestrictedTypeSubstitution());
        attribute.setImportedId(this.getObjectID());
        attribute.setImportedDesign(this.getDesign());
    }

    public List getAlldelegates() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Attribute delegate = this.getDelegate(); delegate != null && !list.contains(delegate); delegate = delegate.getDelegate()) {
            list.add(delegate);
        }
        return list;
    }

    public Attribute getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Attribute value) {
        if (this.delegate != value) {
            if (this.delegate != null) {
                this.delegate.removeObjectListener(this);
            }
            this.delegate = value;
            if (this.delegate != null && !this.hasCircularRef()) {
                this.delegate.addObjectListener(this);
            }
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean setName(String name) {
        if (name != null && name.equals(this.name)) {
            return true;
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        propagateFKName = this.getDesign().getAppView().getSettings().isKeepFKNamesSynchronized();
        boolean result = super.setName(name);
        if (!this.getDesign().isLoading() && !ApplicationView.importing && result && propagateFKName) {
            list.add(this);
            this.propagateNameToDependent(name, list);
        }
        return result;
    }

    public void propagateNameToFKAttributes(String name) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        propagateFKName = this.getDesign().getAppView().getSettings().isKeepFKNamesSynchronized();
        if (propagateFKName) {
            list.add(this);
            this.propagateNameToDependent(name, list);
        }
    }

    private boolean setPropagatedName(String name, List list) {
        if (!list.contains(this)) {
            boolean result = super.setName(name);
            if (result && propagateFKName) {
                list.add(this);
                this.propagateNameToDependent(name, list);
            }
            return result;
        }
        return false;
    }

    private void propagateNameToDependent(String name, List list) {
        List dependent = ((LogicalDesign)this.getDesignPart()).getAttributeSet().getDependentOnDelegate(this);
        for (Attribute attr : dependent) {
            attr.setPropagatedName(name, list);
        }
    }

    public String getPreferredAbbreviation() {
        return this.preferredAbbreviation;
    }

    public void setPreferredAbbreviation(String preferredAbbreviation) {
        this.preferredAbbreviation = preferredAbbreviation;
    }

    public String getLogicalRepresentationName() {
        String name = "";
        if (this.getUse() == 0) {
            return this.getDomain().getLogicalRepresentationName(this.getDesign().getDesignLevelSettings().isLogicalTypeForDomainPresentation());
        }
        if (this.getUse() == 1) {
            name = this.getLogicalDatatype().getName();
            String size = this.getDataTypeParameter("size");
            if (size != null && !"".equals(size)) {
                if (!"".equals(size) && !"0".equals(size)) {
                    return name + " (" + size + ")";
                }
                return name;
            }
            String precision = this.getDataTypeParameter("precision");
            if (precision != null && !"".equals(precision)) {
                if (!"".equals(precision) && !"0".equals(precision)) {
                    String scale = this.getDataTypeParameter("scale");
                    if (!(scale == null || "".equals(scale) && !"*".equals(precision) || "0".equals(scale) && !"*".equals(precision))) {
                        return name + " (" + precision + "," + scale + ")";
                    }
                    return name + " (" + precision + ")";
                }
                return name;
            }
            return name;
        }
        if (this.getUse() == 3) {
            if (this.isReference()) {
                return "REF " + this.getStructuredType().getName();
            }
            return this.getStructuredType().getName();
        }
        if (this.getUse() == 2) {
            return this.getDistinctType().getName();
        }
        if (this.getUse() == 4) {
            return this.getCollectionType().getName();
        }
        return name;
    }

    @Override
    public void addAVT(AVT avt) {
        if (!this.getUseDomainConstraints()) {
            super.addAVT(avt);
        }
    }

    @Override
    public Set getAVTs() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getAVTs();
        }
        return super.getAVTs();
    }

    @Override
    public void removeAVT(AVT avt) {
        if (!this.getUseDomainConstraints()) {
            super.removeAVT(avt);
        }
    }

    @Override
    public void clearAVTs() {
        if (!this.getUseDomainConstraints()) {
            super.clearAVTs();
        }
    }

    @Override
    public void setValueList(ConstraintEnumeration valueList) {
        if (!this.getUseDomainConstraints()) {
            super.setValueList(valueList);
        }
    }

    @Override
    public CheckConstraint getCheck() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getCheck();
        }
        return super.getCheck();
    }

    @Override
    public void setCheck(CheckConstraint check) {
        if (!this.getUseDomainConstraints()) {
            super.setCheck(check);
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean shouldBeEngineered(XtdMapping tableMapping) {
        return !tableMapping.getAttributes().contains(this.getObjectID());
    }

    @Override
    public Domain getDomain() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getDomain();
        }
        return super.getDomain();
    }

    protected String getOriginatingTableName() {
        ArrayList<DesignObject> processed = new ArrayList<DesignObject>();
        processed.add(this);
        processed.add(this.getContainerWithKeyObject());
        String tName = this.getContainerWithKeyObject().getName();
        Attribute delg = this.delegate;
        while (delg != null) {
            processed.add(delg);
            ContainerWithKeyObject cont = delg.getContainerWithKeyObject();
            if (cont != null) {
                tName = cont.getName();
                if (processed.contains(cont)) {
                    delg = null;
                    continue;
                }
                processed.add(cont);
                if (delg.isFKAttribute()) {
                    if (!processed.contains(delg = delg.getDelegate())) continue;
                    delg = null;
                    continue;
                }
                delg = null;
                continue;
            }
            delg = null;
        }
        return tName;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    @Override
    public ContainedObject getDelegateElement() {
        return this.getDelegate();
    }

    @Override
    public void setDomain(Domain domain) {
        if (this.getDelegate() == null) {
            super.setDomain(domain);
        }
    }

    @Override
    public Datatype getDataType() {
        if (this.getAppView().getSettings().isAllowSimilarTypesFK() && !this.getParameters().isEmpty()) {
            return super.getDataType();
        }
        if (this.isReference() || this.getDelegate() == null || this.getDelegate() != null && this.hasCircularRef()) {
            return super.getDataType();
        }
        return this.getDelegate().getDataType();
    }

    @Override
    public LogicalDatatype getLogicalDatatype() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getLogicalDatatype();
        }
        return super.getLogicalDatatype();
    }

    private String getOriginatingAttributeName() {
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        processed.add(this);
        String tName = this.getName();
        Attribute delg = this.delegate;
        while (delg != null) {
            processed.add(delg);
            if (delg.isFKAttribute()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                delg = null;
                continue;
            }
            tName = delg.getName();
            delg = null;
        }
        return tName;
    }

    public Attribute getOriginatingAttribute() {
        if (!this.isFKAttribute()) {
            return null;
        }
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        processed.add(this);
        Attribute delg = this.delegate;
        boolean found = false;
        while (!found) {
            processed.add(delg);
            if (delg != null && delg.isFKAttribute()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                delg = null;
                found = true;
                continue;
            }
            found = true;
        }
        return delg;
    }

    public boolean hasCircularRef() {
        if (this.delegate == null) {
            return false;
        }
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        processed.add(this);
        Attribute delg = this.delegate;
        boolean found = false;
        while (!found) {
            processed.add(delg);
            if (delg != null && delg.isFKAttribute()) {
                if (!processed.contains(delg = delg.getDelegate())) continue;
                return true;
            }
            found = true;
        }
        return false;
    }

    @Override
    public String toString() {
        String longName;
        if (!this.isFKAttribute()) {
            return this.getName();
        }
        String tName = this.getOriginatingTableName();
        String atName = this.getOriginatingAttributeName();
        if (this.getRelation() != null) {
            String rName = this.getRelation().getName();
            longName = !tName.equals("") ? tName + "." + atName + "," + rName : atName + "," + rName;
        } else {
            longName = !tName.equals("") ? tName + "." + atName : super.getName();
        }
        return longName;
    }

    @Override
    public String getDataTypeParameter(String key) {
        String res = "";
        boolean superProcessed = false;
        if (this.getAppView().getSettings().isAllowSimilarTypesFK()) {
            res = super.getDataTypeParameter(key);
            superProcessed = true;
        }
        if (res.isEmpty() && this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getDataTypeParameter(key);
        }
        if (superProcessed) {
            return res;
        }
        return super.getDataTypeParameter(key);
    }

    public Relation.Connection getConnection() {
        return this.connection;
    }

    public void setConnectionIfNull(Relation.Connection connection) {
        if (this.connection == null) {
            this.connection = connection;
        }
    }

    public Relation getRelation() {
        if (this.hasRelation()) {
            return this.connection.getRelation();
        }
        return null;
    }

    @Override
    public boolean getNullsAllowed() {
        if (!this.isFKAttribute()) {
            return super.getNullsAllowed();
        }
        return !this.isPKElement() && this.isValid() && this.getConnection().isOptional();
    }

    public boolean hasRelation() {
        return this.getConnection() != null;
    }

    public boolean isValid() {
        return this.hasDelegate() && this.hasRelation();
    }

    private int getPositionInPKOfDelegate() {
        return this.getDelegate().getPositionInPK();
    }

    public int getPositionInRelation() {
        return this.getPositionInPKOfDelegate();
    }

    @Override
    public void setNullsAllowed(boolean value) {
        if (!this.isFKAttribute()) {
            super.setNullsAllowed(value);
        }
    }

    public void setDefaultName() {
        if (this.isValid()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDelegate().getContainerWithKeyObject().getName());
            buffer.append('.');
            String name = this.getDelegate().getName();
            if (name.indexOf(46) > 0) {
                name = name.substring(name.indexOf(46) + 1);
            }
            buffer.append(name);
            int count = 0;
            while (this.connection.getEntity().getElementByName(buffer.toString()) != null) {
                buffer.append(++count);
            }
            this.setName(buffer.toString());
        }
    }

    public void setConnection(Relation.Connection connection) {
        this.connection = connection;
    }

    @Override
    public short getUse() {
        if (this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getUse();
        }
        return super.getUse();
    }

    @Override
    public void setComment(String comment) {
        if (!ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || this.getDelegate() == null) {
            super.setComment(comment);
        }
    }

    @Override
    public void setNotes(String notes) {
        if (!ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || this.getDelegate() == null) {
            super.setNotes(notes);
        }
    }

    @Override
    public String getComment() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getComment();
        }
        return super.getComment();
    }

    @Override
    public String getNotes() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return this.getDelegate().getNotes();
        }
        return super.getNotes();
    }

    @Override
    public void setCommentInRDBMS(String comment) {
        if (!(comment == null || "null".equalsIgnoreCase(comment) || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null)) {
            super.setCommentInRDBMS(comment);
        }
    }

    @Override
    public String getCommentInRDBMS() {
        String result = ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef() ? this.getDelegate().getCommentInRDBMS() : super.getCommentInRDBMS();
        result = result == null ? "" : result;
        return result;
    }

    public String getCommentInRDBMStoStore() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return null;
        }
        return super.getCommentInRDBMS();
    }

    public String getCommentToStore() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return null;
        }
        return super.getComment();
    }

    public String getNotesToStore() {
        if (ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && this.getDelegate() != null && !this.hasCircularRef()) {
            return null;
        }
        return super.getNotes();
    }

    @Override
    public void setUse(short use) {
        short oldUse = super.getUse();
        if (use != oldUse) {
            Entity entity;
            super.setUse(use);
            if (!(this.getDesign().isLoading() || use != 3 && oldUse != 3 || (entity = (Entity)this.getContainer()) == null)) {
                entity.createNestedAttributes(this.getStructuredType(), this);
            }
        }
    }

    @Override
    public void setReference(boolean reference) {
        if (this.isReference() != reference) {
            Entity entity;
            super.setReference(reference);
            if (!this.getDesign().isLoading() && (entity = (Entity)this.getContainer()) != null) {
                entity.createNestedAttributes(this.getStructuredType(), this);
            }
        }
    }

    @Override
    public void setStructuredType(StructuredType structuredType) {
        StructuredType old = this.getStructuredType();
        if (old != structuredType) {
            if (old != null) {
                old.removeObjectListener(this);
            }
            super.setStructuredType(structuredType);
            Entity entity = (Entity)this.getContainer();
            if (entity != null) {
                if (!this.getDesign().isLoading()) {
                    entity.createNestedAttributes(structuredType, this);
                }
                if (structuredType != null) {
                    structuredType.addObjectListener(this);
                }
            }
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        Entity entity;
        super.changed(object, event);
        if (object instanceof StructuredType && (entity = (Entity)this.getContainerWithKeyObject()) != null) {
            entity.createNestedAttributes(this.getStructuredType(), this);
        }
    }

    public Entity getEntity() {
        return (Entity)this.getContainerWithKeyObject();
    }

    public Relation getContainerRelation() {
        if (this.getEntity() != null) {
            return this.getEntity().getContainerRelation();
        }
        return null;
    }
}

