/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.impact.ImpA_Entity;
import oracle.dbtools.crest.model.design.impact.ImpA_Relation;
import oracle.dbtools.crest.model.design.impact.ImpA_TableView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Table
extends ModelIdObjectSelection {
    private Table table;

    public ImpA_Table(Table table, ModelIdObjectSelection parent, boolean load) {
        super(table);
        this.loaded = false;
        this.table = table;
        this.setParent(parent);
        if (load) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addTableNodes(this);
        ImpA_Entity.addDimensionalModels(this, this.table);
        this.loaded = true;
    }

    private void addTableNodes(ImpA_Table parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.Mappings"));
        selection.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        parent.addChild(selection);
        if (this.table.getObjectID() != null) {
            List list = this.table.getDesign().getExtendedMap().getMappingsForDesignPart(this.table, this.table.getDesign().getLogicalDesign().getObjectID());
            for (XtdMapping mapping : list) {
                DesignObject designObject = mapping.getObjectMappedTo(this.table);
                if (designObject == null) continue;
                if (designObject instanceof Entity) {
                    if (!selection.hasAsParent(designObject)) {
                        selection.addChild(new ImpA_Entity((Entity)designObject, selection, false));
                        continue;
                    }
                    selection.addChild(new ModelIdObjectSelection(designObject));
                    continue;
                }
                if (!selection.hasAsParent(designObject)) {
                    selection.addChild(new ImpA_Relation((Relation)designObject, selection, false));
                    continue;
                }
                selection.addChild(new ModelIdObjectSelection(designObject));
            }
        }
        selection.sort();
        this.addTableViews();
        this.addSubViews();
    }

    private void addTableViews() {
        ModelIdObjectSelection viewSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.DependentViews"));
        viewSelection.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        this.addChild(viewSelection);
        ArrayList<TableView> list = new ArrayList<TableView>();
        Iterator it = ((RelationalDesign)this.table.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            if (view.getContainerHolderFor(this.table) == null && (!view.isValidSQL() || !view.sqlNameExists(this.table.getObjectID()))) continue;
            list.add(view);
        }
        if (list.size() > 0) {
            for (TableView view : list) {
                if (!viewSelection.hasAsParent(view)) {
                    viewSelection.addChild(new ImpA_TableView(view, viewSelection));
                    continue;
                }
                viewSelection.addChild(new ModelIdObjectSelection(view));
            }
        }
        viewSelection.sort();
    }

    private void addSubViews() {
        ModelIdObjectSelection viewSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Table.UsedInSubViews"));
        viewSelection.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        this.addChild(viewSelection);
        for (DesignPartView dpv : this.table.getAffectedDPVs()) {
            if (!dpv.isMasterDPV() || dpv.isMainDiagram()) continue;
            PlaceHolder ph = dpv.getPlaceHolder();
            ModelIdObjectSelection sv = new ModelIdObjectSelection(ph);
            sv.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
            viewSelection.addChild(sv);
        }
        viewSelection.sort();
    }
}

