/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Index;

public class KeyIndexComparator
extends EngPropertiesComparator {
    private CandidateKey key;
    private Index index;

    public KeyIndexComparator(CandidateKey key, Index index) {
        super(key, index);
        this.key = key;
        this.index = index;
        this.initPropertiesList();
    }

    public KeyIndexComparator(CandidateKey key, Index index, List filters) {
        this(key, index);
        this.applyCompareFilter(filters, key.getDesign().getShowSelPropsOnly());
    }

    protected void initPropertiesList() {
        Entity ent;
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        this.initDeprecated();
        this.initCommentsAndNotes();
        EngPropertyHolder ph = new EngPropertyHolder(PRIMARY_KEY);
        ph.setLeftValue(this.key != null ? (this.key.isPK() && !this.key.getEntity().isCreateSurrogateKey() ? YES : NO) : "");
        ph.setRightValue(this.index != null ? (this.index.isPK() ? YES : NO) : "");
        if (this.key != null && this.index != null && (this.key.isPK() && !this.key.getEntity().isCreateSurrogateKey()) != this.index.isPK() && (!(ent = (Entity)this.key.getContainerWithKeyObject()).isHierarchicalEntityType() || ent.isHierarchicalRoot() || "Table for each entity".equals(ent.getFwdEngineeringStrategyName()))) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
        ph = new EngPropertyHolder(ATTRIBUTES_COLUMNS);
        ph.setLeftValue(this.key != null ? this.key.getElemntsPresentationAsString() : "");
        ph.setRightValue(this.index != null ? this.getElementsToString(this.index) : "");
        if (this.key != null && this.index != null && FWDEngineering.isColumnsChangedForKeyAndIndex(this.key, this.index)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private String getElementsToString(KeyObject keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = (ContainedObject)it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append(" \n").append(co.getName());
        }
        return sb.toString();
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromKeyToIndex();
        }
    }

    protected void copyPropertiesFromKeyToIndex() {
        if (this.key != null && this.index != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(PRIMARY_KEY)) {
                    this.index.setPK(this.key.isPK());
                    continue;
                }
                if (!ph.getName().equals(ATTRIBUTES_COLUMNS)) continue;
                FWDEngineering.synchronizeColumnsForKeyAndIndex(this.key, this.index);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.key != null ? this.key.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.index != null ? this.index.getLongName() : "";
    }
}

