/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class AttributeColumnComparator
extends EngCOPropertiesComparator {
    private Attribute attribute;
    private Column column;

    public AttributeColumnComparator(Attribute attribute, Column column) {
        super(attribute, column);
        this.attribute = attribute;
        this.column = column;
        this.initPropertiesList();
    }

    public AttributeColumnComparator(Attribute attribute, Column column, List filters) {
        this(attribute, column);
        this.applyCompareFilter(filters, attribute.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyScopeFromAttributeToColumn();
        }
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        EngPropertyHolder ph = new EngPropertyHolder(SCOPE);
        Table engScope = null;
        if (this.column != null && this.attribute != null && this.attribute.getScope() != null) {
            ph.setLeftValue(this.attribute.getScope().getName());
            engScope = ((Entity)this.attribute.getScope()).getEngTable((RelationalDesign)this.column.getDesignPart());
        } else {
            ph.setLeftValue("");
        }
        if (this.column != null && this.column.getScope() != null) {
            ph.setRightValue(this.column.getScope().getName());
        } else {
            ph.setRightValue("");
        }
        if (this.attribute != null && this.column != null && engScope != this.column.getScope()) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    private void copyScopeFromAttributeToColumn() {
        if (this.attribute != null && this.column != null) {
            this.column.setTemporaryWriteable(true);
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(SCOPE)) continue;
                if (this.attribute.getScope() != null) {
                    Table tab = ((Entity)this.attribute.getScope()).getEngTable((RelationalDesign)this.column.getDesignPart());
                    if (tab != null) {
                        this.column.setScopeId(tab.getObjectID());
                        continue;
                    }
                    this.column.setScopeId(null);
                    continue;
                }
                this.column.setScopeId(null);
            }
            this.column.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.attribute != null ? this.attribute.getContainerWithKeyObject().getName() + "." + this.attribute.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.column != null ? this.column.getContainerWithKeyObject().getName() + "." + this.column.getName() : "";
    }
}

