/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.datatypes.TypeElementSet;
import oracle.dbtools.crest.swingui.datatypes.AbstractDTTV;
import oracle.dbtools.crest.swingui.editor.datatypes.StructuredTypePropertiesDialogEx;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class StructuredType
extends AbstractDTObject
implements ObjectListener,
Datatype,
EditableFonts {
    private StructuredType parentType;
    private String parentTypeID = "";
    private String inheritanceRelationID = "";
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    private IDGenerator localIDGenerator;
    private IDGenerator methodIDGenerator;
    private Map localIDs = new TreeMap();
    private Map methodIDs = new TreeMap();
    private boolean isFinal = false;
    private boolean instantiable = true;
    private DTInheritance inheritanceRelation;
    private DesignObjectCollection elements = new DesignObjectCollection();
    private DesignObjectCollection methods = new DesignObjectCollection();
    private List editableFonts = new ArrayList();
    private String className;
    public static String MAP = "MAP";
    public static String STRUCT = "STRUCT";
    public static String UNIONTYPE = "UNIONTYPE";
    public static String[] HIVE_TYPE_CHOICES = new String[]{"", MAP, UNIONTYPE};
    private String hiveType = "";
    private int maxLengthAsString = 0;
    protected ObjectChangeEvent predefinedEvent = new ObjectChangeEvent(Messages.getString("StructuredType.PredefinedStatusChanged"));
    private static final Logger LOGGER = new Logger(StructuredType.class);
    public static final String TYPE_NAME = "StructuredType";

    public StructuredType(DesignPart designPart) {
        super(designPart);
        this.elements.setParent(this);
        this.elements.setName(Messages.getString("StructuredType.Attributes"));
        this.elements.setElementDescriptor(TypeElement.class);
        this.methods.setParent(this);
        this.methods.setName(Messages.getString("StructuredType.Methods"));
        this.methods.setElementDescriptor(Method.class);
    }

    public TypeElementSet getTypeElementSet() {
        return ((DataTypesDesign)this.getDesignPart()).getTypeElementSet();
    }

    public MethodSet getMethodSet() {
        return ((DataTypesDesign)this.getDesignPart()).getMethodSet();
    }

    public void add(TypeElement object) {
        if (object == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(object)) {
            return;
        }
        if (this.getContainedClass().isAssignableFrom(object.getClass())) {
            String newName;
            if (!(this.getDesign().isLoading() || this.getDesign().getAppView().isImporting() || (newName = this.validateElementName(object.getName(), 0)).equalsIgnoreCase(object.getName()))) {
                String message = MessageFormat.format(Messages.getString("StructuredType.TypeElementExists"), object.getName(), newName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message);
                object.setName(newName);
            }
        } else {
            LOGGER.error("Class: " + object.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
        this.assignLocalID(object);
        object.setParent(this.elements);
        this.elements.add(object);
        object.setStructuredType(this);
        this.getTypeElementSet().add(object);
        object.addObjectListener(this);
        ObjectChangeEvent event = new ObjectChangeEvent(ObjectChangeEvent.ELEMENT_ADDED.getDescription());
        event.setAffected(object);
        this.fireChange(event);
    }

    public void addMethod(Method method) {
        if (method == null || this.isReadOnly()) {
            return;
        }
        if (this.containsMethod(method)) {
            return;
        }
        if (!this.getMethodClass().isAssignableFrom(method.getClass())) {
            LOGGER.error("Class: " + method.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
        this.assignMethodID(method);
        this.methods.add(method);
        this.getMethodSet().add(method);
        method.setStructuredType(this);
        method.setParent(this.methods);
        method.addObjectListener(this);
        this.sharedEvent.setAffected(method);
        this.fireChange(this.sharedEvent);
    }

    public boolean contains(TypeElement element) {
        return this.elements.contains(element);
    }

    public boolean containsMethod(Method method) {
        return this.methods.contains(method);
    }

    public Class getContainedClass() {
        return TypeElement.class;
    }

    public Class getMethodClass() {
        return Method.class;
    }

    protected void assignLocalID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.localIDs.put(id, object);
        }
    }

    protected void assignMethodID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.methodIDs.containsKey(id = this.getMethodIDGenerator().createNewID())) {
            }
            this.methodIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.methodIDs.put(id, object);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public IDGenerator getMethodIDGenerator() {
        if (this.methodIDGenerator == null) {
            this.methodIDGenerator = new IDGenerator();
            this.methodIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.methodIDGenerator;
    }

    @Override
    public void remove() {
        this.updateInheritance(null);
        this.removeAll();
        this.removeAllMethods();
        super.remove();
    }

    public void remove(TypeElement object) {
        if (object != null && this.isWriteable()) {
            this.getTypeElementSet().remove(object);
            this.elements.remove(object);
            object.setStructuredType(null);
            this.localIDs.remove(object.getObjectID());
            object.removeObjectListener(this);
            object.setParent(null);
            this.fireChange(ObjectChangeEvent.ELEMENT_REMOVED);
        }
    }

    public TypeElement[] removeAll() {
        TypeElement[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            this.remove(elms[i]);
        }
        return elms;
    }

    public void removeMethod(Method object) {
        if (object != null && this.isWriteable()) {
            this.getMethodSet().remove(object);
            this.methods.remove(object);
            object.setStructuredType(null);
            this.methodIDs.remove(object.getObjectID());
            object.removeObjectListener(this);
            object.setParent(null);
            this.sharedEvent.setAffected(object);
            this.fireChange(this.sharedEvent);
        }
    }

    public Method[] removeAllMethods() {
        Method[] mtds = this.getMethods();
        for (int i = 0; i < mtds.length; ++i) {
            this.removeMethod(mtds[i]);
        }
        return mtds;
    }

    public TypeElement[] getElements() {
        return this.toElementObjectArray(this.elements.getElementsList());
    }

    public Method[] getMethods() {
        return this.toMethodObjectArray(this.methods.getElementsList());
    }

    public TypeElement[] toElementObjectArray(Collection collection) {
        return (TypeElement[])collection.toArray((Object[])Array.newInstance(this.getContainedClass(), 0));
    }

    public Method[] toMethodObjectArray(Collection collection) {
        return (Method[])collection.toArray((Object[])Array.newInstance(this.getMethodClass(), 0));
    }

    public TypeElement getElementByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            TypeElement co = (TypeElement)it.next();
            if (!localID.equals(co.getObjectID())) continue;
            it = null;
            return co;
        }
        it = null;
        return null;
    }

    public Method getMethodByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.methods.iterator();
        while (it.hasNext()) {
            Method co = (Method)it.next();
            if (!localID.equals(co.getObjectID())) continue;
            it = null;
            return co;
        }
        it = null;
        return null;
    }

    public TypeElement getElementByName(String name) {
        if (name == null) {
            return null;
        }
        for (TypeElement co : this.elements) {
            if (!name.equalsIgnoreCase(co.getName())) continue;
            return co;
        }
        return null;
    }

    public Method getMethodByName(String name) {
        if (name != null) {
            for (Method co : this.methods) {
                if (!name.equalsIgnoreCase(co.getName())) continue;
                return co;
            }
        }
        return null;
    }

    public Method getMethodByNameAndNumber(String name, int number) {
        if (name != null) {
            for (Method method : this.methods) {
                if (!name.equalsIgnoreCase(method.getName()) || number != method.getNumber()) continue;
                return method;
            }
        }
        return null;
    }

    public Method getMethod(int index) {
        return (Method)this.methods.getElement(index);
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.elements;
            }
            case 1: {
                return this.methods;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.elements) {
            return 0;
        }
        if (child == this.methods) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public StructuredType getParentType() {
        if (this.parentType == null && !"".equalsIgnoreCase(this.parentTypeID)) {
            this.parentType = (StructuredType)this.getDesign().getDesignObject(this.parentTypeID);
            this.parentTypeID = "";
        }
        return this.parentType;
    }

    public void setParentType(StructuredType parentType, boolean showMessage) {
        if (this.parentType != parentType) {
            if (parentType != null && showMessage) {
                String message = Messages.getString("StructuredType.TypeElementsCouldBeRenamed");
                int r = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), message, Messages.getString("StructuredType.Warning"), 0);
                if (r == 0) {
                    StructuredType newParent = parentType;
                    this.parentType = parentType;
                    if (!this.getDesign().isLoading()) {
                        this.updateInheritance(newParent);
                        if (parentType != null) {
                            this.refreshChildElementsNames();
                        }
                    }
                    this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
                }
            } else {
                StructuredType newParent = parentType;
                this.parentType = parentType;
                if (!this.getDesign().isLoading() && !this.getDesign().getAppView().isImporting()) {
                    this.updateInheritance(newParent);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
        }
    }

    public void setParentType(StructuredType parentType) {
        this.setParentType(parentType, false);
    }

    public void updateInheritance() {
        if (this.getParentType() != null) {
            this.updateInheritance(this.getParentType());
        }
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public String getSize() {
        return "";
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean instantiable) {
        this.instantiable = instantiable;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            StructuredTypePropertiesDialogEx dialog = new StructuredTypePropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event == ObjectChangeEvent.OBJECT_REMOVED) {
            if (event.getAffected() instanceof TypeElement) {
                this.remove((TypeElement)event.getAffected());
            } else if (event.getAffected() instanceof Method) {
                this.removeMethod((Method)event.getAffected());
            }
        } else {
            this.fireChange(event);
        }
    }

    public boolean isParentOf(StructuredType child) {
        if (child == this) {
            return true;
        }
        for (StructuredType st = child.getParentType(); st != null; st = st.getParentType()) {
            if (st != this) continue;
            return true;
        }
        return false;
    }

    private String validateElementName(String name, int idx) {
        String newName = name;
        for (TypeElement element : this.getParentAndChildElements()) {
            if (!element.getName().equalsIgnoreCase(newName)) continue;
            String suffix = "_".concat(String.valueOf(idx));
            if (newName.endsWith(suffix)) {
                newName = newName.substring(0, newName.lastIndexOf(suffix));
            }
            newName = newName.concat("_").concat(String.valueOf(++idx));
            newName = this.validateElementName(newName, idx);
            break;
        }
        return newName;
    }

    public List getParentElements() {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        for (StructuredType st = this.getParentType(); st != null; st = st.getParentType()) {
            for (int i = 0; i < st.getElements().length; ++i) {
                list.add(st.getElements()[i]);
            }
        }
        return list;
    }

    public List getAllElements() {
        ArrayList list = new ArrayList();
        if (this.getParentType() != null) {
            this.getParentType().addParentElements(list);
        }
        this.elements.addAllElementsTo(list);
        return list;
    }

    public List getChildElements() {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        Iterator it = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            TypeElement[] elems = st.getElements();
            for (int i = 0; i < elems.length; ++i) {
                list.add(elems[i]);
            }
            list.addAll(st.getChildElements());
        }
        return list;
    }

    public List getParentAndChildElements() {
        ArrayList list = new ArrayList();
        list.addAll(this.getParentElements());
        list.addAll(this.getChildElements());
        return list;
    }

    protected void refreshChildElementsNames() {
        TypeElement[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            TypeElement te = elms[i];
            te.setName(this.validateElementName(te.getName(), 0));
        }
        Iterator it = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            st.refreshChildElementsNames();
        }
    }

    public List getAllMethods() {
        ArrayList list = new ArrayList();
        if (this.getParentType() != null) {
            this.getParentType().addParentMethods(list);
        }
        this.methods.addAllElementsTo(list);
        return list;
    }

    private void addParentElements(List list) {
        if (this.getParentType() != null) {
            this.getParentType().addParentElements(list);
        }
        this.elements.addAllElementsTo(list);
    }

    private void addParentMethods(List list) {
        if (this.getParentType() != null) {
            this.getParentType().addParentMethods(list);
        }
        this.methods.addAllElementsTo(list);
    }

    public void setParentTypeID(String parentTypeID) {
        this.parentTypeID = parentTypeID;
        DesignObject parent = this.getDesign().getDesignObject(parentTypeID);
        if (parent != null && parent instanceof StructuredType) {
            this.createInheritance((StructuredType)parent);
        } else {
            this.getDesignPart().addTask(new CreateInheritanceTask(this));
        }
    }

    public String getParentTypeID() {
        if (this.getParentType() != null) {
            return this.getParentType().getObjectID();
        }
        return this.parentTypeID;
    }

    protected void updateInheritance(StructuredType newParent) {
        if (newParent == null) {
            if (this.inheritanceRelation != null) {
                this.inheritanceRelation.remove();
                this.inheritanceRelation = null;
            }
        } else {
            if (this.inheritanceRelation != null) {
                if (this.inheritanceRelation.getSourceDTObject() == this.parentType) {
                    return;
                }
                this.inheritanceRelation.remove();
            }
            this.inheritanceRelation = this.getDesign().getDataTypesDesign().createDTInheritance();
            this.inheritanceRelation.setSourceDTObject(newParent);
            this.inheritanceRelation.setSourceTV((AbstractDTTV)newParent.getTopView());
            this.inheritanceRelation.setTargetDTObject(this);
            this.inheritanceRelation.setTargetTV((AbstractDTTV)this.getTopView());
        }
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
        super.fireChange(event);
        if (!this.getDesign().isLoading()) {
            for (StructuredType st : this.getDesign().getDataTypesDesign().getStructuredTypeSet().getDirectSubtypes(this)) {
                st.changed(this, event);
            }
        }
    }

    public boolean moveElementToIndex(DesignObject object, int index) {
        if (this.elements.getIndexOf(object) == index) {
            return true;
        }
        boolean result = this.elements.moveElementToIndex(object, index);
        this.sharedEvent.setAffected(object);
        this.fireChange(this.sharedEvent);
        return result;
    }

    public boolean moveMethodToIndex(DesignObject object, int index) {
        if (this.methods.getIndexOf(object) == index) {
            return true;
        }
        boolean result = this.methods.moveElementToIndex(object, index);
        this.sharedEvent.setAffected(object);
        this.fireChange(this.sharedEvent);
        return result;
    }

    public void setInheritanceRelation(DTInheritance inheritanceRelation) {
        this.inheritanceRelation = inheritanceRelation;
    }

    public boolean containsElementOfStructuredType(StructuredType strType) {
        if (strType.isParentOf(this) || this.isParentOf(strType)) {
            return true;
        }
        Object[] tes = this.getAllElementsInHierarchy().toArray();
        for (int i = 0; i < tes.length; ++i) {
            TypeElement te = (TypeElement)tes[i];
            if (!(te.getType() instanceof StructuredType) || te.isReference()) continue;
            StructuredType st = (StructuredType)te.getType();
            if (strType.isParentOf(st) || st.isParentOf(strType)) {
                return true;
            }
            boolean check = st.containsElementOfStructuredType(strType);
            if (!check) continue;
            return true;
        }
        return false;
    }

    private StructuredType getRoot() {
        StructuredType st = this;
        while (st.getParentType() != null) {
            st = st.getParentType();
        }
        return st;
    }

    private List getSubTypes() {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            list.add(st);
        }
        return list;
    }

    public List getAllSubTypes() {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            list.add(st);
            list.addAll(st.getSubTypes());
        }
        return list;
    }

    public List getAllInstantiableSubTypes(boolean includingMe) {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        if (includingMe && this.instantiable) {
            list.add(this);
        }
        Iterator it = this.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            list.addAll(st.getAllInstantiableSubTypes(true));
        }
        return list;
    }

    public boolean hasInstantiableSubtype() {
        Iterator it = this.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this || !st.isInstantiable() && !st.hasInstantiableSubtype()) continue;
            return true;
        }
        return false;
    }

    private List getOwnAndChildsElements() {
        ArrayList list = new ArrayList();
        this.elements.addAllElementsTo(list);
        for (StructuredType st : this.getSubTypes()) {
            list.addAll(st.getOwnAndChildsElements());
        }
        return list;
    }

    public List getAllElementsInHierarchy() {
        return this.getRoot().getOwnAndChildsElements();
    }

    @Override
    public void copy(DesignObject desObject) {
        StructuredType st = (StructuredType)desObject;
        super.copy(st);
        if (this.getParentType() != null) {
            st.setParentTypeID(this.getParentType().getObjectID());
        }
        st.updateInheritance(st.getParentType());
        st.setFinal(this.isFinal());
        st.setInstantiable(this.isInstantiable());
        st.setHiveType(this.getHiveType());
        for (TypeElement element : Arrays.asList(this.getElements())) {
            TypeElement newelement = new TypeElement(st.getDesignPart(), st);
            element.copy(newelement);
            element.copyDataType(newelement);
            newelement.setDesign(st.getDesign());
            st.add(newelement);
        }
        for (Method metod : Arrays.asList(this.getMethods())) {
            Method newmetod = new Method(st.getDesignPart(), st);
            metod.copy(newmetod);
            newmetod.setDesign(st.getDesign());
            st.addMethod(newmetod);
        }
    }

    @Override
    public String getFCObjectType() {
        return "Structured Type";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public TypeElement createTypeElement(String typeName) {
        TypeElement typeElem = new TypeElement(this.getDesignPart(), this);
        typeElem.setName(typeName);
        typeElem.setDesign(this.getDesign());
        typeElem.setParent(this);
        this.add(typeElem);
        return typeElem;
    }

    public Method createMethod(String methodName) {
        Method method = new Method(this.getDesignPart(), this);
        method.setName(methodName);
        method.setDesign(this.getDesign());
        method.setParent(this);
        this.addMethod(method);
        return method;
    }

    public DTInheritance getInheritanceRelation() {
        return this.inheritanceRelation;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "structuredtype" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public TypeElement createTypeElement() {
        return this.createTypeElement("");
    }

    public Method createMethod() {
        return this.createMethod(null);
    }

    public List getAttributesList() {
        if (this.elements.size() > 0) {
            ArrayList list = new ArrayList();
            this.elements.addAllElementsTo(list);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public int getAttributesCount() {
        return this.elements.size();
    }

    public List getMethodsList() {
        if (this.methods.size() > 0) {
            ArrayList list = new ArrayList();
            this.methods.addAllElementsTo(list);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    private void createInheritance(StructuredType parent) {
        this.inheritanceRelation = (DTInheritance)((DataTypesDesign)this.getDesignPart()).getDTInheritanceSet().getObjectByID(this.inheritanceRelationID);
        if (this.inheritanceRelation == null) {
            this.inheritanceRelation = ((DataTypesDesign)this.getDesignPart()).createDTInheritance();
            if (!"".equals(this.inheritanceRelationID)) {
                this.inheritanceRelation.setObjectID(this.inheritanceRelationID);
            }
        }
        this.inheritanceRelation.setSourceDTObject(parent);
        this.inheritanceRelation.setTargetDTObject(this);
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        super.translateIdToObject(propertyName, id);
        if ("inheritanceRelation".equalsIgnoreCase(propertyName)) {
            this.inheritanceRelationID = id;
        }
        return null;
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getHiveType() {
        return this.hiveType;
    }

    public void setHiveType(String hiveType) {
        this.hiveType = hiveType;
    }

    public static String[] getHIVE_TYPE_CHOICES() {
        return HIVE_TYPE_CHOICES;
    }

    public int getMaxLengthAsString() {
        return this.maxLengthAsString;
    }

    public void setMaxLengthAsString(int maxLengthAsString) {
        this.maxLengthAsString = maxLengthAsString;
    }

    public String getDataTypePresentationForHive() {
        String type = "String";
        TypeElement[] elems = this.getElements();
        if (elems.length > 0) {
            if (MAP.equals(this.getHiveType())) {
                if (elems.length > 1) {
                    type = "MAP<" + elems[0].getDataTypePresentationForHive() + "," + elems[1].getDataTypePresentationForHive() + ">";
                    return type;
                }
            } else {
                if (UNIONTYPE.equals(this.getHiveType())) {
                    type = "UNIONTYPE<";
                    for (int i = 0; i < elems.length; ++i) {
                        TypeElement te = elems[i];
                        if (i > 0) {
                            type = type + ",";
                        }
                        type = type + te.getDataTypePresentationForHive();
                    }
                    type = type + ">";
                    return type;
                }
                type = "STRUCT<";
                for (int i = 0; i < elems.length; ++i) {
                    TypeElement te = elems[i];
                    if (i > 0) {
                        type = type + ",";
                    }
                    type = type + te.getName();
                    type = type + ":" + te.getDataTypePresentationForHive();
                }
                type = type + ">";
                return type;
            }
        }
        return type;
    }

    public class CreateInheritanceTask
    implements Task {
        private static final String TASK_NAME = "create Inheritance task";
        StructuredType st;

        CreateInheritanceTask(StructuredType st) {
            this.st = st;
        }

        @Override
        public boolean execute() {
            StructuredType parent = this.st.getParentType();
            if (parent != null) {
                this.st.createInheritance(parent);
                return this.st.inheritanceRelation != null;
            }
            return false;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

