/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.options.Settings;

public class CSSBAlterColumnOraclev10g
extends AbstractCSSBOraclev10g {
    private Column sourceColumn;
    private Table sourceTable;
    private SSBAutoIncrementColumnOracle targetSSBAutoIncCol = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        this.sourceColumn = (Column)obj.getObject();
        this.sourceTable = (Table)this.sourceColumn.getContainer();
        if (this.sourceTable != null) {
            Design design = this.sourceTable.getDesign();
            RDBMSSite site = this.sourceTable.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, this.sourceTable);
            if (obj.canBeCreate()) {
                this.appendAddColumn(oldbuffer, obj, this.sourceColumn, this.sourceTable, prettyPrint);
            } else {
                this.appendModifyColumn(oldbuffer, obj, tobj, prettyPrint);
            }
        }
    }

    public static boolean isNotSkipColumnFromObjectTable(TableProxy tp, Map propMap) {
        Table table = (Table)tp.getObject();
        if (table.isBST()) {
            int count = 0;
            if (propMap.containsKey(PropertiesComparator.NAME)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.DATA_TYPE)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.COMPUTED)) {
                ++count;
            }
            if (propMap.containsKey(PropertiesComparator.FORMULA_DESC)) {
                ++count;
            }
            if (propMap.size() > count) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendModifyColumn(StringBuffer oldbuffer, CompareObjectSelection obj, CompareObjectSelection tobj, boolean prettyPrint) {
        StorageDesignOracle targetStorageDesign;
        DDLAdvancedGenerator oldg;
        boolean updateVirtualColDef;
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.sourceTable.getObjectID());
        Map propMap = this.getPropertiesMap(obj);
        if (tableProxy == null || propMap.isEmpty() || !CSSBAlterColumnOraclev10g.isNotSkipColumnFromObjectTable(tableProxy, propMap)) return;
        String tableName = this.getTableName(obj);
        StringBuffer buffer = new StringBuffer();
        ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)obj.getProxy();
        Column targetColumn = (Column)tobj.getObject();
        ColumnProxyOracle targetColumnProxy = (ColumnProxyOracle)tobj.getProxy();
        if (propMap.containsKey(PropertiesComparator.NAME) && !this.sourceTable.isBST()) {
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            this.appendRenameColumn(oldbuffer, obj, tobj, prettyPrint);
        }
        if (propMap.containsKey(PropertiesComparator.COMMENT_IN_RDBMS) && this.storageDesign.getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOnColumn(oldbuffer, tableName, obj, columnProxy, prettyPrint);
        }
        boolean bl = updateVirtualColDef = columnProxy.isVirtual() && (propMap.containsKey(PropertiesComparator.FORMULA_DESC) || propMap.containsKey(PropertiesComparator.COMPUTED));
        if (updateVirtualColDef || propMap.containsKey(PropertiesComparator.DATA_TYPE) && !this.sourceTable.isBST() || propMap.containsKey(PropertiesComparator.MANDATORY) || propMap.containsKey(PropertiesComparator.NNC_NAME) || propMap.containsKey(PropertiesComparator.DEFAULT_VALUE)) {
            String addvancedComment;
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
            if (propMap.get(PropertiesComparator.NNC_NAME) != null && !propMap.containsKey(PropertiesComparator.MANDATORY) && this.sourceColumn.isMandatory() && targetColumn.isMandatory()) {
                String nnc = targetColumn.getNotNullConstraintName();
                if (nnc != null && !"".equals(nnc)) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                    addvancedComment = buffer.toString() + "DROP" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(nnc);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nnc));
                    this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                    CDDLFileMaker.incrementAlterTable();
                } else if (!targetColumn.isPKElement()) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                    addvancedComment = buffer.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxy);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                    this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, addvancedComment);
                    CDDLFileMaker.incrementAlterTable();
                }
            }
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
            addvancedComment = buffer.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxy);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            if (updateVirtualColDef) {
                this.appendVirtualColumnDefinition(buffer, tableProxy, (ColumnProxyOraclev11g)columnProxy, prettyPrint);
            } else {
                if (propMap.get(PropertiesComparator.DATA_TYPE) != null && !this.sourceTable.isBST()) {
                    this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.DATA_TYPE));
                }
                if (propMap.get(PropertiesComparator.DEFAULT_VALUE) != null) {
                    this.appendWithDefaultDefinition(buffer, columnProxy);
                }
            }
            if (propMap.get(PropertiesComparator.MANDATORY) != null) {
                if (!this.sourceColumn.getNullsAllowed()) {
                    this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
                } else {
                    this.appendStringWithSpace(buffer, propMap.get(PropertiesComparator.MANDATORY));
                }
            } else if (propMap.get(PropertiesComparator.NNC_NAME) != null) {
                if (targetColumn.isMandatory()) {
                    this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
                } else {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                }
            }
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendToBuffer(oldbuffer, buffer, addvancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, addvancedComment);
            CDDLFileMaker.incrementAlterTable();
        }
        this.appendColumnConstraint(oldbuffer, this.sourceColumn, targetColumn, tableName, columnProxy, obj, prettyPrint);
        if (propMap.containsKey(PropertiesComparator.AUTO_INCREMENT)) {
            oldg = DDLFileMaker.getddlAdvancedGenenerator();
            try {
                String targetAutoIncDDL;
                DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                if (((Boolean)propMap.get(PropertiesComparator.AUTO_INCREMENT)).booleanValue()) {
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, this.sourceColumn, prettyPrint);
                    return;
                }
                if (targetColumnProxy == null) return;
                targetStorageDesign = (StorageDesignOracle)targetColumnProxy.getStorageDesign();
                if (this.targetSSBAutoIncCol == null) {
                    this.targetSSBAutoIncCol = new SSBAutoIncrementColumnOracle(targetStorageDesign);
                }
                if ((targetAutoIncDDL = targetColumnProxy.getDDLTypeForAutoIncCol()).equals("TRIGGER")) {
                    this.appendDropTrigger(oldbuffer, targetColumn, prettyPrint);
                    return;
                }
                if (targetAutoIncDDL.equals("DEFAULT_CLAUSE")) {
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(targetColumnProxy));
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "NULL");
                    CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                    String advancedComment = buffer.toString();
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementAlterTable();
                    return;
                }
                if (!targetAutoIncDDL.equals("IDENTITY_CLAUSE")) return;
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "MODIFY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(targetColumnProxy));
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
                String advancedComment = buffer.toString();
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendLineFinisher(buffer, prettyPrint);
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
                return;
            }
            finally {
                DDLFileMaker.setddlAdvancedGenenerator(oldg);
            }
        }
        if (!propMap.containsKey(PropertiesComparator.SEQUENCE_NAME) && !propMap.containsKey(PropertiesComparator.TRIGGER_NAME)) return;
        oldg = DDLFileMaker.getddlAdvancedGenenerator();
        try {
            String targetAutoIncDDL;
            String oldTriggerName;
            String oldSequenceName;
            DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            if (targetColumnProxy == null) return;
            targetStorageDesign = (StorageDesignOracle)targetColumnProxy.getStorageDesign();
            if (this.targetSSBAutoIncCol == null) {
                this.targetSSBAutoIncCol = new SSBAutoIncrementColumnOracle(targetStorageDesign);
            }
            String newSequenceName = this.ssbAutoIncCol.generateSequenceName(null, this.sourceColumn, false);
            String sourceAutoIncDDL = columnProxy.getDDLTypeForAutoIncCol();
            if ((sourceAutoIncDDL.equals("TRIGGER") || sourceAutoIncDDL.equals("DEFAULT_CLAUSE")) && !newSequenceName.equalsIgnoreCase(oldSequenceName = this.targetSSBAutoIncCol.generateSequenceName(null, targetColumn, false))) {
                newSequenceName = this.ssbAutoIncCol.generateSequenceName(oldbuffer, this.sourceColumn, prettyPrint);
            }
            Settings settings = this.storageDesign.getAppView().getSettings();
            String newTriggerName = this.ssbAutoIncCol.generateAutoIncrementObjectName(obj.getChoosedPropertyValue(PropertiesComparator.TRIGGER_NAME), settings.getDefaultOracleTriggerName(), "TRG", this.sourceColumn);
            if (!newTriggerName.equalsIgnoreCase(oldTriggerName = this.targetSSBAutoIncCol.generateAutoIncrementObjectName(targetColumn.getAutoIncrementTriggerName(), settings.getDefaultOracleTriggerName(), "TRG", targetColumn)) && (targetAutoIncDDL = targetColumnProxy.getDDLTypeForAutoIncCol()).equals("TRIGGER")) {
                this.appendDropTrigger(oldbuffer, targetColumn, prettyPrint);
            }
            if (!sourceAutoIncDDL.equals("TRIGGER") || !this.sourceColumn.isAutoIncrementGenerateTrigger()) return;
            this.ssbAutoIncCol.appendAutoIncrementTrigger(newTriggerName, newSequenceName, this.sourceColumn, oldbuffer, prettyPrint);
            return;
        }
        finally {
            DDLFileMaker.setddlAdvancedGenenerator(oldg);
        }
    }

    private void appendDropTrigger(StringBuffer oldbuffer, Column targetColumn, boolean prettyPrint) {
        if (targetColumn.isAutoIncrementGenerateTrigger()) {
            int dotIndex;
            Settings settings = targetColumn.getAppView().getSettings();
            String triggerName = this.targetSSBAutoIncCol.generateAutoIncrementObjectName(targetColumn.getAutoIncrementTriggerName(), settings.getDefaultOracleTriggerName(), "TRG", targetColumn);
            if (!settings.isIncludeSchemaInDDL() && (dotIndex = triggerName.indexOf(46)) > -1) {
                triggerName = triggerName.substring(dotIndex + 1);
            }
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "DROP");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TRIGGER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(triggerName));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementDropTrigger();
        }
    }

    private void appendCommentOnColumn(StringBuffer oldbuffer, String formattedTableName, CompareObjectSelection columnObj, ColumnProxyOracle columnProxy, boolean prettyPrint) {
        String commentOn = columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnObj.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS);
        if (commentOn.trim().length() > 0) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COMMENT ON");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COLUMN");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName + '.' + CSSBAlterColumnOraclev10g.getFormattedSelectedName(columnObj, this.storageDesign));
            String advancedComment = buffer.toString();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "IS");
            CSSBAlterColumnOraclev10g.appendString(buffer, '\'');
            CSSBAlterColumnOraclev10g.appendString(buffer, this.replaceSingleQuote(commentOn));
            CSSBAlterColumnOraclev10g.appendString(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendColumnConstraint(StringBuffer oldbuffer, Column sourceColumn, Column targetColumn, String tableName, ColumnProxyOracle columnProxy, CompareObjectSelection obj, boolean prettyPrint) {
        boolean add = CSSBCreateRenameTableOraclev10g.isApplyColumnConstraint(obj);
        if (add && sourceColumn.isGenerateConstraintInDDL()) {
            if (!"".equals(targetColumn.getConstraintName())) {
                String constr = this.storageDesign.getFormatedName(targetColumn.getConstraintName());
                StringBuffer buffer = new StringBuffer();
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constr);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, tableName);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD ");
            int len = buffer.length();
            CSSBCreateRenameTableOraclev10g.appendColumnConstraints(buffer, sourceColumn, columnProxy, prettyPrint, obj);
            if (len < buffer.length()) {
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                this.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, buffer.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, Object> propMap = new TreeMap<String, Object>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(PropertiesComparator.NAME)) {
                propMap.put(PropertiesComparator.NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DATA_TYPE)) {
                propMap.put(PropertiesComparator.DATA_TYPE, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.MANDATORY)) {
                if (!Boolean.parseBoolean(ph.getLeftValue())) {
                    propMap.put(PropertiesComparator.MANDATORY, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.MANDATORY, "NOT NULL");
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.NNC_NAME)) {
                propMap.put(PropertiesComparator.NNC_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.DEFAULT_VALUE)) {
                String def = ph.getLeftValue();
                if ("".equals(def.trim())) {
                    propMap.put(PropertiesComparator.DEFAULT_VALUE, "NULL");
                    continue;
                }
                propMap.put(PropertiesComparator.DEFAULT_VALUE, def);
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS)) {
                propMap.put(PropertiesComparator.COMMENT_IN_RDBMS, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT_NAME, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.CHECK_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.RANGE_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) {
                propMap.put(EngPropertiesComparator.LOV_CONSTRAINT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.COMPUTED)) {
                propMap.put(PropertiesComparator.COMPUTED, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.FORMULA_DESC)) {
                propMap.put(PropertiesComparator.FORMULA_DESC, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.AUTO_INCREMENT)) {
                propMap.put(PropertiesComparator.AUTO_INCREMENT, Boolean.valueOf(ph.getLeftValue()));
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.IDENTITY_COLUMN)) {
                propMap.put(PropertiesComparator.IDENTITY_COLUMN, Boolean.valueOf(ph.getLeftValue()));
                continue;
            }
            if (ph.getName().equals(PropertiesComparator.SEQUENCE_NAME)) {
                propMap.put(PropertiesComparator.SEQUENCE_NAME, ph.getLeftValue());
                continue;
            }
            if (!ph.getName().equals(PropertiesComparator.TRIGGER_NAME)) continue;
            propMap.put(PropertiesComparator.TRIGGER_NAME, ph.getLeftValue());
        }
        return propMap;
    }

    private void appendRenameColumn(StringBuffer oldbuffer, CompareObjectSelection sobj, CompareObjectSelection tobj, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.getTableName(sobj));
        CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "RENAME");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "COLUMN");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tobj.getObject()));
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TO");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sobj.getObject()));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        CDDLFileMaker.incrementAlterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddColumn(StringBuffer oldbuffer, CompareObjectSelection obj, Column column, Table table, boolean prettyPrint) {
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxy != null) {
            RelationalObjectProxy proxy;
            ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
            if (column.isAutoIncrementColumn()) {
                this.appendAutoIncrementSequence(oldbuffer, column, prettyPrint);
            }
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            String formattedTableName = this.getTableName(obj);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD");
            String advancedComment = buffer.toString() + this.storageDesign.getFormatedName(columnProxy);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendSpace(buffer);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            String datatypeString = "";
            Datatype datatype = column.getDataType();
            if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (proxy = this.storageDesign.getProxy(datatype)) != null) {
                datatypeString = this.storageDesign.getFormatedLongNameDDL(proxy);
                if (column.isReference() && datatype instanceof StructuredType) {
                    datatypeString = "REF " + datatypeString;
                }
            }
            if (datatypeString.equals("") && (datatypeString = column.getDatatypeString("Oracle Database 10g")).equals("UROWID") && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                datatypeString = datatypeString + " (4000)";
            }
            this.appendDatatype(buffer, datatypeString, columnProxy, prettyPrint);
            if (tableProxy != null) {
                this.appendColumnOptions(buffer, tableProxy, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, true, prettyPrint);
            }
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
            } else if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                } else {
                    this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                }
            } else if (datatype instanceof StructuredType) {
                this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            this.appendOutOfLineConstraint(oldbuffer, column, columnProxy, formattedTableName, prettyPrint);
            this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
            if (this.storageDesign.getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(oldbuffer, formattedTableName, obj, columnProxy, prettyPrint);
            }
            if (column.isAutoIncrementColumn()) {
                DDLAdvancedGenerator oldg = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator(oldg);
                }
            }
        }
    }

    private void appendOutOfLineConstraint(StringBuffer oldbuffer, Column column, ColumnProxyOracle columnProxy, String formattedTableName, boolean prettyPrint) {
        String text;
        if (column.isGenerateConstraintInDDL() && !column.getAppView().getSettings().isGenerateInlineColumnCC() && !"".equals(text = column.getConstraintsText(columnProxy.getStorageDesign().getFormatedName(columnProxy)))) {
            StringBuffer buffer = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, formattedTableName);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "ADD");
            String cname = column.getConstraintName();
            if (cname.length() > columnProxy.getMaxNameLength() || cname.toUpperCase().startsWith("SYS_")) {
                cname = "";
            }
            if (cname.length() > 0) {
                CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, columnProxy.getStorageDesign().getFormatedName(cname));
            }
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, "CHECK");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterColumnOraclev10g.appendString(buffer, text);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBCreateTableOraclev10g.appendConstraintState(buffer, columnProxy, prettyPrint);
            String advancedComments = "Alter Table " + formattedTableName + " Add Constraint " + cname;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBAlterColumnOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    protected void appendVirtualColumnDefinition(StringBuffer buffer, TableProxyOraclev10g tableProxy, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Column;
    }

    public String getTableName(CompareObjectSelection column) {
        CompareObjectSelection table = column.getTableNode();
        if (table != null) {
            return this.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

