/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropPlSqlObjectOracle
extends AbstractCSSBOracle {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        ModelIDObject modelObject;
        if (object != null && (modelObject = ((CompareObjectSelection)object).getCorrespondentNode().getObject()) instanceof PlSqlSourceStorageObjectOracle) {
            PlSqlSourceStorageObjectOracle plSqlObject = (PlSqlSourceStorageObjectOracle)modelObject;
            StorageDesign storageDesign = plSqlObject.getStorageDesign();
            StringBuffer buffer = new StringBuffer();
            CSSBDropPlSqlObjectOracle.appendStringWithSpace(buffer, "DROP");
            if (plSqlObject instanceof FunctionOracle) {
                CSSBDropPlSqlObjectOracle.appendStringWithSpace(buffer, "FUNCTION");
                CDDLFileMaker.incrementDropFunction();
            } else if (plSqlObject instanceof StoredProcedureOracle) {
                CSSBDropPlSqlObjectOracle.appendStringWithSpace(buffer, "PROCEDURE");
                CDDLFileMaker.incrementDropProc();
            } else if (plSqlObject instanceof PackageOracle) {
                CSSBDropPlSqlObjectOracle.appendStringWithSpace(buffer, "PACKAGE");
                CDDLFileMaker.incrementDropPackage();
            } else {
                return;
            }
            CSSBDropPlSqlObjectOracle.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(plSqlObject));
            String advancedComment = buffer.toString();
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBDropPlSqlObjectOracle.appendNewLine(buffer, prettyPrint, 0);
            this.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof PlSqlSourceStorageObjectOracle;
    }
}

