/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropIndex
extends AbstractCSSBOracle {
    private Map fkMap;

    public CSSBDropIndex(Map fkMap) {
        this.fkMap = fkMap;
    }

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        this.doAppend(oldbuffer, object, prettyPrint, false);
    }

    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint, boolean dropIndex) {
        if (object == null) {
            return;
        }
        KeyObject mdObject = (KeyObject)((CompareObjectSelection)object).getCorrespondentNode().getObject();
        if (mdObject != null) {
            ArrayList<KeyObject> list = null;
            FKContainer table = (FKContainer)mdObject.getContainerObject();
            if (this.fkMap.containsKey(mdObject.getObjectID()) || mdObject.isPK() || !mdObject.isUnique()) {
                // empty if block
            }
            if (list == null) {
                list = new ArrayList<KeyObject>();
            }
            list.add(mdObject);
            for (KeyObject index : list) {
                if (this.fkMap.containsKey(index.getObjectID())) continue;
                StringBuffer buffer = new StringBuffer();
                String advancedComment = "";
                Design design = table.getDesign();
                RDBMSSite site = table.getSelectedRDBMSSite();
                StorageDesignOracle storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
                if (index.isPK() || index.isUnique()) {
                    CSSBDropIndex.appendStringWithSpace(buffer, "ALTER");
                    if (table instanceof TableView) {
                        CSSBDropIndex.appendStringWithSpace(buffer, "VIEW");
                    } else {
                        CSSBDropIndex.appendStringWithSpace(buffer, "TABLE");
                    }
                    CSSBDropIndex.appendStringWithSpace(buffer, this.getTableName((CompareObjectSelection)object, storageDesign));
                    CSSBDropIndex.appendStringWithSpace(buffer, "DROP");
                    CSSBDropIndex.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBDropIndex.appendStringWithSpace(buffer, storageDesign.getFormatedName(index));
                    advancedComment = buffer.toString();
                    if (table instanceof TableView) {
                        CDDLFileMaker.incrementAlterView();
                    } else {
                        CDDLFileMaker.incrementAlterTable();
                        CSSBDropIndex.appendStringWithSpace(buffer, "CASCADE");
                        if (dropIndex) {
                            CSSBDropIndex.appendStringWithSpace(buffer, "DROP INDEX");
                        }
                    }
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBDropIndex.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                } else {
                    this.appendDrop(buffer);
                    CSSBDropIndex.appendStringWithSpace(buffer, "INDEX");
                    IndexProxyOracle indexProxy = (IndexProxyOracle)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
                    CSSBDropIndex.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(indexProxy));
                    advancedComment = buffer.toString();
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CSSBDropIndex.appendNewLine(buffer, prettyPrint, 0);
                    this.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    CDDLFileMaker.incrementDropIndex();
                }
                if (list.size() > 1 && mdObject == index) {
                    this.fkMap.put(index.getObjectID(), list);
                    continue;
                }
                this.fkMap.put(index.getObjectID(), index);
            }
            list.remove(mdObject);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof KeyObject;
    }

    private String getTableName(CompareObjectSelection index, StorageDesignOracle storageDesign) {
        CompareObjectSelection table = index.getTableNode();
        if (table != null) {
            return this.getFormattedTableName(table, storageDesign);
        }
        return "";
    }
}

