/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;

public class RelationalSubViewComparator
extends PropertiesComparator {
    private DesignPartViewPlaceHolder source;
    private DesignPartViewPlaceHolder target;
    private CompareCWDDesigns selectionObject;

    public RelationalSubViewComparator(DesignPartViewPlaceHolder source, DesignPartViewPlaceHolder target) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromSubViewToSubView();
    }

    private void copyPropertiesFromSubViewToSubView() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
            }
        }
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    @Override
    public String getLeftName() {
        return this.source != null ? MessageFormat.format(Messages.getString("RelationalSubViewComparator.SourceSubview"), this.source.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? MessageFormat.format(Messages.getString("RelationalSubViewComparator.TargetSubview"), this.target.getName()) : "";
    }

    @Override
    public String getID() {
        if (this.source != null) {
            return this.source.getObjectID();
        }
        return "null";
    }
}

