/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RelationComparator
extends PropertiesComparator {
    private Relation source;
    private Relation target;
    private CompareCWDDesigns selectionObject;
    protected static List propertiesFilterList = new ArrayList();
    private Map objectsMap;

    public RelationComparator(Relation source, Relation target, Map objectsMap) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(NAME_ON_SOURCE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? this.source.getNameOnSource() : "");
        ph.setRightValue(this.target != null ? this.target.getNameOnSource() : "");
        if (this.isExcludedFromComparison(NAME_ON_SOURCE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !this.source.getNameOnSource().equals(this.target.getNameOnSource())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NAME_ON_TARGET);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? this.source.getNameOnTarget() : "");
        ph.setRightValue(this.target != null ? this.target.getNameOnTarget() : "");
        if (this.isExcludedFromComparison(NAME_ON_TARGET)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !this.source.getNameOnTarget().equals(this.target.getNameOnTarget())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SOURCE_KEY);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.getSourcePk()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.getSourcePk()) : "");
        if (this.isExcludedFromComparison(SOURCE_KEY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TARGET_KEY);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.getTargetPk()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.getTargetPk()) : "");
        if (this.isExcludedFromComparison(TARGET_KEY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SOURCE_TO_TARGET_CARDINALITY);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? this.source.getTargetCardinalityString() : "");
        ph.setRightValue(this.target != null ? this.target.getTargetCardinalityString() : "");
        if (this.isExcludedFromComparison(SOURCE_TO_TARGET_CARDINALITY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TARGET_TO_SOURCE_CARDINALITY);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? this.source.getSourceCardinalityString() : "");
        ph.setRightValue(this.target != null ? this.target.getSourceCardinalityString() : "");
        if (this.isExcludedFromComparison(TARGET_TO_SOURCE_CARDINALITY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SOURCE_OPTIONAL);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isOptionalSource()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isOptionalSource()) : "");
        if (this.isExcludedFromComparison(SOURCE_OPTIONAL)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TARGET_OPTIONAL);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isOptionalTarget()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isOptionalTarget()) : "");
        if (this.isExcludedFromComparison(TARGET_OPTIONAL)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SOURCE_TRANSFERABLE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isSourceTransferable()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isSourceTransferable()) : "");
        if (this.isExcludedFromComparison(SOURCE_TRANSFERABLE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(TARGET_TRANSFERABLE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isTargetTransferable()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isTargetTransferable()) : "");
        if (this.isExcludedFromComparison(TARGET_TRANSFERABLE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(DOMINANT_ROLE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.getDominantRole()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.getDominantRole()) : "");
        if (this.isExcludedFromComparison(DOMINANT_ROLE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(IDENTIFYING);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isIdentifying()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isIdentifying()) : "");
        if (this.isExcludedFromComparison(IDENTIFYING)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(USE_SURROGATE_KEY);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? String.valueOf(this.source.isUseSurrogateKey()) : "");
        ph.setRightValue(this.target != null ? String.valueOf(this.target.isUseSurrogateKey()) : "");
        if (this.isExcludedFromComparison(USE_SURROGATE_KEY)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(DELETE_RULE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.source != null ? this.source.getDeleteRule() : "");
        ph.setRightValue(this.target != null ? this.target.getDeleteRule() : "");
        if (this.isExcludedFromComparison(DELETE_RULE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.initCommentsAndNotes();
        this.initDynamicProperties();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromRelationToRelation();
    }

    private void copyPropertiesFromRelationToRelation() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                CandidateKey tkey;
                CandidateKey key;
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(NAME_ON_SOURCE)) {
                    this.target.setNameOnSource(this.source.getNameOnSource());
                    continue;
                }
                if (ph.getName().equals(NAME_ON_TARGET)) {
                    this.target.setNameOnTarget(this.source.getNameOnTarget());
                    continue;
                }
                if (ph.getName().equals(SOURCE_TO_TARGET_CARDINALITY)) {
                    this.target.setTargetCardinality(this.source.getTargetCardinality());
                    continue;
                }
                if (ph.getName().equals(TARGET_TO_SOURCE_CARDINALITY)) {
                    this.target.setSourceCardinality(this.source.getSourceCardinality());
                    continue;
                }
                if (ph.getName().equals(SOURCE_OPTIONAL)) {
                    this.target.setOptionalSource(this.source.isOptionalSource());
                    continue;
                }
                if (ph.getName().equals(TARGET_OPTIONAL)) {
                    this.target.setOptionalTarget(this.source.isOptionalTarget());
                    continue;
                }
                if (ph.getName().equals(SOURCE_KEY)) {
                    key = this.source.getSourcePk();
                    if (key != null) {
                        tkey = (CandidateKey)this.objectsMap.get(key.getObjectID());
                        if (tkey == null) continue;
                        this.target.setSourcePk(tkey);
                        continue;
                    }
                    this.target.setSourcePk(null);
                    continue;
                }
                if (ph.getName().equals(TARGET_KEY)) {
                    key = this.source.getTargetPk();
                    if (key != null) {
                        tkey = (CandidateKey)this.objectsMap.get(key.getObjectID());
                        if (tkey == null) continue;
                        this.target.setTargetPk(tkey);
                        continue;
                    }
                    this.target.setTargetPk(null);
                    continue;
                }
                if (ph.getName().equals(SOURCE_TRANSFERABLE)) {
                    this.target.setSourceTransferable(this.source.isSourceTransferable());
                    continue;
                }
                if (ph.getName().equals(TARGET_TRANSFERABLE)) {
                    this.target.setTargetTransferable(this.source.isTargetTransferable());
                    continue;
                }
                if (ph.getName().equals(DOMINANT_ROLE)) {
                    this.target.setDominantRole(this.source.getDominantRole());
                    continue;
                }
                if (ph.getName().equals(IDENTIFYING)) {
                    this.target.setIdentifying(this.source.isIdentifying());
                    continue;
                }
                if (ph.getName().equals(USE_SURROGATE_KEY)) {
                    this.target.setUseSurrogateKey(this.source.isUseSurrogateKey());
                    continue;
                }
                if (!ph.getName().equals(DELETE_RULE)) continue;
                this.target.setDeleteRule(this.source.getDeleteRule());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.source != null ? MessageFormat.format(Messages.getString("RelationComparator.SourceRelation"), this.source.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? MessageFormat.format(Messages.getString("RelationComparator.TargetRelation"), this.target.getName()) : "";
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }
}

