/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.imports.SyncObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.ColumnSelection;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.EmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.FKArcComparator;
import oracle.dbtools.crest.model.design.compare.FKComparator;
import oracle.dbtools.crest.model.design.compare.FilteredSelection;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableConstraintComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ValidTimeDimensionComparator;
import oracle.dbtools.crest.model.design.compare.ViewIndexComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CollectionTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DistinctTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MethodParamComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.StructuredTypeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBArcConstraintOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCollectionType;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBContextOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDimensionOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDirectoryOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBPlSqlObjectOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBStructuredType;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSynonymOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTriggerOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterColumnOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBFKIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSequenceOracle10vg;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBSnapshotOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBTableViewOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBViewIndexOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAddValidTimeOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAlterColumnOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBAlterIndexOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBCreateTableOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBRenameTableOraclev11g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBSnapshotOraclev11g;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.IndexGlobalPartitioningComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.OraclePartitionSelection;
import oracle.dbtools.crest.model.design.compare.storage.oracle.PartitioningComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparatorOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SnapshotComparator;
import oracle.dbtools.crest.model.design.compare.storage.sqlserver.SequenceSqlServerComparator;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SnapshotOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.util.compare.CompareMapping;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;

public class CompareModelToModel
extends CompareObjectSelection {
    private static final String NEW_VIEW = Messages.getString("CompareModelToModel.NewView");
    private static final String NEW_SNAPSHOT = Messages.getString("CompareModelToModel.NewSnapshot");
    private static final String NEW_SEQUENCE = Messages.getString("CompareModelToModel.NewSequence");
    private static final String NEW_FUNCTION = Messages.getString("CompareModelToModel.NewFunction");
    private static final String NEW_STORED_PROCEDURE = Messages.getString("CompareModelToModel.NewStoredProcedure");
    private static final String NEW_PACKAGE = Messages.getString("CompareModelToModel.NewPackage");
    private static final String NEW_PARAMETER = Messages.getString("CompareModelToModel.NewParameter");
    private static final String NEW_BITMAP_JOIN_INDEX = Messages.getString("CompareModelToModel.NewBitmapJoinIndex");
    private static final String NEW_LOB_STORAGE = Messages.getString("CompareModelToModel.NewLobStorage");
    private static final String NEW_PARTITION = Messages.getString("CompareModelToModel.NewPartition");
    private static final String NEW_SUBPARTITION = Messages.getString("CompareModelToModel.NewSubpartition");
    private static final String NEW_SYNONYM = Messages.getString("CompareModelToModel.NewSynonym");
    private static final String NEW_CONTEXT = Messages.getString("CompareModelToModel.NewContext");
    private static final String NEW_DIRECTORY = Messages.getString("CompareModelToModel.NewDirectory");
    private static final String NEW_DISK_GROUP = Messages.getString("CompareModelToModel.NewDiskGroup");
    private static final String NEW_DIMENSION = Messages.getString("CompareModelToModel.NewDimension");
    private static final String NEW_HIERARCHY = Messages.getString("CompareModelToModel.NewHierarchy");
    private static final String NEW_LEVEL = Messages.getString("CompareModelToModel.NewLevel");
    private static final String NEW_ROLE = Messages.getString("CompareModelToModel.NewRole");
    private static final String NEW_USER = Messages.getString("CompareModelToModel.NewUser");
    private static final String NEW_PERMISSION = Messages.getString("CompareModelToModel.NewPermission");
    private static final String NEW_QUOTA = Messages.getString("CompareModelToModel.NewQuota");
    private static final String NEW_TABLESPACE = Messages.getString("CompareModelToModel.NewTablespace");
    private static final String NEW_TEMP_TABLESPACE = Messages.getString("CompareModelToModel.NewTempTablespace");
    private static final String NEW_UNDO_TABLESPACE = Messages.getString("CompareModelToModel.NewUndoTablespace");
    private static final String NEW_DATA_FILE = Messages.getString("CompareModelToModel.NewDataFile");
    private static final String NEW_ATTRIBUTE = Messages.getString("CompareCWDDesigns.NewAttribute");
    private static final String NEW_DISTINCT_TYPE = Messages.getString("CompareCWDDesigns.NewDistinctType");
    private static final String NEW_STRUCTURED_TYPE = Messages.getString("CompareCWDDesigns.NewStructuredType");
    private static final String NEW_METHOD = Messages.getString("CompareCWDDesigns.NewMethod");
    private static final String NEW_COLLECTION_TYPE = Messages.getString("CompareCWDDesigns.NewCollectionType");
    private static final String PARAMETERS = Messages.getString("CompareModelToModel.Parameters");
    protected static final String PK_UK_CONSTRAINTS = Messages.getString("CompareModelToModel.PKUKConstraints");
    protected static final String FOREIGN_KEYS = Messages.getString("CompareModelToModel.ForeignKeys");
    public static final String PARTITIONING = Messages.getString("CompareModelToModel.Partitioning");
    public static final String GLOBAL_PARTITIONING = Messages.getString("CompareModelToModel.GlobalPartitioning");
    public static final String HASH_PARTITIONS = Messages.getString("CompareModelToModel.HashPartitions");
    public static final String LIST_PARTITIONS = Messages.getString("CompareModelToModel.ListPartitions");
    public static final String RANGE_PARTITIONS = Messages.getString("CompareModelToModel.RangePartitions");
    public static final String HASH_SUBPARTITIONS = Messages.getString("CompareModelToModel.HashSubpartitions");
    public static final String LIST_SUBPARTITIONS = Messages.getString("CompareModelToModel.ListSubpartitions");
    public static final String RANGE_SUBPARTITIONS = Messages.getString("CompareModelToModel.RangeSubpartitions");
    public static final String HASH_SUBPARTITION_TEMPLATES = Messages.getString("CompareModelToModel.HashSubpartitionTemplates");
    public static final String LIST_SUBPARTITION_TEMPLATES = Messages.getString("CompareModelToModel.ListSubpartitionTemplates");
    public static final String RANGE_SUBPARTITION_TEMPLATES = Messages.getString("CompareModelToModel.RangeSubpartitionTemplates");
    public static final String GLOBAL_HASH_PARTITIONS = Messages.getString("CompareModelToModel.GlobalHashPartitions");
    public static final String GLOBAL_RANGE_PARTITIONS = Messages.getString("CompareModelToModel.GlobalRangePartitions");
    private CompareObjectSelection rightRelationalRoot;
    private Map comparatorsMap = new TreeMap();
    private Map physComparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private List newMappings = new ArrayList();
    private RelationalDesign sourcedes;
    private RelationalDesign targetdes;
    private List pkInd = new ArrayList();
    private List viewIndexes = new ArrayList();
    private List indexes = new ArrayList();
    private Map objectsMap;
    private List tablesToRecreate = new ArrayList();
    private List columnsWithChangedDataType = new ArrayList();
    private DataTypesDesign sourceDTD;
    private DataTypesDesign targetDTD;
    private boolean buildDataTypes = false;
    private static boolean caseSensitive = false;
    private static boolean useSchema = true;
    private static boolean swapTarget = false;
    private boolean useGenerateInDDL = false;
    private Map selectedIDs;
    private boolean syncMode;
    private boolean syncConnFlag;
    private static CompareModelToModel currentCompare = null;
    private static final Logger LOGGER = new Logger(CompareModelToModel.class);

    public CompareModelToModel(RelationalDesign sourceRel, RelationalDesign targetRel, boolean swapTarget, boolean useGenerateInDDL, Map selectedIDs, boolean synchronize) {
        super(sourceRel);
        this.useGenerateInDDL = useGenerateInDDL;
        this.selectedIDs = selectedIDs;
        this.syncMode = swapTarget;
        CompareModelToModel.swapTarget = swapTarget;
        this.syncConnFlag = synchronize;
        sourceRel.getDesign().getDataTypesDesign().getPredefinedStCollection();
        targetRel.getDesign().getDataTypesDesign().getPredefinedStCollection();
        this.tablesToRecreate.clear();
        caseSensitive = sourceRel.getAppView().getSettings().isCaseSensitiveNamesInCompare();
        useSchema = sourceRel.getAppView().getSettings().isUseSchemaPropertyInCompare();
        this.sourceDTD = sourceRel.getDesign().getDataTypesDesign();
        this.targetDTD = targetRel.getDesign().getDataTypesDesign();
        this.buildDataTypes = this.sourceDTD != null && this.targetDTD != null && this.sourceDTD != this.targetDTD;
        this.objectsMap = new TreeMap();
        this.sourcedes = sourceRel;
        String leftRootName = sourceRel.getName() + "(" + sourceRel.getDesign().getName() + ")";
        this.setName(leftRootName);
        this.targetdes = targetRel;
        this.rightRelationalRoot = new CompareObjectSelection(this.targetdes.getName());
        String rightRootName = targetRel.getName() + "(" + targetRel.getDesign().getName() + ")";
        this.rightRelationalRoot.setName(rightRootName);
        this.setCorrespondentNode(this.rightRelationalRoot);
        this.rightRelationalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRelationalRoot);
        currentCompare = this;
        this.addFromSourceModel();
        currentCompare = null;
    }

    public static Map getCurrentPhysComparatorsMap() {
        return currentCompare != null ? currentCompare.getPhysComparatorsMap() : null;
    }

    public Map getPhysComparatorsMap() {
        return this.physComparatorsMap;
    }

    private void setEmptyComparator(CompareObjectSelection node) {
        node.setPropertiesComparator(new EmptyPropertiesComparator(null, null));
    }

    private void addTable(Table sourceTable, ModelIdObjectSelection allsTabsel, ModelIdObjectSelection alltTablesel) {
        TableProxy sTableProxy = (TableProxy)this.getSourceStorageDesign().getTableProxySet().getProxy(sourceTable.getObjectID());
        Table targetTable = (Table)this.getCorrespondingObject(this.targetdes.getTableSet(), sourceTable, useSchema);
        TableProxy tTableProxy = null;
        if (targetTable == null && this.getTargetStorageDesign().isOpen()) {
            ModelIDObject sch_impl = sTableProxy.getSchemaImplementingObject();
            if (sch_impl != null && (tTableProxy = this.getTargetStorageDesign().getTableProxySet().getBySchemaImplAndName(sch_impl.getName(), sTableProxy.getName())) != null) {
                targetTable = (Table)tTableProxy.getObject();
            }
        } else if (targetTable != null) {
            tTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
        }
        if (this.useGenerateInDDL && (!sTableProxy.isMarkedGenerate() || tTableProxy != null && !tTableProxy.isMarkedGenerate() || !sourceTable.isMarkedGenerate() || targetTable != null && !targetTable.isMarkedGenerate())) {
            if (sourceTable != null && targetTable != null) {
                this.objectsMap.put(sourceTable.getObjectID(), targetTable);
            }
            return;
        }
        TableSelection sourceTabsel = new TableSelection(sourceTable);
        sourceTabsel.setProxy(sTableProxy);
        TableSelection targetTabsel = null;
        if (targetTable != null) {
            targetTabsel = new TableSelection(targetTable);
            targetTabsel.setProxy(tTableProxy);
            TableComparator comp = new TableComparator(sourceTable, targetTable, sTableProxy, tTableProxy, swapTarget);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabsel.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sourceTabsel);
            this.objectsMap.put(sourceTable.getObjectID(), targetTable);
        } else {
            targetTabsel = new TableSelection(NEW_TABLE);
            sourceTabsel.setStatus(2);
            targetTabsel.setStatus(2);
            targetTabsel.setElementDescriptor(Table.class);
            TableComparator comp = new TableComparator(sourceTable, targetTable, sTableProxy, null);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabsel.setSelected(true);
            this.newMappings.add(sourceTabsel);
        }
        targetTabsel.setCorrespondentNode(sourceTabsel);
        sourceTabsel.setCorrespondentNode(targetTabsel);
        this.addTableDetails(sourceTable, sourceTabsel, targetTable, targetTabsel);
        allsTabsel.addChild(sourceTabsel);
        alltTablesel.addChild(targetTabsel);
        if (targetTabsel.isRecreateTable()) {
            this.tablesToRecreate.add(targetTabsel);
        }
        if (sourceTabsel.isModified() || sourceTabsel.hasChildsWithChangeStatus()) {
            sourceTabsel.setSelectedNoPropagateSelection(true);
        }
    }

    public static DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject object) {
        DesignObject impObj;
        if (object == null) {
            return null;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignObject obj = (DesignObject)it.next();
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (object.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        boolean useSyncName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        if (useSyncName && (impObj = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(set.iterator(), object, false)) != null) {
            return impObj;
        }
        return set.getByName(object.getName(), caseSensitive);
    }

    public DesignObject getCorrespondingObject(DesignObjectSet set, DesignObject object, boolean getByLongName) {
        DesignObject impObj;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignObject obj = (DesignObject)it.next();
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (object.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        boolean useSyncSchema = object.getAppView().getSettings().isUseDBSyncSourceSchema();
        boolean useSyncName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        if (useSyncName && (useSyncSchema && getByLongName || !getByLongName) && (impObj = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(set.iterator(), object, useSyncSchema)) != null) {
            return impObj;
        }
        if (getByLongName) {
            if (object instanceof KeyObject || object instanceof FKIndexAssociation) {
                return set.getByVeryLongdName(object.getVeryLongName());
            }
            return set.getByLongName(object.getLongName());
        }
        if (object instanceof KeyObject) {
            return set.getByLongName(object.getLongName());
        }
        return set.getByName(object.getName(), caseSensitive);
    }

    public DesignObject getCorrespondingObject(TypeElement[] set, DesignObject object) {
        TypeElement obj;
        int i;
        for (i = 0; i < set.length; ++i) {
            obj = set[i];
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (obj.getImportedId() == null || object.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        for (i = 0; i < set.length; ++i) {
            obj = set[i];
            if (!(caseSensitive ? object.getName().equals(obj.getName()) : object.getName().equalsIgnoreCase(obj.getName()))) continue;
            return obj;
        }
        return null;
    }

    private DesignObject getCorrespondingObject(List list, DesignObject object) {
        DesignObject impObj;
        for (DesignObject obj : list) {
            if (!(obj.getImportedId() != null && obj.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj.getObjectID()) || object.getObjectID().equals(obj.getObjectID())) && (object.getImportedId() == null || !object.getImportedId().equals(obj.getImportedId()))) continue;
            return obj;
        }
        boolean useSyncName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        if (useSyncName && (impObj = (DesignObject)CompareModelToModel.getCorrespondingImportedObject(list.iterator(), object, false)) != null) {
            return impObj;
        }
        String name = object.getName();
        for (DesignObject obj : list) {
            boolean nameMatch = caseSensitive ? obj.getName().equals(name) : obj.getName().equalsIgnoreCase(name);
            if (!nameMatch) continue;
            if (obj instanceof Method) {
                if (this.objectsMap.containsValue(obj)) continue;
                return obj;
            }
            return obj;
        }
        return null;
    }

    private QuotaItemOracle getCorrespondingQuotaItem(Iterator iter, QuotaItemOracle sourceQuota) {
        TableSpaceOracle sourceTablespace = sourceQuota.getTableSpace();
        if (sourceTablespace != null) {
            String sourceTablespaceName = sourceTablespace.getName();
            while (iter.hasNext()) {
                QuotaItemOracle targetQuotaItem = (QuotaItemOracle)iter.next();
                TableSpaceOracle targetTablespace = targetQuotaItem.getTableSpace();
                if (targetTablespace == null || !targetTablespace.getName().equalsIgnoreCase(sourceTablespaceName)) continue;
                return targetQuotaItem;
            }
        }
        return null;
    }

    private PermissionsOracle getCorrespondingPermission(Iterator iter, PermissionsOracle sourcePermission) {
        boolean isColumnsTable = false;
        ModelIDObject sourceObject = sourcePermission.getColumnsTable();
        if (sourceObject != null) {
            isColumnsTable = true;
        } else {
            sourceObject = sourcePermission.getObject();
        }
        if (sourceObject instanceof RelationalObjectProxy) {
            sourceObject = ((RelationalObjectProxy)sourceObject).getObject();
        }
        if (sourceObject != null) {
            Object targetObject = this.objectsMap.get(sourceObject.getObjectID());
            if (targetObject instanceof DesignObject) {
                targetObject = this.getTargetStorageDesign().getProxy(targetObject);
            }
            if (targetObject != null) {
                while (iter.hasNext()) {
                    PermissionsOracle targetPermission = (PermissionsOracle)iter.next();
                    if (isColumnsTable) {
                        int sourceCommaIndex;
                        if (targetPermission.getColumnsTable() != targetObject) continue;
                        String sourceColumnList = sourcePermission.getColumnList();
                        if (sourceColumnList.isEmpty()) {
                            sourceColumnList = sourcePermission.getColumnWithGrantOptionList();
                        }
                        if ((sourceCommaIndex = sourceColumnList.indexOf(44)) <= 0) continue;
                        String targetColumnList = targetPermission.getColumnList();
                        if (targetColumnList.isEmpty()) {
                            targetColumnList = targetPermission.getColumnWithGrantOptionList();
                        }
                        if (!sourceColumnList.substring(0, sourceCommaIndex).equalsIgnoreCase(targetColumnList.substring(0, targetColumnList.indexOf(44)))) continue;
                        return targetPermission;
                    }
                    if (targetPermission.getObject() != targetObject) continue;
                    return targetPermission;
                }
            }
        }
        return null;
    }

    private static ModelIDObject getCorrespondingImportedObject(Iterator iter, ModelIDObject object, boolean useSyncSchema) {
        String syncConn = object.getSourceConnName();
        if (!"".equals(syncConn)) {
            String syncName = object.getSourceObjName();
            String syncSchema = object.getSourceObjSchema();
            while (iter.hasNext()) {
                ModelIDObject obj = (ModelIDObject)iter.next();
                if (!"".equals(obj.getSourceConnName())) {
                    if (!(caseSensitive ? syncName.equals(obj.getSourceObjName()) && (!useSyncSchema || syncSchema.equals(obj.getSourceObjSchema())) : syncName.equalsIgnoreCase(obj.getSourceObjName()) && (!useSyncSchema || syncSchema.equalsIgnoreCase(obj.getSourceObjSchema())))) continue;
                    return obj;
                }
                String objSchema = "";
                if (obj instanceof DesignObject) {
                    objSchema = ((DesignObject)obj).getSchema();
                }
                if (!(caseSensitive ? syncName.equals(obj.getName()) && (!useSyncSchema || syncSchema.equals(objSchema)) : syncName.equalsIgnoreCase(obj.getName()) && (!useSyncSchema || syncSchema.equalsIgnoreCase(objSchema)))) continue;
                return obj;
            }
        } else {
            String objectName = object.getName();
            String objectSchema = "";
            if (object instanceof DesignObject) {
                objectSchema = ((DesignObject)object).getSchema();
            }
            while (iter.hasNext()) {
                ModelIDObject obj = (ModelIDObject)iter.next();
                if (!(caseSensitive ? objectName.equals(obj.getSourceObjName()) && (!useSyncSchema || objectSchema.equals(obj.getSourceObjSchema())) : objectName.equalsIgnoreCase(obj.getSourceObjName()) && (!useSyncSchema || objectSchema.equalsIgnoreCase(obj.getSourceObjSchema())))) continue;
                return obj;
            }
        }
        return null;
    }

    private static ModelObject getCorrespondingImportedColumn(ContainedObject[] elems, ModelObject object) {
        if (!"".equals(object.getSourceConnName())) {
            String syncName = object.getSourceObjName();
            String syncTable = object.getSourceObjSchema();
            for (int i = 0; i < elems.length; ++i) {
                ContainedObject obj = elems[i];
                if (!(!"".equals(obj.getSourceConnName()) ? (caseSensitive ? syncName.equals(obj.getSourceObjName()) && syncTable.equals(obj.getSourceObjSchema()) : syncName.equalsIgnoreCase(obj.getSourceObjName()) && syncTable.equalsIgnoreCase(obj.getSourceObjSchema())) : (caseSensitive ? syncName.equals(obj.getName()) && syncTable.equals(obj.getContainer().getName()) : syncName.equalsIgnoreCase(obj.getName()) && syncTable.equalsIgnoreCase(obj.getContainer().getName())))) continue;
                return obj;
            }
        }
        return null;
    }

    private void addTableView(TableView sourceTableView, ModelIdObjectSelection allsTabViewSel, ModelIdObjectSelection alltTabViewSel) {
        TableViewComparator comp;
        TableView targetTableView = (TableView)this.getCorrespondingObject(this.targetdes.getTableViewSet(), sourceTableView, useSchema);
        TableViewProxy sViewProxy = (TableViewProxy)this.getSourceStorageDesign().getTableViewProxySet().getProxy(sourceTableView.getObjectID());
        TableViewProxy tViewProxy = null;
        if (targetTableView == null && this.getTargetStorageDesign().isOpen()) {
            ModelIDObject sch_impl = sViewProxy.getSchemaImplementingObject();
            if (sch_impl != null && (tViewProxy = this.getTargetStorageDesign().getTableViewProxySet().getBySchemaImplAndName(sch_impl.getName(), sViewProxy.getName())) != null) {
                targetTableView = (TableView)tViewProxy.getObject();
            }
        } else if (targetTableView != null) {
            tViewProxy = (TableViewProxy)this.getTargetStorageDesign().getTableViewProxySet().getProxy(targetTableView.getObjectID());
        }
        if (this.useGenerateInDDL && (sViewProxy != null && !sViewProxy.isMarkedGenerate() || tViewProxy != null && !tViewProxy.isMarkedGenerate())) {
            if (sourceTableView != null && targetTableView != null) {
                this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
            }
            return;
        }
        CompareObjectSelection sourceTabViewSel = new CompareObjectSelection(sourceTableView);
        CompareObjectSelection targetTabViewSel = null;
        if (targetTableView != null) {
            targetTabViewSel = new CompareObjectSelection(targetTableView);
            comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, tViewProxy, true);
            sourceTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabViewSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceTableView.getObjectID(), targetTableView);
        } else {
            sourceTabViewSel.setSelected(true);
            targetTabViewSel = new CompareObjectSelection(NEW_VIEW);
            comp = new TableViewComparator(sourceTableView, targetTableView, sViewProxy, null, true);
            sourceTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setPropertiesComparator(comp);
            targetTabViewSel.setElementDescriptor(TableView.class);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceTabViewSel.setStatus(2);
            targetTabViewSel.setStatus(2);
            this.newMappings.add(sourceTabViewSel);
        }
        targetTabViewSel.setCorrespondentNode(sourceTabViewSel);
        sourceTabViewSel.setCorrespondentNode(targetTabViewSel);
        this.addTableViewDetails(sourceTableView, sourceTabViewSel, targetTableView, targetTabViewSel);
        TableViewProxy sourceViewProxy = (TableViewProxy)this.getSourceStorageDesign().getTableViewProxySet().getProxy(sourceTableView.getObjectID());
        if (sourceViewProxy != null) {
            TableViewProxy targetViewProxy = null;
            if (targetTableView != null) {
                targetViewProxy = (TableViewProxy)this.getTargetStorageDesign().getTableViewProxySet().getProxy(targetTableView.getObjectID());
            }
            StorageObjectCollection sourceTriggers = this.getViewTriggers(sourceViewProxy);
            List sourceTriggerList = null;
            if (sourceTriggers != null) {
                sourceTriggerList = sourceTriggers.getElementsList();
            }
            StorageObjectCollection targetTriggers = null;
            if (targetViewProxy != null) {
                targetTriggers = this.getViewTriggers(targetViewProxy);
            }
            String TriggerIconName = "TRIGGER_FOLDER_ICON";
            this.addChildNodes(sourceTriggerList, targetTriggers, sourceTabViewSel, targetTabViewSel, TRIGGERS, TriggerIconName, NEW_TRIGGER, false, false);
        }
        allsTabViewSel.addChild(sourceTabViewSel);
        alltTabViewSel.addChild(targetTabViewSel);
        if (sourceTabViewSel.isModified() || sourceTabViewSel.hasChildsWithChangeStatus()) {
            sourceTabViewSel.setSelectedNoPropagateSelection(true);
        }
    }

    private StorageObjectCollection getViewTriggers(TableViewProxy tableViewProxy) {
        if (tableViewProxy instanceof TableViewProxyOracle) {
            return ((TableViewProxyOracle)tableViewProxy).getTriggers();
        }
        if (tableViewProxy instanceof TableViewProxySqlServer) {
            return ((TableViewProxySqlServer)tableViewProxy).getTriggers();
        }
        if (tableViewProxy instanceof TableViewProxyUDB) {
            return ((TableViewProxyUDB)tableViewProxy).getTriggers();
        }
        return null;
    }

    private void addFK(FKIndexAssociation sourcefk, FKContainer targetTable, CompareObjectSelection allsFKsel, CompareObjectSelection alltFKSel, boolean isViewFK) {
        ModelIDObject sproxy;
        FKIndexAssociation targetfk = null;
        if (targetTable != null && (targetfk = targetTable.getFKIndexAssociationByName(sourcefk.getName())) == null) {
            targetfk = (FKIndexAssociation)this.getCorrespondingObject(targetTable.getFKAssociationsList(), (DesignObject)sourcefk);
        }
        if ((sproxy = this.getSourceStorageDesign().getStorageObject(sourcefk.getLocalFKIndex().getObjectID())) == null) {
            sproxy = sourcefk;
        }
        ModelIDObject tproxy = null;
        if (targetfk != null) {
            tproxy = this.getTargetStorageDesign().getStorageObject(targetfk.getLocalFKIndex().getObjectID());
        }
        if (tproxy == null) {
            tproxy = targetfk;
        }
        if (sourcefk != null && targetfk != null) {
            this.objectsMap.put(sourcefk.getObjectID(), targetfk);
            if (sourcefk.getLocalFKIndex() != null && targetfk.getLocalFKIndex() != null) {
                this.objectsMap.put(sourcefk.getLocalFKIndex().getObjectID(), targetfk.getLocalFKIndex());
            }
        }
        if (this.useGenerateInDDL && (sproxy != null && !sproxy.isMarkedGenerate() || tproxy != null && !tproxy.isMarkedGenerate())) {
            return;
        }
        FKContainer sTable = sourcefk.getRemoteTable();
        CompareObjectSelection sfksel = new CompareObjectSelection(sourcefk);
        String sfkname = sourcefk.getName() + " (" + sourcefk.getContainerWithKeyObject().getName() + " )";
        if (sTable != null) {
            sfkname = sourcefk.getName() + " (" + sourcefk.getContainerWithKeyObject().getName() + " : " + sTable.getName() + " )";
        }
        sfksel.setName(sfkname);
        sfksel.setSelected(true);
        CompareObjectSelection tfksel = null;
        if (targetfk != null) {
            tfksel = new CompareObjectSelection(targetfk);
            FKContainer tTable = null;
            if (sTable != null && (tTable = (FKContainer)this.objectsMap.get(sTable.getObjectID())) == null) {
                if (sTable instanceof Table) {
                    tTable = (Table)this.getCorrespondingObject(this.targetdes.getTableSet(), sTable, useSchema);
                } else if (sTable instanceof TableView) {
                    tTable = (TableView)this.getCorrespondingObject(this.targetdes.getTableViewSet(), sTable, useSchema);
                }
            }
            if (tTable != null) {
                KeyObject pk = (KeyObject)this.getCorrespondingObject(tTable.getPK_UKList(), (DesignObject)sourcefk.getKeyObject());
                if (pk == null) {
                    sfksel.setSelected(true);
                    tfksel = new CompareObjectSelection(NEW_RELATION);
                    sfksel.setStatus(2);
                    tfksel.setStatus(2);
                    this.newMappings.add(sfksel);
                    tfksel.setElementDescriptor(FKIndexAssociation.class);
                    FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap, this.getSourceStorageDesign(), this.getTargetStorageDesign());
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    this.comparatorsMap.put(comp.getID(), comp);
                } else {
                    FKElement[] targetColumns;
                    FKElement[] sourceColumns;
                    boolean matchingColumns;
                    boolean matchingRemoteKey = false;
                    KeyObject targetPK = targetfk.getKeyObject();
                    if (targetPK != null) {
                        if (targetPK.getDesignPart() != targetfk.getDesignPart()) {
                            matchingRemoteKey = true;
                        } else if (targetPK.getObjectID().equals(pk.getObjectID())) {
                            matchingRemoteKey = true;
                        }
                    }
                    boolean bl = matchingColumns = (sourceColumns = sourcefk.getColumns()).length == (targetColumns = targetfk.getColumns()).length;
                    if (matchingColumns) {
                        for (int i = 0; i < sourceColumns.length; ++i) {
                            FKElement mappedTargetCol = (FKElement)this.objectsMap.get(sourceColumns[i].getObjectID());
                            if (mappedTargetCol != null && mappedTargetCol.getObjectID().equals(targetColumns[i].getObjectID())) continue;
                            matchingColumns = false;
                            break;
                        }
                    }
                    FKComparator comp = new FKComparator(sourcefk, targetfk, matchingRemoteKey, matchingColumns, this.objectsMap, this.getSourceStorageDesign(), this.getTargetStorageDesign());
                    sfksel.setPropertiesComparator(comp);
                    tfksel.setPropertiesComparator(comp);
                    tfksel.setSelected(comp.isModified());
                    sfksel.setSelected(comp.isModified());
                    FKContainer tab1 = (FKContainer)targetfk.getContainerWithKeyObject();
                    FKContainer tab2 = targetfk.getRemoteTable();
                    if (tab1 != null && tab2 != null) {
                        String rname = targetfk.getName() + " (" + tab1.getName() + " : " + tab2.getName() + ")";
                        tfksel.setName(rname);
                    }
                    this.comparatorsMap.put(comp.getID(), comp);
                }
            } else {
                FKComparator comp = new FKComparator(sourcefk, targetfk, true, true, this.objectsMap, this.getSourceStorageDesign(), this.getTargetStorageDesign());
                sfksel.setPropertiesComparator(comp);
                tfksel.setPropertiesComparator(comp);
                tfksel.setSelected(false);
                sfksel.setSelected(false);
                this.comparatorsMap.put(comp.getID(), comp);
            }
        } else {
            sfksel.setSelected(true);
            tfksel = new CompareObjectSelection(NEW_RELATION);
            sfksel.setStatus(2);
            tfksel.setStatus(2);
            this.newMappings.add(sfksel);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            FKComparator comp = new FKComparator(sourcefk, null, false, false, this.objectsMap, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sfksel.setPropertiesComparator(comp);
            tfksel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        tfksel.setCorrespondentNode(sfksel);
        sfksel.setCorrespondentNode(tfksel);
        allsFKsel.addChild(sfksel);
        alltFKSel.addChild(tfksel);
    }

    private void addFromSourceModel() {
        StorageDesign storageDesign;
        boolean useSyncSchema = this.object.getAppView().getSettings().isUseDBSyncSourceSchema();
        Settings settings = ApplicationView.getInstance().getSettings();
        FilteredSelection allsTabsel = new FilteredSelection(Messages.getString("CompareModelToModel.Tables"));
        FilteredSelection alltTabsel = new FilteredSelection(Messages.getString("CompareModelToModel.Tables"));
        allsTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        alltTabsel.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        FilteredSelection allsTabViewSel = new FilteredSelection(Messages.getString("CompareModelToModel.Views"));
        FilteredSelection alltTabViewSel = new FilteredSelection(Messages.getString("CompareModelToModel.Views"));
        allsTabViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        alltTabViewSel.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        FilteredSelection allsSequencesSel = new FilteredSelection(Messages.getString("CompareModelToModel.Sequences"));
        FilteredSelection alltSequencesSel = new FilteredSelection(Messages.getString("CompareModelToModel.Sequences"));
        allsSequencesSel.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON"));
        alltSequencesSel.setIcon(GUIConfiguration.getInstance().getIcon("SEQUENCE_FOLDER_ICON"));
        allsTabsel.setCorrespondentNode(alltTabsel);
        alltTabsel.setCorrespondentNode(allsTabsel);
        allsTabViewSel.setCorrespondentNode(alltTabViewSel);
        alltTabViewSel.setCorrespondentNode(allsTabViewSel);
        this.setEmptyComparator(alltTabsel);
        this.setEmptyComparator(alltTabViewSel);
        alltTabsel.setSelected(false);
        alltTabViewSel.setSelected(false);
        this.setEmptyComparator(allsTabsel);
        this.setEmptyComparator(allsTabViewSel);
        if (this.buildDataTypes) {
            this.addDataTypes();
        }
        boolean checkSelectedIDs = this.syncMode;
        List list = new ArrayList();
        this.sourcedes.getTableSet().addAllElementsTo(list);
        list = this.excludeModelObjects(list);
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        for (Table sourceTable : list) {
            if (checkSelectedIDs && this.selectedIDs != null) {
                if (!this.selectedIDs.containsKey(sourceTable.getObjectID())) continue;
                this.addTable(sourceTable, allsTabsel, alltTabsel);
                continue;
            }
            this.addTable(sourceTable, allsTabsel, alltTabsel);
        }
        this.addDeletedTables(allsTabsel, alltTabsel);
        this.addChild(allsTabsel);
        this.rightRelationalRoot.addChild(alltTabsel);
        list.clear();
        this.sourcedes.getTableViewSet().addAllElementsTo(list);
        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
        for (TableView sourceTableView : list) {
            if (checkSelectedIDs && this.selectedIDs != null) {
                if (!this.selectedIDs.containsKey(sourceTableView.getObjectID())) continue;
                this.addTableView(sourceTableView, allsTabViewSel, alltTabViewSel);
                continue;
            }
            this.addTableView(sourceTableView, allsTabViewSel, alltTabViewSel);
        }
        this.addDeletedTableViews(allsTabViewSel, alltTabViewSel);
        this.addChild(allsTabViewSel);
        this.rightRelationalRoot.addChild(alltTabViewSel);
        if (ModelChooserDialog.isSelectedDatabase && this.sourcedes.getStorageDesign() instanceof StorageDesignOracle) {
            storageDesign = (StorageDesignOracle)this.getSourceStorageDesign();
            StorageDesignOracle targetSD = (StorageDesignOracle)this.getTargetStorageDesign();
            FilteredSelection allsSnapshotsSel = new FilteredSelection(Messages.getString("CompareModelToModel.Snapshots"));
            FilteredSelection alltSnapshotsSel = new FilteredSelection(Messages.getString("CompareModelToModel.Snapshots"));
            allsSnapshotsSel.setIcon(GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON"));
            alltSnapshotsSel.setIcon(GUIConfiguration.getInstance().getIcon("MATERIALIZED_VIEW_FOLDER_ICON"));
            allsSnapshotsSel.setCorrespondentNode(alltSnapshotsSel);
            alltSnapshotsSel.setCorrespondentNode(allsSnapshotsSel);
            this.setEmptyComparator(allsSnapshotsSel);
            this.setEmptyComparator(alltSnapshotsSel);
            alltSnapshotsSel.setSelected(false);
            list.clear();
            ((StorageDesignOracle)storageDesign).getSnapshotSet().addAllElementsTo(list);
            Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
            for (SnapshotOracle sourceSnapshot : list) {
                TableProxyOracle tp = sourceSnapshot.getImplementedTable();
                if (tp == null) {
                    tp = sourceSnapshot.getOnPrebuildTable();
                }
                if (checkSelectedIDs && this.selectedIDs != null) {
                    if (tp == null || !this.selectedIDs.containsKey(tp.getObjectID())) continue;
                    this.addSnapshot(sourceSnapshot, allsSnapshotsSel, alltSnapshotsSel);
                    continue;
                }
                this.addSnapshot(sourceSnapshot, allsSnapshotsSel, alltSnapshotsSel);
            }
            this.addDeletedSnapshots(allsSnapshotsSel, alltSnapshotsSel);
            this.addChild(allsSnapshotsSel);
            this.rightRelationalRoot.addChild(alltSnapshotsSel);
            if (this.selectedIDs == null) {
                allsSequencesSel.setCorrespondentNode(alltSequencesSel);
                alltSequencesSel.setCorrespondentNode(allsSequencesSel);
                this.setEmptyComparator(allsSequencesSel);
                this.setEmptyComparator(alltSequencesSel);
                alltSequencesSel.setSelected(false);
                SyncObject so = settings.getSyncObject("SEQUENCE", "Oracle");
                if (so != null && !so.isUsed() && this.syncConnFlag) {
                    allsSequencesSel.setInSyncOperation(false);
                } else {
                    list.clear();
                    ((StorageDesignOracle)storageDesign).getSequenceSet().addAllElementsTo(list);
                    Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                    for (SequenceOracle sourceSequence : list) {
                        this.addSequence(sourceSequence, (ModelIdObjectSelection)allsSequencesSel, (ModelIdObjectSelection)alltSequencesSel);
                    }
                    this.addDeletedSequences(allsSequencesSel, alltSequencesSel);
                }
                this.addChild(allsSequencesSel);
                this.rightRelationalRoot.addChild(alltSequencesSel);
                this.addDimensions(this, this.rightRelationalRoot, useSyncSchema);
                list.clear();
                ((StorageDesignOracle)storageDesign).getStoredProcedureSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String ProcedureIconName = "PROCEDURE_FOLDER_ICON";
                this.addChildNodes(list, targetSD.getStoredProcedureSet(), this, this.rightRelationalRoot, STORED_PROCEDURES, ProcedureIconName, NEW_STORED_PROCEDURE, useSyncSchema, true, "PROCEDURE");
                list.clear();
                ((StorageDesignOracle)storageDesign).getFunctionSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String FunctionIconName = "FUNCTION_FOLDER_ICON";
                this.addChildNodes(list, targetSD.getFunctionSet(), this, this.rightRelationalRoot, FUNCTIONS, FunctionIconName, NEW_FUNCTION, useSyncSchema, true, "FUNCTION");
                list.clear();
                ((StorageDesignOracle)storageDesign).getPackageSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String PackageIconName = "PACKAGE_FOLDER_ICON";
                this.addChildNodes(list, targetSD.getPackageSet(), this, this.rightRelationalRoot, PACKAGES, PackageIconName, NEW_PACKAGE, useSyncSchema, true, "PACKAGE");
                list.clear();
                ((StorageDesignOracle)storageDesign).getSynonymSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String SynonymIconName = "SYNONYM_FOLDER_ICON";
                this.addChildNodes(list, targetSD.getSynonymSet(), this, this.rightRelationalRoot, SYNONYMS, SynonymIconName, NEW_SYNONYM, useSyncSchema, true, "SYNONYM");
                list.clear();
                ((StorageDesignOracle)storageDesign).getContextSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String contextIconName = "CONTEXT_ICON";
                this.addChildNodes(list, targetSD.getContextSet(), this, this.rightRelationalRoot, CONTEXTS, contextIconName, NEW_CONTEXT, useSyncSchema, false, "CONTEXT");
                list.clear();
                ((StorageDesignOracle)storageDesign).getDirectorySet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String directoryIconName = "DIRECTORIES_ICON";
                this.addChildNodes(list, targetSD.getDirectorySet(), this, this.rightRelationalRoot, DIRECTORIES, directoryIconName, NEW_DIRECTORY, useSyncSchema, false, "DIRECTORY");
                if (storageDesign instanceof StorageDesignOraclev10g) {
                    list.clear();
                    ((StorageDesignOraclev10g)storageDesign).getDiskGroupSet().addAllElementsTo(list);
                    if (!list.isEmpty()) {
                        Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                        String diskGroupIconName = "DISK_ICON";
                        this.addChildNodes(list, ((StorageDesignOraclev10g)targetSD).getDiskGroupSet(), this, this.rightRelationalRoot, DISK_GROUPS, diskGroupIconName, NEW_DISK_GROUP, false, false, null);
                    }
                }
                list.clear();
                ((StorageDesignOracle)storageDesign).getTableSpaceSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String TablespaceIconName = "TABLESPACE_ICON";
                this.addTablespaces(list, targetSD.getTableSpaceSet(), this, this.rightRelationalRoot, TABLESPACES, TablespaceIconName, NEW_TABLESPACE, "TABLESPACE");
                list.clear();
                ((StorageDesignOracle)storageDesign).getTemporaryTablespaceSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                this.addTablespaces(list, targetSD.getTemporaryTablespaceSet(), this, this.rightRelationalRoot, TEMP_TABLESPACES, TablespaceIconName, NEW_TEMP_TABLESPACE, "TEMP TABLESPACE");
                list.clear();
                ((StorageDesignOracle)storageDesign).getUndoTablespaceSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                this.addTablespaces(list, targetSD.getUndoTablespaceSet(), this, this.rightRelationalRoot, UNDO_TABLESPACES, TablespaceIconName, NEW_UNDO_TABLESPACE, "UNDO TABLESPACE");
                list.clear();
                ((StorageDesignOracle)storageDesign).getRoleSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String RoleIconName = "ROLE_ICON";
                this.addUsersOrRoles(list, targetSD.getRoleSet(), this, this.rightRelationalRoot, ROLES, RoleIconName, NEW_ROLE, useSyncSchema, "ROLE");
                list.clear();
                ((StorageDesignOracle)storageDesign).getUserSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                String UserIconName = "USER_FOLDER_ICON";
                this.addUsersOrRoles(list, targetSD.getUserSet(), this, this.rightRelationalRoot, USERS, UserIconName, NEW_USER, useSyncSchema, "USER");
            }
        } else if (ModelChooserDialog.isSelectedDatabase && this.sourcedes.getStorageDesign() instanceof StorageDesignSqlServerv2k12) {
            allsSequencesSel.setCorrespondentNode(alltSequencesSel);
            alltSequencesSel.setCorrespondentNode(allsSequencesSel);
            this.setEmptyComparator(allsSequencesSel);
            this.setEmptyComparator(alltSequencesSel);
            alltSequencesSel.setSelected(false);
            storageDesign = (StorageDesignSqlServerv2k12)this.getSourceStorageDesign();
            if (this.selectedIDs == null) {
                list.clear();
                ((StorageDesignSqlServerv2k12)storageDesign).getSequenceSet().addAllElementsTo(list);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                for (SequenceSqlServerv2k12 sourceSequence : list) {
                    this.addSequence(sourceSequence, (ModelIdObjectSelection)allsSequencesSel, (ModelIdObjectSelection)alltSequencesSel);
                }
                this.addDeletedSequences(allsSequencesSel, alltSequencesSel);
                this.addChild(allsSequencesSel);
                this.rightRelationalRoot.addChild(alltSequencesSel);
            }
        }
    }

    private List excludeModelObjects(List list) {
        boolean use = ApplicationView.getInstance().getSettings().isUseDBSyncSourceConnection();
        if (!this.syncConnFlag || !use) {
            return list;
        }
        List<String> syncConnNames = this.getSyncConnNames();
        ArrayList<ModelObject> newList = new ArrayList<ModelObject>();
        for (int i = 0; i < list.size(); ++i) {
            ModelObject obj = (ModelObject)list.get(i);
            String objName = obj.getSourceConnName();
            if (!"".equals(objName) && !syncConnNames.contains(objName)) continue;
            newList.add(obj);
        }
        return newList;
    }

    private boolean excludeModelObject(ModelObject obj) {
        if (!this.syncConnFlag) {
            return false;
        }
        List<String> syncConnNames = this.getSyncConnNames();
        boolean use = obj.getAppView().getSettings().isUseDBSyncSourceConnection();
        String objName = obj.getSourceConnName();
        return use && !"".equals(objName) && !syncConnNames.contains(objName);
    }

    private List<String> getSyncConnNames() {
        ArrayList<String> syncConnNames = new ArrayList<String>();
        if (this.syncMode) {
            for (int i = 0; i < this.sourcedes.getImportConnectionStamps().size(); ++i) {
                if (this.sourcedes.getImportConnectionStamp(i).getSyncSelected() != 1) continue;
                syncConnNames.add(this.sourcedes.getImportConnectionStamp(i).getConnName());
            }
        } else {
            for (int i = 0; i < this.targetdes.getImportConnectionStamps().size(); ++i) {
                if (this.targetdes.getImportConnectionStamp(i).getSyncSelected() != 1) continue;
                syncConnNames.add(this.targetdes.getImportConnectionStamp(i).getConnName());
            }
        }
        return syncConnNames;
    }

    private void addSequence(SequenceOracle sourceSequence, ModelIdObjectSelection allsSequencesSel, ModelIdObjectSelection alltSequencesSel) {
        StorageDesignOracle tStorageDesign = (StorageDesignOracle)this.getTargetStorageDesign();
        boolean useSyncSchema = this.object.getAppView().getSettings().isUseDBSyncSourceSchema();
        SequenceOracle targetSequence = (SequenceOracle)CompareModelToModel.getCorrespondingImportedObject(tStorageDesign.getSequenceSet().iterator(), sourceSequence, useSyncSchema);
        if (this.useGenerateInDDL && (!sourceSequence.isMarkedGenerate() || targetSequence != null && !targetSequence.isMarkedGenerate())) {
            if (sourceSequence != null && targetSequence != null) {
                this.objectsMap.put(sourceSequence.getObjectID(), targetSequence);
            }
            return;
        }
        if (targetSequence == null) {
            String sourceSequenceName = sourceSequence.getName();
            String sourceUserName = sourceSequence.getUser() == null ? "" : sourceSequence.getUser().getName();
            targetSequence = (SequenceOracle)tStorageDesign.getSequenceSet().getByUserSchemaAndName(sourceUserName, sourceSequenceName);
            if (targetSequence == null && !useSchema) {
                targetSequence = (SequenceOracle)tStorageDesign.getSequenceSet().getByName(sourceSequenceName);
            }
        }
        CompareObjectSelection sourceSequenceSel = new CompareObjectSelection(sourceSequence);
        CompareObjectSelection targetSequenceSel = null;
        if (targetSequence != null) {
            targetSequenceSel = new CompareObjectSelection(targetSequence);
            SequenceComparatorOracle comp = new SequenceComparatorOracle(sourceSequence, targetSequence);
            sourceSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSequenceSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceSequence.getObjectID(), targetSequence);
        } else {
            sourceSequenceSel.setSelected(true);
            targetSequenceSel = new CompareObjectSelection(NEW_SEQUENCE);
            SequenceComparatorOracle comp = new SequenceComparatorOracle(sourceSequence, targetSequence);
            sourceSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setElementDescriptor(SequenceOraclev10g.class);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSequenceSel.setStatus(2);
            targetSequenceSel.setStatus(2);
            this.newMappings.add(sourceSequenceSel);
        }
        targetSequenceSel.setCorrespondentNode(sourceSequenceSel);
        sourceSequenceSel.setCorrespondentNode(targetSequenceSel);
        allsSequencesSel.addChild(sourceSequenceSel);
        alltSequencesSel.addChild(targetSequenceSel);
    }

    private void addSequence(SequenceSqlServerv2k12 sourceSequence, ModelIdObjectSelection allsSequencesSel, ModelIdObjectSelection alltSequencesSel) {
        SequenceSqlServerComparator comp;
        CompareObjectSelection sourceSequenceSel = new CompareObjectSelection(sourceSequence);
        StorageDesignSqlServerv2k12 tStorageDesign = (StorageDesignSqlServerv2k12)this.getTargetStorageDesign();
        boolean useSyncSchema = this.object.getAppView().getSettings().isUseDBSyncSourceSchema();
        SequenceSqlServerv2k12 targetSequence = (SequenceSqlServerv2k12)CompareModelToModel.getCorrespondingImportedObject(tStorageDesign.getSequenceSet().iterator(), sourceSequence, useSyncSchema);
        if (this.useGenerateInDDL && (!sourceSequence.isMarkedGenerate() || targetSequence != null && !targetSequence.isMarkedGenerate())) {
            if (sourceSequence != null && targetSequence != null) {
                this.objectsMap.put(sourceSequence.getObjectID(), targetSequence);
            }
            return;
        }
        if (targetSequence == null) {
            String sourceSequenceName = sourceSequence.getName();
            String sourceSchemaName = sourceSequence.getSchema() == null ? "" : sourceSequence.getSchema().getName();
            targetSequence = (SequenceSqlServerv2k12)tStorageDesign.getSequenceSet().getBySchemaAndName(sourceSchemaName, sourceSequenceName);
            if (targetSequence == null && !useSchema) {
                targetSequence = (SequenceSqlServerv2k12)tStorageDesign.getSequenceSet().getByName(sourceSequenceName);
            }
        }
        CompareObjectSelection targetSequenceSel = null;
        if (targetSequence != null) {
            targetSequenceSel = new CompareObjectSelection(targetSequence);
            comp = new SequenceSqlServerComparator(sourceSequence, targetSequence);
            sourceSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSequenceSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceSequence.getObjectID(), targetSequence);
        } else {
            sourceSequenceSel.setSelected(true);
            targetSequenceSel = new CompareObjectSelection(NEW_SEQUENCE);
            comp = new SequenceSqlServerComparator(sourceSequence, targetSequence);
            sourceSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setPropertiesComparator(comp);
            targetSequenceSel.setElementDescriptor(SequenceSqlServerv2k12.class);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSequenceSel.setStatus(2);
            targetSequenceSel.setStatus(2);
            this.newMappings.add(sourceSequenceSel);
        }
        targetSequenceSel.setCorrespondentNode(sourceSequenceSel);
        sourceSequenceSel.setCorrespondentNode(targetSequenceSel);
        allsSequencesSel.addChild(sourceSequenceSel);
        alltSequencesSel.addChild(targetSequenceSel);
    }

    private void addDeletedSnapshots(ModelIdObjectSelection allsSnapshotsSel, ModelIdObjectSelection alltSnapshotsSel) {
        StorageDesign stoDesign = this.targetdes.getStorageDesign();
        if (stoDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)stoDesign;
            for (SnapshotOracle targetSnapshot : storageDesign.getSnapshotSet()) {
                TableProxyOracle tp = targetSnapshot.getImplementedTable();
                if (tp == null) {
                    tp = targetSnapshot.getOnPrebuildTable();
                }
                if (this.selectedIDs != null && tp != null && !this.selectedIDs.containsKey(tp.getObjectID()) || this.objectsMap.containsValue(targetSnapshot)) continue;
                CompareObjectSelection tSnapshopSel = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(tSnapshopSel);
                tSnapshopSel.setSelected(false);
                CompareObjectSelection sSnapshopSel = new CompareObjectSelection(targetSnapshot);
                tSnapshopSel.setElementDescriptor(SnapshotOraclev10g.class);
                SnapshotComparator comp = new SnapshotComparator(null, targetSnapshot, this.objectsMap);
                this.comparatorsMap.put(comp.getID(), comp);
                tSnapshopSel.setPropertiesComparator(comp);
                sSnapshopSel.setPropertiesComparator(comp);
                tSnapshopSel.setStatus(3);
                sSnapshopSel.setStatus(3);
                sSnapshopSel.setCorrespondentNode(tSnapshopSel);
                tSnapshopSel.setCorrespondentNode(sSnapshopSel);
                allsSnapshotsSel.addChild(tSnapshopSel);
                alltSnapshotsSel.addChild(sSnapshopSel);
            }
        }
    }

    private void addDeletedSequences(ModelIdObjectSelection allsSequenceSel, ModelIdObjectSelection alltSequenceSel) {
        StoragePropertiesComparator comp;
        CompareObjectSelection sSequenceSel;
        CompareObjectSelection tSequenceSel;
        StorageDesign storageDesign;
        StorageDesign stoDesign = this.targetdes.getStorageDesign();
        if (stoDesign instanceof StorageDesignOracle) {
            storageDesign = (StorageDesignOracle)stoDesign;
            for (StorageObject targetSequence : ((StorageDesignOracle)storageDesign).getSequenceSet()) {
                if (this.objectsMap.containsValue(targetSequence)) continue;
                tSequenceSel = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(tSequenceSel);
                tSequenceSel.setSelected(false);
                sSequenceSel = new CompareObjectSelection(targetSequence);
                tSequenceSel.setElementDescriptor(SequenceOraclev10g.class);
                comp = new SequenceComparatorOracle(null, (SequenceOracle)targetSequence);
                this.comparatorsMap.put(comp.getID(), comp);
                tSequenceSel.setPropertiesComparator(comp);
                sSequenceSel.setPropertiesComparator(comp);
                tSequenceSel.setStatus(3);
                sSequenceSel.setStatus(3);
                sSequenceSel.setCorrespondentNode(tSequenceSel);
                tSequenceSel.setCorrespondentNode(sSequenceSel);
                allsSequenceSel.addChild(tSequenceSel);
                alltSequenceSel.addChild(sSequenceSel);
            }
        }
        if (stoDesign instanceof StorageDesignSqlServerv2k12) {
            storageDesign = (StorageDesignSqlServerv2k12)stoDesign;
            for (StorageObject targetSequence : ((StorageDesignSqlServerv2k12)storageDesign).getSequenceSet()) {
                if (this.objectsMap.containsValue(targetSequence)) continue;
                tSequenceSel = new CompareObjectSelection(TO_DROP);
                this.deletedMappings.add(tSequenceSel);
                tSequenceSel.setSelected(false);
                sSequenceSel = new CompareObjectSelection(targetSequence);
                tSequenceSel.setElementDescriptor(SequenceSqlServerv2k12.class);
                comp = new SequenceSqlServerComparator(null, targetSequence);
                this.comparatorsMap.put(comp.getID(), comp);
                tSequenceSel.setPropertiesComparator(comp);
                sSequenceSel.setPropertiesComparator(comp);
                tSequenceSel.setStatus(3);
                sSequenceSel.setStatus(3);
                sSequenceSel.setCorrespondentNode(tSequenceSel);
                tSequenceSel.setCorrespondentNode(sSequenceSel);
                allsSequenceSel.addChild(tSequenceSel);
                alltSequenceSel.addChild(sSequenceSel);
            }
        }
    }

    private void addSnapshot(SnapshotOracle sourceSnapshot, ModelIdObjectSelection allsSnapshotsSel, ModelIdObjectSelection alltSnapshotsSel) {
        SnapshotComparator comp;
        StorageDesignOracle tStorageDesign = (StorageDesignOracle)this.getTargetStorageDesign();
        boolean useSyncSchema = this.object.getAppView().getSettings().isUseDBSyncSourceSchema();
        SnapshotOracle targetSnapshot = (SnapshotOracle)CompareModelToModel.getCorrespondingImportedObject(tStorageDesign.getSnapshotSet().iterator(), sourceSnapshot, useSyncSchema);
        if (targetSnapshot == null) {
            targetSnapshot = (SnapshotOracle)tStorageDesign.getSnapshotSet().getByName(sourceSnapshot.getName());
        }
        if (this.useGenerateInDDL && (!sourceSnapshot.isMarkedGenerate() || targetSnapshot != null && !targetSnapshot.isMarkedGenerate())) {
            if (sourceSnapshot != null && targetSnapshot != null) {
                this.objectsMap.put(sourceSnapshot.getObjectID(), targetSnapshot);
            }
            return;
        }
        CompareObjectSelection sourceSnapshotSel = new CompareObjectSelection(sourceSnapshot);
        CompareObjectSelection targetSnapshotSel = null;
        if (targetSnapshot != null) {
            targetSnapshotSel = new CompareObjectSelection(targetSnapshot);
            comp = new SnapshotComparator(sourceSnapshot, targetSnapshot, this.objectsMap);
            sourceSnapshotSel.setPropertiesComparator(comp);
            targetSnapshotSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSnapshotSel.setSelected(comp.isModified());
            this.objectsMap.put(sourceSnapshot.getObjectID(), targetSnapshot);
        } else {
            sourceSnapshotSel.setSelected(true);
            targetSnapshotSel = new CompareObjectSelection(NEW_SNAPSHOT);
            comp = new SnapshotComparator(sourceSnapshot, targetSnapshot, this.objectsMap);
            sourceSnapshotSel.setPropertiesComparator(comp);
            targetSnapshotSel.setPropertiesComparator(comp);
            targetSnapshotSel.setElementDescriptor(SnapshotOraclev10g.class);
            this.comparatorsMap.put(comp.getID(), comp);
            sourceSnapshotSel.setStatus(2);
            targetSnapshotSel.setStatus(2);
            this.newMappings.add(sourceSnapshotSel);
        }
        targetSnapshotSel.setCorrespondentNode(sourceSnapshotSel);
        sourceSnapshotSel.setCorrespondentNode(targetSnapshotSel);
        List sourceLobList = sourceSnapshot.getLobsCollection().getElementsList();
        StorageObjectCollection targetLobs = null;
        if (targetSnapshot != null) {
            targetLobs = targetSnapshot.getLobsCollection();
        }
        String LobStorageIconName = "OPEN_ICON";
        this.addChildNodes(sourceLobList, targetLobs, sourceSnapshotSel, targetSnapshotSel, LOB_STORAGES, LobStorageIconName, NEW_LOB_STORAGE, false, false);
        this.addPartitioningNodes(sourceSnapshot, targetSnapshot, sourceSnapshotSel, targetSnapshotSel);
        allsSnapshotsSel.addChild(sourceSnapshotSel);
        alltSnapshotsSel.addChild(targetSnapshotSel);
        if (sourceSnapshotSel.isModified() || sourceSnapshotSel.hasChildsWithChangeStatus()) {
            sourceSnapshotSel.setSelectedNoPropagateSelection(true);
        }
    }

    private void addColumn(Column sourceColumn, Table targetTable, FilteredSelection sourceColumnSel, FilteredSelection targetColumnSel, int columnPos) {
        ColumnProxy sourceColumnProxy = (ColumnProxy)this.getSourceStorageDesign().getColumnProxySet().getProxy(sourceColumn.getObjectID());
        ColumnSelection sColsel = new ColumnSelection(sourceColumn);
        sColsel.setProxy(sourceColumnProxy);
        ModelIdObjectSelection tColsel = null;
        Column targetColumn = null;
        if (targetTable != null && (targetColumn = (Column)this.getCorrespondingColumn(targetTable.getElements(), sourceColumn, columnPos)) != null) {
            ColumnProxy targetColumnProxy = (ColumnProxy)this.getTargetStorageDesign().getColumnProxySet().getProxy(targetColumn.getObjectID());
            tColsel = new FilteredSelection(targetColumn);
            ((CompareObjectSelection)tColsel).setProxy(targetColumnProxy);
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, targetColumnProxy, this.objectsMap);
            sColsel.setPropertiesComparator(comp);
            ((CompareObjectSelection)tColsel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            boolean propsModified = comp.isModified();
            ((CompareObjectSelection)sColsel).setSelected(propsModified);
            sColsel.setEditable(propsModified);
            this.objectsMap.put(sourceColumn.getObjectID(), targetColumn);
        }
        if (targetColumn == null) {
            ((CompareObjectSelection)sColsel).setSelected(true);
            tColsel = new FilteredSelection(NEW_COLUMN);
            ((CompareObjectSelection)tColsel).setStatus(2);
            sColsel.setStatus(2);
            this.newMappings.add(sColsel);
            ColumnComparator comp = new ColumnComparator(sourceColumn, targetColumn, sourceColumnProxy, null, this.objectsMap);
            sColsel.setPropertiesComparator(comp);
            ((CompareObjectSelection)tColsel).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        tColsel.setElementDescriptor(Column.class);
        sColsel.setCorrespondentNode((CompareObjectSelection)tColsel);
        ((CompareObjectSelection)tColsel).setCorrespondentNode(sColsel);
        sourceColumnSel.addChild(sColsel);
        targetColumnSel.addChild(tColsel);
        if (((ColumnComparator)((CompareObjectSelection)tColsel).getPropertiesComparator()).isDataTypeChanged()) {
            this.columnsWithChangedDataType.add(tColsel);
        }
    }

    private ContainedObject getCorrespondingNestedColumn(List targetNestedElements, ContainedObject sourceColumn) {
        TypeElement targetStructAtt;
        ContainedObject targetParentColumn;
        ContainedObject sourceParentColumn = sourceColumn.getParentObject();
        if (sourceParentColumn != null && (targetParentColumn = (ContainedObject)this.objectsMap.get(sourceParentColumn.getObjectID())) != null && (targetStructAtt = (TypeElement)this.objectsMap.get(sourceColumn.getStructAttributeID())) != null) {
            String targetStructAttID = targetStructAtt.getObjectID();
            String targetParentColumnID = targetParentColumn.getObjectID();
            for (ContainedObject targetCol : targetNestedElements) {
                ContainedObject parentCol;
                if (!targetCol.getStructAttributeID().equals(targetStructAttID) || (parentCol = targetCol.getParentObject()) == null || !parentCol.getObjectID().equals(targetParentColumnID)) continue;
                return targetCol;
            }
        }
        return null;
    }

    private DesignObject getCorrespondingColumn(ContainedObject[] elements, Column object, int columnPos) {
        ContainedObject obj;
        Table targetTable;
        CompareMapping compareMapping = this.sourcedes.getDesign().getDesignLevelSettings().getCompareMapping();
        CompareMapping tcm = this.targetdes.getDesign().getDesignLevelSettings().getCompareMapping();
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj2 = elements[i];
            if (!(obj2.getImportedId() != null && obj2.getImportedId().equals(object.getObjectID()) || object.getImportedId() != null && object.getImportedId().equals(obj2.getObjectID()) || object.getObjectID().equals(obj2.getObjectID())) && (obj2.getImportedId() == null || object.getImportedId() == null || !obj2.getImportedId().equals(object.getImportedId()))) continue;
            return obj2;
        }
        boolean useName = object.getAppView().getSettings().isUseDBSyncSourceObject();
        DesignObject impCol = null;
        if (useName) {
            impCol = (DesignObject)CompareModelToModel.getCorrespondingImportedColumn(elements, object);
        }
        if (impCol != null) {
            return impCol;
        }
        for (int i = 0; i < elements.length; ++i) {
            ContainedObject obj3 = elements[i];
            if (!(caseSensitive ? ((DesignObject)obj3).getName().equals(object.getName()) : ((DesignObject)obj3).getName().equalsIgnoreCase(object.getName()))) continue;
            return obj3;
        }
        CompareMappingObject compObject = compareMapping.getCompareMap().get(object.getName());
        if (compObject == null) {
            compObject = tcm.getCompareMap().get(object.getName());
        }
        Column sourceCol = object;
        Table sourceTable = (Table)sourceCol.getContainer();
        if (compObject != null && compObject.isSelected() && sourceTable.getName().equals(compObject.getSourceParentName()) && (targetTable = (Table)this.targetdes.getTableSet().getByName(compObject.getTargetParentName())) != null) {
            Column targetColumn = (Column)targetTable.getElementByName(compObject.getTargetObjectName());
            return targetColumn;
        }
        if (columnPos < elements.length && (obj = elements[columnPos]) instanceof Column) {
            Column targetCol = (Column)obj;
            sourceCol = object;
            if (targetCol.getIndex() == object.getIndex() && targetCol.getDataType().toString().equals(sourceCol.getDataType().toString()) && sourceCol.getContainer().getElementByName(targetCol.getName()) == null && sourceCol.getContainer().getElementByID(targetCol.getObjectID()) == null) {
                return targetCol;
            }
        }
        return null;
    }

    private void addTableDetails(Table sourceTable, CompareObjectSelection sourceTabsel, Table targetTable, CompareObjectSelection targetTabSel) {
        TableProxy sourceTableProxy;
        FilteredSelection sourceColumnSel = new FilteredSelection(Messages.getString("CompareModelToModel.Columns"));
        FilteredSelection targetColumnSel = new FilteredSelection(Messages.getString("CompareModelToModel.Columns"));
        sourceColumnSel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        targetColumnSel.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        sourceColumnSel.setCorrespondentNode(targetColumnSel);
        targetColumnSel.setCorrespondentNode(sourceColumnSel);
        this.setEmptyComparator(sourceColumnSel);
        this.setEmptyComparator(targetColumnSel);
        targetColumnSel.setSelected(false);
        Iterator<Object> it = sourceTable.getElementsCollection().iterator();
        int pos = 0;
        while (it.hasNext()) {
            Column sourceColumn = (Column)it.next();
            this.addColumn(sourceColumn, targetTable, sourceColumnSel, targetColumnSel, pos);
            ++pos;
        }
        if (targetTable != null) {
            this.addDeletedColumns(sourceTable, sourceColumnSel, targetTable, targetColumnSel);
            List targetNestedElements = targetTable.getNestedElements();
            if (targetNestedElements.size() > 0) {
                for (ContainedObject sourceNestedColumn : sourceTable.getNestedElements()) {
                    ContainedObject targetNestedColumn = this.getCorrespondingNestedColumn(targetNestedElements, sourceNestedColumn);
                    if (targetNestedColumn == null) continue;
                    this.objectsMap.put(sourceNestedColumn.getObjectID(), targetNestedColumn);
                }
            }
        }
        sourceTabsel.addChild(sourceColumnSel);
        targetTabSel.addChild(targetColumnSel);
        ((TableComparator)sourceTabsel.getPropertiesComparator()).presetColumnsOrder();
        this.initIndexes(sourceTable);
        FilteredSelection allsPlainsel = new FilteredSelection(Messages.getString("CompareModelToModel.Indexes"));
        FilteredSelection alltPlainSel = new FilteredSelection(Messages.getString("CompareModelToModel.Indexes"));
        allsPlainsel.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        alltPlainSel.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        allsPlainsel.setCorrespondentNode(alltPlainSel);
        alltPlainSel.setCorrespondentNode(allsPlainsel);
        this.setEmptyComparator(allsPlainsel);
        this.setEmptyComparator(alltPlainSel);
        alltPlainSel.setSelected(false);
        for (Index sourceIndex : this.indexes) {
            this.addIndex(sourceIndex, targetTable, allsPlainsel, alltPlainSel, false);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allsPlainsel, alltPlainSel, false);
        }
        sourceTabsel.addChild(allsPlainsel);
        targetTabSel.addChild(alltPlainSel);
        FilteredSelection allsIndsel = new FilteredSelection(PK_UK_CONSTRAINTS);
        FilteredSelection alltIndSel = new FilteredSelection(PK_UK_CONSTRAINTS);
        allsIndsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        alltIndSel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        allsIndsel.setCorrespondentNode(alltIndSel);
        alltIndSel.setCorrespondentNode(allsIndsel);
        this.setEmptyComparator(allsIndsel);
        this.setEmptyComparator(alltIndSel);
        alltIndSel.setSelected(false);
        for (Index sourceIndex : this.pkInd) {
            this.addIndex(sourceIndex, targetTable, allsIndsel, alltIndSel, true);
        }
        if (targetTable != null) {
            this.addDeletedIndexes(targetTable, allsIndsel, alltIndSel, true);
        }
        sourceTabsel.addChild(allsIndsel);
        targetTabSel.addChild(alltIndSel);
        FilteredSelection allsFKsel = new FilteredSelection(FOREIGN_KEYS);
        FilteredSelection alltFKSel = new FilteredSelection(FOREIGN_KEYS);
        allsFKsel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        alltFKSel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        allsFKsel.setCorrespondentNode(alltFKSel);
        alltFKSel.setCorrespondentNode(allsFKsel);
        this.setEmptyComparator(allsFKsel);
        this.setEmptyComparator(alltFKSel);
        alltFKSel.setSelected(false);
        List<FKIndexAssociation> sourcefkIndexes = Arrays.asList(sourceTable.getFKAssociations());
        for (FKIndexAssociation sourcefk : sourcefkIndexes) {
            this.addFK(sourcefk, targetTable, allsFKsel, alltFKSel, false);
        }
        if (targetTable != null) {
            this.addDeletedFKAssociation(targetTable, allsFKsel, alltFKSel);
        }
        sourceTabsel.addChild(allsFKsel);
        targetTabSel.addChild(alltFKSel);
        String tableCheckConstraintsText = Messages.getString("CompareModelToModel.TableCheckConstraints");
        FilteredSelection sourceCheckSel = new FilteredSelection(tableCheckConstraintsText);
        FilteredSelection targetCheckSel = new FilteredSelection(tableCheckConstraintsText);
        sourceCheckSel.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON"));
        targetCheckSel.setIcon(GUIConfiguration.getInstance().getIcon("CONSTRAINT_ICON"));
        sourceCheckSel.setCorrespondentNode(targetCheckSel);
        targetCheckSel.setCorrespondentNode(sourceCheckSel);
        this.setEmptyComparator(sourceCheckSel);
        this.setEmptyComparator(targetCheckSel);
        targetCheckSel.setSelected(false);
        for (TableLevelConstraint sourceConstraint : sourceTable.getCheckConstraints()) {
            this.addCheckConstraint(sourceConstraint, targetTable, sourceCheckSel, targetCheckSel);
        }
        if (targetTable != null) {
            this.addDeletedCheckConstraints(targetTable, sourceCheckSel, targetCheckSel);
        }
        sourceTabsel.addChild(sourceCheckSel);
        targetTabSel.addChild(targetCheckSel);
        FilteredSelection sourceTimeDimSel = new FilteredSelection(VALID_TIME_DIMENSIONS);
        FilteredSelection targetTimeDimSel = new FilteredSelection(VALID_TIME_DIMENSIONS);
        Icon dimensionIcon = GUIConfiguration.getInstance().getIcon("DIMENSION_ICON");
        sourceTimeDimSel.setIcon(dimensionIcon);
        targetTimeDimSel.setIcon(dimensionIcon);
        sourceTimeDimSel.setCorrespondentNode(targetTimeDimSel);
        targetTimeDimSel.setCorrespondentNode(sourceTimeDimSel);
        this.setEmptyComparator(sourceTimeDimSel);
        this.setEmptyComparator(targetTimeDimSel);
        targetTimeDimSel.setSelected(false);
        for (ValidTimeDimension sourceTimeDim : sourceTable.getValidTimeDimensions()) {
            this.addTimeDimension(sourceTimeDim, targetTable, sourceTimeDimSel, targetTimeDimSel);
        }
        if (targetTable != null) {
            this.addDeletedTimeDimensions(targetTable, sourceTimeDimSel, targetTimeDimSel);
        }
        sourceTabsel.addChild(sourceTimeDimSel);
        targetTabSel.addChild(targetTimeDimSel);
        this.addArcs(sourceTable, sourceTabsel, targetTable, targetTabSel);
        if (ApplicationView.getInstance().getSettings().isIncludePhysicalPropertiesInCompare() && (sourceTableProxy = (TableProxy)this.getSourceStorageDesign().getTableProxySet().getProxy(sourceTable.getObjectID())) != null) {
            TableProxy targetTableProxy = null;
            if (targetTable != null) {
                targetTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            }
            List sourceTriggerList = sourceTableProxy.getTriggers().getElementsList();
            StorageObjectCollection targetTriggers = null;
            if (targetTableProxy != null) {
                targetTriggers = targetTableProxy.getTriggers();
            }
            String TriggerIconName = "TRIGGER_FOLDER_ICON";
            this.addChildNodes(sourceTriggerList, targetTriggers, sourceTabsel, targetTabSel, TRIGGERS, TriggerIconName, NEW_TRIGGER, false, false);
            if (sourceTableProxy instanceof TableProxyOracle) {
                StorageObjectCollection targetBjIndexes = null;
                StorageObjectCollection targetLobs = null;
                if (targetTableProxy instanceof TableProxyOracle) {
                    targetBjIndexes = ((TableProxyOracle)targetTableProxy).getBjIndexes();
                    targetLobs = ((TableProxyOracle)targetTableProxy).getLobStorages();
                }
                List sourceBjIndexList = ((TableProxyOracle)sourceTableProxy).getBjIndexes().getElementsList();
                String BJIndexIconName = "INDEX_FOLDER_ICON";
                this.addChildNodes(sourceBjIndexList, targetBjIndexes, sourceTabsel, targetTabSel, BITMAP_JOIN_INDEXES, BJIndexIconName, NEW_BITMAP_JOIN_INDEX, false, false);
                List sourceLobList = ((TableProxyOracle)sourceTableProxy).getLobStorages().getElementsList();
                String LobStorageIconName = "OPEN_ICON";
                this.addChildNodes(sourceLobList, targetLobs, sourceTabsel, targetTabSel, LOB_STORAGES, LobStorageIconName, NEW_LOB_STORAGE, false, false);
            }
            this.addPartitioningNodes(sourceTableProxy, targetTableProxy, sourceTabsel, targetTabSel);
        }
    }

    private void addTableViewDetails(TableView sourceView, CompareObjectSelection sourceViewsel, TableView targetView, CompareObjectSelection targetViewSel) {
        if (targetView != null) {
            for (ColumnView sourceCol : sourceView.getElementsCollection()) {
                ColumnView targetCol = (ColumnView)this.getCorrespondingObject((List)targetView.getElementsCollection(), (DesignObject)sourceCol);
                if (targetCol == null) continue;
                this.objectsMap.put(sourceCol.getObjectID(), targetCol);
            }
        }
        FilteredSelection allsIndsel = new FilteredSelection(PK_UK_CONSTRAINTS);
        FilteredSelection alltIndSel = new FilteredSelection(PK_UK_CONSTRAINTS);
        allsIndsel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        alltIndSel.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        allsIndsel.setCorrespondentNode(alltIndSel);
        alltIndSel.setCorrespondentNode(allsIndsel);
        this.setEmptyComparator(allsIndsel);
        this.setEmptyComparator(alltIndSel);
        alltIndSel.setSelected(false);
        this.initViewIndexes(sourceView);
        for (ViewIndex sourceIndex : this.viewIndexes) {
            this.addViewIndex(sourceIndex, targetView, allsIndsel, alltIndSel);
        }
        if (targetView != null) {
            this.addDeletedViewIndexes(targetView, allsIndsel, alltIndSel);
        }
        sourceViewsel.addChild(allsIndsel);
        targetViewSel.addChild(alltIndSel);
        FilteredSelection allsFKsel = new FilteredSelection(FOREIGN_KEYS);
        FilteredSelection alltFKSel = new FilteredSelection(FOREIGN_KEYS);
        allsFKsel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        alltFKSel.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        allsFKsel.setCorrespondentNode(alltFKSel);
        alltFKSel.setCorrespondentNode(allsFKsel);
        this.setEmptyComparator(allsFKsel);
        this.setEmptyComparator(alltFKSel);
        alltFKSel.setSelected(false);
        List<FKIndexAssociation> sourcefkIndexes = Arrays.asList(sourceView.getFKAssociations());
        for (FKIndexAssociation sourcefk : sourcefkIndexes) {
            this.addFK(sourcefk, targetView, allsFKsel, alltFKSel, true);
        }
        if (targetView != null) {
            this.addDeletedViewFKAssociation(targetView, allsFKsel, alltFKSel);
        }
        sourceViewsel.addChild(allsFKsel);
        targetViewSel.addChild(alltFKSel);
    }

    private void addDeletedFKAssociation(Table targetTable, FilteredSelection allsFKsel, FilteredSelection alltFKeSel) {
        for (FKIndexAssociation targetfk : Arrays.asList(targetTable.getFKAssociations())) {
            if (this.objectsMap.containsValue(targetfk)) continue;
            ModelIDObject tproxy = null;
            if (targetfk != null) {
                tproxy = this.getTargetStorageDesign().getStorageObject(targetfk.getObjectID());
            }
            if (tproxy == null) {
                tproxy = targetfk;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tproxy)) continue;
            String tfkname = targetfk.getName();
            try {
                tfkname = tfkname + " (" + targetfk.getContainerWithKeyObject().getName() + " : " + targetfk.getRemoteTable() != null ? targetfk.getRemoteTable().getName() : "  )";
            }
            catch (Exception e) {
                LOGGER.error("Error in definition of FK: " + tfkname, e);
            }
            FilteredSelection sfksel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sfksel);
            sfksel.setSelected(false);
            FilteredSelection tfksel = new FilteredSelection(targetfk);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            sfksel.setElementDescriptor(FKIndexAssociation.class);
            this.setEmptyComparator(sfksel);
            FKComparator comp = new FKComparator(null, targetfk, false, false, this.objectsMap, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tfksel.setPropertiesComparator(comp);
            tfksel.setName(tfkname);
            sfksel.setStatus(3);
            tfksel.setStatus(3);
            tfksel.setCorrespondentNode(sfksel);
            sfksel.setCorrespondentNode(tfksel);
            allsFKsel.addChild(sfksel);
            alltFKeSel.addChild(tfksel);
        }
    }

    private void addDeletedViewFKAssociation(TableView targetView, FilteredSelection allsFKsel, FilteredSelection alltFKeSel) {
        for (FKIndexAssociation targetfk : Arrays.asList(targetView.getFKAssociations())) {
            if (this.objectsMap.containsValue(targetfk) || this.useGenerateInDDL && !this.isGenerateInDDL(null, targetfk)) continue;
            String tfkname = targetfk.getName();
            try {
                tfkname = tfkname + " (" + targetfk.getContainerWithKeyObject().getName() + " : " + targetfk.getRemoteTable() != null ? targetfk.getRemoteTable().getName() : "  )";
            }
            catch (Exception e) {
                LOGGER.error("Error in definition of FK: " + tfkname, e);
            }
            FilteredSelection sfksel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sfksel);
            sfksel.setSelected(false);
            FilteredSelection tfksel = new FilteredSelection(targetfk);
            tfksel.setElementDescriptor(FKIndexAssociation.class);
            sfksel.setElementDescriptor(FKIndexAssociation.class);
            this.setEmptyComparator(sfksel);
            FKComparator comp = new FKComparator(null, targetfk, false, false, this.objectsMap, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tfksel.setPropertiesComparator(comp);
            tfksel.setName(tfkname);
            sfksel.setStatus(3);
            tfksel.setStatus(3);
            tfksel.setCorrespondentNode(sfksel);
            sfksel.setCorrespondentNode(tfksel);
            allsFKsel.addChild(sfksel);
            alltFKeSel.addChild(tfksel);
        }
    }

    private void initIndexes(Table r_table) {
        this.clearIndexList();
        Iterator it = r_table.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isPK() || key.isUnique()) {
                this.pkInd.add(key);
                continue;
            }
            if (key.isFK()) continue;
            this.indexes.add(key);
        }
    }

    private void clearIndexList() {
        this.pkInd.clear();
        this.indexes.clear();
    }

    private void initViewIndexes(TableView r_tableView) {
        this.viewIndexes.clear();
        Iterator it = r_tableView.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() && !key.isUnique()) continue;
            this.viewIndexes.add(key);
        }
    }

    private void addIndex(Index sourceIndex, Table targetTable, FilteredSelection allsIndsel, FilteredSelection alltIndSel, boolean pk_uk) {
        IndexComparator comp;
        StorageObject sIndexProxy;
        Index targetIndex = null;
        ModelIDObject siproxy = sIndexProxy = this.getSourceStorageDesign().getStorageObject(sourceIndex.getObjectID());
        StorageObject tIndexProxy = null;
        ModelIDObject tiproxy = null;
        if (targetTable != null) {
            List list = pk_uk ? targetTable.getPK_UKList() : targetTable.getIndexes_Plain_List();
            targetIndex = (Index)this.getCorrespondingObject(list, (DesignObject)sourceIndex);
            if (siproxy == null) {
                siproxy = sourceIndex;
            }
            if (targetIndex != null && (tiproxy = (tIndexProxy = this.getTargetStorageDesign().getStorageObject(targetIndex.getObjectID()))) == null) {
                tiproxy = targetIndex;
            }
        }
        if (this.useGenerateInDDL && (siproxy != null && !((ModelIDObject)siproxy).isMarkedGenerate() || tiproxy != null && !tiproxy.isMarkedGenerate())) {
            if (sourceIndex != null && targetIndex != null) {
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
            return;
        }
        FilteredSelection sIndsel = new FilteredSelection(sourceIndex);
        sIndsel.setSelected(true);
        CompareObjectSelection tIndsel = null;
        if (targetTable != null) {
            if (targetIndex == null) {
                targetIndex = this.checkForEqualStructure(sourceIndex, targetTable, allsIndsel);
            }
            if (targetIndex != null) {
                tIndsel = new FilteredSelection(targetIndex);
                comp = new IndexComparator(sourceIndex, targetIndex, this.objectsMap, pk_uk, this.getSourceStorageDesign(), this.getTargetStorageDesign());
                sIndsel.setPropertiesComparator(comp);
                tIndsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                boolean propsModified = comp.isModified();
                sIndsel.setSelected(propsModified);
                sIndsel.setEditable(propsModified);
                comp.setLeftSelectionObject(sIndsel);
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
        }
        if (targetIndex == null) {
            sIndsel.setSelected(true);
            tIndsel = new FilteredSelection(pk_uk ? NEW_KEY : NEW_INDEX);
            tIndsel.setStatus(2);
            sIndsel.setStatus(2);
            this.newMappings.add(sIndsel);
            tIndsel.setElementDescriptor(Index.class);
            comp = new IndexComparator(sourceIndex, targetIndex, this.objectsMap, pk_uk, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sIndsel.setPropertiesComparator(comp);
            tIndsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        sIndsel.setCorrespondentNode(tIndsel);
        tIndsel.setCorrespondentNode(sIndsel);
        if (ApplicationView.getInstance().getSettings().isIncludePhysicalPropertiesInCompare()) {
            this.addPartitioningNodes(sIndexProxy, tIndexProxy, sIndsel, tIndsel);
        }
        if (this.hasSelectedChildren(sIndsel)) {
            sIndsel.setEditable(true);
            sIndsel.setSelected(true);
        }
        alltIndSel.addChild(tIndsel);
        allsIndsel.addChild(sIndsel);
    }

    private void addViewIndex(ViewIndex sourceIndex, TableView targetView, FilteredSelection allsIndsel, FilteredSelection alltIndSel) {
        ViewIndexComparator comp;
        ViewIndex targetIndex = null;
        if (targetView != null) {
            targetIndex = (ViewIndex)this.getCorrespondingObject(targetView.getPK_UKList(), (DesignObject)sourceIndex);
        }
        if (this.useGenerateInDDL && (sourceIndex != null && !sourceIndex.isMarkedGenerate() || targetIndex != null && !targetIndex.isMarkedGenerate())) {
            if (sourceIndex != null && targetIndex != null) {
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
            return;
        }
        FilteredSelection sIndsel = new FilteredSelection(sourceIndex);
        sIndsel.setSelected(true);
        CompareObjectSelection tIndsel = null;
        if (targetView != null) {
            if (targetIndex == null) {
                targetIndex = this.checkViewForEqualStructure(sourceIndex, targetView, allsIndsel);
            }
            if (targetIndex != null) {
                tIndsel = new FilteredSelection(targetIndex);
                comp = new ViewIndexComparator(sourceIndex, targetIndex, this.objectsMap);
                sIndsel.setPropertiesComparator(comp);
                tIndsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                boolean propsModified = comp.isModified();
                sIndsel.setSelected(propsModified);
                sIndsel.setEditable(propsModified);
                comp.setLeftSelectionObject(sIndsel);
                this.objectsMap.put(sourceIndex.getObjectID(), targetIndex);
            }
        }
        if (targetIndex == null) {
            sIndsel.setSelected(true);
            tIndsel = new FilteredSelection(NEW_KEY);
            tIndsel.setStatus(2);
            sIndsel.setStatus(2);
            this.newMappings.add(sIndsel);
            tIndsel.setElementDescriptor(Index.class);
            comp = new ViewIndexComparator(sourceIndex, targetIndex, this.objectsMap);
            sIndsel.setPropertiesComparator(comp);
            tIndsel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        sIndsel.setCorrespondentNode(tIndsel);
        tIndsel.setCorrespondentNode(sIndsel);
        if (this.hasSelectedChildren(sIndsel)) {
            sIndsel.setEditable(true);
            sIndsel.setSelected(true);
        }
        alltIndSel.addChild(tIndsel);
        allsIndsel.addChild(sIndsel);
    }

    private Index checkForEqualStructure(Index sourceIndex, Table targetTable, FilteredSelection allsIndsel) {
        block4: {
            Table sourceTable;
            block5: {
                block3: {
                    sourceTable = (Table)sourceIndex.getContainerObject();
                    if (!sourceIndex.isPK()) break block3;
                    Index targetIndex = (Index)targetTable.getPK();
                    if (targetIndex != null && this.checkIndexes(sourceIndex, targetIndex)) {
                        return targetIndex;
                    }
                    break block4;
                }
                if (!sourceIndex.isUnique()) break block5;
                for (Object obj : targetTable.getUKeys()) {
                    Index targetIndex = obj instanceof ContainerObjectPlaceHolder ? (Index)((ContainerObjectPlaceHolder)obj).getObject() : (Index)obj;
                    if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getUKeys().getByName(targetIndex.getName()) != null) continue;
                    return targetIndex;
                }
                break block4;
            }
            if (sourceIndex.isFK()) break block4;
            Iterator it = targetTable.getIndexes().iterator();
            while (it.hasNext()) {
                Index targetIndex = (Index)((ContainerObjectPlaceHolder)it.next()).getObject();
                if (!this.checkIndexes(sourceIndex, targetIndex) || sourceTable.getIndexes().getByName(targetIndex.getName()) != null) continue;
                return targetIndex;
            }
        }
        return null;
    }

    private ViewIndex checkViewForEqualStructure(ViewIndex sourceIndex, TableView targetView, FilteredSelection allsIndsel) {
        TableView sourceView = (TableView)sourceIndex.getContainerObject();
        if (sourceIndex.isPK()) {
            ViewIndex targetIndex = (ViewIndex)targetView.getPK();
            if (targetIndex != null && this.checkViewIndexes(sourceIndex, targetIndex)) {
                return targetIndex;
            }
        } else if (sourceIndex.isUnique()) {
            for (Object obj : targetView.getUKeys()) {
                ViewIndex targetIndex = obj instanceof ContainerObjectPlaceHolder ? (ViewIndex)((ContainerObjectPlaceHolder)obj).getObject() : (ViewIndex)obj;
                if (!this.checkViewIndexes(sourceIndex, targetIndex) || sourceView.getUKeys().getByName(targetIndex.getName()) != null) continue;
                return targetIndex;
            }
        }
        return null;
    }

    private boolean checkIndexes(Index sourceIndex, Index targetIndex) {
        ContainedObject[] targetColumns;
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        if (sourceColumns.length != (targetColumns = targetIndex.getElements()).length) {
            return false;
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            Column scol = (Column)sourceColumns[i];
            Column tcol = (Column)this.objectsMap.get(scol.getObjectID());
            if (tcol == null) {
                return false;
            }
            if (tcol.getName().equals(targetColumns[i].getName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkViewIndexes(ViewIndex sourceIndex, ViewIndex targetIndex) {
        ContainedObject[] targetColumns;
        ContainedObject[] sourceColumns = sourceIndex.getElements();
        if (sourceColumns.length != (targetColumns = targetIndex.getElements()).length) {
            return false;
        }
        for (int i = 0; i < sourceColumns.length; ++i) {
            ContainedObject scol = sourceColumns[i];
            ContainedObject tcol = (ContainedObject)this.objectsMap.get(scol.getObjectID());
            if (tcol == null) {
                return false;
            }
            if (tcol.getName().equals(targetColumns[i].getName())) continue;
            return false;
        }
        return true;
    }

    private void addCheckConstraint(TableLevelConstraint sourceConstraint, Table targetTable, FilteredSelection allsTlcSel, FilteredSelection alltTlcSel) {
        TableConstraintComparator comp;
        FilteredSelection sTlcSel = new FilteredSelection(sourceConstraint);
        sTlcSel.setSelected(true);
        CompareObjectSelection tTlcSel = null;
        TableLevelConstraint targetConstraint = null;
        if (targetTable != null) {
            targetConstraint = (TableLevelConstraint)this.getCorrespondingObject(targetTable.getCheckConstraints(), (DesignObject)sourceConstraint);
            if (targetConstraint == null) {
                targetConstraint = this.checkForEqualRule(sourceConstraint, targetTable);
            }
            if (targetConstraint != null) {
                tTlcSel = new FilteredSelection(targetConstraint);
                comp = new TableConstraintComparator(sourceConstraint, targetConstraint, this.getSourceStorageDesign(), this.getTargetStorageDesign());
                sTlcSel.setPropertiesComparator(comp);
                tTlcSel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                boolean propsModified = comp.isModified();
                sTlcSel.setSelected(propsModified);
                sTlcSel.setEditable(propsModified);
                comp.setLeftSelectionObject(sTlcSel);
                this.objectsMap.put(sourceConstraint.getObjectID(), targetConstraint);
            }
        }
        if (targetConstraint == null) {
            sTlcSel.setSelected(true);
            tTlcSel = new FilteredSelection(NEW_CONSTRAINT);
            tTlcSel.setStatus(2);
            sTlcSel.setStatus(2);
            this.newMappings.add(sTlcSel);
            tTlcSel.setElementDescriptor(TableLevelConstraint.class);
            comp = new TableConstraintComparator(sourceConstraint, targetConstraint, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sTlcSel.setPropertiesComparator(comp);
            tTlcSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        sTlcSel.setCorrespondentNode(tTlcSel);
        tTlcSel.setCorrespondentNode(sTlcSel);
        alltTlcSel.addChild(tTlcSel);
        allsTlcSel.addChild(sTlcSel);
    }

    private TableLevelConstraint checkForEqualRule(TableLevelConstraint sourceConstraint, Table targetTable) {
        for (TableLevelConstraint targetConstraint : targetTable.getCheckConstraints()) {
            if (!sourceConstraint.getRule().equals(targetConstraint.getRule())) continue;
            boolean nameMatch = false;
            for (TableLevelConstraint aSourceConstraint : sourceConstraint.getTable().getCheckConstraints()) {
                if (!aSourceConstraint.getName().equalsIgnoreCase(targetConstraint.getName())) continue;
                nameMatch = true;
            }
            if (nameMatch) continue;
            return targetConstraint;
        }
        return null;
    }

    private void addDeletedCheckConstraints(Table targetTable, FilteredSelection sourceCheckSel, FilteredSelection targetCheckSel) {
        for (TableLevelConstraint targetConstraint : targetTable.getCheckConstraints()) {
            if (this.objectsMap.containsValue(targetConstraint)) continue;
            FilteredSelection sTlcSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sTlcSel);
            sTlcSel.setSelected(false);
            sTlcSel.setElementDescriptor(TableLevelConstraint.class);
            FilteredSelection tTlcSel = new FilteredSelection(targetConstraint);
            tTlcSel.setElementDescriptor(TableLevelConstraint.class);
            TableConstraintComparator comp = new TableConstraintComparator(null, targetConstraint, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tTlcSel.setPropertiesComparator(comp);
            sTlcSel.setPropertiesComparator(comp);
            sTlcSel.setStatus(3);
            tTlcSel.setStatus(3);
            tTlcSel.setCorrespondentNode(sTlcSel);
            sTlcSel.setCorrespondentNode(tTlcSel);
            sourceCheckSel.addChild(sTlcSel);
            targetCheckSel.addChild(tTlcSel);
        }
    }

    private void addTimeDimension(ValidTimeDimension sourceTimeDim, Table targetTable, FilteredSelection allsTimeDimSel, FilteredSelection alltTimeDimSel) {
        ValidTimeDimensionComparator comp;
        FilteredSelection sTimeDimSel = new FilteredSelection(sourceTimeDim);
        sTimeDimSel.setSelected(true);
        CompareObjectSelection tTimeDimSel = null;
        ValidTimeDimension targetTimeDim = null;
        if (targetTable != null && (targetTimeDim = (ValidTimeDimension)this.getCorrespondingObject(targetTable.getValidTimeDimensions(), (DesignObject)sourceTimeDim)) != null) {
            tTimeDimSel = new FilteredSelection(targetTimeDim);
            comp = new ValidTimeDimensionComparator(sourceTimeDim, targetTimeDim);
            sTimeDimSel.setPropertiesComparator(comp);
            tTimeDimSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            boolean propsModified = comp.isModified();
            sTimeDimSel.setSelected(propsModified);
            sTimeDimSel.setEditable(propsModified);
            comp.setLeftSelectionObject(sTimeDimSel);
            this.objectsMap.put(sourceTimeDim.getObjectID(), targetTimeDim);
        }
        if (targetTimeDim == null) {
            sTimeDimSel.setSelected(true);
            tTimeDimSel = new FilteredSelection(NEW_VALID_TIME);
            tTimeDimSel.setStatus(2);
            sTimeDimSel.setStatus(2);
            this.newMappings.add(sTimeDimSel);
            tTimeDimSel.setElementDescriptor(ValidTimeDimension.class);
            comp = new ValidTimeDimensionComparator(sourceTimeDim, targetTimeDim);
            sTimeDimSel.setPropertiesComparator(comp);
            tTimeDimSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        sTimeDimSel.setCorrespondentNode(tTimeDimSel);
        tTimeDimSel.setCorrespondentNode(sTimeDimSel);
        alltTimeDimSel.addChild(tTimeDimSel);
        allsTimeDimSel.addChild(sTimeDimSel);
    }

    private void addDeletedTimeDimensions(Table targetTable, FilteredSelection sourceTimeDimSel, FilteredSelection targetTimeDimSel) {
        for (ValidTimeDimension targetTimeDim : targetTable.getValidTimeDimensions()) {
            if (this.objectsMap.containsValue(targetTimeDim)) continue;
            FilteredSelection sTlcSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sTlcSel);
            sTlcSel.setSelected(false);
            sTlcSel.setElementDescriptor(ValidTimeDimension.class);
            FilteredSelection tTlcSel = new FilteredSelection(targetTimeDim);
            tTlcSel.setElementDescriptor(ValidTimeDimension.class);
            ValidTimeDimensionComparator comp = new ValidTimeDimensionComparator(null, targetTimeDim);
            this.comparatorsMap.put(comp.getID(), comp);
            tTlcSel.setPropertiesComparator(comp);
            sTlcSel.setPropertiesComparator(comp);
            sTlcSel.setStatus(3);
            tTlcSel.setStatus(3);
            tTlcSel.setCorrespondentNode(sTlcSel);
            sTlcSel.setCorrespondentNode(tTlcSel);
            sourceTimeDimSel.addChild(sTlcSel);
            targetTimeDimSel.addChild(tTlcSel);
        }
    }

    private void addChildNodes(List sourceChildObjects, Iterable targetChildObjects, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel, String nodeText, String iconName, String newObjectText, boolean useSyncSchema, boolean getByLongName) {
        this.addChildNodes(sourceChildObjects, targetChildObjects, sourceParentSel, targetParentSel, nodeText, iconName, newObjectText, useSyncSchema, getByLongName, null);
    }

    private void addChildNodes(List sourceChildObjects, Iterable targetChildObjects, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel, String nodeText, String iconName, String newObjectText, boolean useSyncSchema, boolean getByLongName, String syncObjectType) {
        FilteredSelection sourceSel = new FilteredSelection(nodeText);
        FilteredSelection targetSel = new FilteredSelection(nodeText);
        Icon icon = GUIConfiguration.getInstance().getIcon(iconName);
        sourceSel.setIcon(icon);
        targetSel.setIcon(icon);
        sourceSel.setCorrespondentNode(targetSel);
        targetSel.setCorrespondentNode(sourceSel);
        this.setEmptyComparator(sourceSel);
        this.setEmptyComparator(targetSel);
        targetSel.setSelected(false);
        Settings settings = ApplicationView.getInstance().getSettings();
        SyncObject so = null;
        if (syncObjectType != null) {
            so = settings.getSyncObject(syncObjectType, "Oracle");
        }
        if (so != null && !so.isUsed() && this.syncConnFlag) {
            sourceSel.setInSyncOperation(false);
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        } else {
            if (sourceChildObjects != null) {
                for (ModelIDObject sourceChildObject : sourceChildObjects) {
                    this.addObjectEntry(sourceChildObject, targetChildObjects, sourceSel, targetSel, newObjectText, useSyncSchema, getByLongName, false);
                }
            }
            if (targetChildObjects != null) {
                this.addDeletedObjects(targetChildObjects, sourceSel, targetSel, false);
            }
            if (sourceSel.getChilds().size() > 0) {
                sourceParentSel.addChild(sourceSel);
                targetParentSel.addChild(targetSel);
            }
        }
    }

    private void addPartitioningNodes(StorageObject sourceStorageObj, StorageObject targetStorageObj, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel) {
        PropertiesComparator partitioningComp = null;
        String partitioningNodeText = null;
        if (this.getTargetStorageDesign() instanceof StorageDesignOracle) {
            PartitionListOracle sourcePartList = null;
            PartitionListOracle targetPartList = null;
            IndexGlobalPartitionsListOracle sourceGlobalPartList = null;
            IndexGlobalPartitionsListOracle targetGlobalPartList = null;
            if (sourceStorageObj instanceof TableProxyOracle) {
                sourcePartList = ((TableProxyOracle)sourceStorageObj).getPartitionList();
            } else if (sourceStorageObj instanceof SnapshotOracle) {
                sourcePartList = ((SnapshotOracle)sourceStorageObj).getPartitionList();
            } else if (sourceStorageObj instanceof IndexProxyOracle) {
                sourceGlobalPartList = ((IndexProxyOracle)sourceStorageObj).getIndexGlobalPartitionsList();
            }
            if (targetStorageObj instanceof TableProxyOracle) {
                targetPartList = ((TableProxyOracle)targetStorageObj).getPartitionList();
            } else if (targetStorageObj instanceof SnapshotOracle) {
                targetPartList = ((SnapshotOracle)targetStorageObj).getPartitionList();
            } else if (targetStorageObj instanceof IndexProxyOracle) {
                targetGlobalPartList = ((IndexProxyOracle)targetStorageObj).getIndexGlobalPartitionsList();
            }
            if (sourcePartList != null || targetPartList != null) {
                partitioningNodeText = PARTITIONING;
                partitioningComp = new PartitioningComparatorOracle(sourcePartList, targetPartList);
            } else if (sourceGlobalPartList != null || targetGlobalPartList != null) {
                partitioningNodeText = GLOBAL_PARTITIONING;
                partitioningComp = new IndexGlobalPartitioningComparatorOracle(sourceGlobalPartList, targetGlobalPartList);
            }
        }
        if (partitioningComp != null) {
            FilteredSelection sourceSel = this.getPartitioningSelection(partitioningComp.getLeftObject(), partitioningNodeText);
            FilteredSelection targetSel = this.getPartitioningSelection(partitioningComp.getRightObject(), partitioningNodeText);
            sourceSel.setCorrespondentNode(targetSel);
            targetSel.setCorrespondentNode(sourceSel);
            sourceSel.setPropertiesComparator(partitioningComp);
            targetSel.setPropertiesComparator(partitioningComp);
            boolean propsModified = partitioningComp.isModified();
            sourceSel.setSelected(propsModified);
            sourceSel.setEditable(propsModified);
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
            this.addPartitions(sourceStorageObj, targetStorageObj, sourceParentSel, targetParentSel);
            this.addSubpartitionTemplates(sourceStorageObj, targetStorageObj, sourceParentSel, targetParentSel);
        }
    }

    private FilteredSelection getPartitioningSelection(ModelIDObject partitionList, String partitioningNodeText) {
        FilteredSelection selection = null;
        if (partitionList != null) {
            selection = new FilteredSelection(partitionList);
            selection.setName(partitioningNodeText);
        } else {
            selection = new FilteredSelection(partitioningNodeText);
        }
        return selection;
    }

    private void addPartitions(StorageObject sourceStorageObj, StorageObject targetStorageObj, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel) {
        ModelObjectSet sourcePartitions = null;
        ModelObjectSet targetPartitions = null;
        if (this.getTargetStorageDesign() instanceof StorageDesignOracle) {
            if (sourceStorageObj instanceof TableProxyOracle) {
                sourcePartitions = ((TableProxyOracle)sourceStorageObj).getPartitions();
            } else if (sourceStorageObj instanceof SnapshotOracle) {
                sourcePartitions = ((SnapshotOracle)sourceStorageObj).getPartitionsCollection();
            } else if (sourceStorageObj instanceof IndexProxyOracle) {
                sourcePartitions = ((IndexProxyOracle)sourceStorageObj).getGlobalPartitions();
            }
            if (targetStorageObj instanceof TableProxyOracle) {
                targetPartitions = ((TableProxyOracle)targetStorageObj).getPartitions();
            } else if (targetStorageObj instanceof SnapshotOracle) {
                targetPartitions = ((SnapshotOracle)targetStorageObj).getPartitionsCollection();
            } else if (targetStorageObj instanceof IndexProxyOracle) {
                targetPartitions = ((IndexProxyOracle)targetStorageObj).getGlobalPartitions();
            }
        }
        ModelObject firstPartition = null;
        if (sourcePartitions != null && sourcePartitions.size() > 0) {
            firstPartition = sourcePartitions.getElement(0);
        } else if (targetPartitions != null && targetPartitions.size() > 0) {
            firstPartition = targetPartitions.getElement(0);
        }
        if (firstPartition != null) {
            String partitionsNodeName = "";
            if (firstPartition instanceof PartitionOracle) {
                partitionsNodeName = RANGE_PARTITIONS;
            } else if (firstPartition instanceof ListPartitionOracle) {
                partitionsNodeName = LIST_PARTITIONS;
            } else if (firstPartition instanceof HashPartitionOracle) {
                partitionsNodeName = HASH_PARTITIONS;
            } else if (firstPartition instanceof IndexGlobalPartitionOracle) {
                partitionsNodeName = GLOBAL_RANGE_PARTITIONS;
            } else if (firstPartition instanceof IndexHashPartitionOracle) {
                partitionsNodeName = GLOBAL_HASH_PARTITIONS;
            }
            OraclePartitionSelection sourceSel = new OraclePartitionSelection(partitionsNodeName);
            OraclePartitionSelection targetSel = new OraclePartitionSelection(partitionsNodeName);
            Icon icon = GUIConfiguration.getInstance().getIcon("PARTITIONED_TABLE_ICON");
            sourceSel.setIcon(icon);
            targetSel.setIcon(icon);
            sourceSel.setCorrespondentNode(targetSel);
            targetSel.setCorrespondentNode(sourceSel);
            this.setEmptyComparator(sourceSel);
            this.setEmptyComparator(targetSel);
            ((CompareObjectSelection)targetSel).setSelected(false);
            if (sourcePartitions != null) {
                for (StorageObject sourcePartition : sourcePartitions) {
                    FilteredSelection sChildObjSel = this.addObjectEntry(sourcePartition, targetPartitions, sourceSel, targetSel, NEW_PARTITION, false, false, true);
                    CompareObjectSelection tChildObjSel = sChildObjSel.getCorrespondentNode();
                    StorageObject targetPartition = (StorageObject)tChildObjSel.getObject();
                    this.addSubpartitions(sourcePartition, targetPartition, sChildObjSel, tChildObjSel);
                    if (!sChildObjSel.hasChildsWithChangeStatus()) continue;
                    sChildObjSel.setEditable(true);
                    sChildObjSel.setSelectedNoPropagateSelection(true);
                }
            }
            if (targetPartitions != null) {
                this.addDeletedObjects(targetPartitions, sourceSel, targetSel, true);
            }
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        }
    }

    private void addSubpartitions(StorageObject sourcePartition, StorageObject targetPartition, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel) {
        StorageObjectCollection sourceSubpartitions = this.getSubpartitions(sourcePartition);
        StorageObjectCollection targetSubpartitions = this.getSubpartitions(targetPartition);
        ModelObject firstPartition = null;
        if (sourceSubpartitions != null) {
            firstPartition = sourceSubpartitions.getElement(0);
        } else if (targetSubpartitions != null) {
            firstPartition = targetSubpartitions.getElement(0);
        }
        if (firstPartition != null) {
            String subpartitionsNodeName = "";
            if (firstPartition instanceof PartitionOracle) {
                subpartitionsNodeName = RANGE_SUBPARTITIONS;
            } else if (firstPartition instanceof ListStorageTemplatePartitionOracle) {
                subpartitionsNodeName = LIST_SUBPARTITIONS;
            } else if (firstPartition instanceof HashPartitionOracle) {
                subpartitionsNodeName = HASH_SUBPARTITIONS;
            }
            OraclePartitionSelection sourceSel = new OraclePartitionSelection(subpartitionsNodeName);
            OraclePartitionSelection targetSel = new OraclePartitionSelection(subpartitionsNodeName);
            Icon icon = GUIConfiguration.getInstance().getIcon("PARTITIONED_TABLE_ICON");
            sourceSel.setIcon(icon);
            targetSel.setIcon(icon);
            sourceSel.setCorrespondentNode(targetSel);
            targetSel.setCorrespondentNode(sourceSel);
            this.setEmptyComparator(sourceSel);
            this.setEmptyComparator(targetSel);
            ((CompareObjectSelection)targetSel).setSelected(false);
            if (sourceSubpartitions != null) {
                for (StorageObject sourceSubpartition : sourceSubpartitions) {
                    this.addObjectEntry(sourceSubpartition, targetSubpartitions, sourceSel, targetSel, NEW_SUBPARTITION, false, false, true);
                }
            }
            if (targetSubpartitions != null) {
                this.addDeletedObjects(targetSubpartitions, sourceSel, targetSel, true);
            }
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        }
    }

    private StorageObjectCollection getSubpartitions(StorageObject partition) {
        ListPartitionOraclev11g listPartition;
        StorageObjectCollection subpartitions = null;
        if (partition instanceof PartitionOracle) {
            PartitionOracle rangePartition = (PartitionOracle)partition;
            if (rangePartition.hasSubPartitions() && (subpartitions = rangePartition.getPartitions()).size() == 0 && (subpartitions = rangePartition.getListPartitions()).size() == 0 && rangePartition instanceof PartitionOraclev11g) {
                subpartitions = ((PartitionOraclev11g)rangePartition).getRangeSubpartitions();
            }
        } else if (partition instanceof ListPartitionOraclev11g && (listPartition = (ListPartitionOraclev11g)partition).hasSubPartitions() && (subpartitions = listPartition.getHashSubpartitions()).size() == 0 && (subpartitions = listPartition.getListSubpartitions()).size() == 0) {
            subpartitions = listPartition.getRangeSubpartitions();
        }
        return subpartitions;
    }

    private void addSubpartitionTemplates(StorageObject sourceStorageObj, StorageObject targetStorageObj, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel) {
        ModelObjectSet sourceSubpartTemplates = null;
        ModelObjectSet targetSubpartTemplates = null;
        if (this.getTargetStorageDesign() instanceof StorageDesignOracle) {
            if (sourceStorageObj instanceof TableProxyOracle) {
                sourceSubpartTemplates = ((TableProxyOracle)sourceStorageObj).getListStorageTemplates();
            }
            if (targetStorageObj instanceof TableProxyOracle) {
                targetSubpartTemplates = ((TableProxyOracle)targetStorageObj).getListStorageTemplates();
            }
        }
        ModelObject firstPartition = null;
        if (sourceSubpartTemplates != null && sourceSubpartTemplates.size() > 0) {
            firstPartition = sourceSubpartTemplates.getElement(0);
        } else if (targetSubpartTemplates != null && targetSubpartTemplates.size() > 0) {
            firstPartition = targetSubpartTemplates.getElement(0);
        }
        if (firstPartition != null) {
            String nodeText = "";
            if (firstPartition instanceof PartitionOracle) {
                nodeText = RANGE_SUBPARTITION_TEMPLATES;
            } else if (firstPartition instanceof ListStorageTemplatePartitionOracle) {
                nodeText = LIST_SUBPARTITION_TEMPLATES;
            } else if (firstPartition instanceof HashPartitionOracle) {
                nodeText = HASH_SUBPARTITION_TEMPLATES;
            }
            OraclePartitionSelection sourceSel = new OraclePartitionSelection(nodeText);
            OraclePartitionSelection targetSel = new OraclePartitionSelection(nodeText);
            Icon icon = GUIConfiguration.getInstance().getIcon("PARTITIONED_TABLE_ICON");
            sourceSel.setIcon(icon);
            targetSel.setIcon(icon);
            sourceSel.setCorrespondentNode(targetSel);
            targetSel.setCorrespondentNode(sourceSel);
            this.setEmptyComparator(sourceSel);
            this.setEmptyComparator(targetSel);
            ((CompareObjectSelection)targetSel).setSelected(false);
            if (sourceSubpartTemplates != null) {
                for (ModelIDObject sourceSubpartTemplate : sourceSubpartTemplates) {
                    this.addObjectEntry(sourceSubpartTemplate, targetSubpartTemplates, sourceSel, targetSel, NEW_SUBPARTITION, false, false, true);
                }
            }
            if (targetSubpartTemplates != null) {
                this.addDeletedObjects(targetSubpartTemplates, sourceSel, targetSel, true);
            }
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        }
    }

    private void addDimensions(CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel, boolean useSyncSchema) {
        FilteredSelection sourceSel = new FilteredSelection(DIMENSIONS);
        FilteredSelection targetSel = new FilteredSelection(DIMENSIONS);
        Icon icon = GUIConfiguration.getInstance().getIcon("DIMENSION_ICON");
        sourceSel.setIcon(icon);
        targetSel.setIcon(icon);
        sourceSel.setCorrespondentNode(targetSel);
        targetSel.setCorrespondentNode(sourceSel);
        this.setEmptyComparator(sourceSel);
        this.setEmptyComparator(targetSel);
        targetSel.setSelected(false);
        Settings settings = ApplicationView.getInstance().getSettings();
        SyncObject so = settings.getSyncObject("DIMENSION", "Oracle");
        if (so != null && !so.isUsed() && this.syncConnFlag) {
            sourceSel.setInSyncOperation(false);
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        } else {
            DimensionSetOracle targetDimSet = ((StorageDesignOracle)this.getTargetStorageDesign()).getDimensionSet();
            ArrayList sourceDimList = new ArrayList();
            ((StorageDesignOracle)this.getSourceStorageDesign()).getDimensionSet().addAllElementsTo(sourceDimList);
            Collections.sort(sourceDimList, ModelObjectSet.NAME_COMPARATOR);
            for (DimensionOracle sourceDim : sourceDimList) {
                FilteredSelection sDimSel = this.addObjectEntry(sourceDim, targetDimSet, sourceSel, targetSel, NEW_DIMENSION, useSyncSchema, true, false);
                CompareObjectSelection tDimSel = sDimSel.getCorrespondentNode();
                DimensionOracle targetDim = (DimensionOracle)tDimSel.getObject();
                StorageObjectCollection targetLevels = targetDim != null ? targetDim.getLevelCollection() : null;
                ArrayList sourceLevelList = new ArrayList();
                sourceDim.getLevelCollection().addAllElementsTo(sourceLevelList);
                Collections.sort(sourceLevelList, ModelObjectSet.NAME_COMPARATOR);
                String LevelIconName = "LEVEL_ICON";
                this.addChildNodes(sourceLevelList, targetLevels, sDimSel, tDimSel, LEVELS, LevelIconName, NEW_LEVEL, false, false);
                StorageObjectCollection targetHierarchies = targetDim != null ? targetDim.getHierarchyCollection() : null;
                ArrayList sourceHierList = new ArrayList();
                sourceDim.getHierarchyCollection().addAllElementsTo(sourceHierList);
                Collections.sort(sourceHierList, ModelObjectSet.NAME_COMPARATOR);
                String HierIconName = "HIERARCHY_ICON";
                this.addChildNodes(sourceHierList, targetHierarchies, sDimSel, tDimSel, HIERARCHIES, HierIconName, NEW_HIERARCHY, false, false);
                if (!sDimSel.hasChildsWithChangeStatus()) continue;
                sDimSel.setEditable(true);
                sDimSel.setSelectedNoPropagateSelection(true);
            }
            this.addDeletedObjects(targetDimSet, sourceSel, targetSel, false);
            if (sourceSel.getChilds().size() > 0) {
                sourceParentSel.addChild(sourceSel);
                targetParentSel.addChild(targetSel);
            }
        }
    }

    private void addTablespaces(List sourceChildObjects, ModelIDObjectSet targetChildObjects, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel, String nodeText, String iconName, String newObjectText, String syncObjectType) {
        FilteredSelection sourceSel = new FilteredSelection(nodeText);
        FilteredSelection targetSel = new FilteredSelection(nodeText);
        Icon icon = GUIConfiguration.getInstance().getIcon(iconName);
        sourceSel.setIcon(icon);
        targetSel.setIcon(icon);
        sourceSel.setCorrespondentNode(targetSel);
        targetSel.setCorrespondentNode(sourceSel);
        this.setEmptyComparator(sourceSel);
        this.setEmptyComparator(targetSel);
        targetSel.setSelected(false);
        Settings settings = ApplicationView.getInstance().getSettings();
        SyncObject so = settings.getSyncObject(syncObjectType, "Oracle");
        if (so != null && !so.isUsed() && this.syncConnFlag) {
            sourceSel.setInSyncOperation(false);
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        } else {
            if (sourceChildObjects != null) {
                for (ModelIDObject sourceTS : sourceChildObjects) {
                    FilteredSelection sTablespaceSel = this.addObjectEntry(sourceTS, targetChildObjects, sourceSel, targetSel, newObjectText, false, false, false);
                    CompareObjectSelection tTablespaceSel = sTablespaceSel.getCorrespondentNode();
                    ModelIDObject targetTS = tTablespaceSel.getObject();
                    List sourceDFileList = sourceTS instanceof TableSpaceOracle ? ((TableSpaceOracle)sourceTS).getDfiles().getElementsList() : (sourceTS instanceof TemporaryTablespaceOraclev10g ? ((TemporaryTablespaceOraclev10g)sourceTS).getDFiles().getElementsList() : (sourceTS instanceof UndoTablespaceOraclev9i ? ((UndoTablespaceOraclev9i)sourceTS).getDfiles().getElementsList() : Collections.EMPTY_LIST));
                    StorageObjectCollection targetDFiles = null;
                    if (targetTS instanceof TableSpaceOracle) {
                        targetDFiles = ((TableSpaceOracle)targetTS).getDfiles();
                    } else if (targetTS instanceof TemporaryTablespaceOraclev10g) {
                        targetDFiles = ((TemporaryTablespaceOraclev10g)targetTS).getDFiles();
                    } else if (targetTS instanceof UndoTablespaceOraclev9i) {
                        targetDFiles = ((UndoTablespaceOraclev9i)targetTS).getDfiles();
                    }
                    String DataFileIconName = "DATAFILE_ICON";
                    this.addChildNodes(sourceDFileList, targetDFiles, sTablespaceSel, tTablespaceSel, DATA_FILES, DataFileIconName, NEW_DATA_FILE, false, false);
                    if (!sTablespaceSel.hasChildsWithChangeStatus()) continue;
                    sTablespaceSel.setEditable(true);
                    sTablespaceSel.setSelectedNoPropagateSelection(true);
                }
            }
            if (targetChildObjects != null) {
                this.addDeletedObjects(targetChildObjects, sourceSel, targetSel, false);
            }
            if (sourceSel.getChilds().size() > 0) {
                sourceParentSel.addChild(sourceSel);
                targetParentSel.addChild(targetSel);
            }
        }
    }

    private void addUsersOrRoles(List sourceChildObjects, ModelIDObjectSet targetChildObjects, CompareObjectSelection sourceParentSel, CompareObjectSelection targetParentSel, String nodeText, String iconName, String newObjectText, boolean useSyncSchema, String syncObjectType) {
        FilteredSelection sourceSel = new FilteredSelection(nodeText);
        FilteredSelection targetSel = new FilteredSelection(nodeText);
        Icon icon = GUIConfiguration.getInstance().getIcon(iconName);
        sourceSel.setIcon(icon);
        targetSel.setIcon(icon);
        sourceSel.setCorrespondentNode(targetSel);
        targetSel.setCorrespondentNode(sourceSel);
        this.setEmptyComparator(sourceSel);
        this.setEmptyComparator(targetSel);
        targetSel.setSelected(false);
        Settings settings = ApplicationView.getInstance().getSettings();
        SyncObject so = settings.getSyncObject(syncObjectType, "Oracle");
        if (so != null && !so.isUsed() && this.syncConnFlag) {
            sourceSel.setInSyncOperation(false);
            sourceParentSel.addChild(sourceSel);
            targetParentSel.addChild(targetSel);
        } else {
            if (sourceChildObjects != null) {
                for (ModelIDObject sourceUser : sourceChildObjects) {
                    FilteredSelection sUserSel = this.addObjectEntry(sourceUser, targetChildObjects, sourceSel, targetSel, newObjectText, useSyncSchema, false, false);
                    CompareObjectSelection tUserSel = sUserSel.getCorrespondentNode();
                    ModelIDObject targetUser = tUserSel.getObject();
                    List sourcePermissionList = null;
                    List targetPermissionList = null;
                    if (sourceUser instanceof UserOracle) {
                        sourcePermissionList = ((UserOracle)sourceUser).getPermissions();
                    } else if (sourceUser instanceof RoleOracle) {
                        sourcePermissionList = ((RoleOracle)sourceUser).getPermissions();
                    }
                    if (targetUser instanceof UserOracle) {
                        targetPermissionList = ((UserOracle)targetUser).getPermissions();
                    } else if (targetUser instanceof RoleOracle) {
                        targetPermissionList = ((RoleOracle)targetUser).getPermissions();
                    }
                    String PermissionsIconName = "PERMISSIONS_ICON";
                    this.addChildNodes(sourcePermissionList, targetPermissionList, sUserSel, tUserSel, PERMISSIONS, PermissionsIconName, NEW_PERMISSION, false, false);
                    if (sourceUser instanceof UserOracle) {
                        StorageObjectCollection targetQuotas = null;
                        if (targetUser != null) {
                            targetQuotas = ((UserOracle)targetUser).getQuotaItemsCollection();
                        }
                        ArrayList sourceQuotaList = new ArrayList();
                        ((UserOracle)sourceUser).getQuotaItemsCollection().addAllElementsTo(sourceQuotaList);
                        String QuotaIconName = "QUOTA_ITEM_ICON";
                        this.addChildNodes(sourceQuotaList, targetQuotas, sUserSel, tUserSel, QUOTAS, QuotaIconName, NEW_QUOTA, false, false);
                    }
                    if (!sUserSel.hasChildsWithChangeStatus()) continue;
                    sUserSel.setEditable(true);
                    sUserSel.setSelectedNoPropagateSelection(true);
                }
            }
            if (targetChildObjects != null) {
                this.addDeletedObjects(targetChildObjects, sourceSel, targetSel, false);
            }
            if (sourceSel.getChilds().size() > 0) {
                sourceParentSel.addChild(sourceSel);
                targetParentSel.addChild(targetSel);
            }
        }
    }

    private FilteredSelection addObjectEntry(ModelIDObject sourceChildObject, Iterable targetChildObjects, FilteredSelection allsNodeSel, FilteredSelection alltNodeSel, String newObjectText, boolean useSyncSchema, boolean getByLongName, boolean usePartitionSelection) {
        PropertiesComparator comp;
        FilteredSelection sChildObjSel = usePartitionSelection ? new OraclePartitionSelection(sourceChildObject) : new FilteredSelection(sourceChildObject);
        FilteredSelection tChildObjSel = null;
        ModelIDObject targetChildObject = null;
        if (targetChildObjects != null) {
            if (sourceChildObject instanceof PermissionsOracle) {
                targetChildObject = this.getCorrespondingPermission(targetChildObjects.iterator(), (PermissionsOracle)sourceChildObject);
            } else if (sourceChildObject instanceof QuotaItemOracle) {
                targetChildObject = this.getCorrespondingQuotaItem(targetChildObjects.iterator(), (QuotaItemOracle)sourceChildObject);
            } else {
                targetChildObject = CompareModelToModel.getCorrespondingImportedObject(targetChildObjects.iterator(), sourceChildObject, useSyncSchema);
                if (targetChildObject == null) {
                    String sourceChildName = sourceChildObject.getName();
                    for (ModelIDObject targetObj : targetChildObjects) {
                        if (!targetObj.getName().equalsIgnoreCase(sourceChildName) || getByLongName && !targetObj.getLongName().equalsIgnoreCase(sourceChildObject.getLongName())) continue;
                        targetChildObject = targetObj;
                        break;
                    }
                }
            }
        }
        if (targetChildObject != null) {
            this.objectsMap.put(sourceChildObject.getObjectID(), targetChildObject);
        }
        if ((comp = StoragePropertiesComparator.getNewInstance(sourceChildObject, targetChildObject)) != null) {
            this.comparatorsMap.put(comp.getID(), comp);
            sChildObjSel.setPropertiesComparator(comp);
            if (targetChildObject != null) {
                tChildObjSel = usePartitionSelection ? new OraclePartitionSelection(targetChildObject) : new FilteredSelection(targetChildObject);
                boolean propsModified = comp.isModified();
                sChildObjSel.setSelected(propsModified);
                sChildObjSel.setEditable(propsModified);
                comp.setLeftSelectionObject(sChildObjSel);
            } else {
                sChildObjSel.setSelected(true);
                tChildObjSel = usePartitionSelection ? new OraclePartitionSelection(newObjectText) : new FilteredSelection(newObjectText);
                tChildObjSel.setElementDescriptor(sourceChildObject.getClass());
                tChildObjSel.setStatus(2);
                sChildObjSel.setStatus(2);
                this.newMappings.add(sChildObjSel);
            }
            tChildObjSel.setPropertiesComparator(comp);
            sChildObjSel.setCorrespondentNode(tChildObjSel);
            tChildObjSel.setCorrespondentNode(sChildObjSel);
            alltNodeSel.addChild(tChildObjSel);
            allsNodeSel.addChild(sChildObjSel);
        }
        return sChildObjSel;
    }

    private void addDeletedObjects(Iterable targetChildObjects, FilteredSelection allsNodeSel, FilteredSelection alltNodeSel, boolean usePartitionSelection) {
        for (ModelIDObject targetObject : targetChildObjects) {
            FilteredSelection tTlcSel;
            FilteredSelection sTlcSel;
            PropertiesComparator comp;
            if (this.objectsMap.containsValue(targetObject) || (comp = StoragePropertiesComparator.getNewInstance(null, targetObject)) == null) continue;
            this.comparatorsMap.put(comp.getID(), comp);
            Class<?> objectClass = targetObject.getClass();
            if (usePartitionSelection) {
                sTlcSel = new OraclePartitionSelection(TO_DROP);
                sTlcSel.setSelected(true);
                tTlcSel = new OraclePartitionSelection(targetObject);
            } else {
                sTlcSel = new FilteredSelection(TO_DROP);
                sTlcSel.setSelected(false);
                tTlcSel = new FilteredSelection(targetObject);
            }
            this.deletedMappings.add(sTlcSel);
            sTlcSel.setElementDescriptor(objectClass);
            tTlcSel.setElementDescriptor(objectClass);
            tTlcSel.setPropertiesComparator(comp);
            sTlcSel.setPropertiesComparator(comp);
            sTlcSel.setStatus(3);
            tTlcSel.setStatus(3);
            tTlcSel.setCorrespondentNode(sTlcSel);
            sTlcSel.setCorrespondentNode(tTlcSel);
            allsNodeSel.addChild(sTlcSel);
            alltNodeSel.addChild(tTlcSel);
        }
    }

    public CompareObjectSelection getRelationalRoot() {
        return this;
    }

    public CompareObjectSelection getRightRelationalRoot() {
        return this.rightRelationalRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    private void addDeletedColumns(Table sourceTable, FilteredSelection sourceColumnSel, Table targetTable, FilteredSelection targetColumnSel) {
        for (Column targetColumn : targetTable.getElementsCollection()) {
            if (this.objectsMap.containsValue(targetColumn)) continue;
            FilteredSelection sColsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sColsel);
            sColsel.setSelected(false);
            sColsel.setElementDescriptor(Column.class);
            FilteredSelection tColSel = new FilteredSelection(targetColumn);
            tColSel.setElementDescriptor(Column.class);
            ColumnComparator comp = new ColumnComparator(null, targetColumn, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tColSel.setPropertiesComparator(comp);
            sColsel.setPropertiesComparator(comp);
            sColsel.setStatus(3);
            tColSel.setStatus(3);
            tColSel.setCorrespondentNode(sColsel);
            sColsel.setCorrespondentNode(tColSel);
            sourceColumnSel.addChild(sColsel);
            targetColumnSel.addChild(tColSel);
        }
    }

    private void addDeletedIndexes(Table targetTable, FilteredSelection allsIndsel, FilteredSelection alltIndsel, boolean isPKorUK) {
        Iterator it = targetTable.getKeySet().iterator();
        while (it.hasNext()) {
            Index ind;
            boolean isdeleted;
            Index targetIndex = (Index)it.next();
            boolean bl = isdeleted = isPKorUK == (targetIndex.isPK() || targetIndex.isUnique());
            if (targetIndex.isFK() || !isdeleted || this.objectsMap.containsValue(targetIndex) || this.syncMode && !isPKorUK && (ind = targetTable.getPKorUKWithName(targetIndex.getName())) != null) continue;
            ModelIDObject tiproxy = null;
            if (targetIndex != null) {
                tiproxy = this.getTargetStorageDesign().getStorageObject(targetIndex.getObjectID());
            }
            if (tiproxy == null) {
                tiproxy = targetIndex;
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tiproxy)) continue;
            FilteredSelection sIndsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sIndsel);
            sIndsel.setSelected(false);
            FilteredSelection tIndsel = new FilteredSelection(targetIndex);
            sIndsel.setElementDescriptor(Index.class);
            IndexComparator comp = new IndexComparator(null, targetIndex, this.objectsMap, isPKorUK, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tIndsel.setPropertiesComparator(comp);
            sIndsel.setPropertiesComparator(comp);
            sIndsel.setStatus(3);
            tIndsel.setStatus(3);
            tIndsel.setCorrespondentNode(sIndsel);
            sIndsel.setCorrespondentNode(tIndsel);
            allsIndsel.addChild(sIndsel);
            alltIndsel.addChild(tIndsel);
        }
    }

    private void addDeletedViewIndexes(TableView targetView, FilteredSelection allsIndsel, FilteredSelection alltIndsel) {
        Iterator it = targetView.getKeySet().iterator();
        while (it.hasNext()) {
            boolean isdeleted;
            ViewIndex targetIndex = (ViewIndex)it.next();
            boolean bl = isdeleted = true == (targetIndex.isPK() || targetIndex.isUnique());
            if (targetIndex.isFK() || !isdeleted || this.objectsMap.containsValue(targetIndex) || this.useGenerateInDDL && !this.isGenerateInDDL(null, targetIndex)) continue;
            FilteredSelection sIndsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sIndsel);
            sIndsel.setSelected(false);
            FilteredSelection tIndsel = new FilteredSelection(targetIndex);
            sIndsel.setElementDescriptor(Index.class);
            ViewIndexComparator comp = new ViewIndexComparator(null, targetIndex, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            tIndsel.setPropertiesComparator(comp);
            sIndsel.setPropertiesComparator(comp);
            sIndsel.setStatus(3);
            tIndsel.setStatus(3);
            tIndsel.setCorrespondentNode(sIndsel);
            sIndsel.setCorrespondentNode(tIndsel);
            allsIndsel.addChild(sIndsel);
            alltIndsel.addChild(tIndsel);
        }
    }

    private void addDeletedTables(ModelIdObjectSelection allsTabsel, ModelIdObjectSelection alltTabsel) {
        Iterator it = this.targetdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table targetTable = (Table)it.next();
            if (this.selectedIDs != null && !this.selectedIDs.containsKey(targetTable.getObjectID()) || this.objectsMap.containsValue(targetTable) || this.excludeModelObject(targetTable)) continue;
            TableProxy tTableProxy = null;
            if (targetTable != null) {
                tTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            }
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tTableProxy)) continue;
            FilteredSelection targetTabsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(targetTabsel);
            targetTabsel.setSelected(false);
            FilteredSelection sourceTabsel = new FilteredSelection(targetTable);
            targetTabsel.setElementDescriptor(Table.class);
            tTableProxy = (TableProxy)this.getTargetStorageDesign().getTableProxySet().getProxy(targetTable.getObjectID());
            TableComparator comp = new TableComparator(null, targetTable, null, tTableProxy);
            this.comparatorsMap.put(comp.getID(), comp);
            targetTabsel.setPropertiesComparator(comp);
            sourceTabsel.setPropertiesComparator(comp);
            targetTabsel.setStatus(3);
            sourceTabsel.setStatus(3);
            sourceTabsel.setCorrespondentNode(targetTabsel);
            targetTabsel.setCorrespondentNode(sourceTabsel);
            allsTabsel.addChild(targetTabsel);
            alltTabsel.addChild(sourceTabsel);
        }
    }

    private void addDeletedTableViews(ModelIdObjectSelection allsTabViewSel, ModelIdObjectSelection alltTabViewSel) {
        Iterator it = this.targetdes.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView targetTableView = (TableView)it.next();
            if (this.selectedIDs != null && !this.selectedIDs.containsKey(targetTableView.getObjectID()) || this.objectsMap.containsValue(targetTableView)) continue;
            TableViewProxy tViewProxy = (TableViewProxy)this.getTargetStorageDesign().getProxy(targetTableView.getObjectID());
            if (this.useGenerateInDDL && !this.isGenerateInDDL(null, tViewProxy)) continue;
            FilteredSelection tTabViewSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(tTabViewSel);
            tTabViewSel.setSelected(false);
            FilteredSelection sTabViewSel = new FilteredSelection(targetTableView);
            tTabViewSel.setElementDescriptor(TableView.class);
            TableViewComparator comp = new TableViewComparator(null, targetTableView, null, tViewProxy, true);
            this.comparatorsMap.put(comp.getID(), comp);
            tTabViewSel.setPropertiesComparator(comp);
            sTabViewSel.setPropertiesComparator(comp);
            tTabViewSel.setStatus(3);
            sTabViewSel.setStatus(3);
            sTabViewSel.setCorrespondentNode(tTabViewSel);
            tTabViewSel.setCorrespondentNode(sTabViewSel);
            allsTabViewSel.addChild(tTabViewSel);
            alltTabViewSel.addChild(sTabViewSel);
        }
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    public List getNewMappings() {
        return this.newMappings;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    @Override
    protected DDLGenerator createDDLGenerator() {
        StorageDesign targetStorageDesign = this.targetdes.getStorageDesign();
        if (targetStorageDesign instanceof StorageDesignOraclev11g) {
            return this.createDDLGeneratorOraclev11g();
        }
        if (targetStorageDesign instanceof StorageDesignOraclev10g) {
            return this.createDDLGeneratorOraclev10g();
        }
        return super.createDDLGenerator();
    }

    private DDLGenerator createDDLGeneratorOraclev11g() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new CSSBCreateTableOraclev11g());
        ddlGenerator.append(new CSSBRenameTableOraclev11g(this.fkMap));
        ddlGenerator.append(new CSSBAlterTableOraclev10g());
        ddlGenerator.append(new CSSBAlterIndexOraclev11g(this.fkMap));
        ddlGenerator.append(new CSSBAlterColumnOraclev11g());
        ddlGenerator.append(new CSSBAddValidTimeOraclev11g());
        ddlGenerator.append(new CSSBAlterTableConstraint());
        ddlGenerator.append(new CSSBFKIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBSnapshotOraclev11g());
        ddlGenerator.append(new CSSBSequenceOracle10vg());
        ddlGenerator.append(new CSSBTableViewOraclev10g());
        ddlGenerator.append(new CSSBViewIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBTriggerOracle());
        ddlGenerator.append(new CSSBPlSqlObjectOracle());
        ddlGenerator.append(new CSSBStructuredType());
        ddlGenerator.append(new CSSBCollectionType());
        ddlGenerator.append(new CSSBSynonymOracle());
        ddlGenerator.append(new CSSBDimensionOracle());
        ddlGenerator.append(new CSSBDirectoryOracle());
        ddlGenerator.append(new CSSBContextOracle());
        ddlGenerator.append(new CSSBArcConstraintOracle());
        return ddlGenerator;
    }

    private DDLGenerator createDDLGeneratorOraclev10g() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new CSSBCreateTableOraclev10g());
        ddlGenerator.append(new CSSBRenameTableOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBAlterTableOraclev10g());
        ddlGenerator.append(new CSSBAlterIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBAlterColumnOraclev10g());
        ddlGenerator.append(new CSSBAlterTableConstraint());
        ddlGenerator.append(new CSSBFKIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBSnapshotOraclev10g());
        ddlGenerator.append(new CSSBSequenceOracle10vg());
        ddlGenerator.append(new CSSBTableViewOraclev10g());
        ddlGenerator.append(new CSSBViewIndexOraclev10g(this.fkMap));
        ddlGenerator.append(new CSSBTriggerOracle());
        ddlGenerator.append(new CSSBPlSqlObjectOracle());
        ddlGenerator.append(new CSSBStructuredType());
        ddlGenerator.append(new CSSBCollectionType());
        ddlGenerator.append(new CSSBSynonymOracle());
        ddlGenerator.append(new CSSBDimensionOracle());
        ddlGenerator.append(new CSSBDirectoryOracle());
        ddlGenerator.append(new CSSBContextOracle());
        ddlGenerator.append(new CSSBArcConstraintOracle());
        return ddlGenerator;
    }

    public StorageDesign getSourceStorageDesign() {
        return this.sourcedes.getStorageDesign();
    }

    public StorageDesign getTargetStorageDesign() {
        return this.targetdes.getStorageDesign();
    }

    public List getColumnsWithChangedDataType() {
        return this.columnsWithChangedDataType;
    }

    public List getTablesToRecreate() {
        return this.tablesToRecreate;
    }

    private void addDataTypes() {
        FilteredSelection sDTModel = new FilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        FilteredSelection tDTModel = new FilteredSelection(Messages.getString("CompareCWDDesigns.DataTypesModel"));
        sDTModel.setCorrespondentNode(tDTModel);
        tDTModel.setCorrespondentNode(sDTModel);
        this.setEmptyComparator(sDTModel);
        this.setEmptyComparator(tDTModel);
        this.addChild(sDTModel);
        this.rightRelationalRoot.addChild(tDTModel);
        FilteredSelection sDistType = new FilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        FilteredSelection tDistType = new FilteredSelection(Messages.getString("CompareCWDDesigns.DistinctTypes"));
        sDistType.setCorrespondentNode(tDistType);
        tDistType.setCorrespondentNode(sDistType);
        this.setEmptyComparator(sDistType);
        this.setEmptyComparator(tDistType);
        sDTModel.addChild(sDistType);
        tDTModel.addChild(tDistType);
        tDistType.setSelected(false);
        FilteredSelection sStrType = new FilteredSelection(Messages.getString("DataTypesDesign.StructuredTypes"));
        FilteredSelection tStrType = new FilteredSelection(Messages.getString("DataTypesDesign.StructuredTypes"));
        sStrType.setCorrespondentNode(tStrType);
        tStrType.setCorrespondentNode(sStrType);
        this.setEmptyComparator(sStrType);
        this.setEmptyComparator(tStrType);
        sDTModel.addChild(sStrType);
        tDTModel.addChild(tStrType);
        tStrType.setSelected(false);
        FilteredSelection sCollType = new FilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        FilteredSelection tCollType = new FilteredSelection(Messages.getString("CompareCWDDesigns.CollectionTypes"));
        sCollType.setCorrespondentNode(tCollType);
        tCollType.setCorrespondentNode(sCollType);
        this.setEmptyComparator(sCollType);
        this.setEmptyComparator(tCollType);
        sDTModel.addChild(sCollType);
        tDTModel.addChild(tCollType);
        tCollType.setSelected(false);
        Iterator it = this.getSourceDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType distType = (DistinctType)it.next();
            this.addDistinctType(distType, sDistType, tDistType);
        }
        this.addDeletedDistinctTypes(sDistType, tDistType);
        it = this.getSourceDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType strType = (StructuredType)it.next();
            this.addStructuredType(strType, sStrType, tStrType);
        }
        if (this.selectedIDs == null || this.selectedIDs.size() == 0) {
            this.addDeletedStructuredTypes(sStrType, tStrType);
        }
        it = this.getSourceDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType collType = (CollectionType)it.next();
            this.addCollectionType(collType, sCollType, tCollType);
        }
        if (this.selectedIDs == null || this.selectedIDs.size() == 0) {
            this.addDeletedCollectionTypes(sCollType, tCollType);
        }
    }

    private void addDistinctType(DistinctType sourceType, FilteredSelection allSDistTypes, FilteredSelection allTDistTypes) {
        FilteredSelection sDistType = new FilteredSelection(sourceType);
        FilteredSelection tDistType = null;
        DistinctType targetType = (DistinctType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getDistinctTypeSet(), sourceType);
        if (targetType != null) {
            tDistType = new FilteredSelection(targetType);
            DistinctTypeComparator comp = new DistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sDistType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tDistType = new FilteredSelection(NEW_DISTINCT_TYPE);
            sDistType.setStatus(2);
            tDistType.setStatus(2);
            tDistType.setElementDescriptor(DistinctType.class);
            DistinctTypeComparator comp = new DistinctTypeComparator(sourceType, targetType);
            sDistType.setPropertiesComparator(comp);
            tDistType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sDistType.setSelected(true);
            this.newMappings.add(sDistType);
        }
        tDistType.setCorrespondentNode(sDistType);
        sDistType.setCorrespondentNode(tDistType);
        allSDistTypes.addChild(sDistType);
        allTDistTypes.addChild(tDistType);
    }

    private void addDeletedDistinctTypes(FilteredSelection allSDistTypes, FilteredSelection allTDistTypes) {
        Iterator it = this.getTargetDataTypesDesign().getDistinctTypeSet().iterator();
        while (it.hasNext()) {
            DistinctType targetType = (DistinctType)it.next();
            if (this.objectsMap.containsValue(targetType)) continue;
            FilteredSelection selTargetType = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(selTargetType);
            selTargetType.setSelected(false);
            FilteredSelection selSourceType = new FilteredSelection(targetType);
            selTargetType.setElementDescriptor(DistinctType.class);
            DistinctTypeComparator comp = new DistinctTypeComparator(null, targetType);
            this.comparatorsMap.put(comp.getID(), comp);
            selTargetType.setPropertiesComparator(comp);
            selSourceType.setPropertiesComparator(comp);
            selTargetType.setStatus(3);
            selSourceType.setStatus(3);
            selSourceType.setCorrespondentNode(selTargetType);
            selTargetType.setCorrespondentNode(selSourceType);
            allSDistTypes.addChild(selTargetType);
            allTDistTypes.addChild(selSourceType);
        }
    }

    private void addStructuredType(StructuredType sourceType, FilteredSelection allSourceStrTypes, FilteredSelection allTargetStrTypes) {
        FilteredSelection sStrType = new FilteredSelection(sourceType);
        FilteredSelection tStrType = null;
        if (this.getSourceStorageDesign() == null) {
            return;
        }
        if (this.getSourceStorageDesign().getStructuredTypeProxySet() == null) {
            return;
        }
        StructuredTypeProxy sstp = (StructuredTypeProxy)this.getSourceStorageDesign().getStructuredTypeProxySet().getProxy(sourceType.getObjectID());
        StructuredType targetType = (StructuredType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getStructuredTypeSet(), sourceType);
        StructuredTypeProxy tstp = null;
        if (targetType != null) {
            tstp = (StructuredTypeProxy)this.getTargetStorageDesign().getStructuredTypeProxySet().getProxy(targetType.getObjectID());
        }
        if (this.useGenerateInDDL && (sstp != null && !sstp.isMarkedGenerate() || tstp != null && !tstp.isMarkedGenerate())) {
            if (sourceType != null && targetType != null) {
                this.objectsMap.put(sourceType.getObjectID(), targetType);
            }
            return;
        }
        if (targetType != null) {
            tStrType = new FilteredSelection(targetType);
            StructuredTypeComparator comp = new StructuredTypeComparator(sourceType, targetType, sstp, tstp);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sStrType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tStrType = new FilteredSelection(NEW_STRUCTURED_TYPE);
            sStrType.setStatus(2);
            tStrType.setStatus(2);
            tStrType.setElementDescriptor(StructuredType.class);
            StructuredTypeComparator comp = new StructuredTypeComparator(sourceType, targetType, sstp, tstp);
            sStrType.setPropertiesComparator(comp);
            tStrType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sStrType.setSelected(true);
            this.newMappings.add(sStrType);
        }
        tStrType.setCorrespondentNode(sStrType);
        sStrType.setCorrespondentNode(tStrType);
        this.addStructuredTypeDetails(sourceType, sStrType, targetType, tStrType);
        if (sStrType.hasChildsWithChangeStatus()) {
            sStrType.setEditable(true);
            sStrType.setSelectedNoPropagateSelection(true);
        }
        allSourceStrTypes.addChild(sStrType);
        allTargetStrTypes.addChild(tStrType);
    }

    private void addDeletedStructuredTypes(FilteredSelection allsStrTypes, FilteredSelection alltStrTypes) {
        Iterator it = this.getTargetDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType targetType = (StructuredType)it.next();
            if (targetType.getName().equalsIgnoreCase("SDO_GEOMETRY") || targetType.getName().equalsIgnoreCase("XMLTYPE")) continue;
            StructuredTypeProxy tstp = null;
            StructuredTypeProxySet stProxySet = this.getTargetStorageDesign().getStructuredTypeProxySet();
            if (stProxySet != null) {
                tstp = (StructuredTypeProxy)stProxySet.getProxy(targetType.getObjectID());
            }
            if (this.useGenerateInDDL && tstp != null && !tstp.isMarkedGenerate() || this.objectsMap.containsValue(targetType)) continue;
            FilteredSelection tStrType = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(tStrType);
            tStrType.setSelected(false);
            FilteredSelection sStrType = new FilteredSelection(targetType);
            tStrType.setElementDescriptor(StructuredType.class);
            StructuredTypeComparator comp = new StructuredTypeComparator(null, targetType, null, tstp);
            this.comparatorsMap.put(comp.getID(), comp);
            tStrType.setPropertiesComparator(comp);
            sStrType.setPropertiesComparator(comp);
            tStrType.setStatus(3);
            sStrType.setStatus(3);
            sStrType.setCorrespondentNode(tStrType);
            tStrType.setCorrespondentNode(sStrType);
            allsStrTypes.addChild(tStrType);
            alltStrTypes.addChild(sStrType);
        }
    }

    private void addStructuredTypeDetails(StructuredType sourceType, FilteredSelection sTypeDesign, StructuredType targetType, FilteredSelection tTypeDesign) {
        FilteredSelection sTypeElems = new FilteredSelection(Messages.getString("CompareCWDDesigns.Attributes"));
        FilteredSelection tTypeElems = new FilteredSelection(Messages.getString("CompareCWDDesigns.Attributes"));
        sTypeElems.setCorrespondentNode(tTypeElems);
        tTypeElems.setCorrespondentNode(sTypeElems);
        this.setEmptyComparator(sTypeElems);
        this.setEmptyComparator(tTypeElems);
        tTypeElems.setSelected(false);
        TypeElement[] elems = sourceType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement sourceAttribute = elems[i];
            this.addTypeElement(sourceAttribute, targetType, sTypeElems, tTypeElems);
        }
        if (targetType != null) {
            this.addDeletedTypeElements(sTypeElems, targetType, tTypeElems);
        }
        sTypeDesign.addChild(sTypeElems);
        tTypeDesign.addChild(tTypeElems);
        ((StructuredTypeComparator)sTypeDesign.getPropertiesComparator()).presetTypeElemsOrder();
        FilteredSelection sourceMethods = new FilteredSelection(Messages.getString("CompareCWDDesigns.Methods"));
        FilteredSelection targetMethods = new FilteredSelection(Messages.getString("CompareCWDDesigns.Methods"));
        sourceMethods.setCorrespondentNode(targetMethods);
        targetMethods.setCorrespondentNode(sourceMethods);
        this.setEmptyComparator(sourceMethods);
        this.setEmptyComparator(targetMethods);
        targetMethods.setSelected(false);
        Method[] methods = sourceType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            this.addMethod(method, targetType, sourceMethods, targetMethods);
        }
        if (targetType != null) {
            this.addDeletedMethods(sourceMethods, targetType, targetMethods);
        }
        sTypeDesign.addChild(sourceMethods);
        tTypeDesign.addChild(targetMethods);
    }

    private void addTypeElement(TypeElement sourceElem, StructuredType targetType, FilteredSelection sTypeElement, FilteredSelection tTypeElement) {
        TypeElementComparator comp;
        FilteredSelection sElemType = new FilteredSelection(sourceElem);
        ModelIdObjectSelection tElemType = null;
        TypeElement targetElem = null;
        if (targetType != null && (targetElem = (TypeElement)this.getCorrespondingObject(targetType.getElements(), (DesignObject)sourceElem)) != null) {
            tElemType = new FilteredSelection(targetElem);
            comp = new TypeElementComparator(sourceElem, targetElem);
            sElemType.setPropertiesComparator(comp);
            ((CompareObjectSelection)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            boolean propsModified = comp.isModified();
            sElemType.setSelected(propsModified);
            sElemType.setEditable(propsModified);
            this.objectsMap.put(sourceElem.getObjectID(), targetElem);
        }
        if (targetElem == null) {
            sElemType.setSelected(true);
            tElemType = new FilteredSelection(NEW_ATTRIBUTE);
            ((CompareObjectSelection)tElemType).setStatus(2);
            sElemType.setStatus(2);
            this.newMappings.add(sElemType);
            comp = new TypeElementComparator(sourceElem, null);
            sElemType.setPropertiesComparator(comp);
            ((CompareObjectSelection)tElemType).setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        tElemType.setElementDescriptor(TypeElement.class);
        sElemType.setCorrespondentNode((CompareObjectSelection)tElemType);
        ((CompareObjectSelection)tElemType).setCorrespondentNode(sElemType);
        sTypeElement.addChild(sElemType);
        tTypeElement.addChild(tElemType);
    }

    private void addDeletedTypeElements(FilteredSelection sElemSelected, StructuredType targetType, FilteredSelection tElemSelected) {
        TypeElement[] elems = targetType.getElements();
        for (int i = 0; i < elems.length; ++i) {
            TypeElement targetElem = elems[i];
            if (this.objectsMap.containsValue(targetElem)) continue;
            FilteredSelection sElemSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sElemSel);
            sElemSel.setSelected(false);
            sElemSel.setElementDescriptor(TypeElement.class);
            FilteredSelection tElemSel = new FilteredSelection(targetElem);
            tElemSel.setElementDescriptor(TypeElement.class);
            TypeElementComparator comp = new TypeElementComparator(null, targetElem);
            this.comparatorsMap.put(comp.getID(), comp);
            tElemSel.setPropertiesComparator(comp);
            sElemSel.setPropertiesComparator(comp);
            sElemSel.setStatus(3);
            tElemSel.setStatus(3);
            tElemSel.setCorrespondentNode(sElemSel);
            sElemSel.setCorrespondentNode(tElemSel);
            sElemSelected.addChild(sElemSel);
            tElemSelected.addChild(tElemSel);
        }
    }

    private void addMethod(Method sourceMethod, StructuredType targetType, FilteredSelection sMethodType, FilteredSelection tMethodType) {
        MethodComparator comp;
        FilteredSelection sMethodTab = new FilteredSelection(sourceMethod);
        CompareObjectSelection tMethodTab = null;
        Method targetMethod = null;
        if (targetType != null && (targetMethod = (Method)this.getCorrespondingObject(targetType.getMethodsList(), (DesignObject)sourceMethod)) != null) {
            tMethodTab = new FilteredSelection(targetMethod);
            comp = new MethodComparator(sourceMethod, targetMethod, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            boolean propsModified = comp.isModified();
            sMethodTab.setSelected(propsModified);
            sMethodTab.setEditable(propsModified);
            comp.setLeftSelectionObject(sMethodTab);
            this.objectsMap.put(sourceMethod.getObjectID(), targetMethod);
        }
        if (targetMethod == null) {
            sMethodTab.setSelected(true);
            tMethodTab = new FilteredSelection(NEW_METHOD);
            tMethodTab.setStatus(2);
            sMethodTab.setStatus(2);
            this.newMappings.add(sMethodTab);
            tMethodTab.setElementDescriptor(Method.class);
            comp = new MethodComparator(sourceMethod, targetMethod, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sMethodTab.setPropertiesComparator(comp);
            tMethodTab.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        sMethodTab.setCorrespondentNode(tMethodTab);
        tMethodTab.setCorrespondentNode(sMethodTab);
        sMethodType.addChild(sMethodTab);
        tMethodType.addChild(tMethodTab);
        FilteredSelection sourceParams = new FilteredSelection(PARAMETERS);
        FilteredSelection targetParams = new FilteredSelection(PARAMETERS);
        sourceParams.setCorrespondentNode(targetParams);
        targetParams.setCorrespondentNode(sourceParams);
        this.setEmptyComparator(sourceParams);
        this.setEmptyComparator(targetParams);
        targetParams.setSelected(false);
        List paramList = sourceMethod.getParameters();
        for (MethodParam sourceParam : paramList) {
            this.addMethodParam(sourceParam, targetMethod, sourceParams, targetParams);
        }
        if (targetMethod != null) {
            this.addDeletedMethodParams(sourceParams, targetMethod, targetParams);
        }
        sMethodTab.addChild(sourceParams);
        tMethodTab.addChild(targetParams);
        if (sMethodTab.hasChildsWithChangeStatus()) {
            sMethodTab.setEditable(true);
            sMethodTab.setSelectedNoPropagateSelection(true);
        }
    }

    private void addDeletedMethods(FilteredSelection sMethodSelected, StructuredType targetType, FilteredSelection tMethodSelected) {
        Method[] methods = targetType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method targetMethod = methods[i];
            if (this.objectsMap.containsValue(targetMethod)) continue;
            FilteredSelection sMethodSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sMethodSel);
            sMethodSel.setSelected(false);
            sMethodSel.setElementDescriptor(Method.class);
            FilteredSelection tMethodSel = new FilteredSelection(targetMethod);
            tMethodSel.setElementDescriptor(Method.class);
            MethodComparator comp = new MethodComparator(null, targetMethod, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tMethodSel.setPropertiesComparator(comp);
            sMethodSel.setPropertiesComparator(comp);
            sMethodSel.setStatus(3);
            tMethodSel.setStatus(3);
            tMethodSel.setCorrespondentNode(sMethodSel);
            sMethodSel.setCorrespondentNode(tMethodSel);
            sMethodSelected.addChild(sMethodSel);
            tMethodSelected.addChild(tMethodSel);
        }
    }

    private void addMethodParam(MethodParam sourceParam, Method targetMethod, FilteredSelection sMethodParams, FilteredSelection tMethodParams) {
        MethodParamComparator comp;
        FilteredSelection sMethodParamSel = new FilteredSelection(sourceParam);
        CompareObjectSelection tMethodParamSel = null;
        MethodParam targetParam = null;
        if (targetMethod != null && (targetParam = (MethodParam)this.getCorrespondingObject(targetMethod.getParameters(), (DesignObject)sourceParam)) != null) {
            tMethodParamSel = new FilteredSelection(targetParam);
            comp = new MethodParamComparator(sourceParam, targetParam, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sMethodParamSel.setPropertiesComparator(comp);
            tMethodParamSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            boolean propsModified = comp.isModified();
            sMethodParamSel.setSelected(propsModified);
            sMethodParamSel.setEditable(propsModified);
            comp.setLeftSelectionObject(sMethodParamSel);
            this.objectsMap.put(sourceParam.getObjectID(), targetParam);
        }
        if (targetParam == null) {
            sMethodParamSel.setSelected(true);
            tMethodParamSel = new FilteredSelection(NEW_PARAMETER);
            tMethodParamSel.setStatus(2);
            sMethodParamSel.setStatus(2);
            this.newMappings.add(sMethodParamSel);
            tMethodParamSel.setElementDescriptor(MethodParam.class);
            comp = new MethodParamComparator(sourceParam, targetParam, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            sMethodParamSel.setPropertiesComparator(comp);
            tMethodParamSel.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
        }
        sMethodParamSel.setCorrespondentNode(tMethodParamSel);
        tMethodParamSel.setCorrespondentNode(sMethodParamSel);
        sMethodParams.addChild(sMethodParamSel);
        tMethodParams.addChild(tMethodParamSel);
    }

    private void addDeletedMethodParams(FilteredSelection sParamsSel, Method targetMethod, FilteredSelection tParamsSel) {
        List paramList = targetMethod.getParameters();
        for (MethodParam targetParam : paramList) {
            if (this.objectsMap.containsValue(targetParam)) continue;
            FilteredSelection sParamSel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sParamSel);
            sParamSel.setSelected(false);
            sParamSel.setElementDescriptor(MethodParam.class);
            FilteredSelection tParamSel = new FilteredSelection(targetParam);
            tParamSel.setElementDescriptor(MethodParam.class);
            MethodParamComparator comp = new MethodParamComparator(null, targetParam, this.getSourceStorageDesign(), this.getTargetStorageDesign());
            this.comparatorsMap.put(comp.getID(), comp);
            tParamSel.setPropertiesComparator(comp);
            sParamSel.setPropertiesComparator(comp);
            sParamSel.setStatus(3);
            tParamSel.setStatus(3);
            tParamSel.setCorrespondentNode(sParamSel);
            sParamSel.setCorrespondentNode(tParamSel);
            sParamsSel.addChild(sParamSel);
            tParamsSel.addChild(tParamSel);
        }
    }

    private void addCollectionType(CollectionType sourceType, FilteredSelection selSourceCollType, FilteredSelection selTargetCollType) {
        FilteredSelection sCollType = new FilteredSelection(sourceType);
        FilteredSelection tCollType = null;
        CollectionTypeProxy sourceCTP = null;
        StorageDesign sourceStorageDesign = this.getSourceStorageDesign();
        if (sourceStorageDesign != null && sourceStorageDesign.getCollectionTypeProxySet() != null) {
            sourceCTP = (CollectionTypeProxy)sourceStorageDesign.getCollectionTypeProxySet().getProxy(sourceType.getObjectID());
        }
        CollectionType targetType = (CollectionType)CompareModelToModel.getCorrespondingObject(this.getTargetDataTypesDesign().getCollectionTypeSet(), sourceType);
        CollectionTypeProxy targetCTP = null;
        if (targetType != null) {
            targetCTP = (CollectionTypeProxy)this.getTargetStorageDesign().getCollectionTypeProxySet().getProxy(targetType.getObjectID());
        }
        if (this.useGenerateInDDL && (sourceCTP != null && !sourceCTP.isMarkedGenerate() || targetCTP != null && !targetCTP.isMarkedGenerate())) {
            if (sourceType != null && targetType != null) {
                this.objectsMap.put(sourceType.getObjectID(), targetType);
            }
            return;
        }
        if (targetType != null) {
            tCollType = new FilteredSelection(targetType);
            CollectionTypeComparator comp = new CollectionTypeComparator(sourceType, targetType, sourceCTP, targetCTP);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(comp.isModified());
            comp.setLeftSelectionObject(sCollType);
            this.objectsMap.put(sourceType.getObjectID(), targetType);
        } else {
            tCollType = new FilteredSelection(NEW_COLLECTION_TYPE);
            sCollType.setStatus(2);
            tCollType.setStatus(2);
            tCollType.setElementDescriptor(CollectionType.class);
            CollectionTypeComparator comp = new CollectionTypeComparator(sourceType, targetType, sourceCTP, targetCTP);
            sCollType.setPropertiesComparator(comp);
            tCollType.setPropertiesComparator(comp);
            this.comparatorsMap.put(comp.getID(), comp);
            sCollType.setSelected(true);
            this.newMappings.add(sCollType);
        }
        tCollType.setCorrespondentNode(sCollType);
        sCollType.setCorrespondentNode(tCollType);
        selSourceCollType.addChild(sCollType);
        selTargetCollType.addChild(tCollType);
    }

    private void addDeletedCollectionTypes(FilteredSelection sCollTypes, FilteredSelection tCollTypes) {
        Iterator it = this.getTargetDataTypesDesign().getCollectionTypeSet().iterator();
        while (it.hasNext()) {
            CollectionType targetType = (CollectionType)it.next();
            CollectionTypeProxy targetCTP = null;
            CollectionTypeProxySet ctProxySet = this.getTargetStorageDesign().getCollectionTypeProxySet();
            if (ctProxySet != null) {
                targetCTP = (CollectionTypeProxy)ctProxySet.getProxy(targetType.getObjectID());
            }
            if (this.useGenerateInDDL && targetCTP != null && !targetCTP.isMarkedGenerate() || this.objectsMap.containsValue(targetType)) continue;
            FilteredSelection tCollType = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(tCollType);
            tCollType.setSelected(false);
            FilteredSelection sCollType = new FilteredSelection(targetType);
            tCollType.setElementDescriptor(CollectionType.class);
            CollectionTypeComparator comp = new CollectionTypeComparator(null, targetType, null, targetCTP);
            this.comparatorsMap.put(comp.getID(), comp);
            tCollType.setPropertiesComparator(comp);
            sCollType.setPropertiesComparator(comp);
            tCollType.setStatus(3);
            sCollType.setStatus(3);
            sCollType.setCorrespondentNode(tCollType);
            tCollType.setCorrespondentNode(sCollType);
            sCollTypes.addChild(tCollType);
            tCollTypes.addChild(sCollType);
        }
    }

    private DataTypesDesign getTargetDataTypesDesign() {
        return this.targetDTD;
    }

    private DataTypesDesign getSourceDataTypesDesign() {
        return this.sourceDTD;
    }

    private boolean isGenerateInDDL(ModelIDObject source, ModelIDObject target) {
        if (swapTarget) {
            if (source != null) {
                return source.isMarkedGenerate();
            }
        } else if (target != null) {
            return target.isMarkedGenerate();
        }
        return true;
    }

    private void addArcs(Table sTable, CompareObjectSelection sParentNode, Table tTable, CompareObjectSelection tParentNode) {
        FilteredSelection targetArcsel;
        FilteredSelection sourceArcsel;
        List slist = sTable.getArcs();
        List tlist = tTable != null ? tTable.getArcs() : Collections.EMPTY_LIST;
        if (slist.isEmpty() && tlist.isEmpty()) {
            return;
        }
        FilteredSelection sArcs = new FilteredSelection(ModelIdObjectSelection.ARCS);
        FilteredSelection tArcs = new FilteredSelection(ModelIdObjectSelection.ARCS);
        sArcs.setCorrespondentNode(tArcs);
        tArcs.setCorrespondentNode(sArcs);
        this.setEmptyComparator(sArcs);
        this.setEmptyComparator(tArcs);
        sParentNode.addChild(sArcs);
        tParentNode.addChild(tArcs);
        tArcs.setSelected(false);
        for (FKArc source : slist) {
            FKArcComparator comp;
            sourceArcsel = new FilteredSelection(source);
            targetArcsel = null;
            FKArc target = (FKArc)this.getCorrespondingObject(tlist, (DesignObject)source);
            if (target != null) {
                targetArcsel = new FilteredSelection(target);
                comp = new FKArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(comp.isModified());
                this.objectsMap.put(source.getObjectID(), target);
            } else {
                targetArcsel = new FilteredSelection(NEW_ARC);
                sourceArcsel.setStatus(2);
                targetArcsel.setStatus(2);
                targetArcsel.setElementDescriptor(FKArc.class);
                comp = new FKArcComparator(source, target, this.objectsMap);
                sourceArcsel.setPropertiesComparator(comp);
                targetArcsel.setPropertiesComparator(comp);
                this.comparatorsMap.put(comp.getID(), comp);
                sourceArcsel.setSelected(true);
            }
            targetArcsel.setCorrespondentNode(sourceArcsel);
            sourceArcsel.setCorrespondentNode(targetArcsel);
            sArcs.addChild(sourceArcsel);
            tArcs.addChild(targetArcsel);
        }
        for (FKArc targetArc : tlist) {
            if (this.objectsMap.containsValue(targetArc) || PropertiesComparator.DDL_ONLY && targetArc.isReverse()) continue;
            sourceArcsel = new FilteredSelection(TO_DROP);
            this.deletedMappings.add(sourceArcsel);
            sourceArcsel.setSelected(false);
            sourceArcsel.setElementDescriptor(FKArc.class);
            targetArcsel = new FilteredSelection(targetArc);
            targetArcsel.setElementDescriptor(FKArc.class);
            FKArcComparator comp = new FKArcComparator(null, targetArc, this.objectsMap);
            this.comparatorsMap.put(comp.getID(), comp);
            targetArcsel.setPropertiesComparator(comp);
            sourceArcsel.setPropertiesComparator(comp);
            sourceArcsel.setStatus(3);
            targetArcsel.setStatus(3);
            targetArcsel.setCorrespondentNode(sourceArcsel);
            sourceArcsel.setCorrespondentNode(targetArcsel);
            sArcs.addChild(sourceArcsel);
            tArcs.addChild(targetArcsel);
        }
    }
}

