/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class ImageObject
extends MultiShapedDesignObject {
    public static final String TYPE_NAME = "Image";
    private BufferedImage picture;
    private String fileName = null;
    private Image scaledPicture;
    private String lastDir = null;
    private boolean pictureChanged = false;
    private static final Logger LOGGER = new Logger(ImageObject.class);

    public ImageObject(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void remove() {
        if (this.picture != null) {
            this.picture.flush();
        }
        this.remove(true);
    }

    public void remove(boolean ask) {
        if (ask) {
            int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ImageObject.SureYouWantToDelete"), this.getName()), Messages.getString("ImageObject.ConfirmObjectDelete"), 0);
            if (res == 0) {
                super.remove();
            }
        } else {
            super.remove();
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "image" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BufferedImage getPicture() {
        return this.picture;
    }

    public void setPicture(BufferedImage bi) {
        if (bi != null) {
            if (this.picture != null) {
                this.picture.flush();
            }
            this.picture = this.copyPicture(bi);
            bi.flush();
        } else if (this.picture != null) {
            this.picture.flush();
            this.picture = null;
        }
    }

    public BufferedImage copyPicture(BufferedImage bi) {
        BufferedImage pic = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        Graphics g = pic.getGraphics();
        g.drawImage(bi, 0, 0, null);
        g.dispose();
        return pic;
    }

    private File getImageFile() {
        int result;
        URLFilter fileFilter = new URLFilter(){

            public boolean accept(URL url) {
                File file = new File(url.getPath());
                return file.getName().toLowerCase().endsWith(".png") || file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".gif") || file.isDirectory();
            }

            public String toString() {
                return "Image files (*.png, *.jpg, *.gif)";
            }
        };
        URLFileChooser fileChooser = new URLFileChooser();
        fileChooser.clearChooseableURLFilters();
        fileChooser.setSelectionScope(0);
        fileChooser.setSelectionMode(0);
        fileChooser.setShowJarsAsDirs(false);
        fileChooser.setURLFilter(fileFilter);
        if (this.lastDir != null) {
            fileChooser.setSelectedURL(URLFactory.newDirURL((String)this.lastDir));
        }
        if ((result = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ImageObject.SelectImage"))) == 0) {
            File file = new File(fileChooser.getSelectedURL().getPath());
            this.lastDir = file.getParent();
            return file;
        }
        return null;
    }

    public BufferedImage getImage() {
        BufferedImage newPicture = null;
        File file = this.getImageFile();
        if (file != null) {
            try {
                newPicture = ImageIO.read(file);
                this.fileName = file.getName();
            }
            catch (Throwable e) {
                LOGGER.error("ImageObject.showPropertyDialog: ", e);
            }
        }
        return newPicture;
    }

    public boolean selectImage() {
        boolean success = false;
        File file = this.getImageFile();
        if (file != null) {
            try {
                this.picture = ImageIO.read(file);
                this.fileName = file.getName();
                this.pictureChanged = true;
                success = true;
                this.setDirty(true);
            }
            catch (Throwable e) {
                LOGGER.error("ImageObject.showPropertyDialog: ", e);
            }
        }
        return success;
    }

    public void loadImageFromFile() {
        if (this.fileName != null && !"".equalsIgnoreCase(this.fileName)) {
            try {
                File imagePath = new File(this.getDesign().getStoragePath(), "files/images");
                File imageFile = new File(imagePath, this.getFileName());
                if (imageFile.exists()) {
                    this.picture = ImageIO.read(imageFile);
                    this.pictureChanged = false;
                }
            }
            catch (Throwable e) {
                LOGGER.error("ImageObject.loadFromFile: ", e);
            }
        }
    }

    public void saveImageToFile() {
        if (this.picture != null && this.pictureChanged) {
            try {
                File imagePath = new File(this.getDesign().getStoragePath(), "files/images");
                if (!imagePath.exists()) {
                    imagePath.mkdirs();
                }
                File outputfile = new File(imagePath, this.getFileName());
                ImageIO.write((RenderedImage)this.picture, "png", outputfile);
            }
            catch (Throwable e) {
                LOGGER.error("ImageObject.saveToFile: ", e);
            }
        }
    }

    private String getFileName() {
        return this.fileName;
    }

    public String getImageFileName() {
        this.saveImageToFile();
        return this.getFileName();
    }

    public void setImageFileName(String fileName) {
        this.fileName = fileName;
        this.loadImageFromFile();
    }

    public void setPictureChanged(boolean value) {
        this.pictureChanged = value;
    }

    public void scalePicture(Rectangle bounds) {
        if (bounds.width > 0 && bounds.height > 0 && this.picture != null) {
            this.scaledPicture = this.picture.getScaledInstance(bounds.width, bounds.height, 2);
        }
    }

    public Image getScaledPicture() {
        return this.scaledPicture;
    }

    @Override
    public void copy(DesignObject desObject) {
        super.copy(desObject);
        ImageObject img = (ImageObject)desObject;
        img.setImageFileName(this.getFileName());
        if (img.getPicture() == null) {
            img.setPicture(this.getPicture());
        }
    }
}

