/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.GUID;

public class DesignSet
extends ModelIDObjectSet {
    private static final String UNTITLED_DESIGN = Messages.getString("Design.Untitled");
    private static final ModelIDObject[] PROTO_ARRAY = new Design[0];
    private ApplicationView appView;
    private Object elDescriptor;

    public DesignSet(ApplicationView appView) {
        this.appView = appView;
    }

    @Override
    public ApplicationView getAppView() {
        return this.appView;
    }

    @Override
    public ModelIDObject createElement(String id) {
        Design design = new Design(this.getAppView());
        this.getAppView().setCurrentDesign(design);
        if (id == null || "".equalsIgnoreCase(id)) {
            design.setObjectID(new GUID().toString());
        } else {
            design.setObjectID(id);
        }
        design.setName(this.createName(true));
        design.setParent(this);
        this.getAppView().getPersistenceManager().readSystemInit(design);
        this.getAppView().getUDPLibrariesPersistence().load(design, this.getAppView());
        this.add(design);
        return design;
    }

    public String createName(boolean newDesign) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        int count = this.size();
        if (newDesign) {
            ++count;
        }
        while (this.getByName(buffer.toString() + String.valueOf(count)) != null) {
            ++count;
        }
        buffer.append(count);
        return buffer.toString();
    }

    @Override
    public String getDefaultNamePrefix() {
        return UNTITLED_DESIGN;
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public void setElementDescriptor(Object elementDescriptor) {
        this.elDescriptor = elementDescriptor;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }
}

