/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDFloatSqlServer
extends MDPackedSized {
    protected String name = "FLOAT";

    @Override
    public String getName() {
        return this.name;
    }

    public void setNumericSynonym() {
        this.name = "NUMERIC";
    }

    @Override
    public String getMaxSize() {
        return "8";
    }

    @Override
    public MDDataType deepCopy() {
        MDFloatSqlServer copy = new MDFloatSqlServer();
        copy.setPrecision(this.getPrecision());
        copy.setScale(this.getScale());
        if (this.getName().equals("NUMERIC")) {
            copy.setNumericSynonym();
        }
        return copy;
    }

    @Override
    public int getByteSize() {
        int size = 0;
        if (this.getPrecision() == 7) {
            size = 4;
        } else if (this.getPrecision() == 15) {
            size = 8;
        }
        return size;
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDFloatSqlServer.NA");
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public int getMaxPrecision() {
        return 28;
    }
}

