/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDPackedSized;

public class MDYearToMonthOraclev9i
extends MDPackedSized {
    private String name = "INTERVAL YEAR TO MONTH";

    public MDYearToMonthOraclev9i() {
        this.precision = 2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String getNameFirstPart() {
        return "INTERVAL YEAR";
    }

    protected String getNameSecondPart() {
        return " TO MONTH";
    }

    @Override
    public String getMaxSize() {
        return "31";
    }

    @Override
    public MDDataType deepCopy() {
        MDYearToMonthOraclev9i copy = new MDYearToMonthOraclev9i();
        copy.setPrecision(this.getPrecision());
        return copy;
    }

    @Override
    public void setPrecision(int precision) {
        if (precision >= 0 && precision <= 9) {
            this.precision = precision;
            this.precisionStr = String.valueOf(precision);
        }
    }

    public void setPrecision(String precision) {
        try {
            int pr = Integer.parseInt(precision);
            if (pr >= 0 && pr <= 9) {
                this.precision = pr;
            }
        }
        catch (NumberFormatException e) {
            this.precision = 2;
        }
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDYearToMonthOracle.NA");
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDYearToMonthOracle.YearPrecision");
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        buffer.append(this.getNameFirstPart());
        if (this.getPrecision() != 2) {
            buffer.append(" (");
            buffer.append(this.getPrecision());
            buffer.append(")");
        }
        buffer.append(this.getNameSecondPart());
    }

    @Override
    public int getMaxPrecision() {
        return 9;
    }
}

