/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.db2;

import oracle.dbtools.crest.model.datatype.AbstractDataType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDVarSized;

public class MDVarChar
extends MDVarSized {
    protected String name = "VARCHAR";

    @Override
    public String getMaxSize() {
        return "32704";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MDDataType deepCopy() {
        MDVarChar copy = new MDVarChar();
        copy.setSize(this.getSize());
        return copy;
    }

    @Override
    public int getByteSize() {
        return AbstractDataType.parseSize(this.getSize()) + 2;
    }

    public void setCharVaryingSynonym() {
        this.name = "CHAR VARYING";
    }

    public void setCharacterVaryingSynonym() {
        this.name = "CHARACTER VARYING";
    }

    @Override
    public String getSize() {
        String s = super.getSize();
        s = s.replaceFirst("max", this.getMaxSize());
        s = s.replaceFirst("MAX", this.getMaxSize());
        return s;
    }
}

