/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.xmi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class XMIHandler {
    private static final Map DATATYPE_MAP = new HashMap();
    private static final String XMI_DATATYPE_P_INTEGER = "P-INTEGER";
    private static final String XMI_DATATYPE_P_SMALLINT = "P-SMALLINT";
    private static final String XMI_DATATYPE_P_BYTE = "P-BYTE";
    private static final String XMI_DATATYPE_P_DOUBLE = "P-DOUBLE";
    private static final String XMI_DATATYPE_P_FLOAT = "P-FLOAT";
    private static final String XMI_DATATYPE_P_NUMERIC = "P-NUMERIC";
    private static final String XMI_DATATYPE_P_REAL = "P-REAL";
    private static final String XMI_DATATYPE_P_DECIMAL = "P-DECIMAL";
    private static final String XMI_DATATYPE_P_TIMESTAMP = "P-TIMESTAMP";
    private static final String XMI_DATATYPE_P_VARCHAR = "P-VARCHAR";
    private static final String XMI_DATATYPE_P_TEXT = "P-TEXT";
    private static final String XMI_DATATYPE_P_CHARACTER = "P-CHARACTER";
    private static final String XMI_DATATYPE_P_CURRENCY = "P-CURRENCY";
    private static final String XMI_DATATYPE_P_DATE = "P-DATE";
    private static final String XMI_DATATYPE_P_TIME = "P-TIME";
    private static final String XMI_DATATYPE_P_DATETIME = "P-DATETIME";
    private static final String XMI_DATATYPE_P_BINARY = "P-BINARY";
    private static final String XMI_DATATYPE_P_STRING = "P-STRING";
    private static final String XMI_DATATYPE_INTEGER = "INTEGER";
    private static final String XMI_DATATYPE_INT = "INT";
    private static final String XMI_DATATYPE_SMALLINT = "SMALLINT";
    private static final String XMI_DATATYPE_BYTE = "BYTE";
    private static final String XMI_DATATYPE_DOUBLE = "DOUBLE";
    private static final String XMI_DATATYPE_FLOAT = "FLOAT";
    private static final String XMI_DATATYPE_NUMERIC = "NUMERIC";
    private static final String XMI_DATATYPE_REAL = "REAL";
    private static final String XMI_DATATYPE_DECIMAL = "DECIMAL";
    private static final String XMI_DATATYPE_TIMESTAMP = "TIMESTAMP";
    private static final String XMI_DATATYPE_VARCHAR = "VARCHAR";
    private static final String XMI_DATATYPE_TEXT = "TEXT";
    private static final String XMI_DATATYPE_CHARACTER = "CHARACTER";
    private static final String XMI_DATATYPE_CURRENCY = "CURRENCY";
    private static final String XMI_DATATYPE_DATE = "DATE";
    private static final String XMI_DATATYPE_TIME = "TIME";
    private static final String XMI_DATATYPE_DATETIME = "DATETIME";
    private static final String XMI_DATATYPE_BINARY = "BINARY";
    private static final String XMI_DATATYPE_STRING = "STRING";
    private static final String XMI_DATATYPE_BOOLEAN = "BOOLEAN";
    private static final String XMI_DATATYPE_CHAR = "CHAR";
    private static final String XMI_DATATYPE_BLOB = "BLOB";
    private static final String XMI_DATATYPE_CLOB = "CLOB";
    private static final String XMI_DATATYPE_ROWID = "ROWID";
    private static final String INTEGER = "INTEGER";
    private static final String DATE_TIME = "datetime";
    private static final String ALPHANUMERIC = "alphanumeric";
    private static final String BIGINT = "BIGINT";
    private static final String DOUBLE = "Double";
    private static final String FLOAT = "Float";
    private static final String DECIMAL = "Decimal";
    private static final String NUMERIC = "Numeric";
    private static final String TEXT = "Text";
    private static final String REAL = "real";
    private static final String TIMESTAMP = "timestamp";
    private static final String DATE = "Date";
    private static final String BINARY = "Binary";
    private static final String LONG_ALPHANUMERIC = "long alphanumeric";
    private static final String BOOLEAN = "boolean";
    private static final String BLOB = "Blob";
    private static final String CLOB = "Clob";
    private static final String ROWID = "ROWID";
    private ApplicationView appView;
    private String designName;
    private Design design;
    private ProgressDialog monitor;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private static Logger LOGGER;
    private ImportLogger importLog;
    Map typeMap = new HashMap();

    public XMIHandler(ApplicationView view) {
        this.appView = view;
    }

    public void parse(File file, String dsnName) {
        try {
            String oldDesignPath = this.appView.getCurrentDesign().getDesignPath();
            this.designName = dsnName;
            if (this.designName != null) {
                this.appView.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
                if (this.appView.designExists(this.designName)) {
                    this.appView.deleteDesign(this.designName);
                }
                this.appView.setDesignName(this.designName);
                this.design = this.appView.getCurrentDesign();
                this.design.setFileName(this.designName);
                new Thread(new Runner(file.getAbsolutePath())).start();
            } else {
                this.appView.getCurrentDesign().setDesignPath(oldDesignPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing file: " + file.getAbsolutePath(), e);
        }
    }

    private void parseFile(String file) {
    }

    private void rearrangeEntities() {
        EntitySet entitySet;
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (this.design != null && (entitySet = this.design.getLogicalDesign().getEntitySet()).size() > 0) {
            Iterator it = entitySet.iterator();
            float square = (float)Math.sqrt(entitySet.size());
            long maxEntitiesPerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxEntitiesPerRow;
            }
            ++maxEntitiesPerRow;
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                TopView topView = entity.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getEntitySize(entity);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxEntitiesPerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private Dimension getEntitySize(Entity entity) {
        int w = 35;
        int h = 25;
        int colCount = entity.getElements().length;
        h += colCount * 14;
        if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
            h += 4;
            for (int i = 0; i < entity.getKeys().length; ++i) {
                if (entity.getKeys()[i].isFK()) continue;
                h += 14;
            }
        }
        int colLength = 1;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            ContainedObjectWithDomain element = (ContainedObjectWithDomain)entity.getElement(i);
            int cl = element.getName().length() * 7;
            int dtl = element.getDataType().toString().length() * 7;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = entity.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    private void rearrangeTables() {
        TableSet tableSet;
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (this.design != null && (tableSet = this.design.getRelationalDesign().getTableSet()).size() > 0) {
            Iterator it = tableSet.iterator();
            float square = (float)Math.sqrt(tableSet.size());
            long maxTablePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTablePerRow;
            }
            ++maxTablePerRow;
            while (it.hasNext()) {
                Table table = (Table)it.next();
                TopView topView = table.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.getTableSize(table);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTablePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private void rearrangeTypes() {
        StructuredTypeSet typeSet;
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.count = 0;
        if (this.design != null && (typeSet = this.design.getDataTypesDesign().getStructuredTypeSet()).size() > 0) {
            Iterator it = typeSet.iterator();
            float square = (float)Math.sqrt(typeSet.size());
            long maxTypePerRow = (int)square;
            if (Math.sqrt(square * square) != (double)square) {
                ++maxTypePerRow;
            }
            ++maxTypePerRow;
            while (it.hasNext()) {
                StructuredType type = (StructuredType)it.next();
                TopView topView = type.getTopView();
                if (topView == null) continue;
                ++this.count;
                Dimension dim = this.design.getDataTypesDesign().getTypeSize(type);
                this.width = dim.width;
                this.height = Math.max(dim.height, this.height);
                if (topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dim));
                } else {
                    topView.setBounds(new Rectangle(new Point(this.left, this.top), dim));
                }
                this.left = this.left + this.width + 50;
                if ((long)this.count != maxTypePerRow) continue;
                this.count = 0;
                this.left = 20;
                this.top = this.top + this.height + 50;
                this.height = 25;
            }
        }
    }

    private Dimension getTableSize(Table table) {
        int w = 35;
        int h = 25;
        int colCount = table.getElements().length;
        h += colCount * 14;
        if (table.getKeys().length > 0 && !this.allKeysAreFK(table.getKeys())) {
            h += 4;
            for (int i = 0; i < table.getKeys().length; ++i) {
                if (table.getKeys()[i].isFK()) continue;
                h += 14;
            }
        }
        int colLength = 1;
        int dtLength = 1;
        for (int i = 0; i < colCount; ++i) {
            ContainedObjectWithDomain element = (ContainedObjectWithDomain)table.getElement(i);
            int cl = element.getName().length() * 7;
            int dtl = element.getDataType().toString().length() * 7;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = table.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    private boolean allKeysAreFK(KeyObject[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            result = false;
            break;
        }
        return result;
    }

    static {
        DATATYPE_MAP.put(XMI_DATATYPE_P_INTEGER, BIGINT);
        DATATYPE_MAP.put(XMI_DATATYPE_P_SMALLINT, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_P_BYTE, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_P_DOUBLE, DOUBLE);
        DATATYPE_MAP.put(XMI_DATATYPE_P_FLOAT, FLOAT);
        DATATYPE_MAP.put(XMI_DATATYPE_P_NUMERIC, NUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_P_REAL, REAL);
        DATATYPE_MAP.put(XMI_DATATYPE_P_DECIMAL, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_P_TIMESTAMP, TIMESTAMP);
        DATATYPE_MAP.put(XMI_DATATYPE_P_VARCHAR, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_P_TEXT, TEXT);
        DATATYPE_MAP.put(XMI_DATATYPE_P_CHARACTER, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_P_CURRENCY, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_P_DATE, DATE);
        DATATYPE_MAP.put(XMI_DATATYPE_P_TIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_P_DATETIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_P_BINARY, BINARY);
        DATATYPE_MAP.put(XMI_DATATYPE_P_STRING, LONG_ALPHANUMERIC);
        DATATYPE_MAP.put("INTEGER", BIGINT);
        DATATYPE_MAP.put(XMI_DATATYPE_INT, BIGINT);
        DATATYPE_MAP.put(XMI_DATATYPE_SMALLINT, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_BYTE, "INTEGER");
        DATATYPE_MAP.put(XMI_DATATYPE_DOUBLE, DOUBLE);
        DATATYPE_MAP.put(XMI_DATATYPE_FLOAT, FLOAT);
        DATATYPE_MAP.put(XMI_DATATYPE_NUMERIC, NUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_REAL, REAL);
        DATATYPE_MAP.put(XMI_DATATYPE_DECIMAL, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_TIMESTAMP, TIMESTAMP);
        DATATYPE_MAP.put(XMI_DATATYPE_VARCHAR, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_TEXT, TEXT);
        DATATYPE_MAP.put(XMI_DATATYPE_CHARACTER, ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_CURRENCY, DECIMAL);
        DATATYPE_MAP.put(XMI_DATATYPE_DATE, DATE);
        DATATYPE_MAP.put(XMI_DATATYPE_TIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_DATETIME, DATE_TIME);
        DATATYPE_MAP.put(XMI_DATATYPE_BINARY, BINARY);
        DATATYPE_MAP.put(XMI_DATATYPE_STRING, LONG_ALPHANUMERIC);
        DATATYPE_MAP.put(XMI_DATATYPE_BOOLEAN, BOOLEAN);
        DATATYPE_MAP.put(XMI_DATATYPE_CHAR, TEXT);
        DATATYPE_MAP.put(XMI_DATATYPE_BLOB, BLOB);
        DATATYPE_MAP.put(XMI_DATATYPE_CLOB, CLOB);
        DATATYPE_MAP.put("ROWID", "ROWID");
        LOGGER = new Logger(XMIHandler.class);
    }

    private class Runner
    implements Runnable {
        private String file;

        public Runner(String file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                XMIHandler.this.design.getLogicalDesign().setMainViewVisible(false);
                XMIHandler.this.design.getRelationalDesign().setMainViewVisible(false);
                XMIHandler.this.design.getDataTypesDesign().setMainViewVisible(false);
                XMIHandler.this.importLog = new ImportLogger();
                try {
                    XMIHandler.this.monitor = new ProgressDialog(XMIHandler.this.appView, "", 0, 100);
                    try {
                        try {
                            XMIHandler.this.monitor.setNote(Messages.getString("XMIHandler.ParseFile"));
                            XMIHandler.this.monitor.setProgress(10);
                            XMIHandler.this.parseFile(this.file);
                            XMIHandler.this.monitor.setNote(Messages.getString("XMIHandler.RearrangeLayout"));
                            XMIHandler.this.monitor.setProgress(80);
                            try {
                                XMIHandler.this.rearrangeTypes();
                                XMIHandler.this.rearrangeEntities();
                                XMIHandler.this.rearrangeTables();
                                XMIHandler.this.design.getDataTypesDesign().setMainViewVisible(true);
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Layout", e);
                            }
                            XMIHandler.this.monitor.setProgress(100);
                            XMIHandler.this.appView.getCurrentDesign().setDesignPath("");
                            XMIHandler.this.appView.synchronizeTitle();
                            System.gc();
                        }
                        finally {
                            XMIHandler.this.appView.setImporting(false);
                        }
                    }
                    finally {
                        XMIHandler.this.monitor.close();
                    }
                }
                finally {
                    ApplicationView.loading = false;
                    XMIHandler.this.design.getLogicalDesign().setMainViewVisible(true);
                    XMIHandler.this.design.getRelationalDesign().setMainViewVisible(true);
                    if (XMIHandler.this.design.getRelationalDesign().getTableSet().size() > 0) {
                        XMIHandler.this.appView.setCurrentDPV(XMIHandler.this.design.getRelationalDesign().getMainView());
                    } else {
                        XMIHandler.this.appView.setCurrentDPV(XMIHandler.this.design.getLogicalDesign().getMainView());
                    }
                }
                LogReport logPanel = new LogReport(XMIHandler.this.appView);
                logPanel.setLog(XMIHandler.this.importLog.generateReport(XMIHandler.this.appView));
                if (XMIHandler.this.appView.getSettings().showImportLog()) {
                    logPanel.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception e) {
                XMIHandler.this.design.destroyAll(false);
                XMIHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + this.file, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("XMIHandler.UnableToImportTheFile"), Messages.getString("XMIHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

