/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableViewProxySet;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHView
extends RowHandler {
    public static final String OBJECT_TYPE = "VIEW";
    public static final String OBJECT_TYPE_COOL = "VIEWS";
    private int tableKey;
    private int viewKey;
    private int tableColumnKey;
    private int viewColumnKey;
    private boolean found;
    private static final Logger LOGGER = new Logger(RHView.class);

    public RHView(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createView(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    public void createView(VarFileLine line) {
        this.found = true;
        ContainerObject tableView = null;
        String viewKey = this.getField(line, "general_id");
        if (viewKey != null) {
            String name = this.getField(line, "VIEW_NAME");
            if (this.getPhysicalDesign().getTableViewSet().getByName(name) == null) {
                tableView = this.getPhysicalDesign().getTableViewSet().createTableView(null);
                if (tableView != null) {
                    if (!Fields.typeVar.equalsIgnoreCase("Sterling COOL:DBA V2.1")) {
                        List listViewDepKey = this.getViewDependentKey(viewKey);
                        if (listViewDepKey.size() > 0) {
                            for (String viewDepKey : listViewDepKey) {
                                this.addColumnsToView((TableView)tableView, viewDepKey);
                            }
                        }
                    } else {
                        List listKey = this.getView2Key(viewKey);
                        if (listKey.size() > 0) {
                            for (String key : listKey) {
                                this.addColumnsToViewForCool((TableView)tableView, key);
                            }
                        }
                    }
                } else {
                    this.found = false;
                }
            } else {
                this.found = false;
            }
        } else {
            this.found = false;
        }
        if (this.found && tableView.getElements().length > 0) {
            tableView.setName(this.getField(line, "VIEW_NAME"));
            this.addDefinition(line, (TableView)tableView);
            this.fillElements(line, (TableView)tableView);
            if (tableView.getTopView() == null) {
                this.getDesign().getRelationalDesign().getMainView().createViewFor(tableView);
            }
            this.addCreatedObject(this.getField(line, "general_id"), tableView);
            this.removeSelectedLine(line);
        } else if (tableView != null) {
            ((TableView)tableView).remove();
        }
    }

    private List getViewDependentKey(String viewKey) {
        ArrayList<String> viewDepKeyList = new ArrayList<String>();
        List allLines = this.getAllSelectedLines();
        for (VarFileLine selectedLine : allLines) {
            if (!selectedLine.getType().equalsIgnoreCase("VIEWSVIEW_DEPENDEN") || !this.getField(selectedLine, "VIEW_VIEW_DEPENDENT_VIEWSKEY").equalsIgnoreCase(viewKey)) continue;
            String viewDepKey = this.getField(selectedLine, "VIEW_VIEW_DEPENDENT_VIEWDEPENDENTKEY");
            viewDepKeyList.add(viewDepKey);
        }
        return viewDepKeyList;
    }

    private List getView2Key(String viewKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        List allLines = this.getAllSelectedLines();
        for (VarFileLine selectedLine : allLines) {
            if (!selectedLine.getType().equalsIgnoreCase("VIEWDEPENDE2") || !this.getField(selectedLine, "VIEW_VIEW_DEPENDENT2_VIEWSKEY").equalsIgnoreCase(viewKey)) continue;
            String key = this.getField(selectedLine, "VIEW_VIEW_DEPENDENT2_KEY");
            keyList.add(key);
        }
        return keyList;
    }

    private void addColumnsToView(TableView tableView, String viewDepKey) {
        List allLines = this.getAllSelectedLines();
        for (VarFileLine selectedLine : allLines) {
            Column column;
            int num;
            ContainedObject[] columns;
            if (!selectedLine.getType().equalsIgnoreCase("VIEWDEPENDENT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(viewDepKey)) continue;
            int type = Integer.parseInt(this.getField(selectedLine, "VIEW_DEPENDENT_TYPE"));
            if (tableView == null) continue;
            this.determineType();
            if (type == this.tableKey) {
                Table table = (Table)this.getCreatedObject(this.getField(selectedLine, "VIEW_DEPENDENT_TABLE"));
                if (table != null) {
                    columns = table.getElements();
                    for (num = 0; num < columns.length; ++num) {
                        column = (Column)columns[num];
                        if (column != null) {
                            tableView.add(column);
                            continue;
                        }
                        this.found = false;
                    }
                    continue;
                }
                this.found = false;
                continue;
            }
            if (type == this.tableColumnKey) {
                Column tableColumn = (Column)this.getCreatedObject(this.getField(selectedLine, "VIEW_DEPENDENT_TABLE_COLUMN"));
                if (tableColumn != null) {
                    tableView.add(tableColumn);
                    continue;
                }
                this.found = false;
                continue;
            }
            if (type == this.viewColumnKey) {
                Column viewColumn = (Column)this.getCreatedObject(this.getField(selectedLine, "VIEW_DEPENDENT_VIEW_COLUMN"));
                if (viewColumn != null) {
                    tableView.add(viewColumn);
                    continue;
                }
                this.found = false;
                continue;
            }
            if (type != this.viewKey) continue;
            TableView view = (TableView)this.getCreatedObject(this.getField(selectedLine, "VIEW_DEPENDENT_VIEW"));
            if (view != null) {
                columns = view.getElements();
                for (num = 0; num < columns.length; ++num) {
                    column = (Column)columns[num];
                    if (column != null) {
                        tableView.add(column);
                        continue;
                    }
                    this.found = false;
                }
                continue;
            }
            this.found = false;
        }
    }

    private void addColumnsToViewForCool(TableView tableView, String key) {
        ModelIDObject createdObject = this.getCreatedObject(key);
        if (createdObject instanceof Column) {
            if (createdObject != null) {
                tableView.add((Column)createdObject);
            } else {
                this.found = false;
            }
        }
    }

    private void determineType() {
        if (Fields.typeVar.equals("BACHMAN DB2 V6.1") || Fields.typeVar.equals("BACHMAN DB2 V7.1")) {
            this.tableColumnKey = 2053;
            this.tableKey = 2054;
            this.viewColumnKey = 2055;
            this.viewKey = 2061;
        } else if (Fields.typeVar.equals("CAYENNE DB2 V7.1")) {
            this.tableColumnKey = 2055;
            this.tableKey = 2054;
        }
    }

    private void fillElements(VarFileLine line, TableView tableView) {
        tableView.setComment(this.getComment(line));
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        TableViewProxySet tableViewProxySet = storageDesign.getTableViewProxySet();
        TableViewProxyDB2 tableViewProxy = (TableViewProxyDB2)tableViewProxySet.getProxy(tableView.getObjectID());
        if (tableViewProxy != null) {
            String ownerKey = this.getField(line, "VIEW_OWNER");
            Owner owner = (Owner)this.getCreatedObject(ownerKey);
            if (owner != null) {
                tableViewProxy.setOwner(owner);
            }
            try {
                int checkOptions = Integer.parseInt(this.getField(line, "VIEW_CHECK_OPTIONS"));
                switch (checkOptions) {
                    case 0: {
                        tableViewProxy.setCheckOption(false);
                        break;
                    }
                    case 1: {
                        tableViewProxy.setCheckOption(true);
                        break;
                    }
                    default: {
                        tableViewProxy.setCheckOption(false);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format in RHView.fillElements (Set CheckOption) : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
                this.importLog.addError("Wrong CHECK OPTION format in " + line);
            }
            String labelOn = this.getField(line, "VIEW_LABEL_ON");
            tableViewProxy.setLabelOn(labelOn);
            this.fillDefinition(line, tableViewProxy);
        }
    }

    private void fillDefinition(VarFileLine line, TableViewProxyDB2 tableViewProxy) {
        try {
            int textID = Integer.parseInt(this.getField(line, "VIEW_TEXT_ID"));
            if (textID > 0) {
                int whereIndex;
                String definition = null;
                VarFileLine commentLine = this.getCommentLine(String.valueOf(textID), "TEXT");
                if (commentLine != null) {
                    definition = this.getField(commentLine, "text_comment");
                    this.removeSelectedLine(commentLine);
                }
                if (definition != null && (whereIndex = definition.toUpperCase().indexOf("WHERE")) > -1) {
                    String whereDef = definition.substring(whereIndex + 5).trim();
                    tableViewProxy.setDefinition(whereDef);
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHView.fillDefinition : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addError("Unknown view body near " + line);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        if (!this.getField(line, "VIEW_COMMENT_ID").equalsIgnoreCase("0")) {
            VarFileLine commentLine = this.getCommentLine(this.getField(line, "VIEW_COMMENT_ID"), "TEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "text_comment");
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private void addDefinition(VarFileLine line, TableView tableView) {
        int textID = Integer.parseInt(this.getField(line, "VIEW_TEXT_ID"));
        if (textID > 0) {
            String definition = null;
            VarFileLine commentLine = this.getCommentLine(String.valueOf(textID), "TEXT");
            if (commentLine != null) {
                definition = this.getDefinitionField(commentLine, "text_comment");
                this.removeSelectedLine(commentLine);
            }
            if (definition != null) {
                tableView.setUserDefined(true);
                StringBuffer buffer = new StringBuffer();
                buffer.append("CREATE VIEW ").append(tableView.getName()).append('\n').append(definition);
                tableView.setUserDefinedSQL(buffer.toString());
            }
        }
    }
}

