/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.logical.TVRelation;

public class RHPartnership
extends RowHandler {
    public static final String OBJECT_TYPE = "PARTNERSHIP";
    List lines = new ArrayList();
    private Map arcMap = new TreeMap();
    private Map relMap = new TreeMap();

    public RHPartnership(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            if (!this.lines.contains(line)) {
                this.lines.add(line);
            }
            this.createRelation(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createRelation(VarFileLine line) {
        String keySourcePartnershipSet = this.getField(line, "partnership_source");
        String keyTargetPartnershipSet = this.getField(line, "partnership_target");
        VarFileLine sourceLine = this.getVarFileLine(keySourcePartnershipSet);
        VarFileLine targetLine = this.getVarFileLine(keyTargetPartnershipSet);
        if (sourceLine == null || targetLine == null) {
            return;
        }
        Entity sourceEntity = this.getEntityFromLine(sourceLine);
        Entity targetEntity = this.getEntityFromLine(targetLine);
        Relation rel1 = (Relation)this.relMap.get(keySourcePartnershipSet);
        Relation rel2 = (Relation)this.relMap.get(keyTargetPartnershipSet);
        if (rel1 != null && rel2 != null && sourceEntity == targetEntity) {
            Integer arc_type_pos = new Integer(12);
            String arctype_s = this.getField(sourceLine.getLine(), arc_type_pos);
            String arctype_t = this.getField(targetLine.getLine(), arc_type_pos);
            if ("X".equalsIgnoreCase(arctype_t) && "X".equalsIgnoreCase(arctype_s)) {
                ArcHolder holder = new ArcHolder();
                holder.entity = sourceEntity;
                holder.rel1 = rel1;
                holder.rel2 = rel2;
                ArrayList<ArcHolder> list = (ArrayList<ArcHolder>)this.arcMap.get(sourceEntity.getObjectID());
                if (list == null) {
                    list = new ArrayList<ArcHolder>();
                }
                list.add(holder);
                this.arcMap.put(sourceEntity.getObjectID(), list);
                this.removeSelectedLine(line);
                return;
            }
            return;
        }
        if (sourceEntity != null && targetEntity != null) {
            Relation relation = this.getLogicalDesign().getRelationSet().createRelation(null);
            this.setCreatorChanger(relation, line);
            String optSource = this.getField(line, "partnership_optional_source");
            String optTarget = this.getField(line, "partnership_optional_target");
            relation.setFireCardinalityChange(false);
            if (optSource.equalsIgnoreCase("0")) {
                relation.setOptionalSource(true);
            } else {
                relation.setOptionalSource(false);
            }
            if (optTarget.equalsIgnoreCase("0")) {
                relation.setOptionalTarget(true);
            } else {
                relation.setOptionalTarget(false);
            }
            String cardSource = this.getField(line, "partnership_cardinality_source");
            String cardTarget = this.getField(line, "partnership_cardinality_target");
            int sourceCardinality = new Integer(cardSource);
            if (sourceCardinality > 0) {
                relation.setSourceCardinality(this.findCardinality(sourceCardinality));
            }
            String psSourceName = this.getPartnershipSetName(sourceLine);
            String psTargetName = this.getPartnershipSetName(targetLine);
            relation.setSourceEntity(sourceEntity);
            relation.setNameOnSource(psSourceName);
            relation.setTargetEntity(targetEntity);
            relation.setNameOnTarget(psTargetName);
            boolean belPK = this.belongsToPK(keySourcePartnershipSet);
            relation.setBelongsToSourcePK(belPK);
            belPK = this.belongsToPK(keyTargetPartnershipSet);
            relation.setBelongsToTargetPK(belPK);
            relation.setIdentifying(relation.belongsToSourcePK() || relation.belongsToTargetPK());
            int targetCardinality = new Integer(cardTarget);
            if (targetCardinality > 0) {
                relation.setTargetCardinality(this.findCardinality(targetCardinality));
            }
            if (((Relation.Cardinality)relation.getSourceCardinality()).getValue() == 1 && ((Relation.Cardinality)relation.getTargetCardinality()).getValue() == 1) {
                if (relation.belongsToTargetPK()) {
                    relation.setDominantRole(relation.getSourceEntity());
                } else if (relation.belongsToSourcePK()) {
                    relation.setDominantRole(relation.getTargetEntity());
                } else if (relation.isOptionalSource() != relation.isOptionalTarget()) {
                    if (relation.isOptionalSource()) {
                        relation.setDominantRole(relation.getSourceEntity());
                    } else {
                        relation.setDominantRole(relation.getTargetEntity());
                    }
                }
            }
            relation.setFireCardinalityChange(true);
            relation.setTargetCardinality(relation.getTargetCardinality());
            ((TVRelation)relation.getTopView()).addConnection();
            relation.setComment(this.getComment(keySourcePartnershipSet, keyTargetPartnershipSet));
            relation.setNotes(this.getNotes(keySourcePartnershipSet, keyTargetPartnershipSet));
            this.relMap.put(keySourcePartnershipSet, relation);
            this.relMap.put(keyTargetPartnershipSet, relation);
            this.addCreatedObject(this.getField(line, "general_id"), relation);
            this.addCreatedObject(keySourcePartnershipSet, relation);
            this.addCreatedObject(keyTargetPartnershipSet, relation);
            this.removeSelectedLine(line);
        }
    }

    private VarFileLine getVarFileLine(String keyPartnershipSet) {
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("PARTNERSHIP_SET") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(keyPartnershipSet)) continue;
            return selectedLine;
        }
        return null;
    }

    private Entity getEntityFromLine(VarFileLine selectedLine) {
        return (Entity)this.getCreatedObject(this.getField(selectedLine, "partnership_source"));
    }

    private String getPartnershipSetName(VarFileLine selectedLine) {
        return this.getField(selectedLine, "partnership_set_name");
    }

    private Object findCardinality(int max) {
        Relation.Cardinality[] choises = Relation.getCardinalityChoices();
        switch (max) {
            case 1: {
                return choises[max];
            }
        }
        return choises[0];
    }

    private String getNotes(String sourceId, String targetID) {
        StringBuffer comment = new StringBuffer("");
        for (VarFileLine selectedLine : this.getCommentLines()) {
            VarFileLine commentLine;
            String textID;
            String relID;
            if (!selectedLine.getType().equalsIgnoreCase("NOTES") || !sourceId.equalsIgnoreCase(relID = this.getField(selectedLine, "note_relation_id")) && !targetID.equalsIgnoreCase(relID) || "0".equalsIgnoreCase(textID = this.getField(selectedLine, "note_text_id")) || (commentLine = this.getCommentLine(textID, "ANLTEXT")) == null) continue;
            if (comment.length() > 0) {
                comment.append("\n");
            }
            comment.append(this.getField(commentLine, "TEXT_COMMENT_2"));
        }
        return comment.toString();
    }

    private String getComment(String sourceId, String targetID) {
        StringBuffer comment = new StringBuffer("");
        for (VarFileLine selectedLine : this.getCommentLines()) {
            VarFileLine commentLine;
            String textID;
            String relID;
            if (!selectedLine.getType().equalsIgnoreCase("PARTNERSHIP_SET") || !sourceId.equalsIgnoreCase(relID = this.getField(selectedLine, "general_id")) && !targetID.equalsIgnoreCase(relID) || "0".equalsIgnoreCase(textID = this.getField(selectedLine, "PARTNERSHIP_TEXT_ID")) || (commentLine = this.getCommentLine(textID, "ANLTEXT")) == null) continue;
            if (comment.length() > 0) {
                comment.append("\n");
            }
            comment.append(this.getField(commentLine, "TEXT_COMMENT_2"));
        }
        return comment.toString();
    }

    private boolean belongsToPK(String psID) {
        boolean result = false;
        if (psID != null) {
            for (VarFileLine selectedLine : this.getAllSelectedLines()) {
                String id;
                if (!selectedLine.getType().equalsIgnoreCase("PARTNERSHIP_SETENT") || !psID.equalsIgnoreCase(id = this.getField(selectedLine, "general_id"))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }

    public void createArcs() {
        for (String id : this.arcMap.keySet()) {
            List list = (List)this.arcMap.get(id);
            if (list.size() <= 0) continue;
            Entity ent = ((ArcHolder)list.get((int)0)).entity;
            while (list.size() > 0) {
                ArrayList copy = new ArrayList();
                copy.addAll(list);
                ArrayList<DesignObject> arclist = new ArrayList<DesignObject>();
                arclist.add(ent);
                ArcHolder holder = (ArcHolder)copy.get(0);
                arclist.add(holder.rel1);
                arclist.add(holder.rel2);
                list.remove(holder);
                for (int i = 1; i < copy.size(); ++i) {
                    ArcHolder holder2 = (ArcHolder)copy.get(i);
                    if (holder.rel1 != holder2.rel1 && holder.rel1 != holder2.rel2 && holder.rel2 != holder2.rel1 && holder.rel2 != holder2.rel2) continue;
                    if (!arclist.contains(holder2.rel1)) {
                        arclist.add(holder2.rel1);
                    }
                    if (!arclist.contains(holder2.rel2)) {
                        arclist.add(holder2.rel2);
                    }
                    list.remove(holder2);
                }
                ((LogicalDesign)ent.getDesignPart()).createArc(arclist.toArray());
            }
        }
    }

    private class ArcHolder {
        public Relation rel1;
        public Relation rel2;
        public Entity entity;

        private ArcHolder() {
        }
    }
}

