/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHEntitySynonym;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Entity;

public class RHEntity
extends RowHandler {
    public static final String OBJECT_TYPE = "ENTITY";

    public RHEntity(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createEntity(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createEntity(VarFileLine line) {
        String comment = this.getComment(line);
        String entityID = this.getField(line, "general_id");
        Entity entity = (Entity)this.getAllCreatedObjects().get(entityID);
        if (entity != null) {
            return;
        }
        String superEntity = this.getField(line, "super_entity").trim();
        Entity supEntity = null;
        if (!superEntity.equals("0") && (supEntity = (Entity)this.getAllCreatedObjects().get(superEntity)) == null) {
            return;
        }
        entity = this.getLogicalDesign().createEntity(this.getField(line, "entity_name"));
        if (supEntity != null) {
            entity.setHierarchicalParent(supEntity);
        }
        this.setCreatorChanger(entity, line);
        if (comment != null) {
            entity.setComment(comment);
        }
        entity.setNotes(this.getNotes(line, "note_ent_id"));
        entity.setSynonym(this.getSynonym(line));
        this.setVolumeInfo(line, entity);
        this.addCreatedObject(entityID, entity);
        this.removeSelectedLine(line);
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "ENTITY_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHEntitySynonym.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID = this.getField(selectedLine, "general_id");
            if (!id.equalsIgnoreCase(lineID) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }

    private boolean check(String token) {
        return !"".equalsIgnoreCase(token);
    }

    private void setVolumeInfo(VarFileLine line, Entity entity) {
        String min = this.getField(line, "ENTITY_VOLUMES_MIN");
        String max = this.getField(line, "ENTITY_VOLUMES_MAX");
        String expected = this.getField(line, "ENTITY_VOLUMES_EXPECTED");
        String grPercent = this.getField(line, "ENTITY_GR_PERCENT");
        String grYMD = this.getField(line, "ENTITY_GR_YMD");
        String normalForm = this.getField(line, "ENTITY_NORMAL_FORM");
        String normalized = this.getField(line, "ENTITY_NORMALIZED");
        if (this.check(min)) {
            entity.setMinVolumes(min);
        }
        if (this.check(max)) {
            entity.setMaxVolumes(max);
        }
        if (this.check(expected)) {
            entity.setExpectedVolumes(expected);
        }
        if (this.check(grPercent)) {
            entity.setGrowthPercent(grPercent);
        }
        if (this.check(grYMD)) {
            if ("D".equalsIgnoreCase(grYMD)) {
                entity.setGrowthType(Entity.GROWTH_TYPES[0]);
            } else if ("M".equalsIgnoreCase(grYMD)) {
                entity.setGrowthType(Entity.GROWTH_TYPES[1]);
            } else if ("Y".equalsIgnoreCase(grYMD)) {
                entity.setGrowthType(Entity.GROWTH_TYPES[2]);
            }
        }
        if (this.check(normalForm)) {
            if ("C".equalsIgnoreCase(normalForm)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[0]);
            } else if ("1".equalsIgnoreCase(normalForm)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[1]);
            } else if ("2".equalsIgnoreCase(normalForm)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[2]);
            } else if ("3".equalsIgnoreCase(normalForm)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[3]);
            } else if ("4".equalsIgnoreCase(normalForm)) {
                entity.setNormalForm(Entity.NORMAL_FORMS[4]);
            }
        }
        if (this.check(normalized)) {
            if ("Y".equalsIgnoreCase(normalized)) {
                entity.setAdequatelyNormalized(Entity.YES_NO_STATES[0]);
            } else {
                entity.setAdequatelyNormalized(Entity.YES_NO_STATES[1]);
            }
        }
    }
}

