/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.physical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODOCluster
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "CLUSTER";
    private static final Logger LOGGER = new Logger(ODOCluster.class);
    PreparedStatement col_statement;
    PreparedStatement ind_statement;

    public ODOCluster(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List appSystems) throws Exception {
        Statement nvstatement = null;
        Statement statement = null;
        ArrayList<ODObject> list = new ArrayList<ODObject>();
        for (ODObject odNext : appSystems) {
            ODObject odTable;
            String ivid;
            String id;
            String tableName;
            StringBuffer buffer;
            ResultSet rs;
            if (!odNext.isSelected()) continue;
            if (odNext.branches.size() == 0) {
                rs = null;
                if (nvstatement == null) {
                    buffer = new StringBuffer();
                    buffer.append("select  a.NAME,a.ID,a.ivid    ");
                    buffer.append("from CI_CLUSTERS a,sdd_folder_members b , i$sdd_wa_context cc ");
                    buffer.append("where ");
                    buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                    buffer.append(" and b.PARENT_IVID = ? ");
                    buffer.append("and cc.workarea_irid = ?  and a.ivid = cc.object_ivid and cc.wastebasket ='N' ");
                    buffer.append(" order by name ");
                    nvstatement = sqlConnection.prepareStatement(buffer.toString());
                }
                try {
                    nvstatement.setString(1, odNext.getIrid());
                    nvstatement.setString(2, odNext.ivid);
                    nvstatement.setString(3, odNext.wa_irid);
                    rs = nvstatement.executeQuery();
                }
                catch (SQLException e) {
                    LOGGER.error("ODOCluster.extract(): " + e.getMessage());
                }
                if (rs == null) continue;
                while (rs.next()) {
                    tableName = rs.getString(1);
                    id = rs.getString(2);
                    ivid = rs.getString(3);
                    odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                    odTable.ivid = ivid;
                    odTable.setParentName(odNext.getName());
                    odTable.setParentID(odNext.getIrid());
                    list.add(odTable);
                }
                rs.close();
                continue;
            }
            if (odNext.branch == null) continue;
            rs = null;
            if (statement == null) {
                buffer = new StringBuffer();
                buffer.append("select  a.NAME,a.ID,a.ivid ");
                buffer.append("from CI_CLUSTERS a,sdd_folder_members b ");
                buffer.append("where ");
                buffer.append(" a.ID = b.member_object and b.folder_reference = ? ");
                buffer.append(" and b.PARENT_IVID = ? ");
                buffer.append("AND EXISTS \n");
                buffer.append("(SELECT 1 \n");
                buffer.append("FROM CI_CLUSTERS F, \n");
                buffer.append("  I$sdd_Wa_Context C \n");
                buffer.append("WHERE a.Irid        = F.Irid \n");
                buffer.append("AND F.Ivid          = C.Object_Ivid \n");
                buffer.append("AND C.Workarea_Irid = ? \n");
                buffer.append(")");
                buffer.append(" and a.ivid = ");
                buffer.append(" (select ivid from i$sdd_object_versions v ");
                buffer.append("  where ");
                buffer.append("  a.id = v.irid and ");
                buffer.append("  branch_id = ? ");
                buffer.append("  and sequence_in_branch  is not null");
                buffer.append("  and wastebasket='N' ");
                buffer.append("  and sequence_in_branch = ");
                buffer.append("   ( ");
                buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                buffer.append("     where ");
                buffer.append("     v2.irid = a.id");
                buffer.append("     and branch_id = ? ");
                buffer.append("     and sequence_in_branch  is not null ");
                buffer.append("     and wastebasket='N' ");
                buffer.append("   ) ");
                buffer.append("  )");
                buffer.append(" order by name ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            try {
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
                statement.setString(4, odNext.branch.getId());
                statement.setString(5, odNext.branch.getId());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOCluster.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                tableName = rs.getString(1);
                id = rs.getString(2);
                ivid = rs.getString(3);
                odTable = new ODObject(false, tableName, OBJECT_TYPE, id);
                odTable.ivid = ivid;
                odTable.branch = odNext.branch;
                odTable.setParentName(odNext.getName());
                odTable.setParentID(odNext.getIrid());
                odTable.branch = odNext.branch;
                list.add(odTable);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (nvstatement != null) {
            nvstatement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        this.col_statement = null;
        this.ind_statement = null;
        for (ODObject odObject : selectedObjects) {
            if (!OBJECT_TYPE.equalsIgnoreCase(odObject.getType())) continue;
            String id = odObject.getIrid();
            if (statement == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("CLUSTER_SIZE").append(',');
                buffer.append("CLUSTER_TYPE").append(',');
                buffer.append("HASH_IS").append(',');
                buffer.append("HASHKEYS").append(',');
                buffer.append("REMARK").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("CI_CLUSTERS").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("ivid").append('=').append(" ? ");
                statement = sqlConnection.prepareStatement(buffer.toString());
            }
            ResultSet rs = null;
            try {
                statement.setString(1, odObject.ivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODOCluster.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    int clusterSize = rs.getInt("CLUSTER_SIZE");
                    String clusterType = rs.getString("CLUSTER_TYPE");
                    String hashIs = rs.getString("HASH_IS");
                    String remark = rs.getString("REMARK");
                    int hashKeys = rs.getInt("HASHKEYS");
                    String ivid = odObject.ivid;
                    StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                    ClusterOracle cluster = null;
                    StorageObject obj = storage.getStorageObject(id);
                    if (obj instanceof ClusterOracle) {
                        cluster = (ClusterOracle)obj;
                    }
                    if (cluster == null) {
                        cluster = storage.getClusterSet().createCluster();
                        if (obj == null) {
                            cluster.setObjectID(id);
                        }
                    }
                    cluster.setName(odObject.getName());
                    this.getExtractionHandler().addToImportedObjects(id, cluster);
                    this.setNotesAndComments(sqlConnection, cluster, id, ivid);
                    cluster.setCommentInRDBMS(remark);
                    cluster.setSize(clusterSize);
                    if ("ICL".equalsIgnoreCase(clusterType)) {
                        cluster.setIndexed("YES");
                    } else {
                        cluster.setIndexed("NO");
                        cluster.setHashExpression(hashIs);
                        cluster.setHashKeys(hashKeys);
                    }
                    this.initIndexes(sqlConnection, cluster, id, ivid);
                    this.initColumns(sqlConnection, cluster, id, ivid);
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.col_statement != null) {
            this.col_statement.close();
        }
        if (this.ind_statement != null) {
            this.ind_statement.close();
        }
    }

    public void initIndexes(Connection sqlConnection, ClusterOracle cluster, String clusterID, String ivid) throws Exception {
        if (this.ind_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(',');
            buffer.append("COMPUTE_STATISTICS_FLAG").append(',');
            buffer.append("REMARK").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("ci_indexes").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append(" parent_ivid = ? ");
            this.ind_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.ind_statement.setString(1, ivid);
            rs = this.ind_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOCluster.initIndexes(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString("NAME");
                String computeStats = rs.getString("COMPUTE_STATISTICS_FLAG");
                String comments = rs.getString("REMARK");
                ClusterIndexOracle index = ((StorageDesignOracle)this.getStorageDesign()).getClusterIndexSet().createClusterIndex();
                index.setName(name);
                index.setCluster(cluster);
                index.setComment(comments);
                if ("Y".equalsIgnoreCase(computeStats)) {
                    index.setComputeStatistics("YES");
                    continue;
                }
                index.setComputeStatistics("NO");
            }
            rs.close();
        }
    }

    public void initColumns(Connection sqlConnection, ClusterOracle cluster, String clusterID, String ivid) throws Exception {
        if (this.col_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(',');
            buffer.append("ID").append(',');
            buffer.append("DATATYPE").append(',');
            buffer.append("LENGTH").append(',');
            buffer.append("SCALE").append(' ').append("DECIMAL_PLACES").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("CI_CLUSTER_COLUMNS").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append(" parent_ivid = ? ");
            buffer.append("ORDER BY").append(' ').append("SEQUENCE_NUMBER");
            this.col_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.col_statement.setString(1, ivid);
            rs = this.col_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODOCluster.initColumns(): " + e.getMessage());
        }
        if (rs != null) {
            int pos = 0;
            while (rs.next()) {
                ++pos;
                String name = rs.getString("NAME");
                String columnID = rs.getString("ID");
                String datatype = rs.getString("DATATYPE");
                int length = rs.getInt("LENGTH");
                int scale = rs.getInt("DECIMAL_PLACES");
                ClusterColumnOracle column = ((StorageDesignOracle)this.getStorageDesign()).getClusterColumnSet().createClusterColumn();
                column.setName(name);
                column.setCluster(cluster);
                column.setPosition(pos);
                column.setDataType(datatype);
                if (length > 0) {
                    if (scale > 0) {
                        column.setLengthPrecision(String.valueOf(length) + ", " + String.valueOf(scale));
                    } else if (!"NUMBER".equals(datatype.trim())) {
                        column.setLengthPrecision(String.valueOf(length));
                    }
                }
                this.setNotesAndComments(sqlConnection, column, columnID);
            }
            rs.close();
        }
    }
}

