/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.OwnerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.UserGroupUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTablespaceUDBv81
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTablespaceUDBv81.class);

    public MOHTablespaceUDBv81(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT  tbspace,tbspacetype managed_by,datatype, ");
                buffer.append("extentsize,prefetchsize,ts.pagesize,  ");
                buffer.append("ts.dbpgname,transferrate, ");
                buffer.append("drop_recovery,remarks,overhead,bpname  ");
                buffer.append("from syscat.TABLESPACES ts,syscat.BUFFERPOOLS bp ");
                buffer.append("WHERE tbspace = '").append(name).append("'");
                buffer.append(" and ts.bufferpoolid = bp.bufferpoolid");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTablespaceUDBv81.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    TableSpaceUDB ts = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDB) {
                        StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                        ts = (TableSpaceUDBv81)storage.getTableSpaceSet().getByName(name);
                        if (ts == null) {
                            BufferPoolUDB bp;
                            String tbspace = rs.getString(1);
                            String managed = rs.getString(2);
                            String datatype = rs.getString(3);
                            int extentsize = rs.getInt(4);
                            int prefetchsize = rs.getInt(5);
                            int pagesize = rs.getInt(6);
                            String dbpgname = rs.getString(7);
                            float transferrate = rs.getFloat(8);
                            String drop_recovery = rs.getString(9);
                            String comment = rs.getString(10);
                            float overhead = rs.getFloat(11);
                            String bpname = rs.getString(12);
                            ts = storage.getTableSpaceSet().createTableSpace();
                            ts.setName(tbspace);
                            this.stampModelObject(ts, dbo);
                            ts.setDataType(datatype);
                            if ("D".equalsIgnoreCase(managed)) {
                                ts.setManagedBy("DATABASE");
                            }
                            if ((bp = (BufferPoolUDB)storage.getBufferPoolSet().getByName(bpname)) != null) {
                                ts.setBufferPool(bp);
                            }
                            ts.setDataType(this.getDataTypeTB(datatype));
                            ts.setExtentSize(String.valueOf(extentsize));
                            ts.setPrefetchSize(String.valueOf(prefetchsize));
                            ts.setPageSize(pagesize);
                            ts.setOverhead(overhead);
                            ts.setTransferRate(transferrate);
                            DBPartitionGroupUDBv81 group = (DBPartitionGroupUDBv81)storage.getNodeGroupSet().getByName(dbpgname);
                            if (group == null) {
                                group = (DBPartitionGroupUDBv81)storage.getNodeGroupSet().createNodeGroup();
                                group.setName(dbpgname);
                                this.stampModelObject((ModelObject)group, dbo.getSchema(), dbpgname);
                            }
                            ts.setNodeGroup(group);
                            if ("Y".equalsIgnoreCase(drop_recovery)) {
                                ts.setDroppedTableRecovery(true);
                            }
                            this.initTbprivileges(sqlConnection, ts);
                            ts.setCommentInRDBMS(comment);
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initTbprivileges(Connection sqlConnection, TableSpaceUDB ts) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  grantee,granteetype,useauth ");
            buffer.append("from syscat.tbspaceauth ");
            buffer.append("WHERE tbspace = '").append(ts.getName()).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceUDBv81.initTbprivileges():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                UserGroupUDBv81 group;
                String userOrGroup = rs.getString(1);
                String type = rs.getString(2);
                String grant = rs.getString(3);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
                if ("U".equalsIgnoreCase(type)) {
                    OwnerUDBv81 owner = (OwnerUDBv81)storage.getOwnerSet().getByName(userOrGroup);
                    if (owner != null) {
                        ts.setUsers(owner.getName());
                    }
                } else if ("G".equalsIgnoreCase(type) && (group = (UserGroupUDBv81)storage.getUserGroupSet().getByName(userOrGroup)) != null) {
                    ts.setGroups(group.getName());
                }
                if (!"Y".equalsIgnoreCase(grant)) continue;
                ts.setGrantOption("YES");
            }
            rs.close();
        }
        statement.close();
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT tbspace from syscat.TABLESPACES");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTablespaceUDBv81.extract(): ", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tsname = rs.getString(1);
                DBObject dboTs = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tsname, OBJECT_TYPE);
                list.add(dboTs);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    private String getDataTypeTB(String datatype) {
        if (datatype.equalsIgnoreCase("L")) {
            return "LARGE";
        }
        if (datatype.equalsIgnoreCase("T")) {
            return "SYSTEM TEMPORARY";
        }
        if (datatype.equalsIgnoreCase("U")) {
            return "USER TEMPORARY";
        }
        return "REGULAR";
    }
}

