/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.udb.v81.MOHTableUDBv81;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSummerTableUDBv81
extends MOHTableUDBv81 {
    public static final String OBJECT_TYPE = "SUMMARY TABLE";
    private static final Logger LOGGER = new Logger(MOHSummerTableUDBv81.class);

    public MOHSummerTableUDBv81(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TABNAME from SYSCAT.TABLES t").append(' ');
                buffer.append("WHERE TYPE = 'S' and TABSCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHSummerTableUDB.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, OBJECT_TYPE, dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TABNAME, ");
                buffer.append("TABSCHEMA, TABNAME, t.DEFINER, TYPE table_type, ");
                buffer.append("ROWTYPESCHEMA, ROWTYPENAME, TABLEID, KEYINDEXID PK_ID, ");
                buffer.append("TBSPACE, INDEX_TBSPACE, LONG_TBSPACE, PARTITION_MODE, ");
                buffer.append("DATACAPTURE, LOG_ATTRIBUTE, REMARKS, ");
                buffer.append("refresh,compression,clustered,v.text  ");
                buffer.append("from syscat.tables t,syscat.VIEWS v  ");
                buffer.append("WHERE TYPE = 'S' and TABSCHEMA = '");
                buffer.append(dbo.getSchema()).append("'");
                buffer.append(" AND TABNAME = '").append(dbo.getName()).append("'");
                buffer.append(" AND  v.viewname = t.tabname ");
                buffer.append(" AND v.viewschema = t.tabschema");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHSummerTableUDB.generate(): ");
            }
            Table table = null;
            TableProxyUDBv81 tableProxy = null;
            StorageDesign storageDesign = null;
            if (rs != null) {
                if (rs.next()) {
                    table = this.getDesign().getRelationalDesign().createTable();
                    table.setSchema(dbo.getSchema());
                    table.setName(dbo.getName());
                    this.stampModelObject(table, dbo);
                    table.setTypeID("4");
                    String tbspace = rs.getString("TBSPACE");
                    String schemaname = rs.getString("TABSCHEMA");
                    String indextspacename = rs.getString("INDEX_TBSPACE");
                    String longtspacename = rs.getString("LONG_TBSPACE");
                    String summaryQuery = rs.getString("TEXT");
                    String refresh = rs.getString("REFRESH");
                    TableSpaceUDBv81 ts = null;
                    TableSpaceUDBv81 indextspace = null;
                    TableSpaceUDBv81 longtspace = null;
                    SchemaUDBv81 schema = null;
                    storageDesign = this.getStorageDesign();
                    if (storageDesign instanceof StorageDesignUDBv81) {
                        tableProxy = (TableProxyUDBv81)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy != null) {
                            tableProxy.setName(dbo.getName());
                            ts = this.getTableSpace(storageDesign, tbspace);
                            if (ts != null) {
                                tableProxy.setTableSpace(ts);
                            }
                            if ((indextspace = this.getTableSpace(storageDesign, indextspacename)) != null) {
                                tableProxy.setIndexInTableSpace(indextspace);
                            }
                            if ((longtspace = this.getTableSpace(storageDesign, longtspacename)) != null) {
                                tableProxy.setLongInTableSpace(longtspace);
                            }
                            table.setMaterializedQueryTable(true);
                            tableProxy.setSummaryQuery("YES");
                            String select = summaryQuery.toUpperCase().substring(summaryQuery.indexOf("SELECT") - 2);
                            select = Token.getValBetweenBrackets(select);
                            table.setUserDefinedSQL(select);
                            table.setSyntaxProvider("DB2");
                            if ("I".equalsIgnoreCase(refresh)) {
                                tableProxy.setSummaryRefreshOptions(TableProxyUDB.getSummaryRefreshOptionsChoices()[1]);
                            }
                            if ((schema = (SchemaUDBv81)((StorageDesignUDBv81)storageDesign).getSchemaSet().getByName(schemaname.trim())) != null) {
                                tableProxy.setSchema(schema);
                                tableProxy.setOwner(schema.getOwner());
                            }
                            this.initTriggers(sqlConnection, tableProxy);
                            this.setProperties(tableProxy, (StorageDesignUDBv81)storageDesign, rs);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    this.initColumns(sqlConnection, tableProxy, dbo);
                    this.initColumnConstraints(sqlConnection, table, schemaname);
                    this.initTableConstraints(sqlConnection, table, schemaname);
                    this.initUniqueConstraints(sqlConnection, table, schemaname);
                    this.initIndexes(sqlConnection, table, schemaname);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }
}

