/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxySetUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHStagingTableUDBv81
extends MOHTable {
    public static final String OBJECT_TYPE = "STAGING TABLE";
    private static final Logger LOGGER = new Logger(MOHStagingTableUDBv81.class);

    public MOHStagingTableUDBv81(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TABNAME from SYSCAT.TABLES t,syscat.VIEWS v ").append(' ');
                buffer.append("WHERE TYPE = 'T' and TABSCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                buffer.append(" AND v.VIEWNAME = t.TABNAME ");
                buffer.append(" AND v.VIEWSCHEMA = t.TABSCHEMA");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHStagingTableUDBv81.extract(): ", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, OBJECT_TYPE, dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT TABNAME from SYSCAT.TABLES t,syscat.VIEWS v ").append(' ');
                buffer.append("WHERE TYPE = 'T' and TABSCHEMA = '");
                buffer.append(dbo.getSchema()).append("'");
                buffer.append(" AND TABNAME = '").append(dbo.getName()).append("'");
                buffer.append(" AND v.VIEWNAME = t.TABNAME ");
                buffer.append(" AND v.VIEWSCHEMA = t.TABSCHEMA");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHStagingTableUDBv81.generate(): ");
            }
            if (rs != null) {
                while (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81)) continue;
                    StorageDesignUDBv81 storage = (StorageDesignUDBv81)storageDesign;
                    StagingTableUDBv81 staging = (StagingTableUDBv81)storage.getStagingTableSet().createStagingTable();
                    staging.setName(dbo.getName());
                    this.setTable(sqlConnection, staging, dbo.getSchema());
                    this.initColumns(sqlConnection, staging, dbo);
                    this.stampModelObject(staging, dbo);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setTable(Connection sqlConnection, StagingTableUDBv81 staging, String schemaName) throws SQLException {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT BSCHEMA, BNAME  from syscat.tabdep ").append(' ');
            buffer.append("WHERE  TABSCHEMA = '");
            buffer.append(schemaName).append("'");
            buffer.append(" AND TABNAME = '").append(staging.getName()).append("'");
            buffer.append(" AND BTYPE = 'S' ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableDB2v80.extract(): ");
        }
        if (rs != null) {
            while (rs.next()) {
                StorageDesignUDBv81 storage;
                TableProxyUDBv81 table;
                String tableName = rs.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv81) || (table = (TableProxyUDBv81)((TableProxySetUDBv81)(storage = (StorageDesignUDBv81)storageDesign).getTableProxySet()).getByName(tableName)) == null) continue;
                staging.setTable(table);
            }
            rs.close();
        }
        statement.close();
    }

    private void initColumns(Connection sqlConnection, StagingTableUDBv81 tableProxy, DBObject dbo) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABSCHEMA").append(',');
            buffer.append("TABNAME").append(',');
            buffer.append("COLNAME").append(',');
            buffer.append("COLNO").append(',');
            buffer.append("TYPESCHEMA").append(',');
            buffer.append("TYPENAME").append(',');
            buffer.append("LENGTH").append(',');
            buffer.append("scale").append(',');
            buffer.append("DEFAULT").append(',');
            buffer.append("NULLS").append(',');
            buffer.append("LOGGED").append(',');
            buffer.append("COMPACT").append(',');
            buffer.append("CODEPAGE").append(',');
            buffer.append("TARGET_TYPESCHEMA").append(',');
            buffer.append("SCOPE_TABSCHEMA").append(',');
            buffer.append("SCOPE_TABNAME").append(',');
            buffer.append("IDENTITY").append(',');
            buffer.append("GENERATED").append(',');
            buffer.append("TEXT").append(',');
            buffer.append("REMARKS").append(',');
            buffer.append("SPECIAL_PROPS").append(',');
            buffer.append("DL_FEATURES").append(',');
            buffer.append("PARTKEYSEQ").append(',');
            buffer.append("COMPRESS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("SYSCAT").append('.').append("COLUMNS").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABSCHEMA").append('=');
            buffer.append('\'').append(dbo.getSchema()).append('\'');
            buffer.append("AND").append(' ');
            buffer.append("TABNAME").append('=');
            buffer.append('\'').append(dbo.getName()).append('\'');
            buffer.append("ORDER BY").append(' ').append("COLNO");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHStagingTableUDBv81.initColumns():", e);
        }
        if (rs != null) {
            tableProxy.setDefineColumnNames(true);
            while (rs.next()) {
                String colName = rs.getString("COLNAME");
                tableProxy.setColumns(colName);
            }
            rs.close();
        }
        statement.close();
    }
}

