/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUserGroupUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "USERGROUP";
    private static final Logger LOGGER = new Logger(MOHUserGroupUDB.class);

    public MOHUserGroupUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String schemaName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select grantee group,alterinauth, ");
                buffer.append("createinauth,dropinauth ");
                buffer.append("from syscat.schemaauth ");
                buffer.append("where schemaname = '");
                buffer.append(schemaName).append("'");
                buffer.append(" and granteetype = 'G'");
                buffer.append(" and grantee = '").append(name).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHUserGroupUDB.generate():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    StorageDesignUDB storage;
                    String grantee = rs.getString(1);
                    UserGroupUDB group = null;
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB) || (group = (UserGroupUDB)(storage = (StorageDesignUDB)storageDesign).getUserGroupSet().getByName(grantee)) != null) continue;
                    group = storage.getUserGroupSet().createUserGroup();
                    group.setName(grantee);
                    this.stampModelObject(group, dbo);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            String schemaName = dboNext.getName();
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select grantee group,alterinauth, ");
                buffer.append("createinauth,dropinauth ");
                buffer.append("from syscat.schemaauth ");
                buffer.append("where schemaname = '");
                buffer.append(schemaName).append("'");
                buffer.append(" and granteetype = 'G'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHUserGroupUDB.extract():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String userName = rs.getString(1);
                    DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), userName.trim(), OBJECT_TYPE, schemaName);
                    list.add(dboUser);
                }
                rs.close();
            }
            statement.close();
        }
        return list;
    }
}

