/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSchemaPrivilegesUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SCHEMA_OBJECT";
    private static final Logger LOGGER = new Logger(MOHSchemaPrivilegesUDB.class);

    public MOHSchemaPrivilegesUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesignUDB storage = (StorageDesignUDB)this.getStorageDesign();
        for (SchemaUDB schema : storage.getSchemaSet()) {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select ");
                buffer.append("grantee user,granteetype,alterinauth,createinauth,dropinauth ");
                buffer.append("from syscat.schemaauth ");
                buffer.append("where ");
                buffer.append("schemaname = '").append(schema.getName()).append("'");
                buffer.append(" and granteetype in ('U','G')");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (Exception e) {
                System.out.println("MOHSchemaPrivilegesUDB.generate(): " + e.getMessage());
                LOGGER.error("MOHSchemaObjectsUDB.generate():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String userOrGroupName = rs.getString(1);
                    String type = rs.getString(2);
                    String alter = rs.getString(3);
                    String create = rs.getString(4);
                    String dropIn = rs.getString(5);
                    PrivilegesUDB privilege = null;
                    StorageObject userOrGroup = this.getUserOrGroup(storage, userOrGroupName, type);
                    if (userOrGroup == null || (privilege = this.getPrivileges(storage, schema, userOrGroup)) == null) continue;
                    if ("U".equalsIgnoreCase(type)) {
                        privilege.setUser((OwnerUDB)userOrGroup);
                    } else {
                        privilege.setGroup((UserGroupUDB)userOrGroup);
                    }
                    this.initPrivileges(privilege, (String)PrivilegesUDB.getPrivilegesValues().get(0), alter);
                    this.initPrivileges(privilege, (String)PrivilegesUDB.getPrivilegesValues().get(1), create);
                    this.initPrivileges(privilege, (String)PrivilegesUDB.getPrivilegesValues().get(2), dropIn);
                }
                rs.close();
            }
            statement.close();
        }
    }

    private StorageObject getUserOrGroup(StorageDesignUDB storage, String userOrGroup, String type) {
        if ("U".equalsIgnoreCase(type) && storage.getOwnerSet().getByName(userOrGroup) != null) {
            return (StorageObject)storage.getOwnerSet().getByName(userOrGroup);
        }
        if ("G".equalsIgnoreCase(type) && storage.getUserGroupSet().getByName(userOrGroup) != null) {
            return (StorageObject)storage.getUserGroupSet().getByName(userOrGroup);
        }
        return null;
    }

    private PrivilegesUDB getPrivileges(StorageDesignUDB storageDesign, SchemaUDB schema, Object user) {
        PrivilegesUDB priv2;
        for (PrivilegesUDB priv2 : storageDesign.getPrivilegesSet()) {
            if (priv2.getSchema() != schema || priv2.getUser() != user && priv2.getGroup() != user) continue;
            return priv2;
        }
        priv2 = storageDesign.getPrivilegesSet().createPriv();
        priv2.setSchema(schema);
        return priv2;
    }

    private void initPrivileges(PrivilegesUDB priv, String privName, String privType) {
        if ("Y".equalsIgnoreCase(privType)) {
            priv.setSystemPrivileges(privName);
        }
        if ("G".equalsIgnoreCase(privType)) {
            priv.setSystemPrivileges(privName);
            priv.setGrantOption("YES");
        }
    }
}

