/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHPartitionGroupUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "PARTITION GROUP";
    private static final Logger LOGGER = new Logger(MOHPartitionGroupUDB.class);

    public MOHPartitionGroupUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select  dbpgname,remarks ");
            buffer.append("from syscat.DBPARTITIONGROUPS");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHPartitionGroupUDB.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String dbpgname = rs.getString(1);
                String comment = rs.getString(2);
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71)) continue;
                StorageDesignUDBv71 storage = (StorageDesignUDBv71)storageDesign;
                NodeGroupUDBv71 group = (NodeGroupUDBv71)storage.getNodeGroupSet().getByName(dbpgname);
                if (group == null) {
                    group = (NodeGroupUDBv71)storage.getNodeGroupSet().createNodeGroup();
                    group.setName(dbpgname);
                    this.stampModelObject((ModelObject)group, "", dbpgname);
                }
                group.setCommentInRDBMS(comment);
            }
            rs.close();
        }
        statement.close();
    }
}

