/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeUDB.class);

    public MOHDatatypeUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String schemaName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT  TYPENAME,SOURCESCHEMA,SOURCENAME,METATYPE,LENGTH,SCALE,  ");
                buffer.append("ATTRCOUNT,INSTANTIABLE,FINAL,INLINE_LENGTH,REMARKS,WITH_FUNC_ACCESS,  ");
                buffer.append("JARSCHEMA,JAR_ID,CLASS,SQLJ_REPRESENTATION,NATURAL_INLINE_LENGTH ");
                buffer.append("FROM syscat.DATATYPES ");
                buffer.append("WHERE TYPESCHEMA = '");
                buffer.append(schemaName).append("'");
                buffer.append(" AND TYPENAME = '").append(name).append("'");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatatypeUDB.generate():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String typeName = rs.getString(1);
                    String sourceName = rs.getString(3);
                    String size = rs.getString(5);
                    String scale = rs.getString(6);
                    DistinctType dtype = this.getDesign().getDataTypesDesign().createDistinctType();
                    dtype.setName(typeName);
                    this.stampModelObject(dtype, dbo);
                    LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), sourceName);
                    if (logicalDT == null) {
                        logicalDT = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(sourceName, this.getDbmeHandler().getRDBMSSite().getType().getName());
                    }
                    if (logicalDT == null) continue;
                    dtype.setLogicalDataType(logicalDT);
                    if (MOHDatatypeUDB.hasSize(sourceName)) {
                        dtype.setSize(size);
                        continue;
                    }
                    if (MOHDatatypeUDB.hasPrecision(sourceName)) {
                        dtype.setPrecision(Integer.parseInt(size));
                    }
                    if (!MOHDatatypeUDB.hasScale(sourceName)) continue;
                    dtype.setScale(Integer.parseInt(scale));
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    public static boolean hasSize(String type) {
        if (type != null) {
            if (type.toUpperCase().indexOf("CHAR") > -1 && type.toUpperCase().indexOf("LONG") == -1) {
                return true;
            }
            if (type.toUpperCase().indexOf("LOB") > -1) {
                return true;
            }
            if (type.toUpperCase().indexOf("GRAPH") > -1 && type.toUpperCase().indexOf("LONG") == -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasPrecision(String type) {
        if (type != null) {
            if (type.toUpperCase().indexOf("FLOAT") > -1) {
                return true;
            }
            if (type.toUpperCase().indexOf("NUM") > -1) {
                return true;
            }
            if (type.toUpperCase().indexOf("DEC") > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasScale(String type) {
        if (type != null) {
            if (type.toUpperCase().indexOf("NUM") > -1) {
                return true;
            }
            if (type.toUpperCase().indexOf("DEC") > -1) {
                return true;
            }
        }
        return false;
    }
}

