/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHBufferpoolUDB
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "BUFFERPOOL";
    private static final Logger LOGGER = new Logger(MOHBufferpoolUDB.class);

    public MOHBufferpoolUDB(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select ");
                buffer.append("bpname,bufferpoolid,ngname,npages,pagesize, ");
                buffer.append("estore,numblockpages,blocksize ");
                buffer.append("FROM syscat.BUFFERPOOLS  ");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (Exception e) {
                LOGGER.error("MOHBufferpoolUDB.generate():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String dbPartitionGroup = rs.getString(3);
                    int size = rs.getInt(4);
                    int pagesize = rs.getInt(5);
                    String estore = rs.getString(6);
                    String bfpoolId = rs.getString(2);
                    BufferPoolUDB bfpool = null;
                    StorageDesignUDB storage = (StorageDesignUDB)this.getStorageDesign();
                    if (storage == null) continue;
                    bfpool = (BufferPoolUDB)storage.getBufferPoolSet().getByName(name);
                    if (bfpool == null) {
                        bfpool = storage.getBufferPoolSet().createBufferPool();
                        bfpool.setName(name);
                        this.stampModelObject(bfpool, dbo);
                    }
                    bfpool.setSize(size);
                    if (dbPartitionGroup != null) {
                        bfpool.setScope(dbPartitionGroup);
                    }
                    if (pagesize != 0) {
                        bfpool.setPageSize(pagesize / 1024);
                    }
                    if ("Y".equalsIgnoreCase(estore)) {
                        bfpool.setExtendedStorage(true);
                    }
                    String diffSizePart = this.getDiffSizePartitions(sqlConnection, bfpoolId);
                    bfpool.setNodesWithDiffSize(diffSizePart);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private String getDiffSizePartitions(Connection sqlConnection, String bfpoolId) throws Exception {
        StringBuffer result = new StringBuffer();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select ");
            buffer.append(" dbpartitionnum,npages ");
            buffer.append("FROM syscat.BUFFERPOOLDBPARTITIONS ");
            buffer.append("where BUFFERPOOLID = ").append(bfpoolId);
            buffer.append(" order by DBPARTITIONNUM");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHBufferpoolUDB.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String dbpartitionnum = rs.getString(1);
                String npages = rs.getString(2);
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(dbpartitionnum).append(" size ").append(npages);
            }
            rs.close();
        }
        statement.close();
        return result.toString();
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select distinct bpname ");
            buffer.append("FROM syscat.BUFFERPOOLS  ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHBufferpoolUDB.generate():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String dimName = rs.getString(1);
                DBObject dboDim = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, OBJECT_TYPE);
                list.add(dboDim);
            }
            rs.close();
        }
        statement.close();
        return list;
    }
}

