/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHRuleSqlServerv2k5
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "RULE";
    private static final Logger LOGGER = new Logger(MOHRuleSqlServerv2k5.class);

    public MOHRuleSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            String ruleId = dbo.getId();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("USE").append(' ');
                buffer.append(MOHRuleSqlServerv2k5.getFormattedName(db)).append(' ');
                buffer.append("SELECT").append(' ');
                buffer.append(" text,encrypted ");
                buffer.append("FROM").append(' ');
                buffer.append("dbo.syscomments  ");
                buffer.append("WHERE").append(' ');
                buffer.append("ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append(ruleId);
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHRuleSqlServer.generate():", e);
            }
            if (rs != null && rs.next()) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    RuleSqlServer rule = storage.getRuleSet().createRule();
                    rule.setName(name);
                    this.stampModelObject((ModelObject)rule, dbo.getSchema(), name);
                    String text = rs.getString(1);
                    rule.setDatabase(database);
                    this.setSchema(rule, dbo.getSchema());
                    this.setText(rule, text);
                    this.bindColumns(rule, storage, ruleId, db, sqlConnection);
                    this.bindToUserDefinedTypes(rule, storage);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void bindToUserDefinedTypes(RuleSqlServer rule, StorageDesignSqlServer storage) {
        String longName = rule.getLongName();
        if (((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).getRuleMap().containsKey(longName)) {
            List listId = (List)((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).getRuleMap().get(longName);
            for (String id : listId) {
                UsedUserDefinedDatav2k5 usedDT = (UsedUserDefinedDatav2k5)storage.getUsedUserDefinedDataSet().getById(id);
                if (usedDT == null) continue;
                usedDT.setRuleObject(rule);
            }
        }
    }

    private void setSchema(RuleSqlServer rule, String username) {
        SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)rule.getDatabase().getSchemas().getByName(username);
        rule.setSchema(schema);
    }

    private void bindColumns(RuleSqlServer rule, StorageDesignSqlServer storage, String rule_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("col.name columnname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("obj.name tablename").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHRuleSqlServerv2k5.getFormattedName(db)).append('.').append("dbo.syscolumns col").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHRuleSqlServerv2k5.getFormattedName(db)).append('.').append("dbo.sysobjects obj").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("col.domain").append(' ');
            buffer.append('=').append(' ');
            buffer.append(rule_id).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("col").append('.').append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("obj").append('.').append("ID").append(' ');
            rs = statement.executeQuery(buffer.toString());
            TableProxySetSqlServer tableSet = (TableProxySetSqlServer)storage.getTableProxySet();
            if (rs != null) {
                while (rs.next()) {
                    ColumnProxySqlServer c;
                    String col = rs.getString(1);
                    String table = rs.getString(2);
                    TableProxySqlServer t = tableSet.getByName(table);
                    if (t == null || (c = (ColumnProxySqlServer)t.getColumnProxyByName(col)) == null) continue;
                    rule.setColumns(c.getLongName());
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRuleSqlServer.bindColumns():", e);
        }
    }

    private void setText(RuleSqlServer rule, String text) throws Exception {
        String definition = Token.getStringAfterToken(text.replaceAll("[\n]", " "), "AS");
        rule.setExpression(definition.trim());
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbo) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String dbName = dbo.getDb();
        String uid = dbo.getId();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("UID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHRuleSqlServerv2k5.getFormattedName(dbName)).append('.').append("dbo.sysobjects s").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("R").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(uid);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHRuleSqlServer.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String ruleName = rs.getString(1);
                String ruleId = rs.getString(2);
                DBObjectSqlServer dboRule = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), ruleName, OBJECT_TYPE, dbo.getName());
                dboRule.setDb(dbName);
                dboRule.setId(ruleId);
                list.add(dboRule);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

