/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDefaultSqlServerv2k5
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DEFAULT";
    private static final Logger LOGGER = new Logger(MOHDefaultSqlServerv2k5.class);

    public MOHDefaultSqlServerv2k5(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            String defId = dbo.getId();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("USE").append(' ');
                buffer.append(MOHDefaultSqlServerv2k5.getFormattedName(db)).append(' ').append("\n");
                buffer.append(';').append("\n").append("\n");
                buffer.append("SELECT").append(' ');
                buffer.append("text,encrypted ");
                buffer.append("FROM").append(' ');
                buffer.append("dbo.syscomments ").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append(defId);
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHDefaultSqlServerv2k5.generate():", e);
            }
            ArrayList<String> list = new ArrayList<String>();
            if (rs != null && rs.next()) {
                String text = rs.getString(1);
                list.add(text);
            }
            if (statement != null) {
                statement.close();
            }
            for (String text : list) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    DefaultSqlServer def = storage.getDefaultSet().createDefault();
                    def.setName(name);
                    def.setDataBase(database);
                    this.setSchema(def, dbo.getSchema());
                    this.setText(def, text);
                    this.stampModelObject((ModelObject)def, dbo.getSchema(), name);
                    this.bindColumns(def, storage, defId, db, sqlConnection);
                    this.bindToUserDefinedTypes(def, storage);
                    continue;
                }
                LOGGER.error("Unable to find Storage Design!");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void bindToUserDefinedTypes(DefaultSqlServer def, StorageDesignSqlServer storage) {
        String longName = def.getLongName();
        if (((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).getDefaultMap().containsKey(longName)) {
            List listId = (List)((DBMExtractionHandlerSQLServer)this.getDbmeHandler()).getDefaultMap().get(longName);
            for (String id : listId) {
                UsedUserDefinedDatav2k5 usedDT = (UsedUserDefinedDatav2k5)storage.getUsedUserDefinedDataSet().getById(id);
                if (usedDT == null) continue;
                usedDT.setDefaultObject(def);
            }
        }
    }

    private void setSchema(DefaultSqlServer def, String username) {
        SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)def.getDataBase().getSchemas().getByName(username);
        def.setSchema(schema);
    }

    private void bindColumns(DefaultSqlServer def, StorageDesignSqlServer storage, String rule_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("col.name columnname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("obj.name tablename").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDefaultSqlServerv2k5.getFormattedName(db)).append('.').append("dbo.syscolumns col").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHDefaultSqlServerv2k5.getFormattedName(db)).append('.').append("dbo.sysobjects obj").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("col.cdefault").append(' ');
            buffer.append('=').append(' ');
            buffer.append(rule_id).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("col").append('.').append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("obj").append('.').append("ID").append(' ');
            rs = statement.executeQuery(buffer.toString());
            TableProxySetSqlServer tableSet = (TableProxySetSqlServer)storage.getTableProxySet();
            if (rs != null) {
                while (rs.next()) {
                    ColumnProxySqlServer c;
                    String col = rs.getString(1);
                    String table = rs.getString(2);
                    TableProxySqlServer t = tableSet.getByName(table);
                    if (t == null || (c = (ColumnProxySqlServer)t.getColumnProxyByName(col)) == null) continue;
                    c.setDefineDefault(true);
                    c.setDefaultObject(def);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRuleSqlServer.bindColumns():", e);
        }
    }

    private void setText(DefaultSqlServer def, String text) throws Exception {
        String definition = Token.getStringAfterToken(text, "AS");
        definition = Token.getValBetweenQuotes(definition);
        def.setConstant(definition.trim());
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbo) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String dbName = dbo.getDb();
        String uid = dbo.getId();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHDefaultSqlServerv2k5.getFormattedName(dbName)).append(' ').append("\n");
            buffer.append(';').append("\n").append("\n");
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("UID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDefaultSqlServerv2k5.getFormattedName(dbName)).append('.').append("dbo.sysobjects s").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("D").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append(1).append(' ');
            buffer.append('=').append(' ');
            buffer.append('(').append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("OBJECTPROPERTY ( s.id ,'IsDefault')").append(' ');
            buffer.append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(uid);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHDefaultSqlServerv2k5.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String defName = rs.getString(1);
                String defId = rs.getString(2);
                DBObjectSqlServer dboDef = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), defName, OBJECT_TYPE, dbo.getName());
                dboDef.setDb(dbName);
                dboDef.setId(defId);
                list.add(dboDef);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

