/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUserSqlServer
extends MOHandlerSqlServer {
    public static final String OBJECT_TYPE = "USER";
    private static final Logger LOGGER = new Logger(MOHUserSqlServer.class);

    public MOHUserSqlServer(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                UserSqlServer user;
                StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                DataBaseSqlServer database = null;
                if (!"".equalsIgnoreCase(db)) {
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                } else {
                    database = (DataBaseSqlServer)storage.getDataBaseSet().getNullInstance();
                }
                if ((user = (UserSqlServer)storage.getUserSet().getByName(name)) == null) {
                    user = storage.getUserSet().createUser();
                    user.setName(name);
                    this.stampModelObject((ModelObject)user, db, name);
                }
                String user_id = this.getUserId(name, db, sqlConnection);
                String loginname = this.getLogin(name, db, sqlConnection);
                if (loginname != null) {
                    LoginSqlServer login = (LoginSqlServer)storage.getLoginSet().getByName(loginname);
                    if (login == null) {
                        login = storage.getLoginSet().createLogin();
                        login.setName(loginname);
                        this.stampModelObject((ModelObject)login, dbo.getSchema(), loginname);
                    }
                    user.setLogin(login);
                    login.setUsers(name);
                }
                user.setDatabase(database);
                if (user_id != null) {
                    this.initPrivileges(user, user_id, db, sqlConnection);
                }
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initPrivileges(UserSqlServer user, String user_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("DB_PRIV").append(' ');
            buffer.append('=').append(' ');
            buffer.append(" case action ");
            buffer.append(" when 178 then 'CREATE FUNCTION'");
            buffer.append(" when 198 then 'CREATE TABLE'");
            buffer.append(" when 203 then 'CREATE DATABASE'");
            buffer.append(" when 207 then 'CREATE VIEW'");
            buffer.append(" when 222 then 'CREATE PROCEDURE'");
            buffer.append(" when 228 then 'BACKUP DATABASE'");
            buffer.append(" when 233 then 'CREATE DEFAULT'");
            buffer.append(" when 235 then 'BACKUP LOG'");
            buffer.append(" when 236 then 'CREATE RULE'");
            buffer.append(" end").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHUserSqlServer.getFormattedName(db)).append('.').append("dbo.sysprotects").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("protecttype in (204,205)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("action in (178,198,203,207,222,228,233,235,236)").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(user_id).append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    user.setSystemPrivileges(rs.getString(1));
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHUserSqlServer.bindColumns():", e);
        }
    }

    private String getUserId(String username, String db, Connection sqlConnection) {
        String user_id = null;
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("u").append('.').append("UID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("master.dbo.syslogins l").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHUserSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("l").append('.').append("sid").append(' ');
            buffer.append('=').append(' ');
            buffer.append("u").append('.').append("sid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append('=').append(' ').append('\'');
            buffer.append(username).append('\'').append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null && rs.next()) {
                user_id = rs.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHUserSqlServer.getUserId():", e);
        }
        return user_id;
    }

    private String getLogin(String username, String db, Connection sqlConnection) {
        String login = null;
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("l.loginname").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("master.dbo.syslogins l").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHUserSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("l").append('.').append("sid").append(' ');
            buffer.append('=').append(' ');
            buffer.append("u").append('.').append("sid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append('=').append(' ').append('\'');
            buffer.append(username).append('\'').append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null && rs.next()) {
                login = rs.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRuleSqlServer.getLogin():", e);
        }
        return login;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBUserSqlServer> list = new ArrayList<DBUserSqlServer>();
        Iterator it = schemas.iterator();
        String dbName = null;
        while (it.hasNext()) {
            DBUserSqlServer dbo;
            DBObject dboNext = (DBObject)it.next();
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer) || (dbName = !this.containsDboForDb(schemas, dbo = (DBUserSqlServer)dboNext) ? dbo.getDb() : null) == null) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(' ').append(',');
                buffer.append("UID").append(' ').append(',');
                buffer.append("sid").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHUserSqlServer.getFormattedName(dbName)).append(".dbo.sysusers").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("getUsers(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String userName = rs.getString(1);
                    String uid = rs.getString(2);
                    DBUserSqlServer dboUser = new DBUserSqlServer(AbstractDBMExtractionHandler.isAllSelected(), userName, OBJECT_TYPE, userName);
                    dboUser.setUid(uid);
                    dboUser.setDb(dbName);
                    list.add(dboUser);
                }
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

