/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHCommentsSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHDatabaseSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHDatatypeSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHDefaultSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHForeignKeySQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHLoginSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHPermissionsSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHProcedureSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHRoleSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHRuleSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHTableSQLServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHViewSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHDatabaseSqlServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHRoleSqlServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHSequenceSqlServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHTableSQLServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k12.MOHUserSqlServerv2k12;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHDatabaseSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHDatatypeSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHDefaultSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHForeignKeySQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHLoginSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionColumnSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHPermissionsSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHProcedureSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHRoleSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHRuleSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHSchemaSqlServer2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHTableSQLServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHUserSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHViewSqlServerv2k5;
import oracle.dbtools.crest.imports.metadata.sqlserver.v2k5.MOHXMLSchemaCollection;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.JDBCUtils;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class DBMExtractionHandlerSQLServer
extends AbstractDBMExtractionHandler
implements DBMOConstants {
    private static final Logger LOGGER = new Logger(DBMExtractionHandlerSQLServer.class);
    private static DBMExtractionHandlerSQLServer dbmExtractionHandler;
    private List mohObjects = null;
    private List mohObjectsv2k5 = null;
    private List mohObjectsv2k12 = null;
    private ApplicationView view;
    private List loginList = null;
    private static final String SQL_SERVER_V2K = "Microsoft SQL Server 2000";
    private static final String SQL_SERVER_V2K5 = "Microsoft SQL Server 2005";
    private static final String SQL_SERVER_V2K8 = "Microsoft SQL Server 2008";
    private static final String SQL_SERVER_V2K12 = "Microsoft SQL Server 2012";
    private Map defaultMap = new HashMap();
    private Map ruleMap = new HashMap();
    private boolean defaultDBImpoted = false;

    private DBMExtractionHandlerSQLServer(ApplicationView view) {
        this.view = view;
    }

    public static AbstractDBMExtractionHandler getInstance(ApplicationView view) {
        if (dbmExtractionHandler == null) {
            dbmExtractionHandler = new DBMExtractionHandlerSQLServer(view);
        }
        return dbmExtractionHandler;
    }

    public static void clearInstance() {
        dbmExtractionHandler = null;
    }

    @Override
    public List getMOHObjects() {
        switch (this.dbMajorVersion) {
            case 0: {
                return this.getMOHObjectsv2k();
            }
            case 1: {
                return this.getMOHObjectsv2k5();
            }
            case 2: {
                return this.getMOHObjectsv2k8();
            }
            case 3: {
                return this.getMOHObjectsv2k12();
            }
        }
        return this.getMOHObjectsv2k12();
    }

    private List getMOHObjectsv2k5() {
        if (this.mohObjectsv2k5 == null) {
            this.mohObjectsv2k5 = new ArrayList();
            this.mohObjectsv2k5.add(new MOHSchemaSqlServer2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHDatatypeSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHDatabaseSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHLoginSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHUserSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHXMLSchemaCollection(this, this.view));
            this.mohObjectsv2k5.add(new MOHPartitionFunctionSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHTableSQLServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHForeignKeySQLServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHPartitionColumnSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHViewSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHDefaultSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHRoleSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHRuleSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHProcedureSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHPermissionsSqlServerv2k5(this, this.view));
            this.mohObjectsv2k5.add(new MOHCommentsSqlServer(this, this.view));
        }
        return this.mohObjectsv2k5;
    }

    private List getMOHObjectsv2k8() {
        return this.getMOHObjectsv2k5();
    }

    private List getMOHObjectsv2k12() {
        if (this.mohObjectsv2k12 == null) {
            this.mohObjectsv2k12 = new ArrayList();
            this.mohObjectsv2k12.add(new MOHSchemaSqlServer2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHDatatypeSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHDatabaseSqlServerv2k12(this, this.view));
            this.mohObjectsv2k12.add(new MOHLoginSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHUserSqlServerv2k12(this, this.view));
            this.mohObjectsv2k12.add(new MOHXMLSchemaCollection(this, this.view));
            this.mohObjectsv2k12.add(new MOHPartitionFunctionSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHTableSQLServerv2k12(this, this.view));
            this.mohObjectsv2k12.add(new MOHForeignKeySQLServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHPartitionColumnSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHViewSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHDefaultSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHRoleSqlServerv2k12(this, this.view));
            this.mohObjectsv2k12.add(new MOHRuleSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHProcedureSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHPermissionsSqlServerv2k5(this, this.view));
            this.mohObjectsv2k12.add(new MOHCommentsSqlServer(this, this.view));
            this.mohObjectsv2k12.add(new MOHSequenceSqlServerv2k12(this, this.view));
        }
        return this.mohObjectsv2k12;
    }

    public List getMOHObjectsv2k() {
        if (this.mohObjects == null) {
            this.mohObjects = new ArrayList();
            this.mohObjects.add(new MOHDatatypeSqlServer(this, this.view));
            this.mohObjects.add(new MOHDatabaseSqlServer(this, this.view));
            this.mohObjects.add(new MOHLoginSqlServer(this, this.view));
            this.mohObjects.add(new MOHUserSqlServer(this, this.view));
            this.mohObjects.add(new MOHTableSQLServer(this, this.view));
            this.mohObjects.add(new MOHForeignKeySQLServer(this, this.view));
            this.mohObjects.add(new MOHViewSqlServer(this, this.view));
            this.mohObjects.add(new MOHDefaultSqlServer(this, this.view));
            this.mohObjects.add(new MOHRoleSqlServer(this, this.view));
            this.mohObjects.add(new MOHRuleSqlServer(this, this.view));
            this.mohObjects.add(new MOHProcedureSqlServer(this, this.view));
            this.mohObjects.add(new MOHPermissionsSqlServer(this, this.view));
            this.mohObjects.add(new MOHCommentsSqlServer(this, this.view));
        }
        return this.mohObjects;
    }

    @Override
    public void init(Connection connection) {
        try {
            DatabaseMetaData dbmd = connection.getMetaData();
            try {
                this.dbProductName = dbmd.getDatabaseProductName();
                this.dbProductVersion = dbmd.getDatabaseProductVersion();
                this.dbMajorVersion = this.getDatabaseMajorVersion(connection);
            }
            catch (Throwable e) {
                System.out.println(e.getMessage());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public List getSchemas(Connection conn) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        if (conn != null) {
            this.init(conn);
            ResultSet resultSet = conn.getMetaData().getCatalogs();
            List userList = null;
            ArrayList<String> dbs = new ArrayList<String>();
            while (resultSet.next()) {
                String db = resultSet.getString(1);
                dbs.add(db);
            }
            resultSet.close();
            for (String db : dbs) {
                if (this.dbMajorVersion == 0) {
                    userList = this.getUsers(db, conn);
                } else if (this.dbMajorVersion == 1 || this.dbMajorVersion == 2 || this.dbMajorVersion == 3) {
                    userList = this.getSchemas(db, conn);
                }
                if (userList.isEmpty()) continue;
                DBObject dbo = new DBObject(false, db, "DATABASE");
                list.add(dbo);
                list.addAll(userList);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSchemas(String dbName, Connection conn) throws Exception {
        ArrayList<DBUserSqlServer> arrayList;
        ArrayList<DBUserSqlServer> list = new ArrayList<DBUserSqlServer>();
        Statement statement = conn.createStatement();
        ResultSet rs = null;
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(' ');
                buffer.append("AS").append(' ');
                buffer.append("schema_name").append(',');
                buffer.append("schema_id").append(',');
                buffer.append("principal_id").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHandlerSqlServer.getFormattedName(dbName)).append(".sys.schemas").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("NAME").append(' ');
                buffer.append("NOT").append(' ').append("IN").append(' ');
                buffer.append('(').append("'db_owner'").append(',');
                buffer.append("'db_accessadmin'").append(',');
                buffer.append("'db_backupoperator'").append(',');
                buffer.append("'db_datareader'").append(',');
                buffer.append("'db_datawriter'").append(',');
                buffer.append("'db_ddladmin'").append(',');
                buffer.append("'db_denydatareader'").append(',');
                buffer.append("'db_denydatawriter'").append(',');
                buffer.append("'db_securityadmin'").append(',');
                buffer.append("'INFORMATION_SCHEMA'").append(')');
                buffer.append("ORDER BY").append(' ').append("NAME");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getSchemas(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String schemaName = rs.getString(1);
                    String schema_id = rs.getString(2);
                    String uid = rs.getString(3);
                    DBUserSqlServer dboSchema = new DBUserSqlServer(false, schemaName, "Schema");
                    dboSchema.setUid(uid);
                    dboSchema.setDb(dbName);
                    dboSchema.setId(schema_id);
                    list.add(dboSchema);
                }
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs, statement);
            throw throwable;
        }
        JDBCUtils.close(rs, statement);
        return arrayList;
    }

    private int getDatabaseMajorVersion(Connection sqlConnection) throws Exception {
        int vers = 2;
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = statement.executeQuery("SELECT @@VERSION");
            if (rs != null) {
                while (rs.next()) {
                    String version = rs.getString(1);
                    if (Token.hasString(version, SQL_SERVER_V2K)) {
                        vers = 0;
                        continue;
                    }
                    if (Token.hasString(version, SQL_SERVER_V2K5)) {
                        vers = 1;
                        continue;
                    }
                    if (Token.hasString(version, SQL_SERVER_V2K8)) {
                        vers = 2;
                        continue;
                    }
                    if (!Token.hasString(version, SQL_SERVER_V2K12)) continue;
                    vers = 3;
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("DBMExtractionHandlerSQLServer.getDatabaseMajorVersion(): " + e.getMessage());
        }
        return vers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getUsers(String dbName, Connection conn) throws Exception {
        ArrayList<DBUserSqlServer> list = new ArrayList<DBUserSqlServer>();
        Statement statement = conn.createStatement();
        ResultSet rs = null;
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("NAME").append(' ').append(',');
                buffer.append("UID").append(' ').append(',');
                buffer.append("sid").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHandlerSqlServer.getFormattedName(dbName)).append(".dbo.sysusers").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("sid").append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getUsers(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String userName = rs.getString(1);
                    String uid = rs.getString(2);
                    String sid = "0x" + rs.getString(3);
                    String login = this.getLogin(sid, conn);
                    String user = login + " / " + userName;
                    if (login == null && !userName.equalsIgnoreCase("guest")) {
                        user = "BUILTIN\\Admin / " + userName;
                    }
                    DBUserSqlServer dboUser = new DBUserSqlServer(false, user, "Login / User");
                    dboUser.setUid(uid);
                    dboUser.setDb(dbName);
                    list.add(dboUser);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs, statement);
            throw throwable;
        }
        JDBCUtils.close(rs, statement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLogin(String sid, Connection conn) throws Exception {
        String string;
        ResultSet resultSet = null;
        Statement statement = conn.createStatement();
        try {
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("loginname").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("master.dbo.syslogins").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("sid").append('=').append(sid);
                resultSet = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("DBMExtractionHandlerSQLServer.getLogin(): " + e.getMessage());
            }
            String loginName = null;
            if (resultSet != null) {
                while (resultSet.next()) {
                    loginName = resultSet.getString(1);
                }
            }
            string = loginName;
        }
        catch (Throwable throwable) {
            JDBCUtils.close(resultSet, statement);
            throw throwable;
        }
        JDBCUtils.close(resultSet, statement);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getLogins(Connection conn) throws Exception {
        if (this.loginList == null) {
            ResultSet rs;
            Statement statement;
            block6: {
                this.loginList = new ArrayList();
                statement = conn.createStatement();
                rs = null;
                try {
                    try {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("sid").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append("master.dbo.syslogins");
                        rs = statement.executeQuery(buffer.toString());
                    }
                    catch (SQLException e) {
                        LOGGER.error("DBMExtractionHandlerSQLServer.getLogins(): " + e.getMessage());
                    }
                    if (rs == null) break block6;
                    while (rs.next()) {
                        String sid = rs.getString(1);
                        this.loginList.add("0x" + sid);
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs, statement);
                    throw throwable;
                }
            }
            JDBCUtils.close(rs, statement);
        }
        return this.loginList;
    }

    @Override
    public RDBMSSite getRDBMSSite() {
        switch (this.dbMajorVersion) {
            case 0: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k.RDBMS_TYPE);
            }
            case 1: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k5.RDBMS_TYPE);
            }
            case 2: {
                if (this.dbProductVersion.startsWith("12.") || this.dbProductVersion.startsWith("11.")) {
                    return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k12.RDBMS_TYPE);
                }
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k8.RDBMS_TYPE);
            }
            case 3: {
                return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k12.RDBMS_TYPE);
            }
        }
        return this.view.getCurrentDesign().getRDBMSSiteSet().get(StorageDesignSqlServerv2k12.RDBMS_TYPE);
    }

    public Map getDefaultMap() {
        return this.defaultMap;
    }

    public Map getRuleMap() {
        return this.ruleMap;
    }

    public void addToDefaultMap(String key, String value) {
        if (!key.equals("")) {
            List<String> list = new ArrayList<String>();
            if (this.defaultMap.containsKey(key)) {
                list = (List)this.defaultMap.get(key);
            }
            list.add(value);
            this.defaultMap.put(key, list);
        }
    }

    public void addToRuleMap(String key, String value) {
        if (!key.equals("")) {
            List<String> list = new ArrayList<String>();
            if (this.ruleMap.containsKey(key)) {
                list = (List)this.ruleMap.get(key);
            }
            list.add(value);
            this.ruleMap.put(key, list);
        }
    }

    @Override
    public void generateDesign(Connection conn, List selectedObjects, ImportLogger importLog, ProgressDialog monitor) throws Exception {
        if (!this.isNullStorageDesign(this.view.getCurrentDesign().getRelationalDesign().getStorageDesign())) {
            super.generateDesign(conn, selectedObjects, importLog, monitor);
        }
    }

    public boolean isDefaultDBImpoted() {
        return this.defaultDBImpoted;
    }

    public void setDefaultDBImpoted(boolean defaultDBImpoted) {
        this.defaultDBImpoted = defaultDBImpoted;
    }
}

