/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableOraclev9i
extends MOHTableOracle {
    private static final Logger LOGGER = new Logger(MOHTableOraclev9i.class);
    private PreparedStatement xmlTypeCols_st = null;
    private PreparedStatement identityCols_st = null;

    public MOHTableOraclev9i(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    public MOHTableOraclev9i(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view, dbaUser);
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Table begin");
        ArrayList list = new ArrayList();
        Statement statement = null;
        Statement statement_ext = null;
        for (DBObject dboNext : schemas) {
            DBObject dboTable;
            if (!dboNext.isSelected()) continue;
            String owner = dboNext.getName();
            ArrayList<DBObject> tables = new ArrayList<DBObject>();
            ResultSet rs = null;
            ResultSet rs_ext = null;
            try {
                if (statement == null) {
                    String filterCondition = this.getFilterConditionOracle("TABLE_NAME");
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("TABLE_NAME").append(' ').append(',');
                    buffer.append("TABLE_TYPE").append(' ').append(',');
                    buffer.append("TABLE_TYPE_OWNER").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_ALL_TABLES : ALL_ALL_TABLES).append(' ').append("a").append(' ');
                    buffer.append("WHERE").append(' ').append("IOT_NAME").append(' ').append("IS").append(' ').append("NULL").append(' ');
                    buffer.append("AND").append(' ').append('(');
                    buffer.append("IOT_TYPE").append(' ').append("IS").append(' ').append("NULL").append(' ');
                    buffer.append("OR").append(' ').append("IOT_TYPE").append('=').append("'IOT'");
                    buffer.append(')').append(' ');
                    buffer.append("AND").append(' ').append("NESTED").append('=').append('\'').append("NO").append('\'').append(' ');
                    buffer.append("AND").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
                    if (!this.getDbmeHandler().isSecondaryTables()) {
                        buffer.append("AND").append(' ');
                        buffer.append("SECONDARY").append('=').append('\'').append("N").append('\'').append(' ');
                    }
                    buffer.append("AND").append(' ').append("NOT").append(' ').append("EXISTS").append(' ').append('(');
                    buffer.append("SELECT").append(' ').append('1').append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_QUEUE_TABLES : ALL_QUEUE_TABLES).append(' ').append("c").append(' ');
                    buffer.append("WHERE").append(' ').append("c.").append("OWNER").append('=').append("a.").append("OWNER").append(' ');
                    buffer.append("AND").append(' ').append("c.").append("QUEUE_TABLE").append('=').append("a.").append("TABLE_NAME").append(')').append(' ');
                    if (filterCondition != null) {
                        buffer.append("AND").append(' ').append(filterCondition).append(' ');
                    }
                    buffer.append("ORDER BY").append(' ').append("TABLE_NAME");
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, owner);
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOraclev9i.extract():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    String objName = rs.getString("TABLE_NAME");
                    String tableTypeOwner = rs.getString("TABLE_TYPE_OWNER");
                    String tableType = rs.getString("TABLE_TYPE");
                    dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), objName, "TABLE", owner);
                    dboTable.setTypeName(tableType);
                    dboTable.setTypeOwner(tableTypeOwner);
                    tables.add(dboTable);
                }
                rs.close();
            }
            try {
                if (statement_ext == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("TABLE_NAME").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_EXTERNAL_TABLES : ALL_EXTERNAL_TABLES).append(' ').append("a").append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append("OWNER").append('=').append('?');
                    statement_ext = sqlConnection.prepareStatement(buffer.toString());
                }
                statement_ext.setString(1, owner);
                rs_ext = statement_ext.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOraclev9i.extract() external tables:", e);
            }
            if (rs_ext != null) {
                Object[] tabs = tables.toArray();
                block6: while (rs_ext.next()) {
                    String objName = rs_ext.getString("TABLE_NAME");
                    for (int i = 0; i < tabs.length; ++i) {
                        dboTable = (DBObject)tabs[i];
                        if (!dboTable.getName().equals(objName)) continue;
                        tables.remove(dboTable);
                        continue block6;
                    }
                }
                rs_ext.close();
            }
            list.addAll(tables);
        }
        if (statement_ext != null) {
            statement_ext.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract Table end");
        return list;
    }

    @Override
    public void initColumns(Connection sqlConnection, List dbos) throws Exception {
        this.xmlTypeCols_st = null;
        StorageDesign storageDesign = this.getStorageDesign();
        boolean oraclev11g = storageDesign instanceof StorageDesignOraclev11g;
        boolean oraclev12c = storageDesign instanceof StorageDesignOraclev12c;
        boolean importEncryption = oraclev11g && storageDesign.getAppView().getSettings().isIncludeEncryptionInDDL();
        TreeMap<String, TypeHolder> map = new TreeMap<String, TypeHolder>();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("a.").append("COLUMN_NAME").append(',');
        buffer.append("DATA_TYPE").append(',');
        buffer.append("DATA_TYPE_MOD").append(',');
        buffer.append("DATA_TYPE_OWNER").append(',');
        buffer.append("DATA_LENGTH").append(',');
        buffer.append("DATA_PRECISION").append(',');
        buffer.append("DATA_SCALE").append(',');
        buffer.append("CHAR_USED").append(',');
        buffer.append("CHAR_LENGTH").append(',');
        buffer.append("NULLABLE").append(',');
        if (oraclev11g) {
            buffer.append("VIRTUAL_COLUMN").append(',');
            if (importEncryption) {
                buffer.append("ENCRYPTION_ALG").append(',');
                buffer.append("SALT").append(',');
            }
            if (oraclev12c) {
                buffer.append("HIDDEN_COLUMN").append(',');
                buffer.append("USER_GENERATED").append(',');
                buffer.append("DEFAULT_ON_NULL").append(',');
                buffer.append("IDENTITY_COLUMN").append(',');
                if (importEncryption) {
                    buffer.append("INTEGRITY_ALG").append(',');
                }
            }
        }
        buffer.append("DATA_DEFAULT").append(',');
        buffer.append("COMMENTS").append(' ');
        buffer.append("FROM").append(' ');
        if (oraclev11g) {
            buffer.append(this.dbaUser ? DBA_TAB_COLS : ALL_TAB_COLS).append(' ').append("a").append(',');
            if (importEncryption) {
                buffer.append(this.dbaUser ? DBA_ENCRYPTED_COLUMNS : ALL_ENCRYPTED_COLUMNS).append(' ').append("c").append(',');
            }
        } else {
            buffer.append(this.dbaUser ? DBA_TAB_COLUMNS : ALL_TAB_COLUMNS).append(' ').append("a").append(',');
        }
        buffer.append(this.dbaUser ? DBA_COL_COMMENTS : ALL_COL_COMMENTS).append(' ').append("b").append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a.").append("OWNER").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("OWNER").append('=');
        buffer.append("b.").append("OWNER").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("TABLE_NAME").append('=');
        buffer.append("b.").append("TABLE_NAME").append(' ').append("(+)").append(' ');
        buffer.append("AND").append(' ');
        buffer.append("a.").append("COLUMN_NAME").append('=');
        buffer.append("b.").append("COLUMN_NAME").append(' ').append("(+)").append(' ');
        if (oraclev11g) {
            if (importEncryption) {
                buffer.append("AND").append(' ');
                buffer.append("a.").append("OWNER").append('=');
                buffer.append("c.").append("OWNER").append(' ').append("(+)").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("TABLE_NAME").append('=');
                buffer.append("c.").append("TABLE_NAME").append(' ').append("(+)").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("COLUMN_NAME").append('=');
                buffer.append("c.").append("COLUMN_NAME").append(' ').append("(+)").append(' ');
            }
            if (!oraclev12c) {
                buffer.append("AND").append(' ');
                buffer.append("HIDDEN_COLUMN").append('=').append("'NO'").append(' ');
            }
        }
        buffer.append("ORDER BY").append(' ');
        buffer.append("COLUMN_ID");
        String sql = buffer.toString();
        PreparedStatement statement = sqlConnection.prepareStatement(sql);
        for (DBObject dbo : dbos) {
            Table table = (Table)dbo.getTable();
            ResultSet rs = null;
            try {
                statement.setString(1, dbo.getSchema());
                statement.setString(2, dbo.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHTableOraclev9i.initColumns():", e);
            }
            RDBMSType dbtype = storageDesign.getRDBMSType();
            if (rs == null) continue;
            boolean hasXMLTypeColumns = false;
            boolean hasIdentityColumn = false;
            while (rs.next()) {
                ColumnProxyOracle columnProxy;
                Column column;
                boolean nameNeedsQuotes;
                String char_used;
                String colName = rs.getString("COLUMN_NAME");
                String colDatatype = rs.getString("DATA_TYPE");
                String ref = rs.getString("DATA_TYPE_MOD");
                String dt_owner = rs.getString("DATA_TYPE_OWNER");
                String pres = rs.getString("DATA_PRECISION");
                int colSize = rs.getInt("DATA_LENGTH");
                int colPrecision = 0;
                if (pres != null) {
                    try {
                        colPrecision = Integer.valueOf(pres);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                String scale = rs.getString("DATA_SCALE");
                int colScale = 0;
                if (scale != null) {
                    try {
                        colScale = Integer.valueOf(scale);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                char_used = (char_used = rs.getString("CHAR_USED")) == null ? "" : (char_used.equalsIgnoreCase("C") ? " CHAR" : (char_used.equalsIgnoreCase("B") ? " BYTE" : ""));
                int charLength = rs.getInt("CHAR_LENGTH");
                String allowNull = rs.getString("NULLABLE");
                String virtualCol = oraclev11g ? rs.getString("VIRTUAL_COLUMN") : "";
                String encryptionAlg = importEncryption ? rs.getString("ENCRYPTION_ALG") : null;
                String salt = importEncryption ? rs.getString("SALT") : null;
                String hiddenColumn = oraclev12c ? rs.getString("HIDDEN_COLUMN") : "";
                String userGenerated = oraclev12c ? rs.getString("USER_GENERATED") : "YES";
                String defaultOnNull = oraclev12c ? rs.getString("DEFAULT_ON_NULL") : "";
                String identityColumn = oraclev12c ? rs.getString("IDENTITY_COLUMN") : "";
                String integrityAlg = oraclev12c && importEncryption ? rs.getString("INTEGRITY_ALG") : null;
                String colDefault = rs.getString("DATA_DEFAULT");
                String comments = rs.getString("COMMENTS");
                boolean bl = nameNeedsQuotes = !colName.equals(colName.toUpperCase());
                if ("NO".equals(userGenerated)) {
                    if (!"YES".equals(virtualCol) || !"NUMBER".equals(colDatatype) || !"YES".equals(hiddenColumn) || colName.startsWith("SYS_")) continue;
                    ValidTimeDimension validTimeDimension = table.createValidTimeDimension();
                    validTimeDimension.setName(colName);
                    validTimeDimension.setNameHasQuotes(nameNeedsQuotes);
                    this.stampModelObject((ModelObject)validTimeDimension, table.getName(), colName);
                    continue;
                }
                if (table.isBST()) {
                    column = (Column)table.getElementByName(colName);
                    if (column == null) {
                        continue;
                    }
                } else {
                    column = table.createColumn(colName);
                    column.setNameHasQuotes(nameNeedsQuotes);
                    this.stampModelObject((ModelObject)column, table.getName(), colName);
                    colDatatype = this.removeBrackets(colDatatype).trim();
                    TypeHolder th = (TypeHolder)map.get(colDatatype);
                    if (th == null) {
                        th = new TypeHolder();
                        map.put(colDatatype, th);
                        boolean st_col_used = false;
                        if (dt_owner != null) {
                            StructuredType st = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(colDatatype);
                            if (st != null) {
                                th.strDT = true;
                                th.strdt = st;
                                st_col_used = true;
                            } else {
                                CollectionType ct = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(colDatatype);
                                if (ct != null) {
                                    th.colDT = true;
                                    th.coldt = ct;
                                    st_col_used = true;
                                }
                            }
                        }
                        if (!st_col_used) {
                            String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                            LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, usedDatatype);
                            if (logDatatype == null) {
                                NativeDBType nt = StandardDatatypeNames.getNativeDBType(dbtype, usedDatatype);
                                if (nt == null && dt_owner != null) {
                                    nt = StandardDatatypeNames.getNativeDBType(dbtype, dt_owner + "." + usedDatatype);
                                }
                                if (nt != null) {
                                    logDatatype = nt.getLogicalDatatype();
                                }
                            }
                            if (logDatatype == null) {
                                logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                            }
                            if (logDatatype != null && !"UNKNOWN".equalsIgnoreCase(usedDatatype)) {
                                th.ldt = logDatatype;
                                th.logicalDT = true;
                            } else {
                                th.ukndt = logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByName("UNKNOWN");
                                th.unknownDT = true;
                            }
                        }
                    }
                    if (th.logicalDT) {
                        colDatatype = colDatatype.toUpperCase();
                        column.setUse((short)1);
                        column.setLogicalDatatype(th.ldt);
                        if (colDatatype.startsWith("TIMESTAMP")) {
                            column.setDataTypeParameter("precision", String.valueOf(colScale));
                        } else {
                            if (colDatatype.equals("CHAR") || colDatatype.equals("VARCHAR2") || colDatatype.equals("VARCHAR")) {
                                this.setParameter(column, "size", Integer.toString(charLength) + char_used);
                            } else if (colDatatype.equals("NCHAR") || colDatatype.equals("NVARCHAR2") || colDatatype.equals("NVARCHAR")) {
                                this.setParameter(column, "size", Integer.toString(charLength));
                            } else if (colSize != 0) {
                                column.setDataTypeParameter("size", String.valueOf(colSize));
                            }
                            if (pres != null) {
                                column.setDataTypeParameter("precision", String.valueOf(colPrecision));
                                if (scale != null) {
                                    column.setDataTypeParameter("scale", String.valueOf(colScale));
                                }
                                column.setDataTypeSize(null);
                            } else if (scale != null) {
                                this.setParameter(column, "precision", "*");
                                this.setParameter(column, "scale", scale);
                                column.setDataTypeSize(null);
                            } else if (colDatatype.startsWith("NUM")) {
                                column.setDataTypeSize(null);
                            }
                        }
                        if (colDatatype.equals("BLOB") || colDatatype.equals("CLOB") || colDatatype.equals("NCLOB")) {
                            dbo.hasLOBs = true;
                        }
                    } else if (th.strDT) {
                        if ("REF".equalsIgnoreCase(ref)) {
                            column.setUse((short)3);
                            column.setReference(true);
                            column.setStructuredType(th.strdt);
                        } else if (colDatatype.equalsIgnoreCase("XMLTYPE")) {
                            column.setUse((short)1);
                            column.setLogicalDatatype(this.getDesign().getLogicalDatatypeSet().getLogTypeByName("XMLTYPE"));
                            hasXMLTypeColumns = true;
                        } else {
                            column.setUse((short)3);
                            column.setStructuredType(th.strdt);
                            dbo.hasLOBs = true;
                        }
                    } else if (th.colDT) {
                        column.setUse((short)4);
                        column.setCollectionType(th.coldt);
                        dbo.hasLOBs = true;
                    } else {
                        column.setUse((short)1);
                        column.setLogicalDatatype(th.ukndt);
                    }
                }
                column.setNullsAllowed("Y".equalsIgnoreCase(allowNull));
                if (hiddenColumn.equals("YES") && (columnProxy = this.getColumnProxy(column)) instanceof ColumnProxyOraclev12c) {
                    ((ColumnProxyOraclev12c)columnProxy).setInvisible("YES");
                }
                if (identityColumn.equals("YES")) {
                    hasIdentityColumn = true;
                    column.setAutoIncrementColumn(true);
                    column.setIdentityColumn(true);
                    columnProxy = this.getColumnProxy(column);
                    if (columnProxy != null) {
                        columnProxy.setAutoIncrementDDL("IDENTITY_CLAUSE");
                    }
                } else if (colDefault != null) {
                    colDefault = colDefault.trim();
                    if ("YES".equalsIgnoreCase(virtualCol)) {
                        column.setComputed(true);
                        column.setFormulaDesc(colDefault);
                        column.setSourceType("Derived");
                    } else {
                        ColumnProxyOracle columnProxy2;
                        String unquotedName;
                        int lastDotIndex = colDefault.lastIndexOf(46);
                        if (lastDotIndex > -1 && colDefault.substring(lastDotIndex).equalsIgnoreCase(".NEXTVAL") && (unquotedName = Token.getFirstName(colDefault, '\"', '\"')).length() >= colDefault.length() - 4 && (columnProxy2 = this.getColumnProxy(column)) instanceof ColumnProxyOraclev12c) {
                            column.setAutoIncrementColumn(true);
                            columnProxy2.setAutoIncrementDDL("DEFAULT_CLAUSE");
                            String seqName = unquotedName.substring(0, unquotedName.length() - 8);
                            String seqUser = "";
                            int dotIndex = seqName.lastIndexOf(46);
                            if (dotIndex > -1) {
                                seqUser = seqName.substring(0, dotIndex);
                                seqName = seqName.substring(dotIndex + 1);
                            }
                            column.setAutoIncrementSequenceName(seqName);
                            if (!seqUser.isEmpty() && !seqUser.equalsIgnoreCase(table.getSchema())) {
                                UserOracle user = (UserOracle)((StorageDesignOracle)storageDesign).getUserSet().getByName(seqUser);
                                columnProxy2.setAutoIncrementUser(user);
                            }
                        }
                        column.setDefaultValue(colDefault);
                    }
                }
                if (defaultOnNull.equals("YES") && (columnProxy = this.getColumnProxy(column)) instanceof ColumnProxyOraclev12c) {
                    ((ColumnProxyOraclev12c)columnProxy).setDefaultOnNull("YES");
                }
                if (encryptionAlg != null && (columnProxy = this.getColumnProxy(column)) instanceof ColumnProxyOraclev11g) {
                    ColumnProxyOraclev11g columnProxy11g = (ColumnProxyOraclev11g)columnProxy;
                    columnProxy11g.setEncrypt("YES");
                    if (encryptionAlg.equalsIgnoreCase("AES 192 bits key")) {
                        columnProxy11g.setEncryptionAlgorithm("AES192");
                    } else if (encryptionAlg.equalsIgnoreCase("AES 128 bits key")) {
                        columnProxy11g.setEncryptionAlgorithm("AES128");
                    } else if (encryptionAlg.equalsIgnoreCase("AES 256 bits key")) {
                        columnProxy11g.setEncryptionAlgorithm("AES256");
                    } else if (encryptionAlg.equalsIgnoreCase("3 Key Triple DES 168 bits key")) {
                        columnProxy11g.setEncryptionAlgorithm("3DES168");
                    }
                    if ("SHA-1".equalsIgnoreCase(integrityAlg)) {
                        columnProxy11g.setIntegrityAlgorithm("SHA-1");
                    } else if ("NOMAC".equalsIgnoreCase(integrityAlg)) {
                        columnProxy11g.setIntegrityAlgorithm("NOMAC");
                    }
                    if (salt != null) {
                        columnProxy11g.setUseSalt(salt);
                    }
                }
                if (comments == null) continue;
                column.setCommentInRDBMS(comments);
            }
            rs.close();
            if (hasXMLTypeColumns) {
                this.initXMLTypeColumns(sqlConnection, dbo);
            }
            if (!hasIdentityColumn) continue;
            this.initIdentityColumn(sqlConnection, dbo);
        }
        if (this.xmlTypeCols_st != null) {
            this.xmlTypeCols_st.close();
            this.xmlTypeCols_st = null;
        }
        if (this.identityCols_st != null) {
            this.identityCols_st.close();
            this.identityCols_st = null;
        }
        statement.close();
    }

    private ColumnProxyOracle getColumnProxy(Column column) {
        return (ColumnProxyOracle)this.getStorageDesign().getColumnProxySet().getProxy(column.getObjectID());
    }

    protected void initXMLTypeColumns(Connection sqlConnection, DBObject dbo) throws Exception {
        boolean oraclev11g = this.getStorageDesign() instanceof StorageDesignOraclev11g;
        Table table = (Table)dbo.getTable();
        if (this.xmlTypeCols_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("XMLSCHEMA").append(',');
            buffer.append("ELEMENT_NAME").append(',');
            buffer.append("STORAGE_TYPE");
            if (oraclev11g) {
                buffer.append(',');
                buffer.append("ANYSCHEMA").append(',');
                buffer.append("NONSCHEMA");
            }
            buffer.append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_XML_TAB_COLS : ALL_XML_TAB_COLS).append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.xmlTypeCols_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.xmlTypeCols_st.setString(1, dbo.getSchema());
            this.xmlTypeCols_st.setString(2, table.getName());
            rs = this.xmlTypeCols_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOraclev9i.initXMLTypeColumns():", e);
        }
        if (rs != null) {
            TableProxyOracle tableProxy = (TableProxyOracle)this.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            while (rs.next()) {
                ColumnProxyOraclev9i columnProxy;
                String colName = rs.getString("COLUMN_NAME");
                String xmlSchema = rs.getString("XMLSCHEMA");
                String xmlElementName = rs.getString("ELEMENT_NAME");
                String xmlStorageType = rs.getString("STORAGE_TYPE");
                String anySchema = null;
                String nonSchema = null;
                if (oraclev11g) {
                    anySchema = rs.getString("ANYSCHEMA");
                    nonSchema = rs.getString("NONSCHEMA");
                }
                if ((columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxyByName(colName)) == null) continue;
                if (xmlSchema != null) {
                    columnProxy.setXmlSchemaUrl(xmlSchema);
                }
                if (xmlElementName != null) {
                    columnProxy.setXmlSchemaElement(xmlElementName);
                }
                if (xmlStorageType != null) {
                    if (xmlStorageType.equals("BINARY")) {
                        xmlStorageType = "BINARY XML";
                    } else if (xmlStorageType.equals("OBJECT-RELATIONAL")) {
                        xmlStorageType = "OBJECT RELATIONAL";
                    }
                    columnProxy.setStoreAs(xmlStorageType);
                }
                if (anySchema != null) {
                    ((ColumnProxyOraclev11g)columnProxy).setAllowAnySchema(anySchema);
                }
                if (nonSchema == null) continue;
                ((ColumnProxyOraclev11g)columnProxy).setAllowNonSchema(nonSchema);
            }
            rs.close();
        }
    }

    protected void initIdentityColumn(Connection sqlConnection, DBObject dbo) throws Exception {
        Table table = (Table)dbo.getTable();
        if (this.identityCols_st == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLUMN_NAME").append(',');
            buffer.append("GENERATION_TYPE").append(',');
            buffer.append("IDENTITY_OPTIONS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_TAB_IDENTITY_COLS : ALL_TAB_IDENTITY_COLS).append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TABLE_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.identityCols_st = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.identityCols_st.setString(1, dbo.getSchema());
            this.identityCols_st.setString(2, table.getName());
            rs = this.identityCols_st.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHTableOraclev9i.initIdentityColumn():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                Column column = (Column)table.getElementByName(colName);
                if (column == null) continue;
                String generationType = rs.getString("GENERATION_TYPE");
                column.setAutoIncrementGenerateAlways(generationType.equals("ALWAYS"));
                String identityOptions = rs.getString("IDENTITY_OPTIONS");
                StringTokenizer tok = new StringTokenizer(identityOptions, ",");
                while (tok.hasMoreElements()) {
                    String option = tok.nextToken();
                    int colonIndex = option.indexOf(58);
                    if (colonIndex <= -1) continue;
                    String optName = option.substring(0, colonIndex).trim();
                    String optValue = option.substring(colonIndex + 1).trim();
                    try {
                        if (optName.equals("START WITH")) {
                            column.setAutoIncrementStartWith(optValue);
                            continue;
                        }
                        if (optName.equals("INCREMENT BY")) {
                            column.setAutoIncrementIncrementBy(Integer.parseInt(optValue));
                            continue;
                        }
                        if (optName.equals("MAX_VALUE")) {
                            if (optValue.equals("9999999999999999999999999999") && column.getAutoIncrementIncrementBy() > 0) continue;
                            column.setAutoIncrementMaxValue(optValue);
                            continue;
                        }
                        if (optName.equals("MIN_VALUE")) {
                            if (optValue.equals("1") && column.getAutoIncrementIncrementBy() > 0) continue;
                            column.setAutoIncrementMinValue(optValue);
                            continue;
                        }
                        if (optName.equals("CYCLE_FLAG")) {
                            column.setAutoIncrementCycle(optValue.equals("Y"));
                            continue;
                        }
                        if (optName.equals("CACHE_SIZE")) {
                            int cacheSize = Integer.parseInt(optValue);
                            column.setAutoIncrementCache(cacheSize);
                            column.setAutoIncrementDisableCache(cacheSize == 0);
                            continue;
                        }
                        if (!optName.equals("ORDER_FLAG")) continue;
                        column.setAutoIncrementOrder(optValue.equals("Y"));
                    }
                    catch (NumberFormatException e) {}
                }
            }
            rs.close();
        }
    }

    protected String removeBrackets(String input) {
        String result;
        int length = input.length();
        int ind = input.indexOf(40);
        if (ind > 0) {
            result = input.substring(0, ind);
            int close_ind = input.indexOf(41);
            if (close_ind > 0 && close_ind < length - 1) {
                String rest = input.substring(close_ind + 1, length);
                result = result.trim() + " " + this.removeBrackets(rest).trim();
            }
        } else {
            result = input;
        }
        return result;
    }

    protected void setParameter(Column column, String param, String value) {
        column.setDataTypeParameter(param, value);
    }

    class TypeHolder {
        boolean logicalDT = false;
        boolean strDT = false;
        boolean colDT = false;
        boolean unknownDT = false;
        LogicalDatatype ldt;
        LogicalDatatype ukndt;
        StructuredType strdt;
        CollectionType coldt;

        TypeHolder() {
        }
    }
}

