/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v10g;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHUndoTableSpaceOraclev10g
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "UNDO TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHUndoTableSpaceOraclev10g.class);
    protected boolean dbaUser;

    public MOHUndoTableSpaceOraclev10g(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("TABLESPACE_NAME");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_TABLESPACES : USER_TABLESPACES).append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("NOT").append(' ').append("IN").append(' ');
            buffer.append('(').append('\'');
            buffer.append("SYSTEM").append('\'').append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("CONTENTS").append('=').append('\'');
            buffer.append("UNDO").append('\'').append(' ');
            if (filterCondition != null) {
                buffer.append("AND").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ');
            buffer.append("TABLESPACE_NAME");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            System.out.println("MOHUndoTableSpaceOraclev10g.extract(): " + e.getMessage());
            LOGGER.error("MOHUndoTableSpaceOraclev10g.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String tablespaceName = rs.getString(1);
                DBObject dboTablespace = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablespaceName, OBJECT_TYPE);
                list.add(dboTablespace);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            ResultSet rs = null;
            try {
                if (statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("BIGFILE").append(',');
                    buffer.append("RETENTION").append(' ');
                    buffer.append("FROM").append(' ');
                    buffer.append(this.dbaUser ? DBA_TABLESPACES : USER_TABLESPACES).append(' ');
                    buffer.append("WHERE").append(' ');
                    buffer.append("TABLESPACE_NAME").append('=').append('?').append(' ');
                    buffer.append("AND").append(' ');
                    buffer.append("CONTENTS").append('=').append('\'');
                    buffer.append("UNDO").append('\'');
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, dbo.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHUndoTableSpaceOraclev10g.generate(): " + e.getMessage());
                LOGGER.error("MOHUndoTableSpaceOraclev10g.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign instanceof StorageDesignOraclev10g) {
                        UndoTablespaceOracle tableSpace = ((StorageDesignOraclev10g)storageDesign).getUndoTablespaceSet().createTablespace();
                        tableSpace.setName(dbo.getName());
                        this.setProperties(tableSpace, rs);
                        this.stampModelObject(tableSpace, dbo);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private void setProperties(UndoTablespaceOracle tableSpace, ResultSet resultSet) throws Exception {
        String bigfile = resultSet.getString("BIGFILE");
        if ("YES".equals(bigfile)) {
            tableSpace.setFileType("BIGFILE");
        } else if ("NO".equals(bigfile)) {
            tableSpace.setFileType("SMALLFILE");
        }
        String retention = resultSet.getString("RETENTION");
        if ("GUARANTEE".equals(retention) || "NOGUARANTEE".equals(retention)) {
            tableSpace.setRetention(retention);
        }
    }
}

