/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TemporaryTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTempTableSpaceOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "TEMP TABLESPACE";
    private static final Logger LOGGER = new Logger(MOHTempTableSpaceOracle.class);
    protected boolean dbaUser;

    public MOHTempTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
        this.dbaUser = false;
    }

    public MOHTempTableSpaceOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("TABLESPACE_NAME");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? DBA_TABLESPACES : USER_TABLESPACES).append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABLESPACE_NAME").append(' ');
            buffer.append("NOT").append(' ').append("IN").append(' ');
            buffer.append('(').append('\'');
            buffer.append("SYSTEM").append('\'').append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("CONTENTS").append('=').append('\'');
            buffer.append("TEMPORARY").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
            buffer.append("LOCAL").append('\'').append(' ');
            if (filterCondition != null) {
                buffer.append("AND").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ');
            buffer.append("TABLESPACE_NAME");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            System.out.println("MOHTempTableSpaceOracle.extract(): " + e.getMessage());
            LOGGER.error("MOHTempTableSpaceOracle.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String clusterName = rs.getString(1);
                DBObject dboSynonym = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), clusterName, OBJECT_TYPE);
                list.add(dboSynonym);
            }
            rs.close();
        }
        statement.close();
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        Statement statement = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT").append(' ');
        buffer.append("INITIAL_EXTENT");
        boolean includeGroupName = false;
        if (storageDesign instanceof StorageDesignOraclev10g) {
            includeGroupName = this.dbaUser;
            buffer.append(',');
            buffer.append("BIGFILE");
            if (includeGroupName) {
                buffer.append(',').append("GROUP_NAME");
            }
        }
        buffer.append(' ');
        buffer.append("FROM").append(' ');
        buffer.append(this.dbaUser ? DBA_TABLESPACES : USER_TABLESPACES).append(' ').append("a");
        if (includeGroupName) {
            buffer.append(',').append("dba_tablespace_groups").append(' ').append("b");
        }
        buffer.append(' ');
        buffer.append("WHERE").append(' ');
        buffer.append("a").append('.').append("TABLESPACE_NAME").append('=').append('?').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("CONTENTS").append('=').append('\'');
        buffer.append("TEMPORARY").append('\'').append(' ');
        buffer.append("AND").append(' ');
        buffer.append("EXTENT_MANAGEMENT").append('=').append('\'');
        buffer.append("LOCAL").append('\'');
        if (includeGroupName) {
            buffer.append("AND").append(' ');
            buffer.append("a.").append("TABLESPACE_NAME").append('=').append("b.").append("TABLESPACE_NAME").append(' ').append("(+)");
        }
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            ResultSet rs = null;
            try {
                if (statement == null) {
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, dbo.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                System.out.println("MOHTempTableSpaceOracle.generate(): " + e.getMessage());
                LOGGER.error("MOHTempTableSpaceOracle.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    if (storageDesign instanceof StorageDesignOracle) {
                        long bytes;
                        TemporaryTablespaceOracle tableSpace = ((StorageDesignOracle)storageDesign).getTemporaryTablespaceSet().createTemporaryTablespace();
                        tableSpace.setName(dbo.getName());
                        String size = rs.getString("INITIAL_EXTENT");
                        try {
                            bytes = Long.parseLong(size);
                        }
                        catch (Exception e1) {
                            LOGGER.error("MOHTempTableSpaceOracle.generate(): Error parsing \"INITIAL_EXTENT\" - " + size);
                            bytes = 1024L;
                        }
                        if (bytes % 1024L == 0L) {
                            tableSpace.setUniformSize(bytes / 1024L);
                            tableSpace.setMeasureUnitUniformSize("K");
                        } else {
                            tableSpace.setUniformSize(bytes);
                            tableSpace.setMeasureUnitUniformSize("");
                        }
                        if (tableSpace instanceof TemporaryTablespaceOraclev10g) {
                            String groupName;
                            TemporaryTablespaceOraclev10g tablespace10g = (TemporaryTablespaceOraclev10g)tableSpace;
                            String bigfile = rs.getString("BIGFILE");
                            if ("YES".equals(bigfile)) {
                                tablespace10g.setFileType(TemporaryTablespaceOraclev10g.BIGFILE);
                            } else if ("NO".equals(bigfile)) {
                                tablespace10g.setFileType(TemporaryTablespaceOraclev10g.SMALLFILE);
                            }
                            if (includeGroupName && (groupName = rs.getString("GROUP_NAME")) != null) {
                                tablespace10g.setTableSpaceGroup(groupName);
                            }
                        }
                        this.stampModelObject(tableSpace, dbo);
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }
}

