/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.PreparedStatement;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHPlSqlStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHProcedureOracle
extends MOHPlSqlStorageObjectOracle<StoredProcedureOracle> {
    public static final String OBJECT_TYPE = "PROCEDURE";
    private static final Logger LOGGER = new Logger(MOHProcedureOracle.class);

    public MOHProcedureOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    public MOHProcedureOracle(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view, boolean dbaUser) {
        super(dbmeHandler, view, dbaUser);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    protected StoredProcedureOracle generate(PreparedStatement statement, DBObject dbObject, ImportLogger importLog) throws Exception {
        StoredProcedureOracle storedProcedureOracle = (StoredProcedureOracle)super.generate(statement, dbObject, importLog);
        if (storedProcedureOracle != null) {
            this.stampModelObject(storedProcedureOracle, dbObject);
        }
        return storedProcedureOracle;
    }

    @Override
    public StoredProcedureOracle generateObject(StorageDesignOracle storageDesignOracle, DBObject dbObject, String source) {
        StoredProcedureOracle storedProcedureOracle = (StoredProcedureOracle)storageDesignOracle.getStoredProcedureSet().createElement(null);
        UserOracle user = (UserOracle)storageDesignOracle.getUserSet().getByName(dbObject.getSchema());
        storedProcedureOracle.setOwner(user);
        storedProcedureOracle.setName(dbObject.getName());
        storedProcedureOracle.setSource("CREATE OR REPLACE " + source);
        this.stampModelObject(storedProcedureOracle, dbObject);
        return storedProcedureOracle;
    }
}

