/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2.v80;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SequenceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSequenceDB2v80
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "SEQUENCE";
    private static final Logger LOGGER = new Logger(MOHSequenceDB2v80.class);

    public MOHSequenceDB2v80(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            String ownerName = dbo.getSchema();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT DATATYPEID, SOURCETYPEID, ");
                buffer.append("START, INCREMENT, cast(MINVALUE as char(20)), ");
                buffer.append("cast(MAXVALUE as char(20)), CYCLE, CACHE, ORDER ");
                buffer.append("from SYSIBM.SYSSEQUENCES").append(' ');
                buffer.append("WHERE NAME = '").append(name).append("'");
                buffer.append(" AND SEQTYPE = 'S'");
                buffer.append(" and SCHEMA = '").append(ownerName).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHSequencesDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    StorageDesign storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                        StorageDesignDB2v80 storage = (StorageDesignDB2v80)storageDesign;
                        int datatypeId = rs.getInt(1);
                        int sourcetypeId = rs.getInt(2);
                        int start = rs.getInt(3);
                        int increment = rs.getInt(4);
                        String minvalue = rs.getString(5).trim();
                        String maxvalue = rs.getString(6).trim();
                        String cycle = rs.getString(7);
                        int cache = rs.getInt(8);
                        String order = rs.getString(9);
                        SequenceDB2 seq = storage.getSequenceSet().createSequence();
                        seq.setName(name);
                        this.stampModelObject(seq, dbo);
                        Owner owner = (Owner)storage.getOwnerSet().getByName(ownerName);
                        if (owner != null) {
                            seq.setOwner(owner);
                        } else {
                            owner = (Owner)storage.getOwnerSet().createElement(ownerName);
                            owner.setName(ownerName);
                            this.stampModelObject((ModelObject)owner, "", ownerName);
                        }
                        if (sourcetypeId != 0) {
                            this.initDatatype(sqlConnection, seq, datatypeId);
                        } else if (datatypeId == 496) {
                            seq.setDatatype("INTEGER");
                        } else if (datatypeId == 500) {
                            seq.setDatatype("SMALLINT");
                        } else if (datatypeId == 484) {
                            seq.setDatatype("DECIMAL");
                        }
                        seq.setStartWith(start);
                        seq.setIncrementBy(increment);
                        seq.setMinValue(minvalue);
                        seq.setMaxValue(maxvalue);
                        if ("N".equalsIgnoreCase(cycle)) {
                            seq.setCycle("NO");
                        } else {
                            seq.setCycle("YES");
                        }
                        seq.setCache(cache);
                        if ("N".equalsIgnoreCase(order)) {
                            seq.setOrder("NO");
                        } else {
                            seq.setOrder("YES");
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initDatatype(Connection sqlConnection, SequenceDB2 seq, int datatypeId) throws Exception {
        Statement statement = null;
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT NAME ");
            buffer.append("from SYSIBM.SYSDATATYPES ");
            buffer.append("WHERE DATATYPEID = ").append(datatypeId);
            statement = sqlConnection.prepareStatement(buffer.toString());
            rs = statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("MOHSequenceDB2v80.initDatatype():", e);
        }
        if (rs != null) {
            if (rs.next()) {
                String datatype = rs.getString(1);
                seq.setDatatype(datatype);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSSEQUENCES").append(' ');
                buffer.append("WHERE SEQTYPE = 'S' and SCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHSequenceDB2v80.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String tablename = rs.getString(1);
                    DBObject dboTable = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), tablename, OBJECT_TYPE, dboNext.getName());
                    list.add(dboTable);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

