/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHOwnerDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OWNER";
    private static final Logger LOGGER = new Logger(MOHOwnerDB2.class);
    protected static final String ARCHIVE = "ARCHIVE";
    protected static final String BINDADD = "BINDADD";
    protected static final String BINDAGENT = "BINDAGENT";
    protected static final String BSDS = "BSDS";
    protected static final String CREATEALIAS = "CREATEALIAS";
    protected static final String CREATEDBA = "CREATEDBA";
    protected static final String CREATEDBC = "CREATEDBC";
    protected static final String CREATESG = "CREATESG";
    protected static final String CREATEMTAB = "CREATEMTAB";
    protected static final String DISPLAY = "DISPLAY";
    protected static final String MONITOR1 = "MONITOR1";
    protected static final String MONITOR2 = "MONITOR2";
    protected static final String RECOVER = "RECOVER";
    protected static final String STOPALL = "STOPALL";
    protected static final String STOSPACE = "STOSPACE";
    protected static final String SYSADMIN = "SYSADMIN";
    protected static final String SYSCTRL = "SYSCTRL";
    protected static final String SYSOPR = "SYSOPR";
    protected static final String TRACE = "TRACE";
    protected static final String Y = "YG";
    protected static final String G = "G";

    public MOHOwnerDB2(AbstractDBMExtractionHandler dbmeHandler, ApplicationView view) {
        super(dbmeHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof AbstractStorageDesignDB2) {
                AbstractStorageDesignDB2 storage = (AbstractStorageDesignDB2)storageDesign;
                Owner owner = (Owner)storage.getOwnerSet().createElement(null);
                owner.setName(name);
                this.stampModelObject((ModelObject)owner, "", name);
                this.initPrivileges(sqlConnection, owner);
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initPrivileges(Connection sqlConnection, Owner owner) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT BINDADDAUTH, BSDSAUTH, ");
            buffer.append("CREATEDBAAUTH, CREATEDBCAUTH, CREATESGAUTH, DISPLAYAUTH, ");
            buffer.append("RECOVERAUTH, STOPALLAUTH, STOSPACEAUTH, SYSADMAUTH, ");
            buffer.append("SYSOPRAUTH, TRACEAUTH, MON1AUTH, MON2AUTH, CREATEALIASAUTH, ");
            buffer.append("SYSCTRLAUTH, BINDAGENTAUTH, ARCHIVEAUTH, CREATETMTABAUTH ");
            buffer.append("from SYSIBM.SYSUSERAUTH ");
            buffer.append("WHERE GRANTEE = '");
            buffer.append(owner.getName()).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHOwnerDB2.initPrivileges():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String bindadd = rs.getString(1);
                String bsds = rs.getString(2);
                String createdba = rs.getString(3);
                String createdbc = rs.getString(4);
                String createsg = rs.getString(5);
                String display = rs.getString(6);
                String recover = rs.getString(7);
                String stopall = rs.getString(8);
                String stospace = rs.getString(9);
                String sysadm = rs.getString(10);
                String sysopr = rs.getString(11);
                String trace = rs.getString(12);
                String mon1 = rs.getString(13);
                String mon2 = rs.getString(14);
                String createalias = rs.getString(15);
                String sysctrl = rs.getString(16);
                String bindagent = rs.getString(17);
                String archive = rs.getString(18);
                String createmtab = rs.getString(19);
                StringBuffer buffer = new StringBuffer();
                boolean grant = false;
                boolean first = true;
                if (bindadd.equalsIgnoreCase(Y)) {
                    buffer.append(BINDADD);
                    first = false;
                } else if (bindadd.equalsIgnoreCase(G)) {
                    buffer.append(BINDADD);
                    first = false;
                    grant = true;
                }
                if (bsds.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(BSDS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(BSDS);
                    }
                } else if (bsds.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(BSDS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(BSDS);
                    }
                    grant = true;
                }
                if (createdba.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATEDBA);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEDBA);
                    }
                } else if (createdba.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATEDBA);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEDBA);
                    }
                    grant = true;
                }
                if (createdbc.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATEDBC);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEDBC);
                    }
                } else if (createdbc.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATEDBC);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEDBC);
                    }
                    grant = true;
                }
                if (createsg.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATESG);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATESG);
                    }
                } else if (createsg.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATESG);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATESG);
                    }
                    grant = true;
                }
                if (display.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(DISPLAY);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DISPLAY);
                    }
                } else if (display.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(DISPLAY);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(DISPLAY);
                    }
                    grant = true;
                }
                if (recover.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(RECOVER);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(RECOVER);
                    }
                } else if (recover.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(RECOVER);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(RECOVER);
                    }
                    grant = true;
                }
                if (stopall.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STOPALL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOPALL);
                    }
                } else if (stopall.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STOPALL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOPALL);
                    }
                    grant = true;
                }
                if (stospace.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(STOSPACE);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOSPACE);
                    }
                } else if (stospace.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(STOSPACE);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(STOSPACE);
                    }
                    grant = true;
                }
                if (sysadm.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(SYSADMIN);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSADMIN);
                    }
                } else if (sysadm.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(SYSADMIN);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSADMIN);
                    }
                    grant = true;
                }
                if (sysopr.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(SYSOPR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSOPR);
                    }
                } else if (sysopr.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(SYSOPR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSOPR);
                    }
                    grant = true;
                }
                if (sysopr.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(SYSOPR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSOPR);
                    }
                } else if (sysopr.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(SYSOPR);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSOPR);
                    }
                    grant = true;
                }
                if (trace.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(TRACE);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(TRACE);
                    }
                } else if (trace.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(TRACE);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(TRACE);
                    }
                    grant = true;
                }
                if (mon1.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(MONITOR1);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(MONITOR1);
                    }
                } else if (mon1.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(MONITOR1);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(MONITOR1);
                    }
                    grant = true;
                }
                if (mon2.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(MONITOR2);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(MONITOR2);
                    }
                } else if (mon2.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(MONITOR2);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(MONITOR2);
                    }
                    grant = true;
                }
                if (createalias.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATEALIAS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEALIAS);
                    }
                } else if (createalias.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATEALIAS);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEALIAS);
                    }
                    grant = true;
                }
                if (sysctrl.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(SYSCTRL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSCTRL);
                    }
                } else if (sysctrl.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(SYSCTRL);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(SYSCTRL);
                    }
                    grant = true;
                }
                if (bindagent.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(BINDAGENT);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(BINDAGENT);
                    }
                } else if (bindagent.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(BINDAGENT);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(BINDAGENT);
                    }
                    grant = true;
                }
                if (archive.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(ARCHIVE);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(ARCHIVE);
                    }
                } else if (archive.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(ARCHIVE);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(ARCHIVE);
                    }
                    grant = true;
                }
                if (createmtab.equalsIgnoreCase(Y)) {
                    if (first) {
                        buffer.append(CREATEMTAB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEMTAB);
                    }
                } else if (createmtab.equalsIgnoreCase(G)) {
                    if (first) {
                        buffer.append(CREATEMTAB);
                        first = false;
                    } else {
                        buffer.append(',');
                        buffer.append(CREATEMTAB);
                    }
                    grant = true;
                }
                owner.setSystemPrivileges(buffer.toString());
                if (grant) {
                    owner.setGrantOption("YES");
                    continue;
                }
                owner.setGrantOption("NO");
            }
            rs.close();
        }
        statement.close();
    }
}

