/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.db2.DBMExtractionHandlerDB2;
import oracle.dbtools.crest.imports.metadata.odbc.DBMExtractionHandlerODBC;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBMExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.udb.DBMExtractionHandlerUDB;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.wizards.metadata.DefaultDBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.connection.ConnectionInfo;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.DBMExtractionWizardDB2;
import oracle.dbtools.crest.swingui.wizards.metadata.db2.v80.DBMExtractionWizardDB2v80;
import oracle.dbtools.crest.swingui.wizards.metadata.odbc.DBMExtractionWizardODBC;
import oracle.dbtools.crest.swingui.wizards.metadata.oracle.DBMExtractionWizardOracle;
import oracle.dbtools.crest.swingui.wizards.metadata.sqlserver.DBMExtractionWizardSqlServer;
import oracle.dbtools.crest.swingui.wizards.metadata.udb.DBMExtractionWizardUDB;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DBMExtractionController {
    public static final String PROPERTIES_CONN_NAME = "ConnName";
    public static final String PROPERTIES_CUSTOM_URL = "customUrl";
    public static final String PROPERTIES_USER = "user";
    private ApplicationView view;
    private Design design;
    private ProgressDialog monitor;
    private String oldDesignPath;
    private RelationalDesign relModel = null;
    public static boolean swapTargetModel = false;
    private Design oldDesign;
    private boolean isNewModel = false;
    private static final Logger LOGGER = new Logger(DBMExtractionController.class);

    public DBMExtractionController(ApplicationView view) {
        this.view = view;
        this.clearInstances();
    }

    private void clearInstances() {
        DBMExtractionHandlerDB2.clearInstance();
        DBMExtractionHandlerUDB.clearInstance();
        DBMExtractionHandlerOracle.clearInstance();
        DBMExtractionHandlerSQLServer.clearInstance();
        DBMExtractionHandlerODBC.clearInstance();
    }

    public AbstractDBMExtractionHandler getDBMExtractionHandler(int type) {
        switch (type) {
            case 3: {
                return DBMExtractionHandlerDB2.getInstance(this.view);
            }
            case 4: {
                return DBMExtractionHandlerUDB.getInstance(this.view);
            }
            case 1: {
                return DBMExtractionHandlerOracle.getInstance(this.view);
            }
            case 2: {
                return DBMExtractionHandlerSQLServer.getInstance(this.view);
            }
            case 0: {
                return DBMExtractionHandlerODBC.getInstance(this.view);
            }
        }
        return null;
    }

    public List getSchemas(int type, Connection conn) throws Exception {
        return this.getDBMExtractionHandler(type).getSchemas(conn);
    }

    public List getDBObjects(int type, List schemas, Connection conn) throws Exception {
        return this.getDBMExtractionHandler(type).getDBObjects(conn, schemas);
    }

    public String getDBProductVersion(int type) {
        return this.getDBMExtractionHandler(type).getDBProductVersion();
    }

    public String getDBProductName(int type) {
        return this.getDBMExtractionHandler(type).getDBProductName();
    }

    public void doCancel() {
        if (this.oldDesign != null) {
            this.design = this.oldDesign;
            this.view.setCurrentDesign(this.design);
        }
    }

    public void generateDesign(Connection conn, Properties cd, List selectedObjects, RelationalDesign relModel, boolean swapTargetModel, RDBMSSite site) throws Exception {
        this.generateDesign(conn, cd, selectedObjects, relModel, swapTargetModel, site, false, null);
    }

    public void generateDesign(Connection conn, Properties cd, List selectedObjects, RelationalDesign relModel, boolean swapTargetModel, RDBMSSite site, boolean synchronize, Map selectedIDs) throws Exception {
        this.generateDesign(conn, cd, selectedObjects, relModel, swapTargetModel, site, synchronize, selectedIDs, null, -1);
    }

    public void generateDesign(Connection conn, Properties cd, List selectedObjects, RelationalDesign relModel, boolean swapTargetModel, RDBMSSite site, boolean synchronize, Map selectedIDs, String connName, int connType) throws Exception {
        this.relModel = relModel;
        DBMExtractionController.swapTargetModel = swapTargetModel;
        FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = !swapTargetModel;
        String dbname = "";
        try {
            dbname = conn.getMetaData().getDatabaseProductName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dsnName = ConnectionInfo.getConnectionName(cd);
        int type = ConnectionInfo.getConnectionType(cd);
        if (cd.isEmpty()) {
            if (connName != null) {
                dsnName = connName;
            }
            if (connType > -1) {
                type = connType;
            }
        }
        if (relModel == null || relModel.isEmpty()) {
            if (relModel != null) {
                this.design = relModel.getDesign();
                this.oldDesignPath = this.design.getDesignPath();
            } else {
                this.design = this.view.getCurrentDesign();
                this.oldDesignPath = this.view.getCurrentDesign().getDesignPath();
            }
            this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
            if (relModel == null) {
                RelationalDesign newRelDesign = this.design.addRelationalDesign(dsnName);
                this.design.setRelationalDesign(newRelDesign);
                this.relModel = newRelDesign;
            } else {
                this.design.setRelationalDesign(relModel);
            }
            if (site != null) {
                this.design.setSelectedRDBMSSite(site);
            } else {
                LOGGER.error("DBMExtractionController.generateDesign(): Unable to get appropriate RDBMS Site");
            }
            if (this.design.getRelationalDesign().getImportConnectionStamps().isEmpty() || this.design.getRelationalDesign().findImportConnectionStamp(dsnName) == -1) {
                if (cd.isEmpty()) {
                    int index = relModel.findImportConnectionStamp(dsnName);
                    if (index > -1) {
                        DBConnectionStamp importConnStamp = relModel.getImportConnectionStamp(index);
                        index = this.design.getRelationalDesign().addImportConnectionStamp(importConnStamp);
                    }
                    this.design.getRelationalDesign().setImportConnectionStampIndex(index);
                } else {
                    int index = this.design.getRelationalDesign().addImportConnectionStamp(new DBConnectionStamp(ConnectionInfo.getConnectionName(cd), cd.getProperty(PROPERTIES_CUSTOM_URL), cd.getProperty(PROPERTIES_USER), type));
                    this.design.getRelationalDesign().setImportConnectionStampIndex(index);
                }
            }
            new Thread(new EmptyRunner(conn, selectedObjects, type, dbname)).start();
        } else {
            this.oldDesign = relModel.getDesign();
            this.design = new Design(this.view, this.oldDesign);
            this.design.getDesignLevelSettings(true).loadDesignLevellSettingsFromString(this.oldDesign.getDesignLevelSettings().getDesignLevelSettingsAsString());
            this.view.setCurrentDesign(this.design);
            this.oldDesignPath = this.oldDesign.getDesignPath();
            this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
            this.design.getRelationalDesign().setName(dsnName);
            this.design.getRelationalDesign().setRelatedSyncModel(relModel);
            this.oldDesign.setRelationalDesign(relModel);
            this.isNewModel = false;
            if (site != null) {
                this.design.setSelectedRDBMSSite(site);
                this.oldDesign.setSelectedRDBMSSite(site);
            } else {
                LOGGER.error("DBMExtractionController.generateDesign(): Unable to get appropriate RDBMS Site");
            }
            if (this.design.getRelationalDesign().getImportConnectionStamps().isEmpty()) {
                if (cd.isEmpty()) {
                    int index = relModel.findImportConnectionStamp(dsnName);
                    if (index > -1) {
                        DBConnectionStamp importConnStamp = relModel.getImportConnectionStamp(index);
                        index = this.design.getRelationalDesign().addImportConnectionStamp(importConnStamp);
                    }
                    this.design.getRelationalDesign().setImportConnectionStampIndex(index);
                } else {
                    int index = this.design.getRelationalDesign().addImportConnectionStamp(new DBConnectionStamp(ConnectionInfo.getConnectionName(cd), cd.getProperty(PROPERTIES_CUSTOM_URL), cd.getProperty(PROPERTIES_USER), ConnectionInfo.getConnectionType(cd)));
                    this.design.getRelationalDesign().setImportConnectionStampIndex(index);
                }
            }
            new Thread(new Runner(conn, selectedObjects, type, synchronize, selectedIDs, dbname)).start();
        }
    }

    public boolean isSecondaryTables(int type) {
        return this.getDBMExtractionHandler(type).isSecondaryTables();
    }

    public void setSecondaryTables(int type, boolean secondaryTables) {
        this.getDBMExtractionHandler(type).setSecondaryTables(secondaryTables);
    }

    public boolean isSpatialProperties(int type) {
        return this.getDBMExtractionHandler(type).isSpatialProperties();
    }

    public void setSpatialProperties(int type, boolean spatial) {
        this.getDBMExtractionHandler(type).setSpatialProperties(spatial);
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public boolean isPartitions(int type) {
        return this.getDBMExtractionHandler(type).isPartitions();
    }

    public void setPartitions(int type, boolean partitions) {
        this.getDBMExtractionHandler(type).setPartitions(partitions);
    }

    public boolean isTriggers(int type) {
        return this.getDBMExtractionHandler(type).isTriggers();
    }

    public void setTriggers(int type, boolean triggers) {
        this.getDBMExtractionHandler(type).setTriggers(triggers);
    }

    public boolean isStructuredTypesScan(int type) {
        return this.getDBMExtractionHandler(type).isStructuredTypesScan();
    }

    public void setStructuredTypesScan(int type, boolean structuredTypesScan) {
        this.getDBMExtractionHandler(type).setStructuredTypesScan(structuredTypesScan);
    }

    private class EmptyRunner
    implements Runnable {
        private Connection conn;
        private List selectedObjects;
        private int selectedObjectsCount;
        private int type;
        private String dbName;
        ImportLogger importLog;

        public EmptyRunner(Connection conn, List selectedObjects, int type, String dbName) {
            this.conn = conn;
            this.selectedObjects = selectedObjects;
            this.selectedObjectsCount = selectedObjects.size();
            this.type = type;
            this.dbName = dbName == null ? "" : dbName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DBMExtractionController.this.relModel.setMainViewVisible(false);
                DBMExtractionController.this.design.setDisableTreeUpdate(true);
                this.importLog = new ImportLogger();
                try {
                    DBMExtractionController.this.monitor = new ProgressDialog(DBMExtractionController.this.view, "", 0, 100);
                    try {
                        DBMExtractionController.this.design.setPropagatePKChahges(false);
                        DBMExtractionController.this.view.setImporting(true);
                        ApplicationView.log(Messages.getString("DBMExtractionController.ImportingDBMetadata"));
                        ApplicationView.canLogging = false;
                        try {
                            DBMExtractionController.this.monitor.setProgress(5);
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.GenerateDesign"));
                            DBMExtractionController.this.monitor.setProgress(10);
                            TimeLog.log("Import begin");
                            DBMExtractionController.this.getDBMExtractionHandler(this.type).generateDesign(this.conn, this.selectedObjects, this.importLog, DBMExtractionController.this.monitor);
                            TimeLog.log("Import end");
                            if (DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign) {
                                String msg = DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).getName();
                                LOGGER.error("Error Generate Design: " + msg);
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DBMExtractionController.UnableToGenerateDesign"), Messages.getString("DBMExtractionController.ErrorGenerateDesign"), 0);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTypes"));
                            DBMExtractionController.this.monitor.setProgress(85);
                            try {
                                DBMExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                                DBMExtractionController.this.design.getDataTypesDesign().updateInheritances();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Types", e);
                            }
                            try {
                                DBMExtractionController.this.design.getRelationalDesign().createArcsFromTableCheckConstraints();
                            }
                            catch (Exception e) {
                                LOGGER.error("Error in creating Arcs from table Check constraints", e);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTables"));
                            DBMExtractionController.this.monitor.setProgress(90);
                            try {
                                ((DPVRelational)DBMExtractionController.this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Tables", e);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeViews"));
                            DBMExtractionController.this.monitor.setProgress(93);
                            try {
                                if (!(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                    DBMExtractionController.this.design.getRelationalDesign().createSubviewsOnSchema(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()));
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to create subviews ", e);
                            }
                            DBMExtractionController.this.monitor.setProgress(95);
                            DBMExtractionController.this.design.setDirty(true);
                            if (!(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            }
                            DBMExtractionController.this.monitor.setProgress(100);
                            TimeLog.log("Import end graphics");
                            DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                        }
                        finally {
                            DefaultDBMExtractionWizard.clearInstance();
                            DBMExtractionWizardDB2.clearInstance();
                            DBMExtractionWizardDB2v80.clearInstance();
                            DBMExtractionWizardODBC.clearInstance();
                            DBMExtractionWizardOracle.clearInstance();
                            DBMExtractionWizardSqlServer.clearInstance();
                            DBMExtractionWizardUDB.clearInstance();
                            if (DBMExtractionController.this.design != null) {
                                DBMExtractionController.this.design.setDirty(true);
                                if (!(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                    if (DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesignOracle) {
                                        ((StorageDesignOracle)DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite())).refreshSynonymReferences();
                                    }
                                    DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                                    DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).sortCollections();
                                }
                                DBMExtractionController.this.design.setPropagatePKChahges(true);
                                DBMExtractionController.this.design.setDisableTreeUpdate(false);
                            }
                            DBMExtractionController.this.view.setImporting(false);
                            ApplicationView.canLogging = true;
                            DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                            ApplicationView.log(Messages.getString("DBMExtractionController.ImportOfDBMetadataFinished"));
                        }
                    }
                    finally {
                        DBMExtractionController.this.monitor.close();
                    }
                    DBMExtractionController.this.view.setImporting(false);
                }
                catch (Throwable throwable) {
                    DBMExtractionController.this.view.setImporting(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DBMExtractionController.this.view.getCurrentDesign().getRelationalDesign().sortCollections();
                            DBMExtractionController.this.view.getCurrentDesign().getDataTypesDesign().sortCollections();
                            DBMExtractionController.this.relModel.setMainViewVisible(true);
                            DBMExtractionController.this.relModel.getMainView().straightenLines();
                            DBMExtractionController.this.view.centerDesign();
                            if (!DBMExtractionController.this.relModel.getMainView().isAutoRoute()) {
                                DBMExtractionController.this.relModel.createDefaultSelfReferencePoints();
                            }
                            if (DBMExtractionController.this.view.getSettings().showImportLog()) {
                                LogReport logPanel = new LogReport(DBMExtractionController.this.view);
                                if (DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign) {
                                    String msg = DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).getName();
                                    logPanel.setLog(msg);
                                } else {
                                    logPanel.setLog(EmptyRunner.this.importLog.generateDDLReport(DBMExtractionController.this.view, EmptyRunner.this.selectedObjectsCount));
                                }
                                logPanel.showDialog(new Dimension(750, 550));
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e) {
                DBMExtractionController.this.view.setImporting(false);
                LOGGER.error("Error Generate Design: " + DBMExtractionController.this.view.getDesignName(), e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DBMExtractionController.UnableToGenerateDesign"), Messages.getString("DBMExtractionController.ErrorGenerateDesign"), 0);
            }
        }
    }

    private class Runner
    implements Runnable {
        private Connection conn;
        private List selectedObjects;
        private int type;
        private boolean synchronize;
        private Map selectedIDs;
        String dbName;
        ImportLogger importLog;

        public Runner(Connection conn, List selectedObjects, int type, boolean synchronize, Map selectedIDs, String dbName) {
            this.conn = conn;
            this.selectedObjects = selectedObjects;
            this.type = type;
            this.synchronize = synchronize;
            this.selectedIDs = selectedIDs;
            this.dbName = dbName == null ? "" : dbName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block27: {
                try {
                    DBMExtractionController.this.oldDesign.getDesign().setDisableTreeUpdate(true);
                    DBMExtractionController.this.design.getDesign().setDisableTreeUpdate(true);
                    DBMExtractionController.this.oldDesign.getAppView().getPersistenceManager().readSystemInit(DBMExtractionController.this.design);
                    this.importLog = new ImportLogger();
                    DBMExtractionController.this.monitor = new ProgressDialog(DBMExtractionController.this.view, "", 0, 100);
                    try {
                        DBMExtractionController.this.design.setPropagatePKChahges(false);
                        DBMExtractionController.this.view.setImporting(true);
                        ApplicationView.log(Messages.getString("DBMExtractionController.ImportingDBMetadata"));
                        ApplicationView.canLogging = false;
                        try {
                            DBMExtractionController.this.monitor.setProgress(5);
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.GenerateDesign"));
                            DBMExtractionController.this.monitor.setProgress(10);
                            TimeLog.log("Import begin");
                            DBMExtractionController.this.getDBMExtractionHandler(this.type).generateDesign(this.conn, this.selectedObjects, this.importLog, DBMExtractionController.this.monitor);
                            TimeLog.log("Import end");
                            if (DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign) {
                                String msg = DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).getName();
                                LOGGER.error("Error Generate Design: " + msg);
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DBMExtractionController.UnableToGenerateDesign"), Messages.getString("DBMExtractionController.ErrorGenerateDesign"), 0);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTypes"));
                            DBMExtractionController.this.monitor.setProgress(85);
                            try {
                                DBMExtractionController.this.design.getDataTypesDesign().rearrangeTypes();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Types", e);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeTables"));
                            DBMExtractionController.this.monitor.setProgress(90);
                            try {
                                DBMExtractionController.this.design.getRelationalDesign().createArcsFromTableCheckConstraints();
                            }
                            catch (Exception e) {
                                LOGGER.error("Error in creating Arcs from table Check constraints", e);
                            }
                            try {
                                ((DPVRelational)DBMExtractionController.this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to rearrange Tables", e);
                            }
                            DBMExtractionController.this.monitor.setNote(Messages.getString("DBMExtractionController.RearrangeViews"));
                            DBMExtractionController.this.monitor.setProgress(93);
                            try {
                                if (!(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                    DBMExtractionController.this.design.getRelationalDesign().createSubviewsOnSchema(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()));
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Unable to create subviews ", e);
                            }
                            DBMExtractionController.this.monitor.setProgress(95);
                            DBMExtractionController.this.design.setDirty(true);
                            if (!(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            }
                            DBMExtractionController.this.monitor.setProgress(100);
                            TimeLog.log("Import end graphics");
                            DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                        }
                        finally {
                            DefaultDBMExtractionWizard.clearInstance();
                            DBMExtractionWizardDB2.clearInstance();
                            DBMExtractionWizardDB2v80.clearInstance();
                            DBMExtractionWizardODBC.clearInstance();
                            DBMExtractionWizardOracle.clearInstance();
                            DBMExtractionWizardSqlServer.clearInstance();
                            DBMExtractionWizardUDB.clearInstance();
                            DBMExtractionController.this.design.setDirty(true);
                            if (!(DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()) instanceof StorageDesign.NullStorageDesign)) {
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).setOpen(true);
                                DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite()).sortCollections();
                            }
                            DBMExtractionController.this.design.setPropagatePKChahges(true);
                            DBMExtractionController.this.oldDesign.setDisableTreeUpdate(false);
                            DBMExtractionController.this.design.setDisableTreeUpdate(true);
                        }
                    }
                    finally {
                        DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                        DBMExtractionController.this.view.setImporting(false);
                        ApplicationView.canLogging = true;
                        ApplicationView.log(Messages.getString("DBMExtractionController.ImportOfDBMetadataFinished"));
                        DBMExtractionController.this.monitor.close();
                    }
                    RelationalDesign sourceModel = null;
                    if (DBMExtractionController.this.design != null) {
                        sourceModel = DBMExtractionController.this.design.getRelationalDesign();
                    }
                    boolean noDDLPreview = DBMExtractionController.this.relModel == null || DBMExtractionController.this.relModel.isEmpty();
                    DBMExtractionController.this.design = DBMExtractionController.this.oldDesign;
                    DBMExtractionController.this.view.setCurrentDesign(DBMExtractionController.this.design);
                    DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                    StorageDesign sd = DBMExtractionController.this.design.getStorageDesign(DBMExtractionController.this.design.getSelectedRDBMSSite());
                    if (sd instanceof StorageDesign.NullStorageDesign) break block27;
                    if (!sd.isOpen()) {
                        sd.openStorageDesign();
                        DBMExtractionController.this.view.getBrowserPanel().getNavigationTreeDesign().updateSubtree(sd);
                    }
                    sd.setDirty(true);
                    DBMExtractionController.this.design.getRelationalDesign().sortCollections();
                    DBMExtractionController.this.design.getDataTypesDesign().sortCollections();
                    try {
                        PropertiesComparator.DDL_ONLY = true;
                        if (this.dbName.toUpperCase().indexOf("HIVE") > -1) {
                            PropertiesComparator.HIVE_DATA_TYPES = true;
                        }
                        ModelChooserDialog.isSelectedDatabase = true;
                        CompareModelsDialog compareDialog = swapTargetModel ? new CompareModelsDialog(DBMExtractionController.this.view, DBMExtractionController.this.design.getRelationalDesign(), sourceModel, noDDLPreview, DBMExtractionController.this.isNewModel, true, this.synchronize, this.selectedIDs) : new CompareModelsDialog(DBMExtractionController.this.view, sourceModel, DBMExtractionController.this.design.getRelationalDesign(), noDDLPreview, DBMExtractionController.this.isNewModel, false, this.synchronize, this.selectedIDs);
                        DBMExtractionController.this.view.setMerging(false);
                        compareDialog.show();
                    }
                    finally {
                        PropertiesComparator.DDL_ONLY = false;
                        DBMExtractionController.this.view.setMerging(false);
                        FKIndexAssociation.RESET_COLUMNS_IN_RESETMANDATORY_FROM_COLUMNS = true;
                    }
                }
                catch (Exception e) {
                    DBMExtractionController.this.view.setImporting(false);
                    DBMExtractionController.this.design = DBMExtractionController.this.oldDesign;
                    DBMExtractionController.this.view.setCurrentDesign(DBMExtractionController.this.design);
                    DBMExtractionController.this.view.getCurrentDesign().setDesignPath(DBMExtractionController.this.oldDesignPath);
                    LOGGER.error("Error Generate Design: " + DBMExtractionController.this.view.getDesignName(), e);
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DBMExtractionController.UnableToGenerateDesign"), Messages.getString("DBMExtractionController.ErrorGenerateDesign"), 0);
                }
            }
        }
    }
}

