/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceUDBv81
extends DDLStatementHandler {
    private TableSpaceUDB tableSpace;
    private RDBMSSite site;
    private StorageDesignUDB stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceUDBv81.class);

    public SHCreateTablespaceUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTablespaceUDBv81.clearCR(line);
        if (Token.startsWithString(statement, "create tablespace") || Token.startsWithString(statement, "create regular tablespace") || Token.startsWithString(statement, "create long tablespace") || Token.startsWithString(statement, "create large tablespace") || Token.startsWithString(statement, "create temporary tablespace") || Token.startsWithString(statement, "create system temporary tablespace") || Token.startsWithString(statement, "create user temporary tablespace")) {
            try {
                this.parseTablespace(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB 8.1 failed!", e);
                this.importLog.addFailedStatement(SHCreateTablespaceUDBv81.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignUDB)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getTableSpaceSet().createTableSpace();
            this.initType();
            this.initName();
            this.initDBPartitionGroup();
            this.initPageSize();
            this.initManagedBy();
            this.initUsingBlock();
            this.initExtentSize();
            this.initPrefetchSize();
            this.initBufferpool();
            this.initOverhead();
            this.initTransferRate();
            this.initDroppedTableRecovery();
            this.initFileSystemCaching();
            this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
        }
    }

    private void initType() {
        String type = Token.getTokenAfter(this.statement, "CREATE").trim();
        if ("USER".equalsIgnoreCase(type)) {
            this.tableSpace.setDataType("USER TEMPORARY");
        } else if ("LONG".equalsIgnoreCase(type) || "LARGE".equalsIgnoreCase(type)) {
            this.tableSpace.setDataType("LARGE");
        } else if ("SYSTEM".equalsIgnoreCase(type)) {
            this.tableSpace.setDataType("SYSTEM TEMPORARY");
        } else {
            this.tableSpace.setDataType("REGULAR");
        }
    }

    private void initName() {
        String name = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(name);
    }

    private void initDBPartitionGroup() {
        if (Token.hasToken(this.statement, "IN")) {
            String afterIn = this.statement.substring(this.statement.toUpperCase().indexOf("IN") + 3);
            if (Token.getFirstToken(afterIn).equalsIgnoreCase("NODEGROUP")) {
                afterIn = Token.cutFirstToken(afterIn);
            } else if (Token.getFirstToken(afterIn).equalsIgnoreCase("DATABASE")) {
                afterIn = Token.cutFirstToken(afterIn);
                afterIn = Token.cutFirstToken(afterIn);
                afterIn = Token.cutFirstToken(afterIn);
            }
            String nodeGroupName = Token.getValBetweenDoubleQuotes(Token.getFirstToken(afterIn));
            DBPartitionGroupUDBv81 group = (DBPartitionGroupUDBv81)this.stoDesign.getNodeGroupSet().getByName(nodeGroupName);
            if (group != null) {
                this.tableSpace.setNodeGroup(group);
            } else {
                group = (DBPartitionGroupUDBv81)this.stoDesign.getNodeGroupSet().createNodeGroup();
                group.setName(nodeGroupName);
                this.tableSpace.setNodeGroup(group);
            }
        }
    }

    private void initPageSize() {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            String pageSize = Token.getStringAfterToken(this.statement, "PAGESIZE");
            String pageSizeInteger = Token.getFirstToken(pageSize);
            String pageSizeUnit = Token.cutFirstToken(pageSize);
            pageSizeUnit = Token.getFirstToken(pageSizeUnit);
            if (this.endsWithValidUnit(pageSizeInteger)) {
                pageSizeUnit = pageSizeInteger.substring(pageSizeInteger.length() - 1);
                pageSizeInteger = pageSizeInteger.substring(0, pageSizeInteger.length() - 1);
            }
            try {
                int size = Integer.parseInt(pageSizeInteger);
                if (size == 4096) {
                    size = 4;
                } else if (size == 8192) {
                    size = 8;
                } else if (size == 16384) {
                    size = 16;
                } else if (size == 32768) {
                    size = 32;
                }
                if (size == 4 || size == 8 || size == 16 || size == 32) {
                    this.tableSpace.setPageSize(size);
                } else {
                    this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateTablespaceUDB.initPageSize : value must represent 4K, 8K, 16K or 32K");
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initPageSize : " + e.getMessage());
            }
        }
    }

    private void initManagedBy() {
        if (Token.hasToken(this.statement, "MANAGED")) {
            String sizeAttributes;
            block28: {
                int i;
                String managedBy = Token.getStringAfterToken(this.statement, "MANAGED");
                managedBy = Token.cutFirstToken(managedBy);
                if ((managedBy = Token.getFirstToken(managedBy)).equalsIgnoreCase("SYSTEM") || managedBy.equalsIgnoreCase("DATABASE")) {
                    this.tableSpace.setManagedBy(managedBy.toUpperCase());
                } else if (managedBy.equalsIgnoreCase("AUTOMATIC")) {
                    this.tableSpace.setManagedBy("AUTOMATIC STORAGE");
                }
                sizeAttributes = Token.getStringAfterToken(this.statement, "MANAGED");
                if (Token.hasToken(sizeAttributes, "AUTORESIZE")) {
                    String autoResize = Token.getStringAfterToken(sizeAttributes, "AUTORESIZE");
                    if ((autoResize = Token.getFirstToken(autoResize)).equalsIgnoreCase("YES") || autoResize.equalsIgnoreCase("NO")) {
                        this.tableSpace.setAutoResize(autoResize);
                    } else {
                        this.importLog.addWarning("Wrong AUTORESIZE format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : AUTORESIZE not YES or NO");
                    }
                }
                if (Token.hasToken(sizeAttributes, "INITIALSIZE")) {
                    String initialSize = Token.getStringAfterToken(sizeAttributes, "INITIALSIZE");
                    String initialSizeInteger = Token.getFirstToken(initialSize);
                    String initialSizeUnit = Token.cutFirstToken(initialSize);
                    initialSizeUnit = Token.getFirstToken(initialSizeUnit);
                    if (this.endsWithValidUnit(initialSizeInteger)) {
                        initialSizeUnit = initialSizeInteger.substring(initialSizeInteger.length() - 1);
                        initialSizeInteger = initialSizeInteger.substring(0, initialSizeInteger.length() - 1);
                    }
                    if (this.isValidUnit(initialSizeUnit)) {
                        try {
                            i = Integer.parseInt(initialSizeInteger);
                            this.tableSpace.setInitialSize(initialSizeInteger + ' ' + initialSizeUnit);
                        }
                        catch (NumberFormatException e) {
                            this.importLog.addWarning("Wrong INITIALSIZE format in statement " + this.statement);
                            LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : " + e.getMessage());
                        }
                    } else {
                        this.importLog.addWarning("Wrong INITIALSIZE format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : INITIALSIZE unit not K, M or G");
                    }
                }
                if (Token.hasToken(sizeAttributes, "INCREASESIZE")) {
                    String increaseSize = Token.getStringAfterToken(sizeAttributes, "INCREASESIZE");
                    String increaseSizeInteger = Token.getFirstToken(increaseSize);
                    String increaseSizeUnit = Token.cutFirstToken(increaseSize);
                    increaseSizeUnit = Token.getFirstToken(increaseSizeUnit);
                    if (this.endsWithValidUnit(increaseSizeInteger)) {
                        increaseSizeUnit = increaseSizeInteger.substring(increaseSizeInteger.length() - 1);
                        increaseSizeInteger = increaseSizeInteger.substring(0, increaseSizeInteger.length() - 1);
                    }
                    if (this.isValidUnit(increaseSizeUnit) || increaseSizeUnit.equalsIgnoreCase("PERCENT")) {
                        try {
                            i = Integer.parseInt(increaseSizeInteger);
                            if (increaseSizeUnit.equalsIgnoreCase("PERCENT") && i > 100) {
                                this.importLog.addWarning("Wrong INCREASESIZE format in statement " + this.statement);
                                LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : INCREASESIZE value greater than 100 PERCENT");
                                break block28;
                            }
                            this.tableSpace.setIncreaseSize(increaseSizeInteger + ' ' + increaseSizeUnit);
                        }
                        catch (NumberFormatException e) {
                            this.importLog.addWarning("Wrong INCREASESIZE format in statement " + this.statement);
                            LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : " + e.getMessage());
                        }
                    } else {
                        this.importLog.addWarning("Wrong INCREASESIZE format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : INCREASESIZE unit not K, M, G or PERCENT");
                    }
                }
            }
            if (Token.hasToken(sizeAttributes, "MAXSIZE")) {
                String maxSize = Token.getStringAfterToken(sizeAttributes, "MAXSIZE");
                String maxSizeInteger = Token.getFirstToken(maxSize);
                if (maxSizeInteger.equalsIgnoreCase("NONE")) {
                    this.tableSpace.setMaxSize("NONE");
                } else {
                    String maxSizeUnit = Token.cutFirstToken(maxSize);
                    maxSizeUnit = Token.getFirstToken(maxSizeUnit);
                    if (this.endsWithValidUnit(maxSizeInteger)) {
                        maxSizeUnit = maxSizeInteger.substring(maxSizeInteger.length() - 1);
                        maxSizeInteger = maxSizeInteger.substring(0, maxSizeInteger.length() - 1);
                    }
                    if (this.isValidUnit(maxSizeUnit)) {
                        try {
                            int i = Integer.parseInt(maxSizeInteger);
                            this.tableSpace.setMaxSize(maxSizeInteger + ' ' + maxSizeUnit);
                        }
                        catch (NumberFormatException e) {
                            this.importLog.addWarning("Wrong MAXSIZE format in statement " + this.statement);
                            LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : " + e.getMessage());
                        }
                    } else {
                        this.importLog.addWarning("Wrong MAXSIZE format in statement " + this.statement);
                        LOGGER.error("wrong format in SHCreateTablespaceUDB.initManagedBy : MAXSIZE unit not K, M or G");
                    }
                }
            }
        }
    }

    private boolean isValidUnit(String unit) {
        return unit.equalsIgnoreCase("K") || unit.equalsIgnoreCase("M") || unit.equalsIgnoreCase("G");
    }

    private boolean endsWithValidUnit(String value) {
        return value.endsWith("K") || value.endsWith("M") || value.endsWith("G");
    }

    private void initUsingBlock() {
        int ind;
        if (Token.hasToken(this.statement, "USING") && (ind = this.statement.indexOf("USING")) > -1) {
            String temp = this.statement.substring(ind);
            while (temp.indexOf("USING") > -1) {
                String val = Token.getValBetweenBrackets(temp, 1);
                String temp_after = Token.getValAfterBrackets(temp, 1);
                if (temp.length() == temp_after.length()) break;
                ContainerUDB container = ((StorageDesignUDB)this.tableSpace.getStorageDesign()).getContainerSet().createContainer();
                if (container == null) continue;
                container.setTableSpace(this.tableSpace);
                container.setContainers(val);
                this.design.getRelationalDesign().stampModelObjectDDL(container);
                if (temp_after.toUpperCase().startsWith("ON")) {
                    String onNodes = Token.getValBetweenBrackets(temp_after, 1);
                    container.setOnNodes(onNodes.trim());
                }
                temp = Token.getValAfterBrackets(temp_after, 1);
            }
        }
    }

    private void initExtentSize() {
        if (Token.hasToken(this.statement, "EXTENTSIZE")) {
            String extentSize = Token.getStringAfterToken(this.statement, "EXTENTSIZE");
            String extentSizeInteger = Token.getFirstToken(extentSize);
            String extentSizeUnit = Token.cutFirstToken(extentSize);
            extentSizeUnit = Token.getFirstToken(extentSizeUnit);
            if (this.endsWithValidUnit(extentSizeInteger)) {
                extentSizeUnit = extentSizeInteger.substring(extentSizeInteger.length() - 1);
                extentSizeInteger = extentSizeInteger.substring(0, extentSizeInteger.length() - 1);
            }
            try {
                int i = Integer.parseInt(extentSizeInteger);
                if (this.isValidUnit(extentSizeUnit) && !extentSizeUnit.equalsIgnoreCase("G")) {
                    this.tableSpace.setExtentSize(extentSizeInteger + ' ' + extentSizeUnit);
                } else {
                    this.tableSpace.setExtentSize(extentSizeInteger);
                }
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong EXTENTSIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initExtentSize : " + e.getMessage());
            }
        }
    }

    private void initPrefetchSize() {
        if (Token.hasToken(this.statement, "PREFETCHSIZE")) {
            String prefetchSize = Token.getStringAfterToken(this.statement, "PREFETCHSIZE");
            String prefetchSizeInteger = Token.getFirstToken(prefetchSize);
            if (prefetchSizeInteger.equalsIgnoreCase("AUTOMATIC")) {
                this.tableSpace.setPrefetchSize("AUTOMATIC");
            } else {
                String prefetchSizeUnit = Token.cutFirstToken(prefetchSize);
                prefetchSizeUnit = Token.getFirstToken(prefetchSizeUnit);
                if (this.endsWithValidUnit(prefetchSizeInteger)) {
                    prefetchSizeUnit = prefetchSizeInteger.substring(prefetchSizeInteger.length() - 1);
                    prefetchSizeInteger = prefetchSizeInteger.substring(0, prefetchSizeInteger.length() - 1);
                }
                try {
                    int i = Integer.parseInt(prefetchSizeInteger);
                    if (this.isValidUnit(prefetchSizeUnit)) {
                        this.tableSpace.setPrefetchSize(prefetchSizeInteger + ' ' + prefetchSizeUnit);
                    } else {
                        this.tableSpace.setPrefetchSize(prefetchSizeInteger);
                    }
                }
                catch (NumberFormatException e) {
                    this.importLog.addWarning("Wrong PREFETCHSIZE format in statement " + this.statement);
                    LOGGER.error("wrong format in SHCreateTablespaceUDB.initPrefetchSize : " + e.getMessage());
                }
            }
        }
    }

    private void initBufferpool() {
        String nameBP;
        if (Token.hasToken(this.statement, "BUFFERPOOL") && !(nameBP = Token.getValBetweenDoubleQuotes(Token.getTokenAfter(this.statement, "BUFFERPOOL").trim())).equals("")) {
            BufferPoolUDBv81 bufferPool = (BufferPoolUDBv81)this.stoDesign.getBufferPoolSet().getByName(nameBP);
            if (bufferPool == null) {
                BufferPoolUDBv81 newBufferPool = (BufferPoolUDBv81)this.stoDesign.getBufferPoolSet().createBufferPool();
                newBufferPool.setName(nameBP);
                this.design.getRelationalDesign().stampModelObjectDDL(newBufferPool);
                this.tableSpace.setBufferPool(newBufferPool);
            } else {
                this.tableSpace.setBufferPool(bufferPool);
            }
        }
    }

    private void initOverhead() {
        if (Token.hasToken(this.statement, "OVERHEAD")) {
            try {
                float overhead = Float.parseFloat(Token.getTokenAfter(this.statement, "OVERHEAD"));
                this.tableSpace.setOverhead(overhead);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initOverhead : " + e.getMessage());
            }
        }
    }

    private void initTransferRate() {
        if (Token.hasToken(this.statement, "TRANSFERRATE")) {
            try {
                float transferRate = Float.parseFloat(Token.getTokenAfter(this.statement, "TRANSFERRATE"));
                this.tableSpace.setTransferRate(transferRate);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initTransferRate : " + e.getMessage());
            }
        }
    }

    private void initDroppedTableRecovery() {
        String dropped;
        if (Token.hasToken(this.statement, "RECOVERY") && "ON".equalsIgnoreCase(dropped = Token.getTokenAfter(this.statement, "RECOVERY").trim())) {
            this.tableSpace.setDroppedTableRecovery(true);
        }
    }

    private void initFileSystemCaching() {
        if (this.statement.indexOf("NO FILE SYSTEM CACHING") > -1) {
            this.tableSpace.setFileSystemCaching(false);
        } else if (this.statement.indexOf("FILE SYSTEM CACHING") > -1) {
            this.tableSpace.setFileSystemCaching(true);
        }
    }
}

