/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.NameElements;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public class SHColumnElementsUDBv81
implements StatementsConstants {
    private static final String ZERO = "0";
    private static final String[] CONSTRAINT_NAMES = new String[]{"CONSTRAINT", "PRIMARY", "UNIQUE", "FOREIGN", "CHECK"};
    private static final String NO_CACHE = "NO CACHE";
    private static final String NO_CYCLE = "NO CYCLE";
    private static final String NO_MAXVALUE = "NO MAXVALUE";
    private static final String NO_MINVALUE = "NO MINVALUE";
    private static final String NO_ORDER = "NO ORDER";
    private static final String INCREMENT_BY = "INCREMENT BY";
    private static final String NOT_ENFORCED = "NOT ENFORCED";
    private static final String DISABLE_QUERY_OPTIMIZATION = "DISABLE QUERY OPTIMIZATION";
    private Map mapElementsColumn;
    private String statement;
    private Set constraints = new HashSet<String>(Arrays.asList(CONSTRAINT_NAMES));
    private static final Logger LOGGER = new Logger(SHColumnElementsUDBv81.class);

    private void parseColumns(String columnStatement, boolean isSummary) {
        this.statement = columnStatement;
        this.mapElementsColumn = new HashMap();
        try {
            if (this.initColumnName()) {
                if (!isSummary) {
                    this.initDatatype();
                }
                String options = this.statement;
                this.initNotNull();
                this.statement = options;
                this.initWithDefault();
                this.statement = options;
                this.initLobOptions();
                this.statement = options;
                this.initDataLinkOptions();
                this.statement = options;
                this.initIdentity();
                this.statement = options;
                this.initCompressSystemDefault();
                this.statement = options;
                this.initPrimaryKeyOrUnique();
                this.statement = options;
                this.initFor();
                this.statement = options;
                this.initReferences();
                this.statement = options;
                this.initConstraintCheck();
            } else {
                this.initConstraints();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + this.statement + " for UDB failed!", e);
        }
    }

    private boolean initColumnName() {
        String value = Token.getFirstToken(this.statement);
        if (this.constraints.contains(value.toUpperCase())) {
            this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.TRUE);
            return false;
        }
        String columnName = "";
        if (this.statement.indexOf("\"") > -1) {
            columnName = Token.getValBetweenDoubleQuotes(this.statement);
            this.statement = Token.getStringAfter(this.statement, columnName);
            this.statement = Token.cutFirstToken(this.statement);
        } else {
            columnName = Token.getFirstToken(this.statement).trim();
            this.statement = Token.getStringAfter(this.statement, columnName);
        }
        this.mapElementsColumn.put("IS_CONSTRAINT", Boolean.FALSE);
        this.mapElementsColumn.put("columnname", columnName);
        return true;
    }

    private void initDatatype() {
        if (!Token.hasString(this.statement.toUpperCase(), "USER GENERATED") && !this.statement.toUpperCase().startsWith("FOREIGN")) {
            int index;
            String dtName = this.statement;
            String dtype = this.searchWhichDatatype(dtName);
            String type = null;
            String afterType = null;
            if (dtype != null) {
                type = dtype;
                afterType = Token.getStringAfter(this.statement, dtype).trim();
                if (afterType.startsWith("(") && (index = afterType.indexOf(")")) > -1) {
                    type = dtype + afterType.substring(0, index + 1);
                }
            }
            if (dtype == null) {
                dtype = this.searchNotStandartDatatypes(this.statement);
                if (dtype != null && !"".equalsIgnoreCase(this.statement.trim())) {
                    type = dtype;
                    afterType = Token.getStringAfter(this.statement, dtype).trim();
                    if (afterType.startsWith("(") && (index = afterType.indexOf(")")) > -1) {
                        type = dtype + afterType.substring(0, index + 1);
                    }
                    this.mapElementsColumn.put("typename", type);
                } else {
                    this.mapElementsColumn.put(NameElements.COL_STRUCTURED_TYPE, dtName);
                }
            }
            if (dtype != null) {
                String datatype = StandardDatatypeNames.getUsedDatatypeName(dtype);
                if (Token.hasCloseAndOpenBrackets(datatype)) {
                    type = datatype;
                    dtype = datatype = Token.getValBeforeBrackets(datatype).trim();
                }
                if (datatype != null) {
                    type = Token.cutTokenFromFront(type, dtype);
                    this.mapElementsColumn.put("datatype", datatype);
                    if (!type.equalsIgnoreCase("")) {
                        boolean hasBrackets = Token.hasCloseAndOpenBrackets(type);
                        if (hasBrackets) {
                            String parameters = Token.getValBetweenBrackets(type, 1);
                            int positionKomma = parameters.indexOf(",");
                            if (positionKomma != -1) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                            } else if (datatype.equals("DECIMAL")) {
                                this.mapElementsColumn.put("size", ZERO);
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", parameters.trim());
                            } else if (datatype.equalsIgnoreCase("NUMERIC")) {
                                if (positionKomma != -1) {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                                    this.mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                                } else {
                                    this.mapElementsColumn.put("size", ZERO);
                                    this.mapElementsColumn.put("precision", parameters.trim());
                                    this.mapElementsColumn.put("scale", ZERO);
                                }
                            } else {
                                this.mapElementsColumn.put("scale", ZERO);
                                this.mapElementsColumn.put("precision", ZERO);
                                this.mapElementsColumn.put("size", parameters.replaceAll(" ", ""));
                            }
                            this.statement = Token.cutFirstToken(this.statement);
                        }
                    } else {
                        this.statement = Token.cutFirstToken(this.statement);
                    }
                } else {
                    StringBuffer message = new StringBuffer("datatype is unknown in SHColumnElements.initDatatype: ");
                    LOGGER.error(message.toString());
                }
            } else {
                this.statement = Token.cutFirstToken(this.statement);
            }
            if (this.statement.trim().startsWith("(")) {
                this.statement = Token.getValAfterBrackets(this.statement.trim(), 1);
            }
        }
    }

    protected String searchWhichDatatype(String statement) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("DB2/UDB 9");
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = statement.toUpperCase().startsWith(name);
            if (!isTrue) continue;
            try {
                char nextChar = statement.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t' || nextChar == ',' || nextChar == ')';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private String searchNotStandartDatatypes(String string) {
        String[] names = NotStandartDataTypeNames.getAllNewTypes();
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            boolean isTrue = string.startsWith(name);
            if (!isTrue) continue;
            try {
                char nextChar = string.charAt(name.length());
                isTrue = nextChar == '(' || nextChar == ' ' || nextChar == '\n' || nextChar == '\t';
            }
            catch (StringIndexOutOfBoundsException e) {
                isTrue = true;
            }
            if (!isTrue) continue;
            return name;
        }
        return null;
    }

    private void initNotNull() {
        boolean notNull = false;
        while (Token.hasToken(this.statement, "NULL")) {
            if (Token.getTokenBefore(this.statement, "NULL").equalsIgnoreCase("NOT")) {
                notNull = true;
                break;
            }
            this.statement = Token.getStringAfterToken(this.statement, "NULL");
        }
        this.mapElementsColumn.put("NOT NULL", notNull);
    }

    private void initIdentity() {
        int ind = this.statement.toUpperCase().indexOf("GENERATED");
        if (ind > -1) {
            this.statement = this.statement.substring(ind);
            String generate = Token.getTokenAfter(this.statement, "GENERATED").trim();
            if (generate.equalsIgnoreCase("ALWAYS")) {
                this.mapElementsColumn.put("GENERATED", "ALWAYS");
            } else if (generate.equalsIgnoreCase("BY")) {
                this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
            }
            if (Token.hasToken(this.statement, "IDENTITY")) {
                if (this.mapElementsColumn.get("GENERATED") == null) {
                    this.mapElementsColumn.put("GENERATED", "BY DEFAULT");
                }
                if (Token.hasCloseAndOpenBrackets(this.statement)) {
                    int pos = this.statement.indexOf(40);
                    this.statement = this.statement.substring(pos).trim();
                    String elements = Token.getValBetweenBrackets(this.statement);
                    if (elements.toUpperCase().indexOf("START") > -1) {
                        String startWith = Token.getTokenAfter(elements, "WITH").trim();
                        if (startWith.endsWith(",")) {
                            startWith = startWith.substring(0, startWith.length() - 1);
                        }
                        this.mapElementsColumn.put("START", startWith);
                    }
                    if (elements.toUpperCase().indexOf(INCREMENT_BY) > -1) {
                        String increment = Token.getTokenAfter(elements, "BY").trim();
                        if (increment.endsWith(",")) {
                            increment = increment.substring(0, increment.length() - 1);
                        }
                        this.mapElementsColumn.put("INCREMENT", increment);
                    }
                    if (Token.hasToken(elements, "CACHE")) {
                        if (elements.toUpperCase().indexOf(NO_CACHE) > -1) {
                            this.mapElementsColumn.put("CACHE", "NO");
                        } else {
                            String cache = Token.getTokenAfter(elements, "CACHE").trim();
                            if (cache.endsWith(",")) {
                                cache = cache.substring(0, cache.length() - 1);
                            }
                            this.mapElementsColumn.put("CACHE", cache);
                        }
                    }
                    if (Token.hasToken(elements, "CYCLE")) {
                        if (elements.toUpperCase().indexOf(NO_CYCLE) > -1) {
                            this.mapElementsColumn.put("CYCLE", "NO");
                        } else {
                            this.mapElementsColumn.put("CYCLE", "YES");
                        }
                    }
                    if (Token.hasToken(elements, "MAXVALUE")) {
                        if (elements.toUpperCase().indexOf(NO_MAXVALUE) > -1) {
                            this.mapElementsColumn.put("MAXVALUE", "NO");
                        } else {
                            String maxValue = Token.getTokenAfter(elements, "MAXVALUE").trim();
                            if (maxValue.endsWith(",")) {
                                maxValue = maxValue.substring(0, maxValue.length() - 1);
                            }
                            this.mapElementsColumn.put("MAXVALUE", maxValue);
                        }
                    }
                    if (Token.hasToken(elements, "MINVALUE")) {
                        if (elements.toUpperCase().indexOf(NO_MINVALUE) > -1) {
                            this.mapElementsColumn.put("MINVALUE", "NO");
                        } else {
                            String minValue = Token.getTokenAfter(elements, "MINVALUE").trim();
                            if (minValue.endsWith(",")) {
                                minValue = minValue.substring(0, minValue.length() - 1);
                            }
                            this.mapElementsColumn.put("MINVALUE", minValue);
                        }
                    }
                    if (Token.hasToken(elements, "ORDER")) {
                        if (elements.toUpperCase().indexOf(NO_ORDER) > -1) {
                            this.mapElementsColumn.put("ORDER", "NO");
                        } else {
                            this.mapElementsColumn.put("ORDER", "YES");
                        }
                    }
                    pos = this.statement.indexOf(41);
                    this.statement = this.statement.substring(pos + 1).trim();
                }
            } else if (Token.hasCloseAndOpenBrackets(this.statement)) {
                if (this.mapElementsColumn.get("GENERATED") == null) {
                    this.mapElementsColumn.put("GENERATED", "ALWAYS");
                }
                int pos = this.statement.indexOf(40);
                this.statement = this.statement.substring(pos).trim();
                String generationExpression = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("GENERATION_EXPRESSION", generationExpression);
                pos = this.statement.indexOf(41);
                this.statement = this.statement.substring(pos + 1).trim();
            }
        }
    }

    private void initCompressSystemDefault() {
        if (this.statement.toUpperCase().indexOf("COMPRESS SYSTEM DEFAULT") > -1) {
            this.mapElementsColumn.put("COMPRESS SYSTEM DEFAULT", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("COMPRESS SYSTEM DEFAULT", Boolean.FALSE);
        }
    }

    private void initPrimaryKeyOrUnique() {
        boolean isPrimary = Token.hasToken(this.statement, "PRIMARY");
        if (isPrimary) {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("PRIMARY KEY", Boolean.FALSE);
            boolean isUnique = Token.hasToken(this.statement, "UNIQUE");
            if (isUnique) {
                this.mapElementsColumn.put("UNIQUE", Boolean.TRUE);
            } else {
                this.mapElementsColumn.put("UNIQUE", Boolean.FALSE);
            }
        }
    }

    private void initWithDefault() {
        int ind = this.statement.toUpperCase().indexOf("DEFAULT");
        if (ind > -1) {
            if (!Token.hasToken(this.statement, "GENERATED")) {
                this.statement = this.statement.substring(ind);
                this.statement = Token.getStringAfter(this.statement, "DEFAULT");
                String withDefault = "";
                withDefault = Token.getFirstToken(this.statement).startsWith("'") ? Token.getValBetweenQuotes(this.statement).trim() : this.initDefaultValue(this.statement);
                this.mapElementsColumn.put("IS DEFAULT", Boolean.TRUE);
                if (!(withDefault.equalsIgnoreCase("REFERENCES") || withDefault.equalsIgnoreCase("CONSTRAINT") || withDefault.equalsIgnoreCase("FIELDPROC"))) {
                    this.mapElementsColumn.put("DEFAULT", withDefault);
                }
            } else {
                this.mapElementsColumn.put("IS DEFAULT", Boolean.FALSE);
            }
        }
    }

    private String initDefaultValue(String defaultClause) {
        int index;
        String value = Token.getFirstToken(defaultClause);
        String next = Token.getStringAfter(defaultClause, value);
        if (value.equalsIgnoreCase("CURRENT")) {
            value = value + ' ' + Token.getFirstToken(next);
        } else if (next.startsWith("(") && (index = next.indexOf(")")) > -1) {
            value = value + next.substring(0, index + 1);
        }
        return value;
    }

    private void initConstraintCheck() {
        boolean isCheck;
        boolean isConstraint = Token.hasToken(this.statement, "CONSTRAINT");
        if (isConstraint) {
            String constraint = Token.getTokenAfter(this.statement, "CONSTRAINT").trim();
            this.mapElementsColumn.put("CONSTRAINT", constraint);
        }
        if (isCheck = Token.hasToken(this.statement, "CHECK")) {
            String check = Token.getStringAfter(this.statement, "CHECK");
            check = Token.getValBetweenBrackets(check, 1).trim();
            this.mapElementsColumn.put("CHECK", check);
            if (this.statement.toUpperCase().indexOf(NOT_ENFORCED) > -1) {
                this.mapElementsColumn.put("VALIDATION", "NO");
            } else {
                this.mapElementsColumn.put("VALIDATION", "YES");
            }
            if (this.statement.toUpperCase().indexOf(DISABLE_QUERY_OPTIMIZATION) > -1) {
                this.mapElementsColumn.put("QUERY OPTIMIZATION", "DISABLE");
            } else {
                this.mapElementsColumn.put("QUERY OPTIMIZATION", "ENABLE");
            }
        }
    }

    public Map getElementsColumn(String statement, boolean isSummary) {
        this.parseColumns(statement.replaceAll("\"", ""), isSummary);
        return this.mapElementsColumn;
    }

    private void initLobOptions() {
        if (Token.hasToken(this.statement, "LOGGED")) {
            if (Token.getTokenBefore(this.statement, "LOGGED").equalsIgnoreCase("NOT")) {
                this.mapElementsColumn.put("NOT LOGGED", Boolean.TRUE);
            } else {
                this.mapElementsColumn.put("NOT LOGGED", Boolean.FALSE);
            }
        }
        if (Token.hasToken(this.statement, "COMPACT")) {
            if (Token.getTokenBefore(this.statement, "COMPACT").equalsIgnoreCase("NOT")) {
                this.mapElementsColumn.put("COMPACT", Boolean.FALSE);
            } else {
                this.mapElementsColumn.put("COMPACT", Boolean.TRUE);
            }
        }
    }

    private void initDataLinkOptions() {
        int ind = this.statement.toUpperCase().indexOf("LINK CONTROL");
        if (ind > -1) {
            this.statement = this.statement.substring(ind);
            while (!Token.getFirstToken(this.statement).equalsIgnoreCase("INTEGRITY")) {
                this.statement = Token.cutFirstToken(this.statement);
            }
            if (this.statement.toUpperCase().startsWith("INTEGRITY")) {
                this.mapElementsColumn.put("INTEGRITY", Boolean.TRUE);
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("READ")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                if (this.statement.toUpperCase().startsWith("READ")) {
                    String readPermission = Token.getTokenAfter(this.statement, "PERMISSION").trim();
                    this.mapElementsColumn.put("READ", readPermission);
                }
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("WRITE")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                if (this.statement.toUpperCase().startsWith("WRITE")) {
                    this.statement = Token.getStringAfterToken(this.statement, "PERMISSION");
                    String writePermission = "";
                    if (this.statement.toUpperCase().startsWith("FS")) {
                        writePermission = "FS";
                    } else if (this.statement.toUpperCase().startsWith("BLOCKED")) {
                        writePermission = "BLOCKED";
                    } else if (this.statement.toUpperCase().startsWith("ADMIN REQUIRING TOKEN FOR UPDATE")) {
                        writePermission = "ADMIN REQUIRING TOKEN FOR UPDATE";
                    } else if (this.statement.toUpperCase().startsWith("ADMIN NOT REQUIRING TOKEN FOR UPDATE")) {
                        writePermission = "ADMIN NOT REQUIRING TOKEN FOR UPDATE";
                    }
                    this.mapElementsColumn.put("WRITE", writePermission);
                }
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("RECOVERY")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                if (this.statement.toUpperCase().startsWith("RECOVERY")) {
                    String recovery = Token.getTokenAfter(this.statement, "RECOVERY").trim();
                    this.mapElementsColumn.put("RECOVERY", recovery);
                }
                while (!Token.getFirstToken(this.statement).equalsIgnoreCase("UNLINK")) {
                    this.statement = Token.cutFirstToken(this.statement);
                }
                if (this.statement.toUpperCase().startsWith("UNLINK")) {
                    String onUnLink = Token.getTokenAfter(this.statement, "UNLINK").trim();
                    this.mapElementsColumn.put("UNLINK", onUnLink);
                }
            } else {
                this.mapElementsColumn.put("INTEGRITY", Boolean.FALSE);
            }
        }
    }

    private void initConstraints() {
        String value = Token.getFirstToken(this.statement);
        if (value.equalsIgnoreCase("CONSTRAINT")) {
            String name = Token.getTokenAfter(this.statement, "CONSTRAINT").trim();
            this.statement = Token.getStringAfterToken(this.statement, name);
            this.mapElementsColumn.put("CONSTRAINT_NAME", name);
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        } else {
            this.mapElementsColumn.put("CONSTRAINT_NAME", "");
            this.initPrimaryKeyOrUnique();
            this.initTableConstraints();
            this.initValue();
        }
    }

    private void initTableConstraints() {
        boolean isCheck = Token.isTokenEqualTo(this.statement, 1, "CHECK");
        if (isCheck) {
            this.mapElementsColumn.put("CHECK", Boolean.TRUE);
        } else {
            this.mapElementsColumn.put("CHECK", Boolean.FALSE);
        }
    }

    private void initValue() {
        if (Token.hasCloseAndOpenBrackets(this.statement)) {
            String value = Token.getValBetweenBrackets(this.statement);
            this.mapElementsColumn.put("CONSTRAINT_VALUE", value);
        } else {
            this.mapElementsColumn.put("CONSTRAINT_VALUE", "");
        }
    }

    private void initReferences() {
        boolean isReferences = Token.hasToken(this.statement, "REFERENCES");
        if (isReferences) {
            boolean isOn;
            this.statement = Token.getStringAfter(this.statement, "REFERENCES");
            String references = Token.getFirstToken(this.statement);
            this.mapElementsColumn.put("REFERENCES", references);
            this.statement = Token.cutTokenFromFront(this.statement, references);
            boolean hasBrackets = Token.hasString(this.statement, "(");
            if (hasBrackets) {
                String columnReferenced = Token.getValBetweenBrackets(this.statement);
                this.mapElementsColumn.put("REFERENCED_COLUMN", columnReferenced);
                this.statement = Token.getStringAfter(this.statement, ")");
            }
            if (isOn = Token.hasToken(this.statement, "ON")) {
                String onDelete = Token.getTokenAfter(this.statement, "ON DELETE").trim();
                if (onDelete.equalsIgnoreCase("NO") || onDelete.equalsIgnoreCase("SET")) {
                    onDelete = onDelete + ' ' + Token.getTokenAfter(this.statement, onDelete).trim();
                }
                this.mapElementsColumn.put("ON DELETE", onDelete);
            }
        }
    }

    private void initFor() {
        boolean isFor = Token.hasToken(this.statement, "FOR");
        if (isFor) {
            String forElement = Token.getTokenAfter(this.statement, "FOR").trim();
            this.mapElementsColumn.put("FOR", forElement);
        }
    }
}

