/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateTablespaceUDB
extends DDLStatementHandler {
    private TableSpaceUDB tableSpace;
    private RDBMSSite site;
    private StorageDesignUDB stoDesign;
    private static final Logger LOGGER = new Logger(SHCreateTablespaceUDB.class);

    public SHCreateTablespaceUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateTablespaceUDB.clearCR(line);
        if (Token.startsWithString(statement, "create tablespace") || Token.startsWithString(statement, "create regular tablespace") || Token.startsWithString(statement, "create long tablespace") || Token.startsWithString(statement, "create temporary tablespace") || Token.startsWithString(statement, "create system temporary tablespace") || Token.startsWithString(statement, "create user temporary tablespace")) {
            try {
                this.parseTablespace(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateTablespaceUDB.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseTablespace(String statement) {
        this.statement = statement;
        this.site = this.design.getSelectedRDBMSSite();
        this.stoDesign = (StorageDesignUDB)this.design.getStorageDesign(this.site);
        if (this.stoDesign != null) {
            this.tableSpace = this.stoDesign.getTableSpaceSet().createTableSpace();
            this.initType();
            this.initName();
            this.initNodeGroup();
            this.initPageSize();
            this.initManagedBy();
            this.initUsingBlock();
            this.initExtentSize();
            this.initPrefetchSize();
            this.initBufferpool();
            this.initOverhead();
            this.initTransferRate();
            this.initDroppedTableRecovery();
            this.design.getRelationalDesign().stampModelObjectDDL(this.tableSpace);
        }
    }

    private void initType() {
        String type = Token.getTokenAfter(this.statement, "CREATE").trim();
        if ("USER".equalsIgnoreCase(type)) {
            this.tableSpace.setDataType("USER TEMPORARY");
        } else if ("LONG".equalsIgnoreCase(type)) {
            this.tableSpace.setDataType("LONG");
        } else if ("SYSTEM".equalsIgnoreCase(type)) {
            this.tableSpace.setDataType("SYSTEM TEMPORARY");
        } else {
            this.tableSpace.setDataType("REGULAR");
        }
    }

    private void initName() {
        String name = Token.getNameAfterToken(this.statement, "TABLESPACE", '\"', '\"').trim();
        this.tableSpace.setName(name);
    }

    private void initNodeGroup() {
        if (Token.hasToken(this.statement, "NODEGROUP")) {
            String nodeGroupName = Token.getTokenAfter(this.statement, "NODEGROUP");
            NodeGroupUDB nodeGroup = (NodeGroupUDB)this.stoDesign.getNodeGroupSet().getByName(nodeGroupName);
            if (nodeGroup != null) {
                this.tableSpace.setNodeGroup(nodeGroup);
            } else {
                nodeGroup = this.stoDesign.getNodeGroupSet().createNodeGroup();
                nodeGroup.setName(nodeGroupName);
                this.tableSpace.setNodeGroup(nodeGroup);
            }
        }
    }

    private void initPageSize() {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int pageSize = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                this.tableSpace.setPageSize(pageSize);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initPageSize : " + e.getMessage());
            }
        }
    }

    private void initManagedBy() {
        if (Token.hasToken(this.statement, "BY")) {
            String managedBy = Token.getTokenAfter(this.statement, "BY");
            this.tableSpace.setManagedBy(managedBy);
        }
    }

    private void initUsingBlock() {
        int ind;
        if (Token.hasToken(this.statement, "USING") && (ind = this.statement.indexOf("USING")) > -1) {
            String temp = this.statement.substring(ind);
            while (temp.indexOf("USING") > -1) {
                String val = Token.getValBetweenBrackets(temp, 1);
                String temp_after = Token.getValAfterBrackets(temp, 1);
                if (temp.length() == temp_after.length()) break;
                ContainerUDB container = ((StorageDesignUDB)this.tableSpace.getStorageDesign()).getContainerSet().createContainer();
                if (container == null) continue;
                container.setTableSpace(this.tableSpace);
                container.setContainers(val);
                this.design.getRelationalDesign().stampModelObjectDDL(container);
                if (temp_after.toUpperCase().startsWith("ON")) {
                    String onNodes = Token.getValBetweenBrackets(temp_after, 1);
                    container.setOnNodes(onNodes.trim());
                }
                temp = Token.getValAfterBrackets(temp_after, 1);
            }
        }
    }

    private void initExtentSize() {
        if (Token.hasToken(this.statement, "EXTENTSIZE")) {
            this.tableSpace.setExtentSize(Token.getTokenAfter(this.statement, "EXTENTSIZE"));
        }
    }

    private void initPrefetchSize() {
        if (Token.hasToken(this.statement, "PREFETCHSIZE")) {
            this.tableSpace.setPrefetchSize(Token.getTokenAfter(this.statement, "PREFETCHSIZE"));
        }
    }

    private void initBufferpool() {
        String nameBP;
        if (Token.hasToken(this.statement, "BUFFERPOOL") && !(nameBP = Token.getValBetweenDoubleQuotes(Token.getTokenAfter(this.statement, "BUFFERPOOL").trim())).equals("")) {
            BufferPoolUDBv71 bufferPool = (BufferPoolUDBv71)this.stoDesign.getBufferPoolSet().getByName(nameBP);
            if (bufferPool == null) {
                BufferPoolUDBv71 newBufferPool = (BufferPoolUDBv71)this.stoDesign.getBufferPoolSet().createBufferPool();
                newBufferPool.setName(nameBP);
                this.design.getRelationalDesign().stampModelObjectDDL(newBufferPool);
                this.tableSpace.setBufferPool(newBufferPool);
            } else {
                this.tableSpace.setBufferPool(bufferPool);
            }
        }
    }

    private void initOverhead() {
        if (Token.hasToken(this.statement, "OVERHEAD")) {
            try {
                float overhead = Float.parseFloat(Token.getTokenAfter(this.statement, "OVERHEAD"));
                this.tableSpace.setOverhead(overhead);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong OVERHEAD format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initOverhead : " + e.getMessage());
            }
        }
    }

    private void initTransferRate() {
        if (Token.hasToken(this.statement, "TRANSFERRATE")) {
            try {
                float transferRate = Float.parseFloat(Token.getTokenAfter(this.statement, "TRANSFERRATE"));
                this.tableSpace.setTransferRate(transferRate);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong TRANSFERRATE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateTablespaceUDB.initTransferRate : " + e.getMessage());
            }
        }
    }

    private void initDroppedTableRecovery() {
        String dropped;
        if (Token.hasToken(this.statement, "RECOVERY") && "ON".equalsIgnoreCase(dropped = Token.getTokenAfter(this.statement, "RECOVERY").trim())) {
            this.tableSpace.setDroppedTableRecovery(true);
        }
    }
}

