/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.StatementsConstants;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.udb.SHColumnElementsUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateDistinctTypeUDB;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;

public class DomainHandlerReadDDLUDB
implements StatementsConstants {
    private DomainFactory factory = new DomainFactory();
    private Design design;
    private LogicalDatatypeFactory factoryLogical;

    public DomainHandlerReadDDLUDB(Design design) {
        this.design = design;
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    public void createDomains(LinkedList statements) {
        Iterator itStat = statements.iterator();
        while (itStat.hasNext()) {
            String statement = DDLStatementHandler.clearCR((String)itStat.next());
            if (Token.startsWithString(statement, "create distinct type")) {
                SHCreateDistinctTypeUDB distTypes = new SHCreateDistinctTypeUDB(this.design, this.factoryLogical);
                distTypes.parseDistinctType(statement);
            }
            boolean isSummary = false;
            if (statement.indexOf("AS ( SELECT") > -1 || statement.indexOf("AS (SELECT") > -1) {
                isSummary = true;
            }
            if (!Token.startsWithString(statement, "create table") || isSummary) continue;
            ArrayList columns = this.getColumns(statement);
            for (String oneColumn : columns) {
                this.createOneDomain(oneColumn);
            }
        }
    }

    private ArrayList getColumns(String statement) {
        ArrayList<String> tableColumns = new ArrayList<String>();
        String columnStatement = Token.getValBetweenBrackets(statement, 1);
        StringTokenizer columns = new StringTokenizer(columnStatement, ",");
        while (columns.hasMoreTokens()) {
            String oneColumn = columns.nextToken().trim();
            if (Token.hasOpenBracket(oneColumn)) {
                StringBuffer oneColumnPast = new StringBuffer(oneColumn);
                while (Token.hasOpenBracket(oneColumn) && columns.hasMoreTokens()) {
                    oneColumnPast.append(", ").append(columns.nextToken().trim());
                    oneColumn = oneColumnPast.toString();
                }
            }
            tableColumns.add(oneColumn.trim());
        }
        return tableColumns;
    }

    private void createOneDomain(String statement) {
        Map elements;
        String columnName;
        SHColumnElementsUDB columnElements = new SHColumnElementsUDB();
        boolean isSummary = false;
        if (Token.hasToken(statement, "AS") && Token.hasToken(statement, "SELECT")) {
            isSummary = true;
        }
        if (!"".equalsIgnoreCase(columnName = (String)(elements = columnElements.getElementsColumn(statement, isSummary)).get("columnname"))) {
            String datatype = (String)elements.get("datatype");
            String[] parameters = new String[]{(String)elements.get("precision"), (String)elements.get("scale"), (String)elements.get("size")};
            if (datatype != null) {
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(datatype);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignUDBv71.RDBMS_TYPE, nameDatatype);
                this.factory.getInstance(this.design, logicalDT, null, 2, parameters, null);
            }
        }
    }
}

