/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHGrantPrivilegesSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHGrantPrivilegesSqlServerv2k5
extends SHGrantPrivilegesSqlServer {
    private StorageDesignSqlServerv2k5 storageDesign;
    private static final Logger LOGGER = new Logger(SHGrantPrivilegesSqlServerv2k5.class);

    public SHGrantPrivilegesSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHGrantPrivilegesSqlServerv2k5.clearCR(line);
        if ((Token.startsWithString(statement, "grant") || Token.startsWithString(statement, "grant all")) && !Token.hasToken(statement, "ON")) {
            try {
                this.grantPrivileges(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHGrantPrivilegesSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void grantPrivileges(String statement) {
        this.statement = statement.replaceAll("\"", "");
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (this.storageDesign != null) {
            String priv = Token.getStringAfter(this.statement, "GRANT").trim();
            priv = Token.getStringBeforeToken(priv, "TO").trim();
            this.initTo(priv);
        }
    }

    private void initTo(String priv) {
        String to = Token.getStringAfterToken(this.statement, "TO").trim();
        if (!to.equalsIgnoreCase("")) {
            StringTokenizer tokenizer = new StringTokenizer(to, ",");
            String userOrRole = null;
            while (tokenizer.hasMoreTokens()) {
                String pr;
                userOrRole = tokenizer.nextToken().trim();
                userOrRole = Token.getValBetweenSquareBrackets(userOrRole);
                DataBaseSqlServerv2k5 db = (DataBaseSqlServerv2k5)this.getCurrentDB();
                StorageObjectCollection users = db.getUsers();
                StorageObjectCollection roles = db.getRoles();
                if (users.getByName(userOrRole) != null) {
                    UserSqlServerv2k5 user = (UserSqlServerv2k5)users.getByName(userOrRole);
                    StringTokenizer userTokenizer = new StringTokenizer(priv, ",");
                    pr = null;
                    while (userTokenizer.hasMoreTokens()) {
                        pr = userTokenizer.nextToken().trim();
                        user.setSystemPrivileges(pr);
                    }
                    continue;
                }
                if (roles.getByName(userOrRole) == null) continue;
                RoleSqlServerv2k5 role = (RoleSqlServerv2k5)roles.getByName(userOrRole);
                StringTokenizer roleTokenizer = new StringTokenizer(priv, ",");
                pr = null;
                while (roleTokenizer.hasMoreTokens()) {
                    pr = roleTokenizer.nextToken().trim();
                    role.setSystemPrivileges(pr);
                }
            }
        } else {
            LOGGER.error("SHGrantPrivilegesSqlServer.initTo(): wrong syntax!");
            this.importLog.addError("Error in setting TO objects of permission " + this.statement);
        }
    }
}

