/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SCHCreateSchemaSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SCHCreateSchemaSqlServerv2k5.class);

    public SCHCreateSchemaSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SCHCreateSchemaSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create schema")) {
            try {
                this.createSchema(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SCHCreateSchemaSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else if (Token.startsWithString(statement, "create user")) {
            try {
                this.createUser(statement.replaceAll("\"", ""));
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SCHCreateSchemaSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createSchema(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            String name = Token.getTokenAfter(statement, "SCHEMA");
            SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)storageDesign.getSchemaSet().createSchema();
            schema.setName(name);
            this.design.getRelationalDesign().stampModelObjectDDL(schema);
            if (Token.hasToken(statement, "AUTHORIZATION")) {
                String ownerName = Token.getTokenAfter(statement, "AUTHORIZATION");
                UserSqlServerv2k5 owner = (UserSqlServerv2k5)this.getCurrentDB().getUsers().getByName(ownerName);
                if (owner != null && schema != null) {
                    schema.setOwner(owner);
                }
            }
            schema.setDatabase(this.getCurrentDB());
        }
    }

    private void createUser(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            String temp = Token.getTokenAfter(statement, "USER");
            String userName = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "USER", '[', ']').trim() : (temp.startsWith("\"") ? Token.getNameAfterToken(this.statement, "USER", '\"', '\"').trim() : temp);
            UserSqlServerv2k5 user = (UserSqlServerv2k5)this.getCurrentDB().getUsers().getByName(userName);
            if (user == null) {
                user = (UserSqlServerv2k5)storageDesign.getUserSet().createUser();
                user.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
                user.setDatabase(this.getCurrentDB());
            }
            if (Token.hasToken(statement, "WITHOUT")) {
                if (Token.getTokenAfter(statement, "WITHOUT").equalsIgnoreCase("LOGIN")) {
                    user.setLogin(null);
                }
            } else if (Token.hasToken(statement, "LOGIN")) {
                temp = Token.getTokenAfter(statement, "LOGIN");
                String loginName = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "LOGIN", '[', ']').trim() : (temp.startsWith("\"") ? Token.getNameAfterToken(this.statement, "LOGIN", '\"', '\"').trim() : temp);
                LoginSqlServer login = (LoginSqlServer)storageDesign.getLoginSet().getByName(loginName);
                if (login != null) {
                    user.setLogin(login);
                }
            }
            if (statement.indexOf("DEFAULT_SCHEMA") > -1) {
                temp = statement.substring(statement.indexOf("DEFAULT_SCHEMA")).trim();
                temp = temp.substring(temp.indexOf("=") + 1).trim();
                String schemaName = Token.getFirstToken(temp);
                schemaName = Token.getValBetweenSquareBrackets(schemaName);
                schemaName = Token.removeQuotes(schemaName);
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)this.getCurrentDB().getSchemas().getByName(schemaName);
                if (schema == null) {
                    schema = (SchemaSqlServerv2k5)storageDesign.getSchemaSet().createSchema();
                    schema.setName(schemaName);
                    this.design.getRelationalDesign().stampModelObjectDDL(schema);
                    schema.setDatabase(this.getCurrentDB());
                    schema.setOwner(user);
                }
            }
        }
    }
}

