/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.ParseException;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateStoredProcedureSqlServer
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateStoredProcedureSqlServer.class);

    public SHCreateStoredProcedureSqlServer(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateStoredProcedureSqlServer.clearCR(line);
        if (Token.startsWithString(statement, "create proc") || Token.startsWithString(statement, "create procedure")) {
            this.parseStoredProcedure(statement, line);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseStoredProcedure(String statement, String line) {
        StoredProcedureSqlServer proc;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k storageDesign = (StorageDesignSqlServerv2k)this.design.getStorageDesign(site);
        if (storageDesign != null && (proc = storageDesign.getStoredProcedureSet().createStoredProcedure()) != null) {
            try {
                this.initStoredProcedureName(storageDesign, proc, statement);
                this.initBody(proc, line, statement);
                this.design.getRelationalDesign().stampModelObjectDDL(proc);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(statement + " Error parsing stored procedure for SqlServer!");
                this.importLog.addFailedStatement(SHCreateStoredProcedureSqlServer.FormatCR(line, "\n"));
            }
        }
    }

    private void initStoredProcedureName(StorageDesignSqlServerv2k storageDesign, StoredProcedureSqlServer proc, String statement) throws ParseException {
        try {
            String name;
            int number = 1;
            String token = Token.getToken(statement, number);
            while (!("".equalsIgnoreCase(token) || token.equalsIgnoreCase("PROCEDURE") || token.equalsIgnoreCase("PROC"))) {
                token = Token.getToken(statement, ++number);
            }
            if ((name = Token.getToken(statement, ++number)).indexOf(46) > -1) {
                String ownerName = name.substring(0, name.indexOf(46));
                ownerName = Token.getValBetweenSquareBrackets(ownerName);
                UserSqlServer owner = (UserSqlServer)storageDesign.getUserSet().getByName(ownerName);
                if (owner != null) {
                    proc.setOwner(owner);
                }
                name = name.substring(name.indexOf(46) + 1);
            }
            proc.setName(name);
            proc.setDatabase(this.getCurrentDB());
        }
        catch (Exception e) {
            LOGGER.error(statement + " Error parsing stored procedure name (SqlServer)! ");
            this.importLog.addError("Error parsing stored procedure name for SqlServer " + statement);
            throw new ParseException();
        }
    }

    private void initBody(StoredProcedureSqlServer proc, String line, String statement) {
        int number = 1;
        String token = Token.getToken(statement, number);
        while (!("".equalsIgnoreCase(token) || token.equalsIgnoreCase("PROCEDURE") || token.equalsIgnoreCase("PROC"))) {
            token = Token.getToken(statement, ++number);
        }
        String name = Token.getToken(statement, ++number);
        proc.setBody(Token.getStringAfter(line, name));
    }
}

