/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v9i;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableColumnOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateExternalTableOraclev9i
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateExternalTableOraclev9i.class);
    private String lineFormatted;
    private String partStatement;

    public SHCreateExternalTableOraclev9i(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateExternalTableOraclev9i.clearCR(line);
        if (Token.startsWithString(statement, "CREATE TABLE") && statement.toUpperCase().indexOf("ORGANIZATION EXTERNAL") > -1) {
            try {
                this.lineFormatted = line;
                this.parseExternalTable(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for Oracle 9i failed!", e);
                this.importLog.addFailedStatement(SHCreateExternalTableOraclev9i.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseExternalTable(String statement) {
        ExternalTableOraclev9i table;
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignOraclev9i stoDesign = (StorageDesignOraclev9i)this.design.getStorageDesign(site);
        if (stoDesign != null && (table = (ExternalTableOraclev9i)stoDesign.getExternalTableSet().createExternalTable()) != null) {
            this.initName(table, stoDesign);
            this.initColumns(table, stoDesign);
            this.initExternalTableClause(table, stoDesign);
            this.initParallel(table);
            this.initRejectLimit(table);
            this.design.getRelationalDesign().stampModelObjectDDL(table);
        }
    }

    private void initName(ExternalTableOraclev9i table, StorageDesignOraclev9i stoDesign) {
        String startOfName = Token.getStringAfterToken(this.statement, "TABLE");
        String name = Token.getFirstName(startOfName, '\"', '\"');
        int posPoint = name.indexOf(46);
        if (posPoint > -1) {
            String userName = name.substring(0, posPoint);
            UserOracle user = (UserOracle)stoDesign.getUserSet().getByName(userName);
            if (user == null) {
                user = stoDesign.getUserSet().createUser();
                user.setName(userName);
                this.design.getRelationalDesign().stampModelObjectDDL(user);
            }
            if (user != null) {
                table.setOwner(user);
            }
            name = name.substring(posPoint + 1);
            startOfName = startOfName.substring(startOfName.indexOf(46) + 1);
        }
        table.setName(name);
        if (startOfName.startsWith("\"") && !name.equals(name.toUpperCase())) {
            table.setNameHasQuotes(true);
        }
        int nameIndex = this.statement.indexOf(name, posPoint);
        this.partStatement = this.statement.substring(nameIndex + name.length());
        if (this.partStatement.startsWith("\"")) {
            this.partStatement = this.partStatement.substring(1);
        }
        this.partStatement = this.partStatement.trim();
    }

    private void initColumns(ExternalTableOraclev9i table, StorageDesignOraclev9i stoDesign) {
        if (this.partStatement.startsWith("(")) {
            String cols = Token.getValBetweenBrackets(this.partStatement, 1);
            this.partStatement = Token.getValAfterBrackets(this.partStatement, 1);
            StringTokenizer tokenizer = new StringTokenizer(cols, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                while (Token.hasOpenBracket(token) && tokenizer.hasMoreTokens()) {
                    token = token + ", " + tokenizer.nextToken();
                }
                token = token.trim();
                boolean colNameQuoted = token.startsWith("\"");
                String colName = Token.getFirstName(token, '\"', '\"');
                if ("".equalsIgnoreCase(colName)) continue;
                String datatype = Token.getStringAfter(token, colName);
                ExternalTableColumnOraclev9i col = (ExternalTableColumnOraclev9i)stoDesign.getExternalColumnSet().createExternalColumn();
                col.setName(colName);
                if (colNameQuoted) {
                    datatype = Token.cutFirstToken(datatype);
                    if (!colName.equals(colName.toUpperCase())) {
                        col.setNameHasQuotes(true);
                    }
                }
                col.setExternalTable(table);
                this.design.getRelationalDesign().stampModelObjectDDL(col);
                datatype = datatype.toUpperCase();
                String firstToken = Token.getFirstToken(datatype);
                if (firstToken.equals("TIMESTAMP")) {
                    String precision = Token.getValBetweenBrackets(datatype, 1).trim();
                    if (precision.length() > 0) {
                        try {
                            col.setPrecision(Integer.parseInt(precision));
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Wrong precision format " + precision);
                            this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                        }
                    }
                    datatype = datatype.indexOf("WITH LOCAL TIME ZONE") >= 0 ? "TIMESTAMP WITH LOCAL TIME ZONE" : (datatype.indexOf("WITH TIME ZONE") >= 0 ? "TIMESTAMP WITH TIME ZONE" : "TIMESTAMP");
                } else if (firstToken.equals("INTERVAL")) {
                    String intervalType = Token.cutTokenFromFront(datatype, "INTERVAL");
                    if (intervalType.startsWith("YEAR")) {
                        datatype = "INTERVAL YEAR TO MONTH";
                    } else {
                        String secondsPrecision;
                        String afterTo;
                        String afterSecond;
                        String precision;
                        datatype = "INTERVAL DAY TO SECOND";
                        String afterDay = Token.cutTokenFromFront(intervalType, "DAY");
                        if (afterDay.startsWith("(") && (precision = Token.getValBetweenBrackets(afterDay, 1).trim()).length() > 0) {
                            try {
                                col.setPrecision(Integer.parseInt(precision));
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("Wrong precision format " + precision);
                                this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                            }
                        }
                        if ((afterSecond = Token.cutTokenFromFront(afterTo = Token.getStringAfterToken(intervalType, "TO"), "SECOND")).startsWith("(") && (secondsPrecision = Token.getValBetweenBrackets(afterSecond, 1).trim()).length() > 0) {
                            try {
                                col.setScale(Integer.parseInt(secondsPrecision));
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("Wrong precision format " + secondsPrecision);
                                this.importLog.addWarning("Wrong precision format in statement " + this.statement);
                            }
                        }
                    }
                } else {
                    datatype = firstToken.equals("NVARCHAR") ? "NVARCHAR2" : (datatype.startsWith("DOUBLE PRECISION") ? "FLOAT" : this.getDatatype(datatype));
                }
                if (datatype == null) continue;
                col.setDatatype(datatype);
                boolean hasBrackets = Token.hasCloseAndOpenBrackets(token);
                if (!hasBrackets) continue;
                String parameters = Token.getValBetweenBrackets(token, 1).trim();
                try {
                    if (datatype.indexOf("CHAR") > -1 || datatype.equals("RAW") || datatype.equals("UROWID")) {
                        if (parameters.endsWith("BYTE") || parameters.endsWith("CHAR")) {
                            col.setUnits(parameters.substring(parameters.length() - 4));
                            parameters = parameters.substring(0, parameters.length() - 4).trim();
                        }
                        col.setSize(Integer.parseInt(parameters));
                        continue;
                    }
                    if (datatype.startsWith("TIMESTAMP") || datatype.equals("INTERVAL DAY TO SECOND")) continue;
                    int positionKomma = parameters.indexOf(",");
                    if (positionKomma != -1) {
                        col.setPrecision(Integer.parseInt(parameters.substring(0, positionKomma).trim()));
                        col.setScale(Integer.parseInt(parameters.substring(positionKomma + 1).trim()));
                        continue;
                    }
                    col.setPrecision(Integer.parseInt(parameters));
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Wrong size/precision format " + parameters);
                    this.importLog.addWarning("Wrong size/precision format in statement " + this.statement);
                }
            }
        } else if (this.statement.toUpperCase().indexOf("AS SELECT") > -1) {
            LOGGER.error("CREATE TABLE ... AS SELECT is not supported");
            this.importLog.addWarning("CREATE TABLE ... AS SELECT is not supported in statement: " + this.statement);
        }
    }

    private String getDatatype(String token) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("Oracle9i");
        for (int number = 0; number < names.length; ++number) {
            String name = names[number];
            if (!token.startsWith(name)) continue;
            return name;
        }
        return null;
    }

    private void initExternalTableClause(ExternalTableOraclev9i table, StorageDesignOraclev9i stoDesign) {
        if (Token.hasToken(this.partStatement, "TYPE")) {
            table.setAccessDriverType(Token.getTokenAfter(this.partStatement, "TYPE"));
        }
        if (Token.hasToken(this.partStatement, "DIRECTORY")) {
            String defDir = Token.getQuotedNameAfterToken(this.partStatement, "DIRECTORY");
            DirectoryOracle dir = (DirectoryOracle)stoDesign.getDirectorySet().getByName(defDir);
            if (dir == null) {
                dir = stoDesign.getDirectorySet().createDirectory();
                dir.setName(defDir);
            }
            table.setDefaultDir(dir);
        }
        if (this.partStatement.toUpperCase().indexOf("ACCESS PARAMETERS") > -1) {
            String formattedLineUC = this.lineFormatted.toUpperCase();
            String access = this.lineFormatted.substring(formattedLineUC.indexOf("PARAMETERS", formattedLineUC.indexOf("ACCESS")) + 10);
            if (Token.startsWithString(access = Token.getStringBefore(access, "LOCATION").trim(), "USING CLOB")) {
                table.setAccessParametersType("CLOB Subquery");
                access = Token.getStringAfter(access, "CLOB");
                table.setClobSubquery(access);
            } else {
                access = Token.getValBetweenBrackets(access, 1).trim();
                table.setAccessParametersType("Opaque Format Spec");
                table.setOpaqueFormatSpec(access);
            }
        }
        String location = Token.getStringAfter(this.partStatement, "LOCATION");
        location = Token.getValBetweenBrackets(location, 1).trim();
        location = Token.getValBetweenQuotationMarks(location);
        table.setLocation(location);
    }

    private void initParallel(ExternalTableOraclev9i table) {
        if (Token.hasToken(this.partStatement, "PARALLEL")) {
            table.setParallel("PARALLEL");
            String paralelNum = Token.getTokenAfter(this.partStatement, "PARALLEL");
            try {
                table.setParallelNum(Integer.parseInt(paralelNum));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initRejectLimit(ExternalTableOraclev9i table) {
        if (Token.hasString(this.partStatement, "REJECT LIMIT")) {
            String rejectLimit = Token.getStringAfter(this.partStatement, "REJECT LIMIT");
            if ((rejectLimit = Token.getFirstToken(rejectLimit)) != null && rejectLimit.trim().equalsIgnoreCase("UNLIMITED")) {
                table.setRejectLimit("UNLIMITED");
            } else {
                try {
                    Integer.parseInt(rejectLimit);
                    table.setRejectLimit(rejectLimit);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Wrong syntax near " + rejectLimit);
                    this.importLog.addWarning("Wrong REJECT LIMIT format in statement " + this.statement);
                }
            }
        }
    }
}

